/*
 * Decompiled with CFR 0.152.
 */
package dap4.cdm;

import dap4.cdm.CDMArray;
import dap4.cdm.CDMArrayAtomic;
import dap4.cdm.CDMArrayStructure;
import dap4.cdm.CDMDataset;
import dap4.core.dmr.AtomicType;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.dap4shared.D4DSP;
import dap4.dap4shared.D4DataSequence;
import dap4.dap4shared.DSP;
import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.ForbiddenConversionException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataA;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;

public class CDMArraySequence
extends ArraySequence
implements CDMArray {
    protected CDMDataset root = null;
    protected D4DSP dsp = null;
    protected DapVariable template = null;
    protected long bytesize = 0L;
    protected D4DataSequence d4data = null;
    protected long nmembers = 0L;
    protected Array[][] records = null;
    protected long nrecords = 0L;

    CDMArraySequence(D4DSP dsp, CDMDataset root, DapStructure template, D4DataSequence d4data) {
        super(CDMArrayStructure.computemembers((DapStructure)d4data.getTemplate()), (StructureDataIterator)new SDI(), (int)d4data.getRecordCount());
        this.dsp = dsp;
        this.root = root;
        this.template = (DapVariable)d4data.getTemplate();
        this.d4data = d4data;
        this.nmembers = template.getFields().size();
        this.nrecords = d4data.getRecordCount();
        this.sdata = new StructureDataA[(int)this.nrecords];
        int i = 0;
        while ((long)i < this.nrecords) {
            this.sdata[i] = new StructureDataA((ArrayStructure)this, i);
            ++i;
        }
        this.records = new Array[(int)this.nrecords][(int)this.nmembers];
        ((SDI)this.iter).setList(this.sdata);
    }

    void finish() {
        int i = 0;
        while ((long)i < this.nrecords) {
            assert (this.records[i] != null);
            ++i;
        }
        this.bytesize = this.computeTotalSize();
    }

    void addField(long recno, int fieldno, Array instance) {
        assert (this.records != null) : "Internal Error";
        if (recno < 0L || recno >= this.nrecords) {
            throw new ArrayIndexOutOfBoundsException("CDMArrayStructure: record index out of range: " + recno);
        }
        if (fieldno < 0 || (long)fieldno >= this.nmembers) {
            throw new ArrayIndexOutOfBoundsException("CDMArrayStructure: field index out of range: " + fieldno);
        }
        Array[] fields = this.records[(int)recno];
        if (fields == null) {
            throw new ArrayIndexOutOfBoundsException("CDMArrayStructure: record: " + recno);
        }
        fields[fieldno] = instance;
    }

    @Override
    public DSP getDSP() {
        return this.dsp;
    }

    @Override
    public AtomicType getPrimitiveType() {
        return AtomicType.Sequence;
    }

    @Override
    public DapType getBaseType() {
        return DapType.SEQ;
    }

    @Override
    public CDMDataset getRoot() {
        return this.root;
    }

    @Override
    public DapVariable getTemplate() {
        return this.template;
    }

    @Override
    public long getByteSize() {
        return this.bytesize;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        DapStructure struct = (DapStructure)this.template;
        int i = 0;
        while ((long)i < this.nrecords) {
            List fields = struct.getFields();
            if ((long)i < this.nrecords - 1L) {
                buf.append("\n");
            }
            buf.append("Sequence {\n");
            if (fields != null) {
                int j = 0;
                while ((long)j < this.nmembers) {
                    DapVariable dapVariable = (DapVariable)fields.get(j);
                    ++j;
                }
            }
            buf.append(String.format("} [%d/%d]", i, this.nrecords));
            ++i;
        }
        return buf.toString();
    }

    public long computeTotalSize() {
        long totalsize = 0L;
        int recno = 0;
        while ((long)recno < this.nrecords) {
            Array[] fields = this.records[recno];
            assert (fields != null) : "internal error";
            int m = 0;
            while ((long)m < this.nmembers) {
                totalsize += fields[m].getSizeBytes();
                ++m;
            }
            ++recno;
        }
        return totalsize;
    }

    public int getStructureDataCount() {
        return (int)this.nrecords;
    }

    public long getSizeBytes() {
        return this.bytesize;
    }

    protected StructureData makeStructureData(ArrayStructure as, int index) {
        throw new UnsupportedOperationException("Cannot subset a Sequence");
    }

    public StructureData getStructureData(int index) {
        assert (this.sdata != null);
        if (index < 0 || (long)index >= this.nrecords) {
            throw new IllegalArgumentException(index + " >= " + this.sdata.length);
        }
        assert (this.sdata[index] != null);
        return this.sdata[index];
    }

    public ArraySequence getArraySequence(StructureMembers.Member m) {
        return this;
    }

    public Array copy() {
        return this;
    }

    public Array getArray(int recno, StructureMembers.Member m) {
        return this.memberArray(recno, CDMArrayStructure.memberIndex(m));
    }

    protected CDMArrayAtomic getAtomicArray(int index, StructureMembers.Member m) {
        Array dd = this.memberArray(index, CDMArrayStructure.memberIndex(m));
        if (dd.getDataType() != DataType.STRUCTURE && dd.getDataType() != DataType.SEQUENCE) {
            return (CDMArrayAtomic)dd;
        }
        throw new ForbiddenConversionException("Cannot convert structure to AtomicArray");
    }

    protected Array memberArray(int recno, int memberindex) {
        Array cdmdata = this.records[recno][memberindex];
        return cdmdata;
    }

    public static class SDI
    implements StructureDataIterator {
        protected StructureData[] list = null;
        protected int position = 0;

        public SDI setList(StructureData[] list) {
            this.list = list;
            return this;
        }

        public boolean hasNext() throws IOException {
            return this.position < this.list.length;
        }

        public StructureData next() throws IOException {
            if (this.position >= this.list.length) {
                throw new IOException("No next element");
            }
            return this.list[this.position++];
        }

        public StructureDataIterator reset() {
            this.position = 0;
            return this;
        }

        public int getCurrentRecno() {
            return this.position;
        }
    }
}

