/*
 * Decompiled with CFR 0.152.
 */
package dap4.cdm;

import dap4.cdm.DapNetcdfFile;
import dap4.cdmshared.CDMUtil;
import dap4.cdmshared.NodeMap;
import dap4.core.dmr.DapAtomicVariable;
import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnum;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.Convert;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.ma2.DataType;
import ucar.ma2.ForbiddenConversionException;
import ucar.nc2.Attribute;
import ucar.nc2.CDMNode;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;

public class DSPToCDM {
    protected DapNetcdfFile ncfile;
    protected DapDataset dmr;
    protected NodeMap nodemap = new NodeMap();

    public DSPToCDM(DapNetcdfFile ncfile, DapDataset dmr) {
        this.ncfile = ncfile;
        this.dmr = dmr;
    }

    public NodeMap create() throws DapException {
        Group cdmroot = this.ncfile.getRootGroup();
        this.nodemap.put((DapNode)this.dmr, (CDMNode)cdmroot);
        this.fillGroup(cdmroot, (DapGroup)this.dmr, this.ncfile, this.nodemap);
        return this.nodemap;
    }

    protected void fillGroup(Group cdmparent, DapGroup dapparent, NetcdfFile ncfile, NodeMap nodemap) throws DapException {
        for (DapDimension dapDimension : dapparent.getDimensions()) {
            if (!dapDimension.isShared()) continue;
            this.createDimension(dapDimension, cdmparent, nodemap);
        }
        for (DapEnum dapEnum : dapparent.getEnums()) {
            DataType cdmbasetype;
            DapType basetype = dapEnum.getBaseType();
            switch (basetype.getAtomicType()) {
                case Char: 
                case Int8: 
                case UInt8: {
                    cdmbasetype = DataType.ENUM1;
                    break;
                }
                case Int16: 
                case UInt16: {
                    cdmbasetype = DataType.ENUM2;
                    break;
                }
                case Int32: 
                case UInt32: {
                    cdmbasetype = DataType.ENUM4;
                    break;
                }
                case Int64: 
                case UInt64: {
                    cdmbasetype = DataType.ENUM4;
                    break;
                }
                default: {
                    throw new DapException("Illegal DapEnum basetype");
                }
            }
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            List ecnames = dapEnum.getNames();
            for (String ecname : ecnames) {
                Long value = dapEnum.lookup(ecname);
                map.put(value.intValue(), ecname);
            }
            EnumTypedef cdmenum = new EnumTypedef(dapEnum.getShortName(), map, cdmbasetype);
            nodemap.put((DapNode)dapEnum, (CDMNode)cdmenum);
            cdmparent.addEnumeration(cdmenum);
        }
        for (DapVariable dapVariable : dapparent.getVariables()) {
            this.createVar(dapVariable, ncfile, nodemap, cdmparent, null);
        }
        for (DapGroup dapGroup : dapparent.getGroups()) {
            this.createGroup(dapGroup, cdmparent, ncfile, nodemap);
        }
        for (Map.Entry entry : dapparent.getAttributes().entrySet()) {
            DapAttribute attr = (DapAttribute)entry.getValue();
            Attribute cdmattr = this.createAttribute(attr, nodemap);
            cdmparent.addAttribute(cdmattr);
        }
    }

    protected void createGroup(DapGroup dapgroup, Group cdmparent, NetcdfFile ncfile, NodeMap nodemap) throws DapException {
        Group cdmgroup = new Group(ncfile, cdmparent, dapgroup.getShortName());
        nodemap.put((DapNode)dapgroup, (CDMNode)cdmgroup);
        this.fillGroup(cdmgroup, dapgroup, ncfile, nodemap);
        if (cdmgroup != null) {
            cdmparent.addGroup(cdmgroup);
        }
    }

    protected void createVar(DapVariable dapvar, NetcdfFile ncfile, NodeMap nodemap, Group cdmgroup, Structure cdmparentstruct) throws DapException {
        Variable cdmvar = null;
        if (dapvar.getSort() == DapSort.ATOMICVARIABLE) {
            DapAtomicVariable atomvar = (DapAtomicVariable)dapvar;
            cdmvar = new Variable(ncfile, cdmgroup, cdmparentstruct, atomvar.getShortName());
            DapType basetype = atomvar.getBaseType();
            DataType cdmbasetype = basetype.isEnumType() ? CDMUtil.enumtypefor((DapType)basetype) : CDMUtil.daptype2cdmtype((DapType)basetype);
            if (cdmbasetype == null) {
                throw new DapException("Unknown basetype:" + basetype);
            }
            cdmvar.setDataType(cdmbasetype);
            if (basetype.isEnumType()) {
                EnumTypedef cdmenum = (EnumTypedef)nodemap.get((DapNode)basetype);
                if (cdmenum == null) {
                    throw new DapException("Unknown enumeration type:" + basetype.toString());
                }
                cdmvar.setEnumTypedef(cdmenum);
            }
            nodemap.put((DapNode)dapvar, (CDMNode)cdmvar);
        } else if (dapvar.getSort() == DapSort.STRUCTURE) {
            DapStructure dapstruct = (DapStructure)dapvar;
            Structure cdmstruct = new Structure(ncfile, cdmgroup, cdmparentstruct, dapstruct.getShortName());
            cdmvar = cdmstruct;
            nodemap.put((DapNode)dapvar, (CDMNode)cdmvar);
            for (DapVariable field : dapstruct.getFields()) {
                this.createVar(field, ncfile, nodemap, cdmgroup, cdmstruct);
            }
        } else if (dapvar.getSort() == DapSort.SEQUENCE) {
            DapSequence dapseq = (DapSequence)dapvar;
            Sequence cdmseq = new Sequence(ncfile, cdmgroup, cdmparentstruct, dapseq.getShortName());
            cdmvar = cdmseq;
            nodemap.put((DapNode)dapvar, (CDMNode)cdmvar);
            for (DapVariable field : dapseq.getFields()) {
                this.createVar(field, ncfile, nodemap, cdmgroup, (Structure)cdmseq);
            }
            if (dapvar.getRank() > 0) {
                ArrayList<String> value = new ArrayList<String>();
                value.add("CDM does not support Sequences with rank > 0");
                Attribute warning = new Attribute("_WARNING:", value);
                cdmvar.addAttribute(warning);
            }
        } else assert (false) : "Unknown variable sort: " + dapvar.getSort();
        int rank = dapvar.getRank();
        ArrayList<Dimension> cdmdims = new ArrayList<Dimension>(rank + 1);
        for (int i = 0; i < rank; ++i) {
            DapDimension dim = dapvar.getDimension(i);
            Dimension cdmdim = this.createDimensionRef(dim, cdmgroup, nodemap);
            cdmdims.add(cdmdim);
        }
        if (dapvar.getSort() == DapSort.SEQUENCE) {
            cdmdims.add(Dimension.VLEN);
        }
        cdmvar.setDimensions(cdmdims);
        for (String key : dapvar.getAttributes().keySet()) {
            DapAttribute attr = (DapAttribute)dapvar.getAttributes().get(key);
            Attribute cdmattr = this.createAttribute(attr, nodemap);
            cdmvar.addAttribute(cdmattr);
        }
        if (cdmparentstruct != null) {
            cdmparentstruct.addMemberVariable(cdmvar);
        } else if (cdmgroup != null) {
            cdmgroup.addVariable(cdmvar);
        }
    }

    protected void createDimension(DapDimension dapdim, Group cdmgroup, NodeMap nodemap) throws DapException {
        if (dapdim.isVariableLength()) {
            nodemap.put((DapNode)dapdim, (CDMNode)Dimension.VLEN);
        } else if (dapdim.isShared()) {
            if (nodemap.containsKey((DapNode)dapdim)) {
                throw new DapException("Attempt to declare dimension twice:" + dapdim.getFQN());
            }
            Dimension cdmdim = new Dimension(dapdim.getShortName(), (int)dapdim.getSize(), true, false, dapdim.isVariableLength());
            nodemap.put((DapNode)dapdim, (CDMNode)cdmdim);
            cdmgroup.addDimension(cdmdim);
        } else {
            throw new DapException("Attempt to declare an anonymous dimension");
        }
    }

    protected Dimension createDimensionRef(DapDimension dim, Group cdmgroup, NodeMap nodemap) throws DapException {
        Dimension cdmdim = null;
        cdmdim = dim.isShared() ? (Dimension)nodemap.get((DapNode)dim) : new Dimension(null, (int)dim.getSize(), false, false, false);
        if (cdmdim == null) {
            throw new DapException("Unknown dimension: " + dim.getFQN());
        }
        return cdmdim;
    }

    protected EnumTypedef createEnum(DapEnum dapenum, Group cdmparent, NodeMap nodemap) throws DapException {
        DataType cdmbasetype;
        DapType basetype = dapenum.getBaseType();
        switch (basetype.getAtomicType()) {
            case Char: 
            case Int8: 
            case UInt8: {
                cdmbasetype = DataType.ENUM1;
                break;
            }
            case Int16: 
            case UInt16: {
                cdmbasetype = DataType.ENUM2;
                break;
            }
            case Int32: 
            case UInt32: {
                cdmbasetype = DataType.ENUM4;
                break;
            }
            default: {
                throw new DapException("Illegal DapEnum basetype");
            }
        }
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        List ecnames = dapenum.getNames();
        for (String ecname : ecnames) {
            Long value = dapenum.lookup(ecname);
            map.put(value.intValue(), ecname);
        }
        EnumTypedef cdmenum = new EnumTypedef(dapenum.getShortName(), map, cdmbasetype);
        nodemap.put((DapNode)dapenum, (CDMNode)cdmenum);
        cdmparent.addEnumeration(cdmenum);
        return cdmenum;
    }

    protected Attribute createAttribute(DapAttribute dapattr, NodeMap nodemap) {
        return this.createAttribute(null, dapattr, nodemap);
    }

    protected Attribute createAttribute(String prefix, DapAttribute dapattr, NodeMap nodemap) {
        Attribute cdmattr = null;
        switch (dapattr.getSort()) {
            case ATTRIBUTE: {
                DapType basetype = dapattr.getBaseType();
                if (!(basetype.isNumericType() || basetype.isStringType() || basetype.isCharType())) {
                    throw new ForbiddenConversionException("Illegal attribute type:" + basetype.toString());
                }
                DapType uptype = Convert.upcastType((DapType)basetype);
                DataType cdmtype = CDMUtil.daptype2cdmtype((DapType)uptype);
                List dapvalues = dapattr.getValues();
                ArrayList cdmvalues = new ArrayList();
                for (int i = 0; i < dapvalues.size(); ++i) {
                    Object o = dapvalues.get(i);
                    o = Convert.upcast(o, (DapType)uptype);
                    if (cdmtype == DataType.CHAR) {
                        o = ((Character)o).toString();
                    }
                    cdmvalues.add(o);
                }
                cdmattr = new Attribute(dapattr.getShortName(), cdmvalues);
                break;
            }
            case ATTRIBUTESET: {
                String setname = dapattr.getShortName();
                prefix = prefix == null ? setname : prefix + "_" + setname;
                for (String key : dapattr.getAttributes().keySet()) {
                    DapAttribute subattr = (DapAttribute)dapattr.getAttributes().get(key);
                    cdmattr = this.createAttribute(prefix, subattr, nodemap);
                }
                break;
            }
            case OTHERXML: {
                ArrayList<String> cdmvalues = new ArrayList<String>();
                cdmvalues.add("OtherXML");
                cdmattr = new Attribute("OtherXML", cdmvalues);
            }
        }
        nodemap.put((DapNode)dapattr, cdmattr);
        return cdmattr;
    }
}

