/*
 * Decompiled with CFR 0.152.
 */
package dap4.cdmshared;

import dap4.core.data.DataException;
import dap4.core.dmr.AtomicType;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnum;
import dap4.core.dmr.DapType;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.Slice;
import dap4.dap4shared.D4DataAtomic;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.DataType;
import ucar.ma2.ForbiddenConversionException;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.CDMNode;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;

public abstract class CDMUtil {
    static final String hexchars = "0123456789abcdef";

    public static List<Slice> createSlices(List<Range> rangelist) throws DapException {
        ArrayList<Slice> slices = new ArrayList<Slice>(rangelist.size());
        for (int i = 0; i < rangelist.size(); ++i) {
            Range r = rangelist.get(i);
            int stride = r.stride();
            int first = r.first();
            int n = r.length();
            int stop = first + n * stride;
            Slice cer = new Slice((long)first, (long)(stop - 1), (long)stride);
            slices.add(cer);
        }
        return slices;
    }

    public static boolean isWhole(List<Range> rangelist, List<DapDimension> dimset, int start, int stop) throws DapException {
        int rsize;
        int n = rsize = rangelist == null ? 0 : rangelist.size();
        if (rsize != dimset.size()) {
            throw new DapException("range/dimset rank mismatch");
        }
        if (rsize == 0) {
            return true;
        }
        if (start < 0 || stop < start || stop > rsize) {
            throw new DapException("Invalid start/stop indices");
        }
        for (int i = start; i < stop; ++i) {
            Range r = rangelist.get(i);
            DapDimension d = dimset.get(i);
            if (r.stride() == 1 && r.first() == 0 && (long)r.length() == d.getSize()) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhole(List<Range> rangelist, List<Slice> slices) throws DapException {
        if (rangelist.size() != slices.size()) {
            return false;
        }
        for (int i = 0; i < rangelist.size(); ++i) {
            Range r = rangelist.get(i);
            Slice slice = slices.get(i);
            if (r.stride() == 1 && r.first() == 0 && (long)r.length() == slice.getCount()) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhole(List<Range> rangelist, Variable var) throws DapException {
        List dimset = var.getDimensions();
        if (rangelist.size() != dimset.size()) {
            return false;
        }
        for (int i = 0; i < rangelist.size(); ++i) {
            Range r = rangelist.get(i);
            Dimension dim = (Dimension)dimset.get(i);
            if (r.stride() == 1 && r.first() == 0 && r.length() == dim.getLength()) continue;
            return false;
        }
        return true;
    }

    public static List<Range> createCDMRanges(List<Slice> slices) throws IOException {
        ArrayList<Range> cdmranges = new ArrayList<Range>();
        for (int i = 0; i < slices.size(); ++i) {
            Slice r = slices.get(i);
            try {
                Range cmdr = new Range((int)r.getFirst(), (int)r.getLast(), (int)r.getStride());
                cdmranges.add(cmdr);
                continue;
            }
            catch (InvalidRangeException ire) {
                throw new IOException(ire);
            }
        }
        return cdmranges;
    }

    public static Variable unwrap(Variable var) {
        return (Variable)CDMNode.unwrap((CDMNode)var);
    }

    public static NetcdfFile unwrapfile(NetcdfFile file) {
        NetcdfDataset ds;
        while (file instanceof NetcdfDataset && (file = (ds = (NetcdfDataset)file).getReferencedFile()) != null) {
        }
        return file;
    }

    public static boolean hasVLEN(List<Range> ranges) {
        if (ranges == null || ranges.size() == 0) {
            return false;
        }
        return ranges.get(ranges.size() - 1) == Range.VLEN;
    }

    public static boolean hasVLEN(Variable v) {
        for (Dimension dim : v.getDimensions()) {
            if (!dim.isVariableLength()) continue;
            return true;
        }
        return false;
    }

    public static DataType enumtypefor(DapType dt) {
        switch (dt.getAtomicType()) {
            case Char: 
            case Int8: 
            case UInt8: {
                return DataType.ENUM1;
            }
            case Int16: 
            case UInt16: {
                return DataType.ENUM2;
            }
            case Int32: 
            case UInt32: {
                return DataType.ENUM4;
            }
            case Enum: {
                return CDMUtil.enumtypefor(((DapEnum)dt).getBaseType());
            }
        }
        return null;
    }

    public static DapType cdmtype2daptype(DataType datatype) {
        switch (datatype) {
            case CHAR: {
                return DapType.CHAR;
            }
            case BYTE: {
                return DapType.INT8;
            }
            case SHORT: {
                return DapType.INT16;
            }
            case INT: {
                return DapType.INT32;
            }
            case LONG: {
                return DapType.INT64;
            }
            case UBYTE: {
                return DapType.UINT8;
            }
            case USHORT: {
                return DapType.UINT16;
            }
            case UINT: {
                return DapType.UINT32;
            }
            case ULONG: {
                return DapType.UINT64;
            }
            case FLOAT: {
                return DapType.FLOAT32;
            }
            case DOUBLE: {
                return DapType.FLOAT64;
            }
            case STRING: {
                return DapType.STRING;
            }
            case OPAQUE: {
                return DapType.OPAQUE;
            }
            case ENUM1: {
                return DapType.INT8;
            }
            case ENUM2: {
                return DapType.INT16;
            }
            case ENUM4: {
                return DapType.INT32;
            }
        }
        return null;
    }

    public static DataType daptype2cdmtype(DapType daptype) {
        AtomicType atomtype = daptype.getPrimitiveType();
        switch (atomtype) {
            case Char: {
                return DataType.CHAR;
            }
            case UInt8: {
                return DataType.UBYTE;
            }
            case Int8: {
                return DataType.BYTE;
            }
            case Int16: {
                return DataType.SHORT;
            }
            case UInt16: {
                return DataType.USHORT;
            }
            case Int32: {
                return DataType.INT;
            }
            case UInt32: {
                return DataType.UINT;
            }
            case Int64: {
                return DataType.LONG;
            }
            case UInt64: {
                return DataType.ULONG;
            }
            case Float32: {
                return DataType.FLOAT;
            }
            case Float64: {
                return DataType.DOUBLE;
            }
            case String: 
            case URL: {
                return DataType.STRING;
            }
            case Opaque: {
                return DataType.OPAQUE;
            }
            case Enum: {
                DapEnum dapenum = (DapEnum)daptype;
                switch (dapenum.getBaseType().getAtomicType()) {
                    case Char: 
                    case Int8: 
                    case UInt8: {
                        return DataType.ENUM1;
                    }
                    case Int16: 
                    case UInt16: {
                        return DataType.ENUM2;
                    }
                    case Int32: 
                    case UInt32: {
                        return DataType.ENUM4;
                    }
                    case Int64: 
                    case UInt64: {
                        return DataType.ENUM4;
                    }
                }
                break;
            }
            case Structure: {
                return DataType.STRUCTURE;
            }
        }
        return null;
    }

    public static int daptypeSize(AtomicType atomtype) {
        switch (atomtype) {
            case Char: 
            case Int8: 
            case UInt8: {
                return 1;
            }
            case Int16: 
            case UInt16: {
                return 2;
            }
            case Int32: 
            case UInt32: 
            case Float32: {
                return 4;
            }
            case Int64: 
            case UInt64: 
            case Float64: {
                return 8;
            }
        }
        return 0;
    }

    public static Class cdmElementClass(DataType dt) {
        switch (dt) {
            case BOOLEAN: {
                return Boolean.TYPE;
            }
            case BYTE: 
            case ENUM1: {
                return Byte.TYPE;
            }
            case CHAR: {
                return Character.TYPE;
            }
            case SHORT: 
            case ENUM2: {
                return Short.TYPE;
            }
            case INT: 
            case ENUM4: {
                return Integer.TYPE;
            }
            case LONG: {
                return Long.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
            case STRING: {
                return String.class;
            }
            case OPAQUE: {
                return ByteBuffer.class;
            }
            case UBYTE: {
                return Byte.class;
            }
            case USHORT: {
                return Short.class;
            }
            case UINT: {
                return Integer.class;
            }
            case ULONG: {
                return Long.class;
            }
        }
        return null;
    }

    public static int[] computeEffectiveShape(List<DapDimension> dimset) {
        if (dimset == null || dimset.size() == 0) {
            return new int[0];
        }
        int effectiverank = dimset.size();
        int[] shape = new int[effectiverank];
        for (int i = 0; i < effectiverank; ++i) {
            shape[i] = (int)dimset.get(i).getSize();
        }
        return shape;
    }

    static Object extractObject(AtomicType atomtype, D4DataAtomic dataset, long index) throws DataException {
        try {
            Object result = dataset.read(index);
            return result;
        }
        catch (IOException ioe) {
            throw new DataException((Throwable)ioe);
        }
    }

    public static long extractLongValue(AtomicType atomtype, D4DataAtomic dataset, long index) throws DataException {
        long lvalue;
        Object result;
        try {
            result = dataset.read(index);
        }
        catch (IOException ioe) {
            throw new DataException((Throwable)ioe);
        }
        switch (atomtype) {
            case Int8: {
                lvalue = ((Byte)result).byteValue();
                break;
            }
            case Char: 
            case UInt8: {
                lvalue = ((Byte)result).byteValue();
                lvalue &= 0xFFL;
                break;
            }
            case Int16: {
                lvalue = ((Short)result).shortValue();
                break;
            }
            case UInt16: {
                lvalue = ((Short)result).shortValue();
                lvalue &= 0xFFFFL;
                break;
            }
            case Int32: {
                lvalue = ((Integer)result).intValue();
                break;
            }
            case UInt32: {
                lvalue = ((Integer)result).intValue();
                lvalue &= 0xFFFFFFFFL;
                break;
            }
            case Int64: 
            case UInt64: {
                lvalue = (Long)result;
                break;
            }
            case Float32: {
                lvalue = (long)((Float)result).floatValue();
                break;
            }
            case Float64: {
                lvalue = (long)((Double)result).doubleValue();
                break;
            }
            default: {
                throw new ForbiddenConversionException("Type not convertible to long");
            }
        }
        return lvalue;
    }

    public static double extractDoubleValue(AtomicType atomtype, D4DataAtomic dataset, int index) throws DataException {
        Object result;
        try {
            result = dataset.read((long)index);
        }
        catch (IOException ioe) {
            throw new DataException((Throwable)ioe);
        }
        double dvalue = 0.0;
        if (atomtype.isIntegerType() || atomtype.isEnumType()) {
            long lvalue = CDMUtil.extractLongValue(atomtype, dataset, index);
            dvalue = lvalue;
        } else if (atomtype == AtomicType.Float32) {
            dvalue = ((Float)result).floatValue();
        } else if (atomtype == AtomicType.Float64) {
            dvalue = (Double)result;
        } else {
            throw new ForbiddenConversionException();
        }
        return dvalue;
    }

    public static Object convertVector(DapType dsttype, DapType srctype, Object src) {
        AtomicType dstatomtype;
        AtomicType srcatomtype = srctype.getPrimitiveType();
        if (srcatomtype == (dstatomtype = dsttype.getPrimitiveType())) {
            return src;
        }
        if (srcatomtype.isIntegerType() && AtomicType.getSignedVersion((AtomicType)srcatomtype) == AtomicType.getSignedVersion((AtomicType)dstatomtype)) {
            return src;
        }
        Object[] result = null;
        boolean ok = true;
        int len = 0;
        boolean srcunsigned = srcatomtype.isUnsigned();
        boolean dstunsigned = dstatomtype.isUnsigned();
        block0 : switch (srcatomtype) {
            case Char: {
                char[] csrc = (char[])src;
                len = csrc.length;
                switch (dstatomtype) {
                    case Char: 
                    case Int8: 
                    case UInt8: {
                        return src;
                    }
                    case Int16: 
                    case UInt16: {
                        short[] shresult;
                        result = shresult = new short[len];
                        for (int i = 0; i < len; ++i) {
                            shresult[i] = (short)(csrc[i] & 0xFF);
                        }
                        break block0;
                    }
                    case Int32: 
                    case UInt32: {
                        int[] iresult = new int[len];
                        result = iresult;
                        for (int i = 0; i < len; ++i) {
                            iresult[i] = csrc[i] & 0xFF;
                        }
                        break block0;
                    }
                    case Int64: 
                    case UInt64: {
                        long[] lresult = new long[len];
                        result = lresult;
                        for (int i = 0; i < len; ++i) {
                            lresult[i] = csrc[i] & 0xFF;
                        }
                        break block0;
                    }
                    case Float32: {
                        float[] fresult = new float[len];
                        result = fresult;
                        for (int i = 0; i < len; ++i) {
                            fresult[i] = csrc[i] & 0xFF;
                        }
                        break block0;
                    }
                    case Float64: {
                        double[] dresult = new double[len];
                        result = dresult;
                        for (int i = 0; i < len; ++i) {
                            dresult[i] = csrc[i] & 0xFF;
                        }
                        break block0;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
                break;
            }
            case Int8: {
                byte[] bsrc = (byte[])src;
                len = bsrc.length;
                switch (dstatomtype) {
                    case Char: {
                        char[] cresult = new char[len];
                        result = cresult;
                        for (int i = 0; i < len; ++i) {
                            cresult[i] = (char)(bsrc[i] & 0xFF);
                        }
                        break block0;
                    }
                    case Int16: 
                    case UInt16: {
                        int i;
                        short[] shresult = new short[len];
                        result = shresult;
                        for (i = 0; i < len; ++i) {
                            shresult[i] = bsrc[i];
                        }
                        if (!dstunsigned) break block0;
                        i = 0;
                        while (i < len) {
                            int n = i++;
                            shresult[n] = (short)(shresult[n] & 0xFF);
                        }
                        break block0;
                    }
                    case Int32: 
                    case UInt32: {
                        int i;
                        int[] iresult = new int[len];
                        result = iresult;
                        for (i = 0; i < len; ++i) {
                            iresult[i] = bsrc[i];
                        }
                        if (!dstunsigned) break block0;
                        i = 0;
                        while (i < len) {
                            int n = i++;
                            iresult[n] = iresult[n] & 0xFF;
                        }
                        break block0;
                    }
                    case Int64: 
                    case UInt64: {
                        int i;
                        long[] lresult = new long[len];
                        result = lresult;
                        for (i = 0; i < len; ++i) {
                            lresult[i] = bsrc[i];
                        }
                        if (!dstunsigned) break block0;
                        i = 0;
                        while (i < len) {
                            int n = i++;
                            lresult[n] = lresult[n] & 0xFFL;
                        }
                        break block0;
                    }
                    case Float32: {
                        float[] fresult = new float[len];
                        result = fresult;
                        for (int i = 0; i < len; ++i) {
                            fresult[i] = bsrc[i];
                        }
                        break block0;
                    }
                    case Float64: {
                        double[] dresult = new double[len];
                        result = dresult;
                        for (int i = 0; i < len; ++i) {
                            dresult[i] = bsrc[i];
                        }
                        break block0;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
                break;
            }
            case UInt8: {
                byte[] bsrc = (byte[])src;
                len = bsrc.length;
                switch (dstatomtype) {
                    case Char: {
                        char[] cresult = new char[len];
                        result = cresult;
                        for (int i = 0; i < len; ++i) {
                            cresult[i] = (char)(bsrc[i] & 0xFF);
                        }
                        break block0;
                    }
                    case Int16: 
                    case UInt16: {
                        short[] shresult = new short[len];
                        result = shresult;
                        for (int i = 0; i < len; ++i) {
                            shresult[i] = (short)(bsrc[i] & 0xFF);
                        }
                        break block0;
                    }
                    case Int32: 
                    case UInt32: {
                        int[] iresult = new int[len];
                        result = iresult;
                        for (int i = 0; i < len; ++i) {
                            iresult[i] = bsrc[i] & 0xFF;
                        }
                        break block0;
                    }
                    case Int64: 
                    case UInt64: {
                        long[] lresult = new long[len];
                        result = lresult;
                        for (int i = 0; i < len; ++i) {
                            lresult[i] = (long)bsrc[i] & 0xFFL;
                        }
                        break block0;
                    }
                    case Float32: {
                        float[] fresult = new float[len];
                        result = fresult;
                        for (int i = 0; i < len; ++i) {
                            fresult[i] = bsrc[i] & 0xFF;
                        }
                        break block0;
                    }
                    case Float64: {
                        double[] dresult = new double[len];
                        result = dresult;
                        for (int i = 0; i < len; ++i) {
                            dresult[i] = bsrc[i] & 0xFF;
                        }
                        break block0;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
                break;
            }
            case Int16: {
                short[] shsrc = (short[])src;
                len = shsrc.length;
                switch (dstatomtype) {
                    case Char: {
                        char[] cresult = new char[len];
                        result = cresult;
                        for (int i = 0; i < len; ++i) {
                            cresult[i] = (char)(shsrc[i] & 0xFF);
                        }
                        break block0;
                    }
                    case Int8: 
                    case UInt8: {
                        byte[] bresult = new byte[len];
                        result = bresult;
                        for (int i = 0; i < len; ++i) {
                            bresult[i] = (byte)shsrc[i];
                        }
                        break block0;
                    }
                    case Int32: 
                    case UInt32: {
                        int i;
                        int[] iresult = new int[len];
                        result = iresult;
                        for (i = 0; i < len; ++i) {
                            iresult[i] = shsrc[i];
                        }
                        if (!dstunsigned) break block0;
                        i = 0;
                        while (i < len) {
                            int n = i++;
                            iresult[n] = iresult[n] & 0xFFFF;
                        }
                        break block0;
                    }
                    case Int64: 
                    case UInt64: {
                        int i;
                        long[] lresult = new long[len];
                        result = lresult;
                        for (i = 0; i < len; ++i) {
                            lresult[i] = shsrc[i];
                        }
                        if (!dstunsigned) break block0;
                        i = 0;
                        while (i < len) {
                            int n = i++;
                            lresult[n] = lresult[n] & 0xFFFFL;
                        }
                        break block0;
                    }
                    case Float32: {
                        float[] fresult = new float[len];
                        result = fresult;
                        for (int i = 0; i < len; ++i) {
                            fresult[i] = shsrc[i];
                        }
                        break block0;
                    }
                    case Float64: {
                        double[] dresult = new double[len];
                        result = dresult;
                        for (int i = 0; i < len; ++i) {
                            dresult[i] = shsrc[i];
                        }
                        break block0;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
                break;
            }
            case UInt16: {
                short[] shsrc = (short[])src;
                len = shsrc.length;
                switch (dstatomtype) {
                    case Char: {
                        char[] cresult = new char[len];
                        result = cresult;
                        for (int i = 0; i < len; ++i) {
                            cresult[i] = (char)(shsrc[i] & 0xFF);
                        }
                        break block0;
                    }
                    case Int8: 
                    case UInt8: {
                        byte[] bresult = new byte[len];
                        result = bresult;
                        for (int i = 0; i < len; ++i) {
                            bresult[i] = (byte)shsrc[i];
                        }
                        break block0;
                    }
                    case Int32: 
                    case UInt32: {
                        int[] iresult = new int[len];
                        result = iresult;
                        for (int i = 0; i < len; ++i) {
                            iresult[i] = shsrc[i] & 0xFFFF;
                        }
                        break block0;
                    }
                    case Int64: 
                    case UInt64: {
                        long[] lresult = new long[len];
                        result = lresult;
                        for (int i = 0; i < len; ++i) {
                            lresult[i] = (long)shsrc[i] & 0xFFFFL;
                        }
                        break block0;
                    }
                    case Float32: {
                        float[] fresult = new float[len];
                        result = fresult;
                        for (int i = 0; i < len; ++i) {
                            fresult[i] = shsrc[i] & 0xFFFF;
                        }
                        break block0;
                    }
                    case Float64: {
                        double[] dresult = new double[len];
                        result = dresult;
                        for (int i = 0; i < len; ++i) {
                            dresult[i] = shsrc[i] & 0xFFFF;
                        }
                        break block0;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
                break;
            }
            case Int32: {
                int[] isrc = (int[])src;
                len = isrc.length;
                switch (dstatomtype) {
                    case Char: {
                        char[] cresult = new char[len];
                        result = cresult;
                        for (int i = 0; i < len; ++i) {
                            cresult[i] = (char)(isrc[i] & 0xFF);
                        }
                        break block0;
                    }
                    case Int8: 
                    case UInt8: {
                        byte[] bresult = new byte[len];
                        result = bresult;
                        for (int i = 0; i < len; ++i) {
                            bresult[i] = (byte)isrc[i];
                        }
                        break block0;
                    }
                    case Int16: 
                    case UInt16: {
                        short[] shresult = new short[len];
                        result = shresult;
                        for (int i = 0; i < len; ++i) {
                            shresult[i] = (short)isrc[i];
                        }
                        break block0;
                    }
                    case Int64: 
                    case UInt64: {
                        int i;
                        long[] lresult = new long[len];
                        result = lresult;
                        for (i = 0; i < len; ++i) {
                            lresult[i] = isrc[i];
                        }
                        if (!dstunsigned) break block0;
                        i = 0;
                        while (i < len) {
                            int n = i++;
                            lresult[n] = lresult[n] & 0xFFFFL;
                        }
                        break block0;
                    }
                    case Float32: {
                        float[] fresult = new float[len];
                        result = fresult;
                        for (int i = 0; i < len; ++i) {
                            fresult[i] = isrc[i];
                        }
                        break block0;
                    }
                    case Float64: {
                        double[] dresult = new double[len];
                        result = dresult;
                        for (int i = 0; i < len; ++i) {
                            dresult[i] = isrc[i];
                        }
                        break block0;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
                break;
            }
            case UInt32: {
                int[] isrc = (int[])src;
                len = isrc.length;
                switch (dstatomtype) {
                    case Char: {
                        char[] cresult = new char[len];
                        result = cresult;
                        for (int i = 0; i < len; ++i) {
                            cresult[i] = (char)(isrc[i] & 0xFF);
                        }
                        break block0;
                    }
                    case Int8: 
                    case UInt8: {
                        byte[] bresult = new byte[len];
                        result = bresult;
                        for (int i = 0; i < len; ++i) {
                            bresult[i] = (byte)isrc[i];
                        }
                        break block0;
                    }
                    case Int16: 
                    case UInt16: {
                        short[] shresult = new short[len];
                        result = shresult;
                        for (int i = 0; i < len; ++i) {
                            shresult[i] = (short)isrc[i];
                        }
                        break block0;
                    }
                    case Int64: 
                    case UInt64: {
                        int i;
                        long[] lresult = new long[len];
                        result = lresult;
                        for (i = 0; i < len; ++i) {
                            lresult[i] = isrc[i];
                        }
                        if (!dstunsigned) break block0;
                        i = 0;
                        while (i < len) {
                            int n = i++;
                            lresult[n] = lresult[n] & 0xFFFFFFFFL;
                        }
                        break block0;
                    }
                    case Float32: {
                        float[] fresult = new float[len];
                        result = fresult;
                        for (int i = 0; i < len; ++i) {
                            fresult[i] = isrc[i] & 0xFFFF;
                        }
                        break block0;
                    }
                    case Float64: {
                        double[] dresult = new double[len];
                        result = dresult;
                        for (int i = 0; i < len; ++i) {
                            dresult[i] = isrc[i] & 0xFFFF;
                        }
                        break block0;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
                break;
            }
            case Int64: {
                long[] lsrc = (long[])src;
                len = lsrc.length;
                switch (dstatomtype) {
                    case Char: {
                        char[] cresult = new char[len];
                        result = cresult;
                        for (int i = 0; i < len; ++i) {
                            cresult[i] = (char)(lsrc[i] & 0xFFL);
                        }
                        break block0;
                    }
                    case Int8: 
                    case UInt8: {
                        byte[] bresult = new byte[len];
                        result = bresult;
                        for (int i = 0; i < len; ++i) {
                            bresult[i] = (byte)lsrc[i];
                        }
                        break block0;
                    }
                    case Int16: 
                    case UInt16: {
                        short[] shresult = new short[len];
                        result = shresult;
                        for (int i = 0; i < len; ++i) {
                            shresult[i] = (short)lsrc[i];
                        }
                        break block0;
                    }
                    case Int32: 
                    case UInt32: {
                        int[] iresult = new int[len];
                        result = iresult;
                        for (int i = 0; i < len; ++i) {
                            iresult[i] = (int)lsrc[i];
                        }
                        break block0;
                    }
                    case Float32: {
                        float[] fresult = new float[len];
                        result = fresult;
                        for (int i = 0; i < len; ++i) {
                            fresult[i] = lsrc[i];
                        }
                        break block0;
                    }
                    case Float64: {
                        double[] dresult = new double[len];
                        result = dresult;
                        for (int i = 0; i < len; ++i) {
                            dresult[i] = lsrc[i];
                        }
                        break block0;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
                break;
            }
            case UInt64: {
                long[] lsrc = (long[])src;
                len = lsrc.length;
                switch (dstatomtype) {
                    case Char: {
                        char[] cresult = new char[len];
                        result = cresult;
                        for (int i = 0; i < len; ++i) {
                            cresult[i] = (char)(lsrc[i] & 0xFFL);
                        }
                        break block0;
                    }
                    case Int8: 
                    case UInt8: {
                        byte[] bresult = new byte[len];
                        result = bresult;
                        for (int i = 0; i < len; ++i) {
                            bresult[i] = (byte)lsrc[i];
                        }
                        break block0;
                    }
                    case Int16: 
                    case UInt16: {
                        short[] shresult = new short[len];
                        result = shresult;
                        for (int i = 0; i < len; ++i) {
                            shresult[i] = (short)lsrc[i];
                        }
                        break block0;
                    }
                    case Int32: 
                    case UInt32: {
                        int[] iresult = new int[len];
                        result = iresult;
                        for (int i = 0; i < len; ++i) {
                            iresult[i] = (int)lsrc[i];
                        }
                        break block0;
                    }
                    case Float32: {
                        float[] fresult = new float[len];
                        result = fresult;
                        for (int i = 0; i < len; ++i) {
                            BigInteger bi = BigInteger.valueOf(lsrc[i]);
                            bi = bi.and(DapUtil.BIG_UMASK64);
                            fresult[i] = bi.floatValue();
                        }
                        break block0;
                    }
                    case Float64: {
                        double[] dresult = new double[len];
                        result = dresult;
                        for (int i = 0; i < len; ++i) {
                            BigInteger bi = BigInteger.valueOf(lsrc[i]);
                            bi = bi.and(DapUtil.BIG_UMASK64);
                            dresult[i] = bi.doubleValue();
                        }
                        break block0;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
                break;
            }
            case Float32: {
                float[] fsrc = (float[])src;
                len = fsrc.length;
                block85 : switch (dstatomtype) {
                    case Char: {
                        char[] cresult = new char[len];
                        result = cresult;
                        for (int i = 0; i < len; ++i) {
                            cresult[i] = (char)((int)fsrc[i] & 0xFF);
                        }
                        break block0;
                    }
                    case Int8: {
                        byte[] bresult = new byte[len];
                        result = bresult;
                        for (int i = 0; i < len; ++i) {
                            bresult[i] = (byte)fsrc[i];
                        }
                        break block0;
                    }
                    case UInt8: {
                        byte[] bresult = new byte[len];
                        result = bresult;
                        for (int i = 0; i < len; ++i) {
                            if (fsrc[i] < 0.0f) {
                                ok = false;
                                break block85;
                            }
                            bresult[i] = (byte)fsrc[i];
                        }
                        break block0;
                    }
                    case Int16: {
                        short[] shresult = new short[len];
                        result = shresult;
                        for (int i = 0; i < len; ++i) {
                            shresult[i] = (short)fsrc[i];
                        }
                        break block0;
                    }
                    case UInt16: {
                        short[] shresult = new short[len];
                        result = shresult;
                        for (int i = 0; i < len; ++i) {
                            if (fsrc[i] < 0.0f) {
                                ok = false;
                                break block85;
                            }
                            shresult[i] = (short)fsrc[i];
                        }
                        break block0;
                    }
                    case Int32: 
                    case UInt32: {
                        int[] iresult = new int[len];
                        result = iresult;
                        for (int i = 0; i < len; ++i) {
                            if (fsrc[i] < 0.0f) {
                                ok = false;
                                break block85;
                            }
                            iresult[i] = (int)fsrc[i];
                        }
                        break block0;
                    }
                    case Int64: {
                        long[] lresult = new long[len];
                        result = lresult;
                        for (int i = 0; i < len; ++i) {
                            BigDecimal bd = new BigDecimal(fsrc[i]);
                            lresult[i] = bd.toBigInteger().longValue();
                        }
                        break block0;
                    }
                    case UInt64: {
                        long[] lresult = new long[len];
                        result = lresult;
                        for (int i = 0; i < len; ++i) {
                            if (fsrc[i] < 0.0f) {
                                ok = false;
                                break block85;
                            }
                            BigDecimal bd = new BigDecimal(fsrc[i]);
                            lresult[i] = bd.toBigInteger().longValue();
                        }
                        break block0;
                    }
                    case Float64: {
                        double[] dresult = new double[len];
                        result = dresult;
                        for (int i = 0; i < len; ++i) {
                            dresult[i] = fsrc[i];
                        }
                        break block0;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
                break;
            }
            case Float64: {
                double[] dsrc = (double[])src;
                len = dsrc.length;
                block96 : switch (dstatomtype) {
                    case Char: {
                        char[] cresult = new char[len];
                        result = cresult;
                        for (int i = 0; i < len; ++i) {
                            cresult[i] = (char)((int)dsrc[i] & 0xFF);
                        }
                        break block0;
                    }
                    case Int8: 
                    case UInt8: {
                        byte[] bresult = new byte[len];
                        result = bresult;
                        for (int i = 0; i < len; ++i) {
                            bresult[i] = (byte)dsrc[i];
                        }
                        break block0;
                    }
                    case Int16: 
                    case UInt16: {
                        short[] shresult = new short[len];
                        result = shresult;
                        for (int i = 0; i < len; ++i) {
                            shresult[i] = (short)dsrc[i];
                        }
                        break block0;
                    }
                    case Int32: 
                    case UInt32: {
                        int[] iresult = new int[len];
                        result = iresult;
                        for (int i = 0; i < len; ++i) {
                            iresult[i] = (int)dsrc[i];
                        }
                        break block0;
                    }
                    case Int64: {
                        long[] lresult = new long[len];
                        result = lresult;
                        for (int i = 0; i < len; ++i) {
                            BigDecimal bd = new BigDecimal(dsrc[i]);
                            lresult[i] = bd.toBigInteger().longValue();
                        }
                        break block0;
                    }
                    case UInt64: {
                        long[] lresult = new long[len];
                        result = lresult;
                        for (int i = 0; i < len; ++i) {
                            if (dsrc[i] < 0.0) {
                                ok = false;
                                break block96;
                            }
                            BigDecimal bd = new BigDecimal(dsrc[i]);
                            lresult[i] = bd.toBigInteger().longValue();
                        }
                        break block0;
                    }
                    case Float32: {
                        float[] fresult = new float[len];
                        result = fresult;
                        for (int i = 0; i < len; ++i) {
                            fresult[i] = (float)dsrc[i];
                        }
                        break block0;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
                break;
            }
            default: {
                throw new ForbiddenConversionException();
            }
        }
        if (!ok) {
            throw new ForbiddenConversionException();
        }
        return result;
    }

    public static Object createVector(AtomicType atype, long count) {
        int icount = (int)count;
        Object[] vector = null;
        switch (atype) {
            case Char: {
                vector = new char[icount];
                break;
            }
            case Int8: 
            case UInt8: {
                vector = new byte[icount];
                break;
            }
            case Int16: 
            case UInt16: {
                vector = new short[icount];
                break;
            }
            case Int32: 
            case UInt32: {
                vector = new int[icount];
                break;
            }
            case Int64: 
            case UInt64: {
                vector = new long[icount];
                break;
            }
            case Float32: {
                vector = new float[icount];
                break;
            }
            case Float64: {
                vector = new double[icount];
                break;
            }
            case String: 
            case URL: {
                vector = new String[icount];
                break;
            }
            case Opaque: {
                vector = new ByteBuffer[icount];
                break;
            }
            default: {
                throw new ForbiddenConversionException();
            }
        }
        return vector;
    }

    public static String getChecksumString(byte[] checksum) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < checksum.length; ++i) {
            byte b = checksum[i];
            buf.append(hexchars.charAt(b >> 4));
            buf.append(hexchars.charAt(b & 0xF));
        }
        return buf.toString();
    }

    public static List<Range> dimsetToRanges(List<DapDimension> dimset) throws DapException {
        if (dimset == null) {
            return null;
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (int i = 0; i < dimset.size(); ++i) {
            DapDimension dim = dimset.get(i);
            try {
                Range r = new Range(dim.getShortName(), 0, (int)dim.getSize() - 1, 1);
                ranges.add(r);
                continue;
            }
            catch (InvalidRangeException ire) {
                throw new DapException((Throwable)ire);
            }
        }
        return ranges;
    }

    public static List<Slice> shapeToSlices(int[] shape) throws DapException {
        if (shape == null) {
            return null;
        }
        ArrayList<Slice> slices = new ArrayList<Slice>(shape.length);
        for (int i = 0; i < shape.length; ++i) {
            Slice sl = new Slice(0L, (long)(shape[i] - 1), 1L);
            slices.add(sl);
        }
        return slices;
    }
}

