/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr.parser;

import dap4.core.dmr.AtomicType;
import dap4.core.dmr.DapAtomicVariable;
import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnum;
import dap4.core.dmr.DapFactory;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapMap;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.dmr.DapXML;
import dap4.core.dmr.ErrorResponse;
import dap4.core.dmr.parser.Dap4Actions;
import dap4.core.dmr.parser.Dap4ParserBody;
import dap4.core.dmr.parser.ParseException;
import dap4.core.dmr.parser.ParseUtil;
import dap4.core.dmr.parser.SaxEvent;
import dap4.core.dmr.parser.SaxEventType;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.DapUtil;
import dap4.core.util.Escape;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import org.xml.sax.SAXException;

public class Dap4Parser
extends Dap4ParserBody {
    protected static final boolean isdatadmr = false;
    protected DapFactory factory = null;
    protected ErrorResponse errorresponse = null;
    protected Deque<DapNode> scopestack = new ArrayDeque<DapNode>();
    protected DapDataset root = null;
    protected boolean debug = false;

    public Dap4Parser(DapFactory factory) {
        this.factory = factory;
    }

    public ErrorResponse getErrorResponse() {
        return this.errorresponse;
    }

    public DapDataset getDMR() {
        return this.root;
    }

    @Override
    public boolean parse(String input) throws SAXException {
        return super.parse(input);
    }

    DapGroup getGroupScope() throws DapException {
        DapGroup gscope = (DapGroup)this.searchScope(DapSort.GROUP, DapSort.DATASET);
        if (gscope == null) {
            throw new DapException("Undefined Group Scope");
        }
        return gscope;
    }

    DapNode getMetadataScope() throws DapException {
        DapNode match = this.searchScope(METADATASCOPES);
        if (match == null) {
            throw new ParseException("No enclosing metadata capable scope");
        }
        return match;
    }

    DapNode getParentScope() throws DapException {
        DapNode parent = this.searchScope(DapSort.STRUCTURE, DapSort.SEQUENCE, DapSort.GROUP, DapSort.DATASET);
        if (parent == null) {
            throw new DapException("Undefined parent Scope");
        }
        return parent;
    }

    DapVariable getVariableScope() throws DapException {
        DapNode match = this.searchScope(DapSort.ATOMICVARIABLE, DapSort.STRUCTURE, DapSort.SEQUENCE);
        if (match == null) {
            throw new ParseException("No enclosing variable scope");
        }
        return (DapVariable)match;
    }

    DapNode getScope(DapSort ... sort) throws DapException {
        DapNode node = this.searchScope(sort);
        if (node == null) {
            throw new ParseException("No enclosing scope of specified type");
        }
        return node;
    }

    DapNode searchScope(DapSort ... sort) {
        for (DapNode node : this.scopestack) {
            for (int j = 0; j < sort.length; ++j) {
                if (node.getSort() != sort[j]) continue;
                return node;
            }
        }
        return null;
    }

    DapVariable findVariable(DapNode parent, String name) {
        DapVariable var = null;
        switch (parent.getSort()) {
            case DATASET: 
            case GROUP: {
                var = ((DapGroup)parent).findVariable(name);
                break;
            }
            case STRUCTURE: {
                var = ((DapStructure)parent).findByName(name);
                break;
            }
            case SEQUENCE: {
                var = ((DapSequence)parent).findByName(name);
                break;
            }
        }
        return var;
    }

    SaxEvent pull(Dap4Actions.XMLAttributeMap map, String name) {
        SaxEvent event = (SaxEvent)map.remove(name.toLowerCase());
        return event;
    }

    SaxEvent peek(Dap4Actions.XMLAttributeMap map, String name) {
        SaxEvent event = (SaxEvent)map.get(name.toLowerCase());
        return event;
    }

    DapAttribute makeAttribute(DapSort sort, String name, DapType basetype, List<String> nslist, DapNode parent) throws DapException {
        DapAttribute attr = (DapAttribute)this.newNode(name, sort);
        if (sort == DapSort.ATTRIBUTE) {
            attr.setBaseType(basetype);
        }
        parent.addAttribute(attr);
        attr.setNamespaceList(nslist);
        return attr;
    }

    boolean isempty(SaxEvent token) {
        return token == null || this.isempty(token.value);
    }

    boolean isempty(String text) {
        return text == null || text.length() == 0;
    }

    List<String> convertNamespaceList(Dap4Actions.NamespaceList nslist) {
        return nslist;
    }

    boolean islegalenumtype(DapType kind) {
        return kind.isIntegerType();
    }

    boolean islegalattributetype(DapType kind) {
        return kind.isLegalAttrType();
    }

    DapAttribute lookupAttribute(DapNode parent, Dap4Actions.XMLAttributeMap attrs) throws DapException {
        SaxEvent name = this.pull(attrs, "name");
        if (this.isempty(name)) {
            throw new ParseException("Attribute: Empty attribute name");
        }
        String attrname = name.value;
        return parent.findAttribute(attrname);
    }

    void changeAttribute(DapAttribute attr, Dap4Actions.XMLAttributeMap description) throws DapException {
        SaxEvent name = this.pull(description, "name");
        if (this.isempty(name)) {
            throw new ParseException("Attribute: Empty attribute name");
        }
        String attrname = name.value;
        if (!attr.getShortName().equals(attrname)) {
            throw new ParseException("Attribute: DATA DMR: Attribute name mismatch:" + name.name);
        }
        switch (attr.getSort()) {
            case ATTRIBUTE: {
                DapType basetype;
                String typename;
                SaxEvent atype = this.pull(description, "type");
                SaxEvent value = this.pull(description, "value");
                String string = typename = atype == null ? "Int32" : atype.value;
                if ("Byte".equalsIgnoreCase(typename)) {
                    typename = "UInt8";
                }
                if ((basetype = DapType.reify(typename)) != attr.getBaseType()) {
                    throw new ParseException("Attribute: DATA DMR: Attempt to change attribute type: " + typename);
                }
                attr.clearValues();
                if (value == null) break;
                attr.addValue(value.value);
                break;
            }
            case ATTRIBUTESET: {
                attr.setAttributes(new HashMap<String, DapAttribute>());
                break;
            }
            case OTHERXML: {
                throw new ParseException("Attribute: DATA DMR: OtherXML attributes not supported");
            }
        }
    }

    DapAttribute createatomicattribute(Dap4Actions.XMLAttributeMap attrs, Dap4Actions.NamespaceList nslist, DapNode parent) throws DapException {
        DapType basetype;
        String typename;
        SaxEvent name = this.pull(attrs, "name");
        SaxEvent atype = this.pull(attrs, "type");
        if (this.isempty(name)) {
            throw new ParseException("Attribute: Empty attribute name");
        }
        String string = typename = atype == null ? "Int32" : atype.value;
        if ("Byte".equalsIgnoreCase(typename)) {
            typename = "UInt8";
        }
        if ((basetype = DapType.reify(typename)) == null || !this.islegalattributetype(basetype)) {
            throw new ParseException("Attribute: Invalid attribute type: " + typename);
        }
        List<String> hreflist = this.convertNamespaceList(nslist);
        DapAttribute attr = this.makeAttribute(DapSort.ATTRIBUTE, name.value, basetype, hreflist, parent);
        return attr;
    }

    DapAttribute createcontainerattribute(Dap4Actions.XMLAttributeMap attrs, Dap4Actions.NamespaceList nslist, DapNode parent) throws DapException {
        SaxEvent name = this.pull(attrs, "name");
        if (this.isempty(name)) {
            throw new ParseException("ContainerAttribute: Empty attribute name");
        }
        List<String> hreflist = this.convertNamespaceList(nslist);
        DapAttribute attr = this.makeAttribute(DapSort.ATTRIBUTESET, name.value, null, hreflist, parent);
        return attr;
    }

    void createvalue(SaxEvent value, DapAttribute parent) throws DapException {
        List<String> textlist = null;
        if (value.eventtype == SaxEventType.CHARACTERS) {
            textlist = ParseUtil.collectValues(value.text);
        } else if (value.eventtype == SaxEventType.ATTRIBUTE) {
            textlist = new ArrayList<String>();
            textlist.add(value.value);
        }
        if (textlist != null) {
            for (String v : textlist) {
                parent.addValue(v);
            }
        }
    }

    DapAttribute createotherxml(Dap4Actions.XMLAttributeMap attrs, DapNode parent) throws DapException {
        SaxEvent name = this.pull(attrs, "name");
        SaxEvent href = this.pull(attrs, "href");
        if (this.isempty(name)) {
            throw new ParseException("OtherXML: Empty name");
        }
        ArrayList<String> nslist = new ArrayList<String>();
        if (!this.isempty(href)) {
            nslist.add(href.value);
        }
        DapAttribute other = this.makeAttribute(DapSort.OTHERXML, name.value, null, nslist, parent);
        parent.setAttribute(other);
        return other;
    }

    @Override
    DapNode newNode(String name, DapSort sort) throws ParseException {
        DapNode node = (DapNode)this.factory.newNode(sort);
        node.setDataset(this.root);
        if (name != null) {
            node.setShortName(name);
        }
        return node;
    }

    @Override
    void enterdataset(Dap4Actions.XMLAttributeMap attrs) throws ParseException {
        boolean bl = this.debug = this.getDebugLevel() > 0;
        if (this.debug) {
            this.report("enterdataset");
        }
        SaxEvent name = this.pull(attrs, "name");
        SaxEvent dapversion = this.pull(attrs, "dapversion");
        SaxEvent dmrversion = this.pull(attrs, "dmrversion");
        if (this.isempty(name)) {
            throw new ParseException("Empty dataset name attribute");
        }
        float ndapversion = 4.0f;
        try {
            ndapversion = Float.parseFloat(dapversion.value);
        }
        catch (NumberFormatException nfe) {
            ndapversion = 4.0f;
        }
        if (ndapversion != 4.0f) {
            throw new ParseException("Dataset dapVersion mismatch: " + dapversion.value);
        }
        float ndmrversion = 4.0f;
        try {
            ndmrversion = Float.parseFloat(dmrversion.value);
        }
        catch (NumberFormatException nfe) {
            ndmrversion = 1.0f;
        }
        if (ndmrversion != 1.0f) {
            throw new ParseException("Dataset dmrVersion mismatch: " + dmrversion.value);
        }
        this.root = (DapDataset)this.newNode(name.value, DapSort.DATASET);
        this.root.setDapVersion(Float.toString(ndapversion));
        this.root.setDMRVersion(Float.toString(ndmrversion));
        this.root.setDataset(this.root);
        this.scopestack.push(this.root);
    }

    @Override
    void leavedataset() throws ParseException {
        if (this.debug) {
            this.report("leavedataset");
        }
        assert (this.scopestack.peek() != null && this.scopestack.peek().getSort() == DapSort.DATASET);
        this.root.sort();
        this.scopestack.pop();
        if (!this.scopestack.isEmpty()) {
            throw new ParseException("Dataset: nested dataset");
        }
        this.root.finish();
    }

    @Override
    void entergroup(SaxEvent name) throws ParseException {
        if (this.debug) {
            this.report("entergroup");
        }
        try {
            if (this.isempty(name)) {
                throw new ParseException("Empty group name");
            }
            DapGroup parent = this.getGroupScope();
            DapGroup group = (DapGroup)this.newNode(name.value, DapSort.GROUP);
            parent.addDecl(group);
            this.scopestack.push(group);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void leavegroup() throws ParseException {
        if (this.debug) {
            this.report("leavegroup");
        }
        this.scopestack.pop();
    }

    @Override
    void enterenumdef(Dap4Actions.XMLAttributeMap attrs) throws ParseException {
        if (this.debug) {
            this.report("enterenumdef");
        }
        try {
            SaxEvent name = this.pull(attrs, "name");
            if (this.isempty(name)) {
                throw new ParseException("Enumdef: Empty Enum Declaration name");
            }
            SaxEvent basetype = this.pull(attrs, "basetype");
            DapType basedaptype = null;
            if (basetype == null) {
                basedaptype = DapEnum.DEFAULTBASETYPE;
            } else {
                String typename = basetype.value;
                if ("Byte".equalsIgnoreCase(typename)) {
                    typename = "UInt8";
                }
                if ((basedaptype = DapType.reify(typename)) == null || !this.islegalenumtype(basedaptype)) {
                    throw new ParseException("Enumdef: Invalid Enum Declaration Type name: " + basetype.value);
                }
            }
            DapEnum dapenum = null;
            dapenum = (DapEnum)this.newNode(name.value, DapSort.ENUMERATION);
            dapenum.setBaseType(basedaptype);
            DapGroup parent = this.getGroupScope();
            parent.addDecl(dapenum);
            this.scopestack.push(dapenum);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void leaveenumdef() throws ParseException {
        DapEnum eparent;
        List<String> econsts;
        if (this.debug) {
            this.report("leaveenumdef");
        }
        if ((econsts = (eparent = (DapEnum)this.scopestack.pop()).getNames()).size() == 0) {
            throw new ParseException("Enumdef: no enum constants specified");
        }
    }

    @Override
    void enumconst(SaxEvent name, SaxEvent value) throws ParseException {
        if (this.debug) {
            this.report("enumconst");
        }
        if (this.isempty(name)) {
            throw new ParseException("Enumconst: Empty enum constant name");
        }
        if (this.isempty(value)) {
            throw new ParseException("Enumdef: Invalid enum constant value: " + value.value);
        }
        long lvalue = 0L;
        try {
            BigInteger bivalue = new BigInteger(value.value);
            bivalue = DapUtil.BIG_UMASK64.and(bivalue);
            lvalue = bivalue.longValue();
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Enumconst: illegal value: " + value.value);
        }
        try {
            DapEnum parent = (DapEnum)this.getScope(DapSort.ENUMERATION);
            if (!ParseUtil.isLegalEnumConstName(name.value)) {
                throw new ParseException("Enumconst: illegal enumeration constant name: " + name.value);
            }
            parent.addEnumConst(name.value, lvalue);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void enterdimdef(Dap4Actions.XMLAttributeMap attrs) throws ParseException {
        if (this.debug) {
            this.report("enterdimdef");
        }
        SaxEvent name = this.pull(attrs, "name");
        SaxEvent size = this.pull(attrs, "size");
        long lvalue = 0L;
        if (this.isempty(name)) {
            throw new ParseException("Dimdef: Empty dimension declaration name");
        }
        if (this.isempty(size)) {
            throw new ParseException("Dimdef: Empty dimension declaration size");
        }
        try {
            lvalue = Long.parseLong(size.value);
            if (lvalue <= 0L) {
                throw new ParseException("Dimdef: value <= 0: " + lvalue);
            }
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Dimdef: non-integer value: " + size.value);
        }
        DapDimension dim = null;
        try {
            dim = (DapDimension)this.newNode(name.value, DapSort.DIMENSION);
            dim.setSize(lvalue);
            dim.setShared(true);
            DapGroup parent = this.getGroupScope();
            parent.addDecl(dim);
            this.scopestack.push(dim);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void leavedimdef() throws ParseException {
        if (this.debug) {
            this.report("leavedimdef");
        }
        this.scopestack.pop();
    }

    @Override
    void dimref(SaxEvent nameorsize) throws ParseException {
        if (this.debug) {
            this.report("dimref");
        }
        try {
            DapDimension dim = null;
            DapVariable var = this.getVariableScope();
            assert (var != null) : "Internal error";
            boolean isname = nameorsize.name.equals("name");
            if (isname && this.isempty(nameorsize)) {
                throw new ParseException("Dimref: Empty dimension reference name");
            }
            if (this.isempty(nameorsize)) {
                throw new ParseException("Dimref: Empty dimension size");
            }
            if (isname) {
                dim = (DapDimension)var.getGroup().findByFQN(nameorsize.value, DapSort.DIMENSION);
            } else {
                String ssize = nameorsize.value.trim();
                if (ssize.equals("*")) {
                    dim = DapDimension.VLEN;
                } else {
                    long anonsize;
                    assert (this.root != null);
                    try {
                        anonsize = Long.parseLong(nameorsize.value.trim());
                    }
                    catch (NumberFormatException nfe) {
                        throw new ParseException("Dimref: Illegal dimension size");
                    }
                    dim = this.root.createAnonymous(anonsize);
                }
            }
            if (dim == null) {
                throw new ParseException("Unknown dimension: " + nameorsize.value);
            }
            var.addDimension(dim);
        }
        catch (DapException de) {
            throw new ParseException(de.getMessage(), de.getCause());
        }
    }

    @Override
    void enteratomicvariable(SaxEvent open, SaxEvent name) throws ParseException {
        if (this.debug) {
            this.report("enteratomicvariable");
        }
        try {
            DapType basetype;
            if (this.isempty(name)) {
                throw new ParseException("Atomicvariable: Empty dimension reference name");
            }
            String typename = open.name;
            if ("Byte".equals(typename)) {
                typename = "UInt8";
            }
            if ((basetype = DapType.reify(typename)) == null) {
                throw new ParseException("AtomicVariable: Illegal type: " + open.name);
            }
            DapVariable var = null;
            var = (DapVariable)this.newNode(name.value, DapSort.ATOMICVARIABLE);
            var.setBaseType(basetype);
            DapNode parent = this.scopestack.peek();
            switch (parent.getSort()) {
                case DATASET: 
                case GROUP: {
                    ((DapGroup)parent).addDecl(var);
                    break;
                }
                case STRUCTURE: {
                    ((DapStructure)parent).addField(var);
                    break;
                }
                case SEQUENCE: {
                    ((DapSequence)parent).addField(var);
                    break;
                }
                default: {
                    assert (false) : "Atomic variable in illegal scope";
                    break;
                }
            }
            this.scopestack.push(var);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    void openclosematch(SaxEvent close, DapSort sort) throws ParseException {
        String typename = close.name;
        if ("Byte".equals(typename)) {
            typename = "UInt8";
        }
        AtomicType atype = AtomicType.getAtomicType(typename);
        DapVariable var = (DapVariable)this.searchScope(sort);
        assert (var != null);
        AtomicType vartype = var.getBaseType().getAtomicType();
        if (atype == null) {
            throw new ParseException("Variable: Illegal type: " + typename);
        }
        if (atype != vartype) {
            throw new ParseException(String.format("variable: open/close type mismatch: <%s> </%s>", new Object[]{vartype, atype}));
        }
    }

    void leavevariable() throws ParseException {
        this.scopestack.pop();
    }

    @Override
    void leaveatomicvariable(SaxEvent close) throws ParseException {
        this.openclosematch(close, DapSort.ATOMICVARIABLE);
        this.leavevariable();
    }

    @Override
    void enterenumvariable(Dap4Actions.XMLAttributeMap attrs) throws ParseException {
        if (this.debug) {
            this.report("enterenumvariable");
        }
        try {
            SaxEvent name = this.pull(attrs, "name");
            SaxEvent enumtype = this.pull(attrs, "enum");
            if (this.isempty(name)) {
                throw new ParseException("Enumvariable: Empty variable name");
            }
            if (this.isempty(enumtype)) {
                throw new ParseException("Enumvariable: Empty enum type name");
            }
            DapEnum target = (DapEnum)this.root.findByFQN(enumtype.value, DapSort.ENUMERATION);
            if (target == null) {
                throw new ParseException("EnumVariable: no such enum: " + name.value);
            }
            DapVariable var = null;
            var = (DapVariable)this.newNode(name.value, DapSort.ATOMICVARIABLE);
            var.setBaseType(target);
            DapNode parent = this.scopestack.peek();
            switch (parent.getSort()) {
                case DATASET: 
                case GROUP: {
                    ((DapGroup)parent).addDecl(var);
                    break;
                }
                case STRUCTURE: {
                    ((DapStructure)parent).addField(var);
                    break;
                }
                case SEQUENCE: {
                    ((DapSequence)parent).addField(var);
                    break;
                }
                default: {
                    assert (false) : "Atomic variable in illegal scope";
                    break;
                }
            }
            this.scopestack.push(var);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void leaveenumvariable(SaxEvent close) throws ParseException {
        if (this.debug) {
            this.report("leaveenumvariable");
        }
        this.openclosematch(close, DapSort.ATOMICVARIABLE);
        this.leavevariable();
    }

    @Override
    void entermap(SaxEvent name) throws ParseException {
        DapNode scope;
        DapAtomicVariable var;
        if (this.debug) {
            this.report("entermap");
        }
        if (this.isempty(name)) {
            throw new ParseException("Mapref: Empty map name");
        }
        try {
            var = (DapAtomicVariable)this.root.findByFQN(name.value, DapSort.ATOMICVARIABLE);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
        if (var == null) {
            throw new ParseException("Mapref: undefined variable: " + name.name);
        }
        DapNode container = var.getContainer();
        try {
            scope = this.getParentScope();
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
        if ((container.getSort() == DapSort.STRUCTURE || container.getSort() == DapSort.SEQUENCE) && container == scope) {
            throw new ParseException("Mapref: map variable not in outer scope: " + name.name);
        }
        DapMap map = (DapMap)this.newNode(DapSort.MAP);
        map.setVariable(var);
        try {
            DapVariable parent = (DapVariable)this.searchScope(DapSort.ATOMICVARIABLE, DapSort.STRUCTURE, DapSort.SEQUENCE);
            parent.addMap(map);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
        this.scopestack.push(map);
    }

    @Override
    void leavemap() throws ParseException {
        if (this.debug) {
            this.report("leavemap");
        }
        this.scopestack.pop();
    }

    @Override
    void enterstructurevariable(SaxEvent name) throws ParseException {
        if (this.debug) {
            this.report("enterstructurevariable");
        }
        if (this.isempty(name)) {
            throw new ParseException("Structure: Empty structure name");
        }
        try {
            DapStructure var = null;
            var = (DapStructure)this.newNode(name.value, DapSort.STRUCTURE);
            var.setBaseType(DapType.STRUCT);
            DapNode parent = this.scopestack.peek();
            switch (parent.getSort()) {
                case DATASET: 
                case GROUP: {
                    ((DapGroup)parent).addDecl(var);
                    break;
                }
                case STRUCTURE: 
                case SEQUENCE: {
                    ((DapStructure)parent).addField(var);
                    break;
                }
                default: {
                    assert (false) : "Structure variable in illegal scope";
                    break;
                }
            }
            this.scopestack.push(var);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void leavestructurevariable(SaxEvent close) throws ParseException {
        if (this.debug) {
            this.report("leavestructurevariable");
        }
        this.openclosematch(close, DapSort.STRUCTURE);
        this.leavevariable();
    }

    @Override
    void entersequencevariable(SaxEvent name) throws ParseException {
        if (this.debug) {
            this.report("entersequencevariable");
        }
        if (this.isempty(name)) {
            throw new ParseException("Sequence: Empty sequence name");
        }
        try {
            DapSequence var = null;
            var = (DapSequence)this.newNode(name.value, DapSort.SEQUENCE);
            var.setBaseType(DapType.SEQ);
            DapNode parent = this.scopestack.peek();
            switch (parent.getSort()) {
                case DATASET: 
                case GROUP: {
                    ((DapGroup)parent).addDecl(var);
                    break;
                }
                case STRUCTURE: {
                    ((DapStructure)parent).addField(var);
                    break;
                }
                case SEQUENCE: {
                    ((DapSequence)parent).addField(var);
                    break;
                }
                default: {
                    assert (false) : "Structure variable in illegal scope";
                    break;
                }
            }
            this.scopestack.push(var);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void leavesequencevariable(SaxEvent close) throws ParseException {
        if (this.debug) {
            this.report("leavesequencevariable");
        }
        this.openclosematch(close, DapSort.SEQUENCE);
        this.leavevariable();
    }

    @Override
    void enteratomicattribute(Dap4Actions.XMLAttributeMap attrs, Dap4Actions.NamespaceList nslist) throws ParseException {
        if (this.debug) {
            this.report("enteratomicattribute");
        }
        try {
            DapNode parent = this.getMetadataScope();
            DapAttribute attr = null;
            attr = this.createatomicattribute(attrs, nslist, parent);
            this.scopestack.push(attr);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void leaveatomicattribute() throws ParseException {
        DapAttribute attr;
        if (this.debug) {
            this.report("leaveatomicattribute");
        }
        if ((attr = (DapAttribute)this.scopestack.pop()).getValues().size() == 0) {
            throw new ParseException("AtomicAttribute: attribute has no values");
        }
    }

    @Override
    void entercontainerattribute(Dap4Actions.XMLAttributeMap attrs, Dap4Actions.NamespaceList nslist) throws ParseException {
        if (this.debug) {
            this.report("entercontainerattribute");
        }
        try {
            DapNode parent = this.getMetadataScope();
            DapAttribute attr = null;
            attr = this.createcontainerattribute(attrs, nslist, parent);
            this.scopestack.push(attr);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void leavecontainerattribute() throws ParseException {
        if (this.debug) {
            this.report("leavecontainerattribute");
        }
        this.scopestack.pop();
    }

    @Override
    void value(SaxEvent value) throws ParseException {
        if (this.debug) {
            this.report("value");
        }
        try {
            DapAttribute parent = (DapAttribute)this.getScope(DapSort.ATTRIBUTE);
            this.createvalue(value, parent);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void enterotherxml(Dap4Actions.XMLAttributeMap attrs) throws ParseException {
        if (this.debug) {
            this.report("enterotherxml");
        }
        try {
            DapNode parent = this.getMetadataScope();
            DapAttribute other = this.createotherxml(attrs, parent);
            parent.setAttribute(other);
            this.scopestack.push(other);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void leaveotherxml() throws ParseException {
        if (this.debug) {
            this.report("leaveotherxml");
        }
        this.scopestack.pop();
    }

    @Override
    void enterxmlelement(SaxEvent open, Dap4Actions.XMLAttributeMap map) throws ParseException {
        if (this.debug) {
            this.report("enterxmlelement");
        }
        try {
            DapNode parent = this.scopestack.peek();
            DapXML xml = this.createxmlelement(open, map, parent);
            this.scopestack.push(xml);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void leavexmlelement(SaxEvent close) throws ParseException {
        if (this.debug) {
            this.report("leavexmlelement");
        }
        try {
            DapXML open = (DapXML)this.getScope(DapSort.XML);
            if (!open.getShortName().equals(close.name)) {
                throw new ParseException(String.format("otherxml: open/close name mismatch: <%s> </%s>", open.getShortName(), close.name));
            }
            this.scopestack.pop();
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void xmltext(SaxEvent text) throws ParseException {
        if (this.debug) {
            this.report("xmltext");
        }
        try {
            DapXML txt = this.createxmltext(text.text);
            DapXML parent = (DapXML)this.getScope(DapSort.XML);
            parent.addElement(txt);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void entererror(Dap4Actions.XMLAttributeMap attrs) throws ParseException {
        SaxEvent xhttpcode;
        if (this.debug) {
            this.report("entererror");
        }
        String shttpcode = (xhttpcode = this.pull(attrs, "httpcode")) == null ? "400" : xhttpcode.value;
        int httpcode = 0;
        try {
            httpcode = Integer.parseInt(shttpcode);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Error Response; illegal http code: " + shttpcode);
        }
        this.errorresponse = new ErrorResponse();
        this.errorresponse.setCode(httpcode);
    }

    @Override
    void leaveerror() throws ParseException {
        if (this.debug) {
            this.report("leaveerror");
        }
        assert (this.errorresponse != null) : "Internal Error";
    }

    @Override
    void errormessage(SaxEvent value) throws ParseException {
        if (this.debug) {
            this.report("errormessage");
        }
        assert (this.errorresponse != null) : "Internal Error";
        assert (value.eventtype == SaxEventType.CHARACTERS) : "Internal error";
        String message = value.text;
        message = Escape.entityUnescape(message);
        this.errorresponse.setMessage(message);
    }

    @Override
    void errorcontext(SaxEvent value) throws ParseException {
        if (this.debug) {
            this.report("errorcontext");
        }
        assert (this.errorresponse != null) : "Internal Error";
        assert (value.eventtype == SaxEventType.CHARACTERS) : "Internal error";
        String context = value.text;
        context = Escape.entityUnescape(context);
        this.errorresponse.setContext(context);
    }

    @Override
    void errorotherinfo(SaxEvent value) throws ParseException {
        if (this.debug) {
            this.report("errorotherinfo");
        }
        assert (this.errorresponse != null) : "Internal Error";
        assert (value.eventtype == SaxEventType.CHARACTERS) : "Internal error";
        String other = value.text;
        other = Escape.entityUnescape(other);
        this.errorresponse.setOtherInfo(other);
    }

    void report(String action) {
        this.getDebugStream().println("ACTION: " + action);
        this.getDebugStream().flush();
    }
}

