/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr;

import dap4.core.dmr.DapType;
import dap4.core.util.DapException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DapEnum
extends DapType {
    public static final DapType DEFAULTBASETYPE = DapType.INT32;
    protected DapType basetype = DEFAULTBASETYPE;
    protected List<String> names = null;
    protected Map<String, Long> namemap = null;
    protected Map<Long, String> valuemap = null;

    public DapEnum(String name) {
        super(name);
    }

    public DapType getBaseType() {
        return this.basetype;
    }

    public void setBaseType(DapType basetype) throws DapException {
        if (!basetype.isIntegerType()) {
            throw new DapException("DapEnum: illegal base type: " + basetype);
        }
        this.basetype = basetype;
    }

    public void addEnumConst(String name, Long value) throws DapException {
        if (this.names == null) {
            this.names = new ArrayList<String>();
            this.namemap = new HashMap<String, Long>();
            this.valuemap = new HashMap<Long, String>();
        }
        Long oldvalue = this.namemap.get(name);
        String oldname = this.valuemap.get(value);
        if (oldname != null) {
            throw new DapException("DapEnum: Duplicate enum constant name: " + name);
        }
        if (oldvalue != null) {
            throw new DapException("DapEnum: Duplicate enum constant value: " + value);
        }
        this.namemap.put(name, value);
        this.valuemap.put(value, name);
        this.names.add(name);
    }

    public List<String> getNames() {
        return this.names;
    }

    public Long lookup(String name) {
        return this.namemap.get(name);
    }

    public String lookup(long value) {
        return this.valuemap.get(value);
    }
}

