/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import dap4.core.util.DapException;
import dap4.core.util.Slice;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class SliceConstraint {
    protected int rank = 0;
    protected List<List<Slice>> slicesets = null;
    protected int[] pos = null;

    public SliceConstraint() {
    }

    public SliceConstraint(int rank) throws DapException {
        this.slicesets = new ArrayList<List<Slice>>();
        this.rank = rank;
        this.pos = new int[this.rank];
        Arrays.fill(this.pos, 0);
    }

    public SliceConstraint(List<List<Slice>> ss) throws DapException {
        this(ss.size());
        for (int i = 0; i < this.rank; ++i) {
            this.add(ss.get(i));
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.rank; ++i) {
            List<Slice> slices = this.slicesets.get(i);
            buf.append("[");
            for (int j = 0; j < slices.size(); ++j) {
                if (j > 0) {
                    buf.append(",");
                }
                buf.append(slices.get(j).toString());
            }
            buf.append("]");
        }
        return buf.toString();
    }

    protected void add(List<Slice> slices) throws DapException {
        if (slices == null || slices.size() == 0) {
            throw new DapException("Null slice set");
        }
        if (this.slicesets.size() == this.rank) {
            throw new DapException("Sliceset overflow");
        }
        this.slicesets.add(slices);
    }

    public int getRank() {
        return this.rank;
    }

    public List<Slice> get(int i) {
        return this.slicesets.get(i);
    }

    public Iterator<List<Slice>> iterator() {
        return new SliceCEIterator(this);
    }

    public static class SliceCEIterator
    implements Iterator<List<Slice>> {
        protected SliceConstraint sce;
        protected int rank;
        protected int[] pos;

        public SliceCEIterator(SliceConstraint sce) {
            this.sce = sce;
            this.rank = sce.getRank();
            this.pos = new int[this.rank];
            Arrays.fill(this.pos, 0);
        }

        @Override
        public boolean hasNext() {
            for (int i = 0; i < this.rank; ++i) {
                List<Slice> innerset = this.sce.get(i);
                if (this.pos[i] >= innerset.size()) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<Slice> next() {
            List<Slice> innerset;
            int i;
            ArrayList<Slice> result = new ArrayList<Slice>();
            int index = -1;
            for (i = this.rank - 1; i >= 0; --i) {
                innerset = this.sce.get(i);
                if (this.pos[i] < innerset.size()) {
                    index = i;
                    int n = i;
                    this.pos[n] = this.pos[n] + 1;
                    break;
                }
                this.pos[i] = 0;
            }
            if (index < 0) {
                throw new NoSuchElementException();
            }
            for (i = 0; i < this.rank; ++i) {
                innerset = this.sce.get(i);
                result.add(innerset.get(this.pos[i]));
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

