/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import dap4.core.dmr.DapDimension;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.Index;
import dap4.core.util.MultiOdometer;
import dap4.core.util.ScalarOdometer;
import dap4.core.util.Slice;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Odometer
implements Iterator<Index> {
    protected STATE state = STATE.INITIAL;
    protected boolean ismulti = false;
    protected int rank = 0;
    protected List<Slice> slices = null;
    protected List<DapDimension> dimset = null;
    protected Index index;
    protected long[] endpoint;

    public static Odometer factoryScalar() {
        return new ScalarOdometer();
    }

    public static Odometer factory(List<Slice> slices) throws DapException {
        return Odometer.factory(slices, null);
    }

    public static Odometer factory(List<Slice> slices, List<DapDimension> dimset) throws DapException {
        if (dimset != null && dimset.size() == 0) {
            if (!DapUtil.isScalarSlices(slices)) {
                throw new DapException("Cannot build scalar odometer with non-scalar slices");
            }
            return Odometer.factoryScalar();
        }
        boolean multi = false;
        if (slices != null) {
            for (int i = 0; i < slices.size(); ++i) {
                if (slices.get(i).getSort() != Slice.Sort.Multi) continue;
                multi = true;
                break;
            }
        }
        if (slices == null || slices.size() == 0) {
            return Odometer.factoryScalar();
        }
        if (multi) {
            return new MultiOdometer(slices, dimset);
        }
        return new Odometer(slices, dimset);
    }

    public Odometer() {
    }

    public Odometer(List<Slice> set) throws DapException {
        this(set, null);
    }

    public Odometer(List<Slice> set, List<DapDimension> dimset) throws DapException {
        if (set == null) {
            throw new DapException("Null slice list");
        }
        if (dimset != null && set.size() != dimset.size()) {
            throw new DapException("Rank mismatch");
        }
        this.rank = set.size();
        if (this.rank == 0) {
            throw new DapException("Rank == 0; use Scalar Odometer");
        }
        this.slices = new ArrayList<Slice>();
        this.slices.addAll(set);
        if (dimset != null) {
            this.dimset = new ArrayList<DapDimension>();
            this.dimset.addAll(dimset);
        }
        this.endpoint = new long[this.rank];
        this.index = new Index(this.rank);
        for (int i = 0; i < this.rank; ++i) {
            this.index.dimsizes[i] = this.slices.get(i).getMax();
        }
        this.reset();
    }

    protected void reset() {
        for (int i = 0; i < this.rank; ++i) {
            try {
                this.slices.get(i).finish();
                this.index.indices[i] = this.slices.get(i).getFirst();
                this.endpoint[i] = this.slices.get(i).getLast() - this.slices.get(i).getStride();
                continue;
            }
            catch (DapException de) {
                throw new IllegalArgumentException(de);
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.rank; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            if (this.dimset != null) {
                buf.append(this.dimset.get(i) != null ? this.dimset.get(i).getShortName() : "null");
            }
            buf.append(this.slices.get(i).toString());
            buf.append(String.format("(%d)", this.slices.get(i).getCount()));
            if (this.index == null) continue;
            buf.append(String.format("@%d", this.index.indices[i]));
        }
        return buf.toString();
    }

    public int rank() {
        return this.rank;
    }

    public Slice slice(int i) {
        if (i < 0 || i >= this.rank) {
            throw new IllegalArgumentException();
        }
        return this.slices.get(i);
    }

    public List<Slice> getSlices() {
        return this.slices;
    }

    public long index() {
        return this.index.index();
    }

    public Index indices() {
        return this.index;
    }

    public long totalSize() {
        long size = 1L;
        for (int i = 0; i < this.rank; ++i) {
            size *= this.slices.get(i).getCount();
        }
        return size;
    }

    @Override
    public boolean hasNext() {
        int stop = this.rank;
        switch (this.state) {
            case INITIAL: {
                return true;
            }
            case STARTED: {
                for (int i = stop - 1; i >= 0; --i) {
                    if (this.index.indices[i] > this.endpoint[i]) continue;
                    return true;
                }
                this.state = STATE.DONE;
                break;
            }
        }
        return false;
    }

    @Override
    public Index next() {
        int lastpos = this.rank;
        int firstpos = 0;
        switch (this.state) {
            case INITIAL: {
                this.state = STATE.STARTED;
                break;
            }
            case STARTED: {
                int i = this.step(firstpos, lastpos);
                if (i >= 0) break;
                this.state = STATE.DONE;
                break;
            }
        }
        if (this.state == STATE.DONE) {
            throw new NoSuchElementException();
        }
        return this.indices();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int step(int firstpos, int lastpos) {
        for (int i = lastpos - 1; i >= firstpos; --i) {
            if (this.index.indices[i] <= this.endpoint[i]) {
                int n = i;
                this.index.indices[n] = this.index.indices[n] + this.slices.get(i).getStride();
                return i;
            }
            this.index.indices[i] = this.slices.get(i).getFirst();
        }
        return -1;
    }

    public List<Odometer> getSubOdometers() {
        ArrayList<Odometer> list = new ArrayList<Odometer>();
        list.add(this);
        return list;
    }

    public boolean isMulti() {
        return this.ismulti;
    }

    protected static enum STATE {
        INITIAL,
        STARTED,
        DONE;

    }
}

