/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr;

import java.nio.ByteBuffer;

public enum TypeSort {
    Char("Char", Character.TYPE, 5192),
    Int8("Int8", Byte.TYPE, 5185),
    UInt8("UInt8", Byte.TYPE, 5217),
    Int16("Int16", Short.TYPE, 5185),
    UInt16("UInt16", Short.TYPE, 5217),
    Int32("Int32", Integer.TYPE, 5185),
    UInt32("UInt32", Integer.TYPE, 5217),
    Int64("Int64", Long.TYPE, 5185),
    UInt64("UInt64", Long.TYPE, 5217),
    Float32("Float32", Float.TYPE, 5186),
    Float64("Float64", Double.TYPE, 5186),
    String("String", String.class, 5124),
    URL("URL", String.class, 5124),
    Opaque("Opaque", ByteBuffer.class, 5136),
    Enum("Enum", null, 5312),
    Structure("Structure", null, 2304),
    Sequence("Sequence", null, 2560);

    private final String typename;
    private final int classification;
    private final Class javaclass;

    private TypeSort(String typename, Class javaclass, int classification) {
        this.typename = typename;
        this.classification = classification;
        this.javaclass = javaclass;
    }

    public final String getTypeName() {
        return this.typename;
    }

    public final Class getJavaClass() {
        return this.javaclass;
    }

    public static final TypeSort getSignedVersion(TypeSort uat) {
        switch (uat) {
            case Int8: 
            case UInt8: {
                return Int8;
            }
            case Int16: 
            case UInt16: {
                return Int16;
            }
            case Int32: 
            case UInt32: {
                return Int32;
            }
            case Int64: 
            case UInt64: {
                return Int64;
            }
        }
        return null;
    }

    public static final int getSize(TypeSort uat) {
        switch (uat) {
            case Int8: 
            case UInt8: 
            case Char: {
                return 1;
            }
            case Int16: 
            case UInt16: {
                return 2;
            }
            case Int32: 
            case UInt32: 
            case Float32: {
                return 4;
            }
            case Int64: 
            case UInt64: 
            case Float64: {
                return 8;
            }
        }
        return 0;
    }

    public static TypeSort getTypeSort(String typename) {
        for (TypeSort dt : TypeSort.values()) {
            if (!typename.equalsIgnoreCase(dt.getTypeName())) continue;
            return dt;
        }
        return null;
    }

    public boolean isIntegerType() {
        return (this.classification & 1) != 0;
    }

    public boolean isFloatType() {
        return (this.classification & 2) != 0;
    }

    public boolean isStringType() {
        return (this.classification & 4) != 0;
    }

    public boolean isCharType() {
        return (this.classification & 8) != 0;
    }

    public boolean isEnumType() {
        return (this.classification & 0x80) != 0;
    }

    public boolean isOpaqueType() {
        return (this.classification & 0x10) != 0;
    }

    public boolean isStructType() {
        return (this.classification & 0x100) != 0;
    }

    public boolean isSeqType() {
        return (this.classification & 0x200) != 0;
    }

    public boolean isCompoundType() {
        return (this.classification & 0x100) != 0 || (this.classification & 0x200) != 0;
    }

    public boolean isNumericType() {
        return (this.classification & 3) != 0;
    }

    public boolean isUnsigned() {
        return (this.classification & 0x20) != 0;
    }

    public boolean isFixedSize() {
        return (this.classification & 0x40) != 0;
    }

    public boolean isLegalAttrType() {
        return (this.classification & 0x1000) != 0;
    }

    public boolean isCompound() {
        return (this.classification & 0x800) != 0;
    }

    public boolean isAtomic() {
        return (this.classification & 0x400) != 0;
    }
}

