/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapAttributeSet;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnumConst;
import dap4.core.dmr.DapEnumeration;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapMap;
import dap4.core.dmr.DapOtherXML;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;

public enum DapSort {
    ATOMICTYPE("AtomicType", DapType.class, new DapSort[0]),
    ATTRIBUTESET("AttributeSet", DapAttributeSet.class, new DapSort[0]),
    OTHERXML("OtherXML", DapOtherXML.class, new DapSort[0]),
    ATTRIBUTE("Attribute", DapAttribute.class, ATTRIBUTESET, OTHERXML),
    DIMENSION("Dimension", DapDimension.class, new DapSort[0]),
    MAP("Map", DapMap.class, new DapSort[0]),
    VARIABLE("Variable", DapVariable.class, new DapSort[0]),
    DATASET("Dataset", DapDataset.class, new DapSort[0]),
    GROUP("Group", DapGroup.class, DATASET),
    ENUMERATION("Enumeration", DapEnumeration.class, new DapSort[0]),
    ENUMCONST("EnumConst", DapEnumConst.class, new DapSort[0]),
    SEQUENCE("Sequence", DapSequence.class, new DapSort[0]),
    STRUCTURE("Structure", DapStructure.class, SEQUENCE);

    private final String name;
    private final Class classfor;
    private final DapSort[] subsorts;

    private DapSort(String name, Class classfor, DapSort ... subsorts) {
        this.name = name;
        this.classfor = classfor;
        this.subsorts = subsorts;
    }

    public final String getName() {
        return this.name;
    }

    public final Class getClassFor() {
        return this.classfor;
    }

    public boolean isa(DapSort supersort) {
        if (supersort == this) {
            return true;
        }
        for (DapSort sub : supersort.subsorts) {
            if (sub != this) continue;
            return true;
        }
        return false;
    }

    public boolean oneof(DapSort ... which) {
        for (DapSort sub : which) {
            if (sub != this) continue;
            return true;
        }
        return false;
    }

    public boolean isVar() {
        return this == VARIABLE;
    }

    public boolean isGroup() {
        return this == DATASET || this == GROUP;
    }

    public boolean isType() {
        return this == ATOMICTYPE || this == SEQUENCE || this == STRUCTURE || this == ENUMERATION;
    }

    public boolean isCompound() {
        return this == SEQUENCE || this == STRUCTURE;
    }
}

