/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib;

import dap4.core.ce.CEConstraint;
import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnumConst;
import dap4.core.dmr.DapEnumeration;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapMap;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.Escape;
import dap4.core.util.IndentWriter;
import dap4.core.util.ResponseFormat;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class DMRPrinter {
    protected static final int NILFLAGS = 0;
    protected static final int PERLINE = 1;
    protected static final int NONAME = 2;
    protected static final int NONNIL = 4;
    protected static final int XMLESCAPED = 8;
    protected static final String[] GROUPSPECIAL = new String[]{"_NCProperties", "_DAP4_Little_Endian"};
    protected static final String[] VARSPECIAL = new String[0];
    protected static final String[] RESERVEDTAGS = new String[]{"_edu.ucar"};
    public static final boolean ALLOWFIELDMAPS = false;
    protected PrintWriter writer = null;
    protected IndentWriter printer = null;
    protected DapDataset dmr = null;
    protected CEConstraint ce = null;
    protected ResponseFormat format = null;
    protected boolean testing = false;

    protected DMRPrinter() {
    }

    public DMRPrinter(DapDataset dmr, PrintWriter writer) {
        this(dmr, null, writer, null);
    }

    public DMRPrinter(DapDataset dmr, CEConstraint ce, PrintWriter writer, ResponseFormat format) {
        this();
        this.dmr = dmr;
        this.ce = ce;
        this.writer = writer;
        this.printer = new IndentWriter((Writer)writer);
        this.format = format == null ? ResponseFormat.XML : format;
    }

    public void flush() {
        this.printer.flush();
    }

    public void close() {
        this.flush();
    }

    public void print() throws IOException {
        if (this.ce == null) {
            this.ce = CEConstraint.getUniversal((DapDataset)this.dmr);
        }
        assert (this.ce != null);
        this.printer.setIndent(0);
        this.printNode((DapNode)this.dmr);
        this.printer.eol();
    }

    public void testprint() throws IOException {
        this.testing = true;
        this.print();
    }

    public void printNode(DapNode node) throws IOException {
        if (node == null) {
            return;
        }
        DapSort sort = node.getSort();
        String dmrname = sort.getName();
        switch (sort) {
            case DATASET: 
            case GROUP: {
                if (!this.ce.references(node)) break;
                DapGroup group = (DapGroup)node;
                this.printer.marginPrint("<" + dmrname);
                int flags = sort == DapSort.DATASET ? 1 : 0;
                this.printXMLAttributes(node, this.ce, flags);
                this.printer.println(">");
                this.printer.indent();
                if (group.getDimensions().size() > 0) {
                    for (DapNode subnode : group.getDimensions()) {
                        if (!this.ce.references(subnode)) continue;
                        this.printNode(subnode);
                        this.printer.eol();
                    }
                }
                if (group.getEnums().size() > 0) {
                    for (DapNode subnode : group.getEnums()) {
                        if (!this.ce.references(subnode)) continue;
                        this.printNode(subnode);
                        this.printer.eol();
                    }
                }
                if (group.getVariables().size() > 0) {
                    for (DapNode subnode : group.getVariables()) {
                        if (!this.ce.references(subnode)) continue;
                        this.printNode(subnode);
                        this.printer.eol();
                    }
                }
                this.printMetadata(node);
                if (group.getGroups().size() > 0) {
                    for (DapNode subnode : group.getGroups()) {
                        if (!this.ce.references(subnode)) continue;
                        this.printNode(subnode);
                        this.printer.eol();
                    }
                }
                this.printer.outdent();
                this.printer.marginPrint("</" + dmrname + ">");
                break;
            }
            case DIMENSION: {
                DapDimension dim;
                if (!this.ce.references(node) || !(dim = (DapDimension)node).isShared()) break;
                this.printer.marginPrint("<" + dmrname);
                this.printXMLAttributes(node, this.ce, 0);
                if (dim.isUnlimited()) {
                    this.printXMLAttribute("_edu.ucar.isunlimited", "1", 0);
                }
                if (this.hasMetadata(node)) {
                    this.printer.println(">");
                    this.printMetadata(node);
                    this.printer.marginPrint("</" + dmrname + ">");
                    break;
                }
                this.printer.print("/>");
                break;
            }
            case ENUMERATION: {
                if (!this.ce.references(node)) break;
                DapEnumeration en = (DapEnumeration)node;
                this.printer.marginPrint("<" + dmrname);
                this.printXMLAttributes((DapNode)en, this.ce, 0);
                this.printer.println(">");
                this.printer.indent();
                List econstnames = en.getNames();
                for (String econst : econstnames) {
                    DapEnumConst value = en.lookup(econst);
                    assert (value != null);
                    this.printer.marginPrintln(String.format("<EnumConst name=\"%s\" value=\"%d\"/>", Escape.entityEscape((String)econst, null), value.getValue()));
                }
                this.printMetadata(node);
                this.printer.outdent();
                this.printer.marginPrint("</" + dmrname + ">");
                break;
            }
            case VARIABLE: {
                if (!this.ce.references(node)) break;
                DapVariable var = (DapVariable)node;
                DapType type = var.getBaseType();
                this.printer.marginPrint("<" + type.getTypeSort().name());
                this.printXMLAttributes(node, this.ce, 0);
                if (type.isAtomic()) {
                    if (this.hasMetadata(node) || DMRPrinter.hasDimensions(var) || DMRPrinter.hasMaps(var)) {
                        this.printer.println(">");
                        this.printer.indent();
                        if (DMRPrinter.hasDimensions(var)) {
                            this.printDimrefs(var);
                        }
                        if (this.hasMetadata((DapNode)var)) {
                            this.printMetadata((DapNode)var);
                        }
                        if (DMRPrinter.hasMaps(var)) {
                            this.printMaps(var);
                        }
                        this.printer.outdent();
                        this.printer.marginPrint("</" + type.getTypeSort().name() + ">");
                        break;
                    }
                    this.printer.print("/>");
                    break;
                }
                if (type.getTypeSort().isCompound()) {
                    DapStructure struct = (DapStructure)type;
                    this.printer.println(">");
                    this.printer.indent();
                    for (DapVariable field : struct.getFields()) {
                        if (!this.ce.references((DapNode)field)) continue;
                        this.printNode((DapNode)field);
                        this.printer.eol();
                    }
                    this.printDimrefs(var);
                    this.printMetadata((DapNode)var);
                    this.printMaps(var);
                    this.printer.outdent();
                    this.printer.marginPrint("</" + type.getTypeSort().name() + ">");
                    break;
                }
                assert (false) : "Illegal variable base type";
                break;
            }
            default: {
                assert (false) : "Unexpected sort: " + sort.name();
                break;
            }
        }
    }

    void printXMLAttributes(DapNode node, CEConstraint ce, int flags) throws IOException {
        String name;
        if ((flags & 1) != 0) {
            this.printer.indent(2);
        }
        if ((name = node.getShortName()) != null && (flags & 2) == 0) {
            name = node.getShortName();
            this.printXMLAttribute("name", name, flags);
        }
        switch (node.getSort()) {
            case DATASET: {
                DapDataset dataset = (DapDataset)node;
                this.printXMLAttribute("dapVersion", dataset.getDapVersion(), flags);
                this.printXMLAttribute("dmrVersion", dataset.getDMRVersion(), flags);
                this.printXMLAttribute("xmlns", "http://xml.opendap.org/ns/DAP/4.0#", flags);
                this.printXMLAttribute("xmlns:dap", "http://xml.opendap.org/ns/DAP/4.0#", flags);
                break;
            }
            case DIMENSION: {
                DapDimension orig = (DapDimension)node;
                if (!orig.isShared()) break;
                DapDimension actual = this.ce.getRedefDim(orig);
                if (actual == null) {
                    actual = orig;
                }
                long size = actual.getSize();
                this.printXMLAttribute("size", Long.toString(size), flags);
                break;
            }
            case ENUMERATION: {
                this.printXMLAttribute("basetype", ((DapEnumeration)node).getBaseType().getTypeName(), flags);
                break;
            }
            case VARIABLE: {
                DapVariable var = (DapVariable)node;
                DapType basetype = var.getBaseType();
                if (!basetype.isEnumType()) break;
                this.printXMLAttribute("enum", basetype.getTypeName(), flags);
                break;
            }
            case ATTRIBUTE: {
                DapAttribute attr = (DapAttribute)node;
                DapType basetype = attr.getBaseType();
                this.printXMLAttribute("type", basetype.getTypeName(), flags);
                if (!attr.getBaseType().isEnumType()) break;
                this.printXMLAttribute("enum", basetype.getTypeName(), flags);
                break;
            }
        }
        if (!this.testing) {
            this.printReserved(node);
        }
        if ((flags & 1) != 0) {
            this.printer.outdent(2);
        }
    }

    protected void printXMLAttribute(String name, String value, int flags) throws DapException {
        if (name == null) {
            return;
        }
        if ((flags & 4) == 0 && (value == null || value.length() == 0)) {
            return;
        }
        if ((flags & 1) != 0) {
            this.printer.eol();
            this.printer.margin();
        }
        this.printer.print(" " + name + "=");
        this.printer.print("\"");
        if (value != null) {
            if ((flags & 8) == 0) {
                value = Escape.entityEscape((String)value, (String)"\"");
            }
            this.printer.print(value);
        }
        this.printer.print("\"");
    }

    protected void printReserved(DapNode node) throws DapException {
        Map xattrs = node.getXMLAttributes();
        if (xattrs == null) {
            return;
        }
        for (Map.Entry entry : xattrs.entrySet()) {
            if (!DMRPrinter.isReserved((String)entry.getKey())) continue;
            this.printXMLAttribute((String)entry.getKey(), (String)entry.getValue(), 0);
        }
    }

    protected void printMetadata(DapNode node) throws IOException {
        Map attributes = node.getAttributes();
        if (attributes.size() == 0) {
            return;
        }
        for (Map.Entry entry : attributes.entrySet()) {
            DapAttribute attr = (DapAttribute)entry.getValue();
            assert (attr != null);
            switch (attr.getSort()) {
                case ATTRIBUTE: {
                    this.printAttribute(attr);
                    break;
                }
                case ATTRIBUTESET: {
                    this.printContainerAttribute(attr);
                    break;
                }
                case OTHERXML: {
                    this.printOtherXML(attr);
                }
            }
        }
    }

    protected void printContainerAttribute(DapAttribute attr) {
    }

    protected void printOtherXML(DapAttribute attr) {
    }

    static boolean isSuppressed(String name) {
        return DMRPrinter.isReserved(name);
    }

    static boolean isReserved(String key) {
        for (String s : RESERVEDTAGS) {
            if (!key.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    static boolean isSpecial(DapAttribute attr) {
        block3: {
            block2: {
                if (attr.getParent().getSort() != DapSort.DATASET) break block2;
                for (String s : GROUPSPECIAL) {
                    if (!s.equals(attr.getShortName())) continue;
                    return true;
                }
                break block3;
            }
            if (attr.getParent().getSort() != DapSort.VARIABLE) break block3;
            for (String s : VARSPECIAL) {
                if (!s.equals(attr.getShortName())) continue;
                return true;
            }
        }
        return false;
    }

    void printAttribute(DapAttribute attr) throws IOException {
        if (this.testing && DMRPrinter.isSpecial(attr)) {
            return;
        }
        this.printer.marginPrint("<Attribute");
        this.printXMLAttribute("name", attr.getShortName(), 0);
        DapType type = attr.getBaseType();
        this.printXMLAttribute("type", type.getTypeName(), 0);
        this.printer.println(">");
        String[] values = attr.getValues();
        if (values == null) {
            throw new DapException("Attribute with no values:" + attr.getFQN());
        }
        this.printer.indent();
        String[] svec = values;
        if (type == DapType.CHAR) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < svec.length; ++i) {
                buf.append(svec[i]);
            }
            String cs = String.format("<Value value=\"%s\"/>", buf.toString());
            this.printer.marginPrintln(cs);
        } else if (type.isEnumType()) {
            String[] names = ((DapEnumeration)type).convert(svec);
            for (int i = 0; i < svec.length; ++i) {
                String s = Escape.entityEscape((String)names[i], null);
                String cs = String.format("<Value value=\"%s\"/>", s);
                this.printer.marginPrintln(cs);
            }
        } else {
            for (int i = 0; i < svec.length; ++i) {
                String s = Escape.entityEscape((String)svec[i], null);
                String cs = String.format("<Value value=\"%s\"/>", s);
                this.printer.marginPrintln(cs);
            }
        }
        this.printer.outdent();
        this.printer.marginPrintln("</Attribute>");
    }

    void printDimrefs(DapVariable var) throws DapException {
        if (var.getRank() == 0) {
            return;
        }
        List dimset = this.ce.getConstrainedDimensions(var);
        if (dimset == null) {
            throw new DapException("Unknown variable: " + var);
        }
        assert (var.getRank() == dimset.size());
        for (int i = 0; i < var.getRank(); ++i) {
            DapDimension dim = (DapDimension)dimset.get(i);
            this.printer.marginPrint("<Dim");
            if (dim.isShared()) {
                String fqn = dim.getFQN();
                assert (fqn != null) : "Illegal Dimension reference";
                fqn = DMRPrinter.fqnXMLEscape(fqn);
                this.printXMLAttribute("name", fqn, 8);
            } else {
                long size = dim.getSize();
                this.printXMLAttribute("size", Long.toString(size), 0);
            }
            this.printer.println("/>");
        }
    }

    void printMaps(DapVariable parent) throws IOException {
        if (this.testing) {
            return;
        }
        List maps = parent.getMaps();
        if (maps.size() == 0) {
            return;
        }
        for (DapMap map : maps) {
            DapVariable mapvar = map.getVariable();
            if (mapvar.getParent() != null && !mapvar.getParent().getSort().isGroup()) continue;
            String name = map.getFQN();
            assert (name != null) : "Illegal <Map> reference";
            this.printer.marginPrint("<Map");
            name = DMRPrinter.fqnXMLEscape(name);
            this.printXMLAttribute("name", name, 8);
            this.printXMLAttributes((DapNode)map, this.ce, 2);
            if (this.hasMetadata((DapNode)map)) {
                this.printer.println(">");
                this.printer.indent();
                this.printMetadata((DapNode)map);
                this.printer.outdent();
                this.printer.marginPrintln("</Map>");
                continue;
            }
            this.printer.println("/>");
        }
    }

    public static String fqnXMLEscape(String fqn) {
        int i;
        StringBuilder xml = new StringBuilder();
        String segment = null;
        List segments = Escape.backslashsplit((String)fqn, (char)'/');
        for (i = 1; i < segments.size() - 1; ++i) {
            segment = (String)segments.get(i);
            segment = Escape.backslashUnescape((String)segment);
            segment = Escape.entityEscape((String)segment, (String)"\"");
            segment = Escape.backslashEscape((String)segment, (String)"/.");
            xml.append("/");
            xml.append(segment);
        }
        segment = (String)segments.get(segments.size() - 1);
        segments = Escape.backslashsplit((String)segment, (char)'.');
        xml.append("/");
        for (i = 0; i < segments.size(); ++i) {
            segment = (String)segments.get(i);
            segment = Escape.backslashUnescape((String)segment);
            segment = Escape.entityEscape((String)segment, (String)"\"");
            segment = Escape.backslashEscape((String)segment, (String)"/.");
            if (i > 0) {
                xml.append(".");
            }
            xml.append(segment);
        }
        return xml.toString();
    }

    protected static String getPrintValue(Object value) {
        if (value instanceof String) {
            String sclean = Escape.cleanString((String)((String)value));
            return Escape.entityEscape((String)((String)value), null);
        }
        if (value instanceof Character) {
            return Escape.entityEscape((String)((Character)value).toString(), null);
        }
        return value.toString();
    }

    protected boolean hasMetadata(DapNode node) {
        return node.getAttributes().size() > 0;
    }

    protected static boolean hasMaps(DapVariable var) {
        return var.getMaps().size() > 0;
    }

    protected static boolean hasDimensions(DapVariable var) {
        return var.getDimensions().size() > 0;
    }
}

