/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib;

import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.dap4lib.ChunkInputStream;
import dap4.dap4lib.RequestMode;
import dap4.dap4lib.XURI;
import dap4.dap4lib.serial.D4DSP;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;

public class FileDSP
extends D4DSP {
    protected static final String[] EXTENSIONS = new String[]{".dap", ".raw"};
    protected byte[] raw = null;

    public boolean dspMatch(String location, DapContext context) {
        try {
            XURI xuri = new XURI(location);
            if (xuri.isFile()) {
                String path = xuri.getPath();
                for (String ext : EXTENSIONS) {
                    if (!path.endsWith(ext)) continue;
                    return true;
                }
            }
        }
        catch (URISyntaxException use) {
            return false;
        }
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public FileDSP open(String filepath) throws DapException {
        try {
            if (filepath.startsWith("file:")) {
                try {
                    XURI xuri = new XURI(filepath);
                    filepath = xuri.getPath();
                }
                catch (URISyntaxException use) {
                    throw new DapException("Malformed filepath: " + filepath).setCode(404);
                }
            }
            try (FileInputStream stream = new FileInputStream(filepath);){
                this.raw = DapUtil.readbinaryfile((InputStream)stream);
            }
            stream = new FileInputStream(filepath);
            try {
                ChunkInputStream rdr = new ChunkInputStream(stream, RequestMode.DAP);
                String document = rdr.readDMR();
                byte[] serialdata = DapUtil.readbinaryfile((InputStream)rdr);
                super.build(document, serialdata, rdr.getRemoteByteOrder());
            }
            finally {
                stream.close();
            }
            return this;
        }
        catch (IOException ioe) {
            throw new DapException((Throwable)ioe).setCode(500);
        }
    }

    public FileDSP open(byte[] rawdata) throws DapException {
        try {
            this.raw = rawdata;
            ByteArrayInputStream stream = new ByteArrayInputStream(this.raw);
            ChunkInputStream rdr = new ChunkInputStream(stream, RequestMode.DAP);
            String document = rdr.readDMR();
            byte[] serialdata = DapUtil.readbinaryfile((InputStream)rdr);
            super.build(document, serialdata, rdr.getRemoteByteOrder());
            return this;
        }
        catch (IOException ioe) {
            throw new DapException((Throwable)ioe).setCode(500);
        }
    }
}

