/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.dmr.DapDimension;
import dap4.core.util.DapException;
import dap4.core.util.Slice;
import dap4.dap4lib.D4Index;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import ucar.ma2.Index;

public class Odometer
implements Iterator<Index> {
    protected STATE state = STATE.INITIAL;
    protected int rank = 0;
    protected List<Slice> slices = null;
    protected List<DapDimension> dimset = null;
    protected D4Index index;
    protected long[] endpoint;

    protected Odometer() {
    }

    public Odometer(List<Slice> set, List<DapDimension> dimset) throws DapException {
        if (set == null) {
            throw new DapException("Null slice list");
        }
        assert (set != null && dimset != null);
        if (set.size() != dimset.size() && (dimset.size() != 0 || set.size() != 1)) {
            throw new DapException("Rank mismatch");
        }
        this.rank = set.size();
        assert (this.rank > 0);
        this.slices = new ArrayList<Slice>();
        this.slices.addAll(set);
        if (dimset != null) {
            this.dimset = new ArrayList<DapDimension>();
            this.dimset.addAll(dimset);
        }
        this.endpoint = new long[this.rank];
        int[] shape = new int[this.rank];
        for (int i = 0; i < this.rank; ++i) {
            shape[i] = this.slices.get(i).getMax();
        }
        this.index = new D4Index(shape);
        this.reset();
    }

    protected void reset() {
        try {
            int[] newcounter = new int[this.rank];
            for (int i = 0; i < this.rank; ++i) {
                this.slices.get(i).finish();
                newcounter[i] = this.slices.get(i).getFirst();
                this.endpoint[i] = this.slices.get(i).getLast() - this.slices.get(i).getStride();
            }
            this.index.set(newcounter);
        }
        catch (DapException de) {
            throw new IllegalArgumentException(de);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int[] current = null;
        if (this.index != null) {
            current = this.index.getCurrentCounter();
        }
        for (int i = 0; i < this.rank; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            if (this.dimset != null) {
                buf.append(this.dimset.get(i) != null ? this.dimset.get(i).getShortName() : "null");
            }
            buf.append(this.slices.get(i).toString());
            buf.append(String.format("(%d)", this.slices.get(i).getCount()));
            if (this.index == null) continue;
            buf.append(String.format("@%d", current[i]));
        }
        return buf.toString();
    }

    public int rank() {
        return this.rank;
    }

    public Slice slice(int i) {
        if (i < 0 || i >= this.rank) {
            throw new IllegalArgumentException();
        }
        return this.slices.get(i);
    }

    public List<Slice> getSlices() {
        return this.slices;
    }

    public long index() {
        return this.index.currentElement();
    }

    public D4Index indices() {
        return this.index;
    }

    public long totalSize() {
        long size = 1L;
        for (int i = 0; i < this.rank; ++i) {
            size *= (long)this.slices.get(i).getCount();
        }
        return size;
    }

    @Override
    public boolean hasNext() {
        int stop = this.rank;
        switch (this.state) {
            case INITIAL: {
                return true;
            }
            case STARTED: {
                int[] cur = this.index.getCurrentCounter();
                for (int i = stop - 1; i >= 0; --i) {
                    if ((long)cur[i] > this.endpoint[i]) continue;
                    return true;
                }
                this.state = STATE.DONE;
                break;
            }
        }
        return false;
    }

    @Override
    public D4Index next() {
        int lastpos = this.rank;
        int firstpos = 0;
        switch (this.state) {
            case INITIAL: {
                this.state = STATE.STARTED;
                break;
            }
            case STARTED: {
                int i = this.step(firstpos, lastpos);
                if (i >= 0) break;
                this.state = STATE.DONE;
                break;
            }
        }
        if (this.state == STATE.DONE) {
            throw new NoSuchElementException();
        }
        return this.indices();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int step(int firstpos, int lastpos) {
        int pos = -1;
        int[] indices = this.index.getCurrentCounter();
        for (int i = lastpos - 1; i >= firstpos; --i) {
            if ((long)indices[i] <= this.endpoint[i]) {
                int n = i;
                indices[n] = indices[n] + this.slices.get(i).getStride();
                pos = i;
                break;
            }
            indices[i] = this.slices.get(i).getFirst();
        }
        this.index.set(indices);
        return pos;
    }

    public List<Odometer> getSubOdometers() {
        ArrayList<Odometer> list = new ArrayList<Odometer>();
        list.add(this);
        return list;
    }

    public boolean isMulti() {
        return false;
    }

    public boolean isScalar() {
        return false;
    }

    protected static enum STATE {
        INITIAL,
        STARTED,
        DONE;

    }
}

