/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.dmr.DapType;
import dap4.core.dmr.TypeSort;
import dap4.core.util.ChecksumMode;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class SerialWriter {
    public static boolean DEBUG = false;
    public static boolean DUMPDATA = false;
    public static boolean DUMPCSUM = false;
    static final int MAXINTOBJECTSIZE = 8;
    static final int MAXFLOATOBJECTSIZE = 4;
    static final int MAXDOUBLEOBJECTSIZE = 8;
    static final ByteOrder NETWORK_ORDER = ByteOrder.BIG_ENDIAN;
    static final ByteOrder NATIVE_ORDER = ByteOrder.nativeOrder();
    static final int COUNTSIZE = 8;
    protected ByteOrder order = null;
    protected OutputStream output = null;
    protected int depth = 0;
    protected Checksum checksum;
    protected ChecksumMode checksummode = null;
    protected boolean serialize = true;
    protected long lastchecksum = 0L;
    protected ByteBuffer crcbuffer = null;
    protected ByteBuffer countbuffer = null;

    public SerialWriter(OutputStream output, ByteOrder order, ChecksumMode mode) {
        this.output = output;
        this.order = order;
        this.checksummode = mode;
        this.countbuffer = ByteBuffer.allocate(8).order(order);
        this.crcbuffer = ByteBuffer.allocate(4).order(order);
        if ("CRC32".equalsIgnoreCase("CRC32")) {
            this.checksum = new CRC32();
        } else assert (false) : "No such checksum algorithm: CRC32";
    }

    public void noSerialize(boolean tf) {
        this.serialize = !tf;
    }

    public long getLastChecksum() {
        return this.lastchecksum;
    }

    public static ByteBuffer encodeArray(DapType vtype, Object values, ByteOrder order) throws IOException {
        TypeSort atomtype = vtype.getAtomicType();
        assert (values != null && values.getClass().isArray());
        int count = Array.getLength(values);
        int total = TypeSort.getSize((TypeSort)atomtype) * count;
        ByteBuffer buf = ByteBuffer.allocate(total).order(order);
        switch (atomtype) {
            case Char: {
                char[] datac = (char[])values;
                for (int i = 0; i < datac.length; ++i) {
                    byte b = (byte)(0xFFL & (long)datac[i]);
                    buf.put(b);
                }
                break;
            }
            case UInt8: 
            case Int8: {
                byte[] data8 = (byte[])values;
                buf.put(data8);
                break;
            }
            case Int16: 
            case UInt16: {
                short[] data16 = (short[])values;
                buf.asShortBuffer().put(data16);
                buf.position(total);
                break;
            }
            case Int32: 
            case UInt32: {
                int[] data32 = (int[])values;
                buf.asIntBuffer().put(data32);
                buf.position(total);
                break;
            }
            case Int64: 
            case UInt64: {
                long[] data64 = (long[])values;
                buf.asLongBuffer().put(data64);
                buf.position(total);
                break;
            }
            case Float32: {
                float[] dataf = (float[])values;
                buf.asFloatBuffer().put(dataf);
                buf.position(total);
                break;
            }
            case Float64: {
                double[] datad = (double[])values;
                buf.asDoubleBuffer().put(datad);
                buf.position(total);
                break;
            }
            case URL: 
            case String: {
                byte[] bytes;
                String content;
                int i;
                String[] datas = (String[])values;
                total = 0;
                for (i = 0; i < datas.length; ++i) {
                    content = datas[i];
                    bytes = content.getBytes(DapUtil.UTF8);
                    total += bytes.length + 8;
                }
                buf = ByteBuffer.allocate(total).order(order);
                for (i = 0; i < datas.length; ++i) {
                    content = datas[i];
                    bytes = content.getBytes(DapUtil.UTF8);
                    buf.putLong(bytes.length);
                    buf.put(bytes);
                }
                break;
            }
            case Opaque: {
                ByteBuffer opaquedata;
                int i;
                Object[] datao = (Object[])values;
                total = 0;
                int size = 0;
                for (i = 0; i < datao.length; ++i) {
                    opaquedata = (ByteBuffer)datao[i];
                    size = opaquedata.remaining();
                    total += size + 8;
                }
                buf = ByteBuffer.allocate(total).order(order);
                for (i = 0; i < datao.length; ++i) {
                    opaquedata = (ByteBuffer)datao[i];
                    size = opaquedata.remaining();
                    buf.putLong(size);
                    int savepos = opaquedata.position();
                    buf.put(opaquedata);
                    opaquedata.position(savepos);
                }
                break;
            }
            case Enum: {
                assert (false) : "Unexpected ENUM type";
            }
            default: {
                throw new DapException("Unknown type: " + vtype.getTypeName());
            }
        }
        return buf;
    }

    public void startGroup() {
    }

    public void endGroup() {
    }

    public void startVariable() {
        if (this.depth == 0) {
            this.checksum.reset();
        }
        ++this.depth;
    }

    public void endVariable() throws IOException {
        --this.depth;
        if (this.depth == 0 && this.checksummode == ChecksumMode.TRUE) {
            long crc = this.checksum.getValue();
            this.crcbuffer.clear();
            this.crcbuffer.putInt((int)(crc &= 0xFFFFFFFFL));
            byte[] csum = this.crcbuffer.array();
            assert (csum.length == 4);
            this.lastchecksum = crc;
            if (DEBUG) {
                System.err.print("checksum = " + this.lastchecksum);
                System.err.println();
            }
            this.outputBytes(csum, 0, 4);
        }
    }

    public void writeCount(long count) throws IOException {
        this.countbuffer.clear();
        this.countbuffer.putLong(count);
        byte[] countbuf = this.countbuffer.array();
        int len = this.countbuffer.position();
        this.writeBytes(countbuf, len);
        if (DEBUG) {
            System.err.printf("count: %d%n", count);
        }
    }

    public void writeAtomicArray(DapType daptype, Object values) throws IOException {
        assert (values != null && values.getClass().isArray());
        ByteBuffer buf = SerialWriter.encodeArray(daptype, values, this.order);
        byte[] bytes = buf.array();
        int len = buf.position();
        this.writeBytes(bytes, len);
        if (DEBUG) {
            System.err.printf("%s: ", daptype.getShortName());
            for (int i = 0; i < len; ++i) {
                byte x = this.order == ByteOrder.BIG_ENDIAN ? bytes[i] : bytes[len - 1 - i];
                System.err.printf("%02x", x & 0xFF);
            }
            System.err.println();
        }
    }

    public void writeBytes(byte[] bytes, int len) throws IOException {
        this.outputBytes(bytes, 0, len);
        if (this.checksummode == ChecksumMode.TRUE) {
            this.checksum.update(bytes, 0, len);
            if (DUMPCSUM) {
                System.err.print("SSS ");
                for (int i = 0; i < len; ++i) {
                    System.err.printf("%02x", bytes[i]);
                }
                System.err.println();
            }
        }
    }

    public void outputBytes(byte[] bytes, int start, int count) throws IOException {
        if (DUMPDATA) {
            System.err.printf("output %d/%d:", start, count);
            for (int i = 0; i < count; ++i) {
                System.err.printf(" %02x", bytes[i]);
            }
            System.err.println("");
            System.err.flush();
        }
        this.output.write(bytes, start, count);
    }

    public void flush() throws IOException {
        this.output.flush();
    }
}

