/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import dap4.core.dmr.DMRFactory;
import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnumeration;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapMap;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.interfaces.ArrayScheme;
import dap4.core.util.Convert;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.DapUtil;
import dap4.dap4lib.cdm.CDMTypeFcns;
import dap4.dap4lib.cdm.CDMUtil;
import dap4.dap4lib.cdm.NodeMap;
import dap4.servlet.CDMData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.CDMNode;
import ucar.nc2.CDMSort;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.util.CancelTask;

public class CDMWrap {
    protected static final boolean DEBUG = false;
    protected static final boolean DUMPCDL = false;
    protected static Set<NetcdfDataset.Enhance> ENHANCEMENT = EnumSet.of(NetcdfDataset.Enhance.CoordSystems);
    protected static final String FILLVALUE = "_FillValue";
    protected static boolean nc4loaded = false;
    protected String location = null;
    protected NetcdfDataset ncdfile = null;
    protected boolean closed = false;
    protected DapDataset dmr = null;
    protected DMRFactory dmrfactory = null;
    protected NodeMap<Variable, DapVariable> varmap = new NodeMap();
    protected Map<DapVariable, CDMData> variables = new HashMap<DapVariable, CDMData>();
    protected NodeMap<Variable, DapStructure> compoundmap = new NodeMap();
    protected NodeMap<Variable, DapSequence> vlenmap = new NodeMap();
    protected NodeMap<CDMNode, DapNode> nodemap = new NodeMap();

    public DapDataset getDMR() {
        return this.dmr;
    }

    public CDMWrap setDMR(DapDataset dmr) {
        this.dmr = dmr;
        if (this.getDMR() != null) {
            this.getDMR().setDataset(this.getDMR());
            this.getDMR().setDapVersion("4.0");
            this.getDMR().setDMRVersion("1.0");
            this.getDMR().setNS("http://xml.opendap.org/ns/DAP/4.0#");
        }
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public CDMWrap setLocation(String path) {
        this.location = path;
        return this;
    }

    public CDMData getVariableData(DapVariable var) throws DapException {
        Variable cdmvar = (Variable)this.varmap.get((DapNode)var);
        if (cdmvar == null) {
            throw new DapException("Unknown variable: " + String.valueOf(var));
        }
        CDMData vardata = this.variables.get(var);
        if (vardata == null) {
            ArrayScheme scheme = ArrayScheme.schemeFor((DapVariable)var);
            try {
                vardata = new CDMData(scheme, this, (DapNode)var, null);
                vardata.setArray(cdmvar.read());
            }
            catch (IOException e) {
                throw new DapException((Throwable)e);
            }
            this.addVariableData(var, vardata);
        }
        return vardata;
    }

    public void addVariableData(DapVariable var, CDMData cursor) {
        this.variables.put(var, cursor);
    }

    public NetcdfDataset getNetcdfDataset() {
        return this.ncdfile;
    }

    public CDMWrap open(String filepath) throws DapException {
        try {
            NetcdfFile ncfile = this.createNetcdfFile(filepath, null);
            NetcdfDataset ncd = new NetcdfDataset(ncfile, ENHANCEMENT);
            return this.open(ncd);
        }
        catch (IOException ioe) {
            throw new DapException("CDMDSP: cannot process: " + filepath, (Throwable)ioe);
        }
    }

    public CDMWrap open(NetcdfDataset ncd) throws DapException {
        this.dmrfactory = new DMRFactory();
        this.ncdfile = ncd;
        this.setLocation(this.ncdfile.getLocation());
        this.buildDMR();
        return this;
    }

    public void close() throws IOException {
        if (this.ncdfile != null) {
            this.ncdfile.close();
        }
    }

    protected void recordNode(CDMNode cdm, DapNode dap) {
        assert (this.nodemap.get(cdm) == null && this.nodemap.get(dap) == null);
        this.nodemap.put(cdm, dap);
    }

    protected void recordVar(Variable cdm, DapVariable dap) {
        cdm = CDMUtil.unwrap((Variable)cdm);
        assert (this.varmap.get((CDMNode)cdm) == null && this.varmap.get((DapNode)dap) == null);
        this.varmap.put((CDMNode)cdm, (DapNode)dap);
    }

    protected void recordStruct(Variable cdm, DapStructure dap) {
        cdm = CDMUtil.unwrap((Variable)cdm);
        assert (this.nodemap.get((CDMNode)cdm) == null && this.nodemap.get((DapNode)dap) == null);
        this.compoundmap.put((CDMNode)cdm, (DapNode)dap);
    }

    protected void recordSeq(Variable cdm, DapSequence dap) {
        cdm = CDMUtil.unwrap((Variable)cdm);
        assert (this.vlenmap.get((CDMNode)cdm) == null && this.vlenmap.get((DapNode)dap) == null);
        this.vlenmap.put((CDMNode)cdm, (DapNode)dap);
    }

    public void buildDMR() throws DapException {
        if (this.getDMR() != null) {
            return;
        }
        try {
            String name = this.ncdfile.getLocation();
            name = DapUtil.canonicalpath((String)name);
            int index = name.lastIndexOf(47);
            if (index >= 0) {
                name = name.substring(index + 1, name.length());
            }
            this.setDMR((DapDataset)this.dmrfactory.newDataset(name).annotate(NetcdfDataset.class, (Object)this.ncdfile));
            this.recordNode((CDMNode)this.ncdfile.getRootGroup(), (DapNode)this.getDMR());
            this.getDMR().setBase(DapUtil.canonicalpath((String)this.ncdfile.getLocation()));
            this.fillgroup((DapGroup)this.getDMR(), this.ncdfile.getRootGroup());
            this.getDMR().sort();
            this.processmappedvariables(this.ncdfile.getRootGroup());
            this.getDMR().finish();
        }
        catch (DapException e) {
            this.setDMR(null);
            throw new DapException((Throwable)e);
        }
    }

    protected void fillgroup(DapGroup dapgroup, Group cdmgroup) throws DapException {
        DapStructure dapStructure;
        Variable cdmvar;
        for (Dimension cdmdim : cdmgroup.getDimensions()) {
            DapDimension dapDimension = this.builddim(cdmdim);
        }
        for (EnumTypedef cdmenum : cdmgroup.getEnumTypedefs()) {
            String name = cdmenum.getShortName();
            DapEnumeration dapenum = this.buildenum(cdmenum);
            dapenum.setShortName(name);
            dapgroup.addDecl((DapNode)dapenum);
        }
        for (Variable cdmvar0 : cdmgroup.getVariables()) {
            cdmvar = CDMUtil.unwrap((Variable)cdmvar0);
            this.buildseqtypes(cdmvar);
        }
        for (Variable cdmvar0 : cdmgroup.getVariables()) {
            cdmvar = CDMUtil.unwrap((Variable)cdmvar0);
            if (cdmvar.getDataType() != DataType.STRUCTURE && cdmvar.getDataType() != DataType.SEQUENCE) continue;
            dapStructure = this.buildcompoundtype(cdmvar, (DapNode)dapgroup);
        }
        for (Variable cdmvar0 : cdmgroup.getVariables()) {
            cdmvar = CDMUtil.unwrap((Variable)cdmvar0);
            dapStructure = this.buildvariable(cdmvar, (DapNode)dapgroup, (List<Dimension>)cdmvar.getDimensions());
        }
        for (Group subgroup : cdmgroup.getGroups()) {
            DapGroup newgroup = this.buildgroup(subgroup);
            dapgroup.addDecl((DapNode)newgroup);
        }
        this.buildattributes((DapNode)dapgroup, cdmgroup.attributes());
    }

    protected DapDimension builddim(Dimension cdmdim) throws DapException {
        boolean shared;
        if (cdmdim.isVariableLength()) {
            throw new DapException("* dimensions not supported");
        }
        DapDimension dapdim = null;
        long cdmsize = this.dapsize(cdmdim);
        String name = cdmdim.getShortName();
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!(shared = cdmdim.isShared())) {
            dapdim = this.dmrfactory.newDimension(null, cdmsize);
            this.getDMR().addDecl((DapNode)dapdim);
        } else {
            dapdim = this.dmrfactory.newDimension(name, cdmsize);
            dapdim.setShared(true);
            if (cdmdim.isUnlimited()) {
                dapdim.setUnlimited(true);
            }
            Group cdmparent = cdmdim.getGroup();
            DapGroup dapparent = (DapGroup)this.nodemap.get((CDMNode)cdmparent);
            assert (dapparent != null);
            assert (dapparent != null);
            dapparent.addDecl((DapNode)dapdim);
        }
        this.recordNode((CDMNode)cdmdim, (DapNode)dapdim);
        return dapdim;
    }

    protected DapEnumeration buildenum(EnumTypedef cdmenum) throws DapException {
        DapType base = null;
        switch (cdmenum.getBaseType()) {
            case ENUM1: {
                base = DapType.INT8;
                break;
            }
            case ENUM2: {
                base = DapType.INT16;
                break;
            }
            default: {
                base = DapType.INT32;
            }
        }
        DapEnumeration dapenum = this.dmrfactory.newEnumeration(cdmenum.getShortName(), base);
        this.recordNode((CDMNode)cdmenum, (DapNode)dapenum);
        ImmutableMap ecvalues = cdmenum.getMap();
        for (Map.Entry entry : ecvalues.entrySet()) {
            String name = (String)entry.getValue();
            assert (name != null);
            long value = ((Integer)entry.getKey()).intValue();
            dapenum.addEnumConst(this.dmrfactory.newEnumConst(name, value));
        }
        return dapenum;
    }

    protected DapStructure buildcompoundtype(Variable cdmvar, DapNode parent) throws DapException {
        Variable cdmfield;
        DapStructure struct;
        if ((cdmvar = CDMUtil.unwrap((Variable)cdmvar)).getDataType() == DataType.STRUCTURE) {
            struct = this.dmrfactory.newStructure(cdmvar.getShortName());
        } else if (cdmvar.getDataType() == DataType.SEQUENCE) {
            struct = this.dmrfactory.newSequence(cdmvar.getShortName());
        } else {
            throw new DapException("Internal error");
        }
        struct.setParent(parent);
        this.recordStruct(cdmvar, struct);
        Structure cdmstruct = (Structure)cdmvar;
        ImmutableList fields = cdmstruct.getVariables();
        for (CDMNode node : fields) {
            cdmfield = (Variable)node;
            ImmutableList dimset = cdmfield.getDimensions();
            if (cdmfield.getDataType() != DataType.STRUCTURE && cdmfield.getDataType() != DataType.SEQUENCE) continue;
            DapStructure dapStructure = this.buildcompoundtype(cdmfield, (DapNode)struct);
        }
        for (CDMNode node : fields) {
            DapVariable dapfield;
            cdmfield = (Variable)node;
            DapType basetype = null;
            switch (cdmfield.getDataType()) {
                default: {
                    basetype = CDMTypeFcns.cdmtype2daptype((DataType)cdmfield.getDataType());
                    break;
                }
                case STRUCTURE: 
                case SEQUENCE: {
                    basetype = (DapType)this.compoundmap.get((CDMNode)cdmfield);
                }
            }
            ImmutableList fielddims = cdmfield.getDimensions();
            if (CDMUtil.hasVLEN((Variable)cdmfield)) {
                DapSequence seq = (DapSequence)this.vlenmap.get((CDMNode)cdmfield);
                List<Dimension> coredims = CDMWrap.getCoreDimset((List<Dimension>)fielddims);
                dapfield = this.buildvariable(cdmfield, (DapNode)struct, coredims);
                dapfield.setBaseType((DapType)seq);
            } else {
                dapfield = this.buildvariable(cdmfield, (DapNode)struct, (List<Dimension>)fielddims);
            }
            struct.addField(dapfield);
        }
        return struct;
    }

    protected DapVariable buildvariable(Variable cdmbasevar, DapNode parent, List<Dimension> cdmdims) throws DapException {
        DapVariable dapvar = null;
        CDMSort sort = cdmbasevar.getSort();
        switch (sort) {
            case VARIABLE: {
                switch (cdmbasevar.getDataType()) {
                    default: {
                        dapvar = this.buildatomicvar(cdmbasevar, parent);
                        break;
                    }
                    case ENUM1: 
                    case ENUM2: 
                    case ENUM4: {
                        dapvar = this.buildenumvar(cdmbasevar);
                        break;
                    }
                    case OPAQUE: {
                        dapvar = this.buildopaquevar(cdmbasevar);
                        break;
                    }
                    case STRING: {
                        dapvar = this.buildstringvar(cdmbasevar);
                        break;
                    }
                    case STRUCTURE: 
                    case SEQUENCE: {
                        assert (false) : "Internal error";
                        break;
                    }
                }
                this.builddimrefs(dapvar, cdmdims);
                break;
            }
            case STRUCTURE: {
                dapvar = this.buildstructvar(cdmbasevar);
                this.builddimrefs(dapvar, cdmdims);
                break;
            }
            default: {
                assert (false) : "Internal Error";
                break;
            }
        }
        if (parent != null) {
            this.addToParent(parent, dapvar);
        }
        return dapvar;
    }

    protected DapVariable buildatomicvar(Variable cdmvar, DapNode parent) throws DapException {
        DapType basetype = CDMTypeFcns.cdmtype2daptype((DataType)cdmvar.getDataType());
        if (basetype == null) {
            throw new DapException("DapFile: illegal CDM variable base type: " + String.valueOf(cdmvar.getDataType()));
        }
        DapVariable dapvar = this.dmrfactory.newVariable(cdmvar.getShortName(), basetype);
        this.recordVar(cdmvar, dapvar);
        this.buildattributes((DapNode)dapvar, cdmvar.attributes());
        if (CDMUtil.hasVLEN((Variable)cdmvar)) {
            DapSequence seq = (DapSequence)this.vlenmap.get((CDMNode)cdmvar);
            List<Dimension> coredims = CDMWrap.getCoreDimset((List<Dimension>)cdmvar.getDimensions());
            dapvar.setBaseType((DapType)seq);
        }
        return dapvar;
    }

    protected DapVariable buildopaquevar(Variable cdmvar) throws DapException {
        assert (cdmvar.getDataType() == DataType.OPAQUE) : "Internal error";
        DapVariable dapvar = this.dmrfactory.newVariable(cdmvar.getShortName(), DapType.OPAQUE);
        this.recordVar(cdmvar, dapvar);
        this.buildattributes((DapNode)dapvar, cdmvar.attributes());
        Object osize = cdmvar.annotation((Object)"_edu.ucar.opaque.size");
        if (osize != null) {
            dapvar.addXMLAttribute("_edu.ucar.opaque.size", osize.toString());
        }
        return dapvar;
    }

    protected DapVariable buildstringvar(Variable cdmvar) throws DapException {
        assert (cdmvar.getDataType() == DataType.STRING) : "Internal error";
        DapVariable dapvar = this.dmrfactory.newVariable(cdmvar.getShortName(), DapType.STRING);
        this.recordVar(cdmvar, dapvar);
        this.buildattributes((DapNode)dapvar, cdmvar.attributes());
        return dapvar;
    }

    protected DapVariable buildenumvar(Variable cdmvar) throws DapException {
        assert (cdmvar.getDataType() == DataType.ENUM1 || cdmvar.getDataType() == DataType.ENUM2 || cdmvar.getDataType() == DataType.ENUM4) : "Internal error";
        EnumTypedef enumdef = cdmvar.getEnumTypedef();
        EnumTypedef trueenumdef = this.findMatchingEnum(enumdef);
        cdmvar.setEnumTypedef(trueenumdef);
        DapEnumeration dapenum = (DapEnumeration)this.nodemap.get((CDMNode)trueenumdef);
        assert (dapenum != null);
        DapVariable dapvar = this.dmrfactory.newVariable(cdmvar.getShortName(), (DapType)dapenum);
        this.recordVar(cdmvar, dapvar);
        this.buildattributes((DapNode)dapvar, cdmvar.attributes());
        return dapvar;
    }

    protected DapVariable buildstructvar(Variable cdmvar) throws DapException {
        assert (cdmvar.getDataType() == DataType.STRUCTURE) : "Internal error";
        DapStructure struct = (DapStructure)this.compoundmap.get((CDMNode)cdmvar);
        assert (struct != null) : "Internal Error";
        DapVariable dapvar = this.dmrfactory.newVariable(cdmvar.getShortName(), (DapType)struct);
        this.recordVar(cdmvar, dapvar);
        this.buildattributes((DapNode)dapvar, cdmvar.attributes());
        return dapvar;
    }

    protected DapSequence buildseqtype(Variable cdmvar) throws DapException {
        cdmvar = CDMUtil.unwrap((Variable)cdmvar);
        assert (CDMUtil.hasVLEN((Variable)cdmvar));
        DataType dt = cdmvar.getDataType();
        DapType daptype = CDMTypeFcns.cdmtype2daptype((DataType)dt);
        DapSequence seq = this.dmrfactory.newSequence(cdmvar.getShortName());
        DapVariable field = this.dmrfactory.newVariable(cdmvar.getShortName(), daptype);
        seq.addField(field);
        field.setParent((DapNode)seq);
        this.recordSeq(cdmvar, seq);
        return seq;
    }

    protected void buildseqtypes(Variable cdmvar) throws DapException {
        if (CDMUtil.hasVLEN((Variable)cdmvar)) {
            this.buildseqtype(cdmvar);
        }
        if (cdmvar.getDataType() == DataType.STRUCTURE || cdmvar.getDataType() == DataType.SEQUENCE) {
            Structure struct = (Structure)cdmvar;
            ImmutableList fields = struct.getVariables();
            for (int i = 0; i < fields.size(); ++i) {
                Variable field = (Variable)fields.get(i);
                this.buildseqtypes(field);
            }
        }
    }

    protected void buildattributes(DapNode node, AttributeContainer attributes) throws DapException {
        for (Attribute attr : attributes) {
            if (this.suppress(attr.getShortName())) continue;
            DapAttribute dapattr = this.buildattribute(attr);
            node.addAttribute(dapattr);
        }
    }

    protected DapAttribute buildattribute(Attribute cdmattr) throws DapException {
        DapType attrtype = CDMTypeFcns.cdmtype2daptype((DataType)cdmattr.getDataType());
        EnumTypedef cdmenum = cdmattr.getEnumType();
        boolean enumfillvalue = cdmattr.getShortName().equals(FILLVALUE) && cdmenum != null;
        DapEnumeration dapenum = null;
        if (enumfillvalue) {
            if (!(cdmenum = this.findMatchingEnum(cdmenum)).getBaseType().isEnum()) {
                throw new DapException("CDM _FillValue attribute type is not enumX");
            }
            cdmattr.setEnumType(cdmenum);
            dapenum = (DapEnumeration)this.nodemap.get((CDMNode)cdmenum);
            if (dapenum == null) {
                throw new DapException("Illegal CDM variable attribute type: " + String.valueOf(cdmenum));
            }
            attrtype = dapenum;
        }
        if (attrtype == null) {
            throw new DapException("DapFile: illegal CDM variable attribute type: " + String.valueOf(cdmattr.getDataType()));
        }
        DapAttribute dapattr = this.dmrfactory.newAttribute(cdmattr.getShortName(), attrtype);
        this.recordNode((CDMNode)cdmattr, (DapNode)dapattr);
        Array values = cdmattr.getValues();
        String[] valuelist = new String[]{};
        if (values != null) {
            if (!this.validatecdmtype(cdmattr.getDataType(), values.getElementType())) {
                throw new DapException("Attr type versus attribute data mismatch: " + String.valueOf(values.getElementType()));
            }
            IndexIterator iter = values.getIndexIterator();
            Object vec = CDMTypeFcns.createVector((DataType)cdmattr.getDataType(), (long)values.getSize());
            int i = 0;
            while (iter.hasNext()) {
                java.lang.reflect.Array.set(vec, i, iter.next());
                ++i;
            }
            valuelist = (String[])Convert.convert((DapType)DapType.STRING, (DapType)attrtype, (Object)vec);
        }
        dapattr.setValues(valuelist);
        return dapattr;
    }

    protected void builddimrefs(DapVariable dapvar, List<Dimension> cdmdims) throws DapException {
        if (cdmdims == null || cdmdims.size() == 0) {
            return;
        }
        for (Dimension cdmdim : cdmdims) {
            DapDimension dapdim = null;
            if (cdmdim.isShared()) {
                Dimension declareddim = this.finddimdecl(cdmdim);
                if (declareddim == null) {
                    throw new DapException("Unprocessed cdm dimension: " + String.valueOf(cdmdim));
                }
                dapdim = (DapDimension)this.nodemap.get((CDMNode)declareddim);
                assert (dapdim != null);
            } else {
                if (cdmdim.isVariableLength()) continue;
                dapdim = this.builddim(cdmdim);
            }
            assert (dapdim != null) : "Internal error";
            dapvar.addDimension(dapdim);
        }
    }

    protected void processmappedvariables(Group g) throws DapException {
        for (Variable v0 : g.getVariables()) {
            Variable cdmvar = CDMUtil.unwrap((Variable)v0);
            if (cdmvar == null) {
                throw new DapException("NetcdfDataset synthetic variable: " + String.valueOf(v0));
            }
            DapNode dapvar = this.varmap.get((CDMNode)cdmvar);
            if (dapvar == null) {
                throw new DapException("Unknown variable: " + String.valueOf(cdmvar));
            }
            if (!(dapvar instanceof DapVariable)) {
                throw new DapException("CDMVariable not mapping to dap variable: " + String.valueOf(cdmvar));
            }
            this.buildmaps((DapVariable)dapvar, v0);
        }
    }

    protected void buildmaps(DapVariable dapvar, Variable var) throws DapException {
        StructureDS sds = null;
        ImmutableList css = null;
        if (var.getSort() == CDMSort.VARIABLE) {
            VariableDS vds = (VariableDS)var;
            css = vds.getCoordinateSystems();
        } else {
            sds = (StructureDS)var;
            css = sds.getCoordinateSystems();
        }
        if (css != null && css.size() > 0) {
            CoordinateSystem coordsystems = (CoordinateSystem)css.get(0);
            for (CoordinateAxis axis : coordsystems.getCoordinateAxes()) {
                Variable v;
                VariableDS vds = (VariableDS)axis.getOriginalVariable();
                if (vds == null || (v = CDMUtil.unwrap((Variable)vds)) == null) continue;
                DapVariable mapvar = (DapVariable)this.varmap.get((CDMNode)v);
                if (mapvar == null) {
                    throw new DapException("Illegal map variable:" + v.toString());
                }
                if (!mapvar.isAtomic()) {
                    throw new DapException("Non-atomic map variable:" + v.toString());
                }
                boolean ignoremap = false;
                if (!mapvar.isTopLevel()) {
                    DapNode parenttype = mapvar.getContainer();
                    assert (dapvar.getSort() == DapSort.VARIABLE);
                    DapVariable parent = dapvar;
                    assert (parent.getSort() == DapSort.STRUCTURE || parent.getSort() == DapSort.SEQUENCE);
                    assert (parent.getBaseType() == parenttype);
                    Variable cdmparent = (Variable)this.varmap.get((DapNode)parent);
                    if (cdmparent == CDMUtil.unwrap((Variable)sds)) {
                        ignoremap = true;
                    }
                }
                if (ignoremap) continue;
                DapMap map = this.dmrfactory.newMap(mapvar.getShortName());
                dapvar.addMap(map);
            }
        }
    }

    protected DapGroup buildgroup(Group cdmgroup) throws DapException {
        DapGroup dapgroup = this.dmrfactory.newGroup(cdmgroup.getShortName());
        this.recordNode((CDMNode)cdmgroup, (DapNode)dapgroup);
        dapgroup.setShortName(cdmgroup.getShortName());
        this.fillgroup(dapgroup, cdmgroup);
        return dapgroup;
    }

    protected EnumTypedef findMatchingEnum(EnumTypedef varenum) throws DapException {
        ArrayList<EnumTypedef> candidates = new ArrayList<EnumTypedef>();
        for (Map.Entry entry : this.nodemap.getCDMMap().entrySet()) {
            CDMNode cdmnode = (CDMNode)entry.getValue();
            if (cdmnode.getSort() != CDMSort.ENUMERATION) continue;
            EnumTypedef target = (EnumTypedef)cdmnode;
            ImmutableMap targetmap = target.getMap();
            ImmutableMap varmap = varenum.getMap();
            if (targetmap.size() != varmap.size()) continue;
            boolean match = true;
            for (Map.Entry tpair : targetmap.entrySet()) {
                String tname = (String)tpair.getValue();
                int value = (Integer)tpair.getKey();
                boolean found = false;
                for (Map.Entry vpair : varmap.entrySet()) {
                    if (!tname.equals(vpair.getValue()) || value != (Integer)vpair.getKey()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                match = false;
                break;
            }
            if (!match) continue;
            boolean shadowed = false;
            for (EnumTypedef etd : candidates) {
                if (!this.shadows(etd.getGroup(), target.getGroup())) continue;
                shadowed = true;
                break;
            }
            if (shadowed) continue;
            candidates.add(target);
        }
        switch (candidates.size()) {
            case 0: {
                throw new DapException("CDMDSP: No matching enum type decl: " + varenum.getShortName());
            }
            case 1: {
                break;
            }
            default: {
                throw new DapException("CDMDSP: Multiple matching enum type decls: " + varenum.getShortName());
            }
        }
        return (EnumTypedef)candidates.get(0);
    }

    protected boolean shadows(Group parent, Group child) {
        if (child == parent) {
            return true;
        }
        Group candidate = child;
        while ((candidate = candidate.getGroup()) != null && candidate != parent) {
        }
        return candidate == parent;
    }

    protected long dapsize(Dimension cdmdim) {
        assert (!cdmdim.isVariableLength());
        return cdmdim.getLength();
    }

    protected boolean validatecdmtype(DataType datatype, Class typeclass) {
        switch (datatype) {
            case CHAR: {
                return typeclass == Character.TYPE;
            }
            case BYTE: 
            case UBYTE: {
                return typeclass == Byte.TYPE;
            }
            case SHORT: 
            case USHORT: {
                return typeclass == Short.TYPE;
            }
            case INT: 
            case UINT: {
                return typeclass == Integer.TYPE;
            }
            case LONG: 
            case ULONG: {
                return typeclass == Long.TYPE;
            }
            case FLOAT: {
                return typeclass == Float.TYPE;
            }
            case DOUBLE: {
                return typeclass == Double.TYPE;
            }
            case STRING: {
                return typeclass == String.class;
            }
            case OPAQUE: {
                return typeclass == Byte[].class;
            }
            case ENUM1: {
                return typeclass == Byte.TYPE;
            }
            case ENUM2: {
                return typeclass == Short.TYPE;
            }
            case ENUM4: {
                return typeclass == Integer.TYPE;
            }
        }
        return false;
    }

    protected Dimension finddimdecl(Dimension dimref) {
        for (Map.Entry entry : this.nodemap.getCDMMap().entrySet()) {
            Dimension d;
            if (((CDMNode)entry.getValue()).getSort() != CDMSort.DIMENSION || !this.isDimDeclFor(d = (Dimension)entry.getValue(), dimref)) continue;
            return d;
        }
        return null;
    }

    protected boolean isDimDeclFor(Dimension decl, Dimension ref) {
        if (!decl.isShared()) {
            return false;
        }
        if (!decl.getShortName().equals(ref.getShortName())) {
            return false;
        }
        if (decl.getLength() != ref.getLength()) {
            return false;
        }
        String dprefix = decl.getGroup().getFullName();
        String rprefix = ref.getGroup().getFullName();
        return dprefix.equals(rprefix);
    }

    protected NetcdfFile createNetcdfFile(String location, CancelTask canceltask) throws DapException {
        try {
            NetcdfFile ncfile = NetcdfFiles.open((String)location, (int)-1, (CancelTask)canceltask);
            return ncfile;
        }
        catch (DapException de) {
            throw de;
        }
        catch (Exception e) {
            throw new DapException((Throwable)e);
        }
    }

    static List<Dimension> getCoreDimset(List<Dimension> dimset) throws DapException {
        if (dimset == null) {
            return null;
        }
        ArrayList<Dimension> core = new ArrayList<Dimension>();
        int pos = -1;
        int count = 0;
        for (int i = 0; i < dimset.size(); ++i) {
            if (dimset.get(i).isVariableLength()) {
                pos = i;
                ++count;
                continue;
            }
            core.add(dimset.get(i));
        }
        if (pos != dimset.size() - 1 || count > 1) {
            throw new DapException("Unsupported use of (*) Dimension");
        }
        return core;
    }

    protected boolean suppress(String attrname) {
        if (attrname.startsWith("_Coord")) {
            return true;
        }
        return attrname.equals("_Unsigned");
    }

    protected void addToParent(DapNode parent, DapVariable dapvar) throws DapException {
        assert (parent != null);
        switch (parent.getSort()) {
            case GROUP: 
            case DATASET: {
                ((DapGroup)parent).addDecl((DapNode)dapvar);
                break;
            }
            case SEQUENCE: 
            case STRUCTURE: {
                dapvar.setParent(parent);
                break;
            }
            default: {
                assert (false) : "Internal error";
                break;
            }
        }
    }
}

