/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.cdmshared.CDMUtil;
import dap4.core.data.DataAtomic;
import dap4.core.data.DataException;
import dap4.core.dmr.AtomicType;
import dap4.core.dmr.DapAtomicVariable;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.DapUtil;
import dap4.core.util.Odometer;
import dap4.core.util.Slice;
import dap4.dap4shared.AbstractDataVariable;
import dap4.dap4shared.Dap4Util;
import dap4.servlet.CDMDSP;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.DataType;

public class CDMDataAtomic
extends AbstractDataVariable
implements DataAtomic {
    protected CDMDSP dsp = null;
    protected long product = 0L;
    protected DapType basetype = null;
    protected AtomicType atomtype = null;
    protected Array data = null;

    public CDMDataAtomic(CDMDSP dsp, DapAtomicVariable template, Array array) throws DataException {
        super((DapNode)template);
        this.basetype = template.getBaseType();
        this.atomtype = this.basetype.getPrimitiveType();
        this.product = DapUtil.dimProduct((List)template.getDimensions());
        this.dsp = dsp;
        this.data = array;
    }

    public DapType getType() {
        return this.basetype;
    }

    public long getCount() {
        return this.product;
    }

    public long getElementSize() {
        return Dap4Util.daptypeSize((AtomicType)this.atomtype);
    }

    public void read(List<Slice> slices, Object data, long offset) throws DataException {
        Array array = this.data;
        DataType datatype = CDMUtil.daptype2cdmtype((DapType)this.basetype);
        if (datatype == null) {
            throw new DataException("Unknown basetype: " + this.basetype);
        }
        Class elementclass = CDMUtil.cdmElementClass((DataType)datatype);
        if (elementclass == null) {
            throw new DataException("Attempt to read non-atomic value of type: " + datatype);
        }
        Object content = array.get1DJavaArray(elementclass);
        try {
            Odometer odom = Odometer.factory(slices, (List)((DapVariable)this.getTemplate()).getDimensions(), (boolean)false);
            while (odom.hasNext()) {
                long index = odom.next();
                System.arraycopy(content, (int)index, data, (int)offset, 1);
                ++offset;
            }
        }
        catch (DapException de) {
            throw new DataException((Throwable)de);
        }
    }

    public Object read(long index) throws DataException {
        Object result;
        int i = (int)index;
        Array content = this.data;
        DataType datatype = content.getDataType();
        switch (datatype) {
            case BOOLEAN: {
                result = content.getBoolean(i);
                break;
            }
            case BYTE: {
                result = content.getByte(i);
                break;
            }
            case CHAR: {
                result = Character.valueOf(content.getChar(i));
                break;
            }
            case SHORT: {
                result = content.getShort(i);
                break;
            }
            case INT: {
                result = content.getInt(i);
                break;
            }
            case LONG: {
                result = content.getLong(i);
                break;
            }
            case FLOAT: {
                result = Float.valueOf(content.getFloat(i));
                break;
            }
            case DOUBLE: {
                result = content.getDouble(i);
                break;
            }
            case STRING: {
                result = content.getObject(i).toString();
                break;
            }
            case OBJECT: {
                result = content.getObject(i);
                break;
            }
            default: {
                throw new DataException("Attempt to read non-atomic value of type: " + datatype);
            }
        }
        return result;
    }

    protected DapSort computesort(Array array) throws DataException {
        Object sort = null;
        Array content = this.data;
        switch (content.getDataType()) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case OBJECT: {
                return DapSort.ATOMICVARIABLE;
            }
            case STRUCTURE: {
                return DapSort.STRUCTURE;
            }
            case SEQUENCE: {
                return DapSort.SEQUENCE;
            }
        }
        throw new DataException("Unsupported datatype: " + content.getDataType());
    }
}

