/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.ce.CEConstraint;
import dap4.core.data.DataAtomic;
import dap4.core.data.DataCompound;
import dap4.core.data.DataCompoundArray;
import dap4.core.data.DataDataset;
import dap4.core.data.DataException;
import dap4.core.data.DataRecord;
import dap4.core.data.DataSequence;
import dap4.core.data.DataSort;
import dap4.core.data.DataStructure;
import dap4.core.data.DataVariable;
import dap4.core.dmr.AtomicType;
import dap4.core.dmr.DapAtomicVariable;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.Slice;
import dap4.dap4shared.DSP;
import dap4.dap4shared.Dap4Util;
import dap4.servlet.SerialWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.List;

public class DapSerializer {
    protected OutputStream stream = null;
    protected SerialWriter writer = null;
    protected DSP dsp = null;
    protected DataDataset data = null;
    protected CEConstraint ce = null;
    protected ByteOrder order = null;

    public DapSerializer() {
    }

    public DapSerializer(DSP dsp, CEConstraint constraint, OutputStream stream, ByteOrder order) throws IOException {
        this.dsp = dsp;
        this.order = order;
        this.stream = stream;
        this.data = dsp.getDataDataset();
        this.ce = constraint;
    }

    public void write(DapDataset dmr) throws IOException {
        this.writer = new SerialWriter(this.stream, this.order);
        for (DapVariable var : dmr.getTopVariables()) {
            DataVariable dv = this.data.getVariableData(var);
            if (!this.ce.references((DapNode)var)) continue;
            if (dv == null) {
                throw new DapException("DapSerializer: cannot find  Variable data " + var.getFQN());
            }
            this.writeVariable(var, dv, this.writer);
        }
    }

    protected void writeVariable(DapVariable dapvar, DataVariable dv, SerialWriter dst) throws IOException {
        assert (dapvar == dv.getTemplate());
        dst.startVariable();
        switch (dv.getSort()) {
            case ATOMIC: {
                this.writeAtomicVariable(dapvar, dv, dst);
                break;
            }
            case STRUCTURE: {
                this.writeStructure(dapvar, (DataStructure)dv, dst);
                break;
            }
            case SEQUENCE: {
                this.writeSequence(dapvar, (DataSequence)dv, dst);
                break;
            }
            case COMPOUNDARRAY: {
                this.writeCompoundArray(dapvar, (DataCompoundArray)dv, dst);
                break;
            }
            default: {
                assert (false) : "Unexpected variable type";
                break;
            }
        }
        dst.endVariable();
    }

    protected void writeAtomicVariable(DapVariable vv, DataVariable dv, SerialWriter dst) throws DataException {
        try {
            DapAtomicVariable dapvar = (DapAtomicVariable)vv;
            DataAtomic dav = (DataAtomic)dv;
            DapType basetype = dapvar.getBaseType();
            if (dapvar.getRank() == 0) {
                dst.writeObject(basetype, dav.read(0L));
            } else {
                List<Slice> slices = this.ce.getConstrainedSlices((DapVariable)dapvar);
                if (slices == null) {
                    throw new DataException("Unknown variable: " + dapvar.getFQN());
                }
                long count = DapUtil.sliceProduct(slices);
                Object vector = Dap4Util.createVector((AtomicType)basetype.getPrimitiveType(), (long)count);
                dav.read(slices, vector, 0L);
                dst.writeArray(basetype, vector);
            }
        }
        catch (IOException ioe) {
            throw new DataException((Throwable)ioe);
        }
    }

    protected void writeStructure(DapVariable vv, DataStructure ds, SerialWriter dst) throws DataException {
        try {
            DapStructure dapvar = (DapStructure)vv;
            for (DapVariable field : dapvar.getFields()) {
                if (!this.ce.references((DapNode)field)) continue;
                DataVariable dv = ds.readfield(field.getShortName());
                this.writeVariable(field, dv, dst);
            }
        }
        catch (IOException ioe) {
            throw new DataException((Throwable)ioe);
        }
    }

    protected void writeCompound(DapVariable vv, DataCompound dc, SerialWriter dst) throws DataException {
        if (dc.getSort() == DataSort.STRUCTURE) {
            this.writeStructure(vv, (DataStructure)dc, dst);
        } else {
            this.writeSequence(vv, (DataSequence)dc, dst);
        }
    }

    protected void writeCompoundArray(DapVariable dapvar, DataCompoundArray dca, SerialWriter dst) throws DataException {
        try {
            if (dapvar.getRank() == 0) {
                this.writeCompound(dapvar, dca.read(0L), dst);
                return;
            }
            List<Slice> slices = this.ce.getConstrainedSlices(dapvar);
            if (slices == null) {
                throw new DataException("Undefined variable: " + dapvar);
            }
            long count = DapUtil.sliceProduct(slices);
            DataCompound[] dc = new DataCompound[(int)count];
            dca.read(slices, dc);
            int i = 0;
            while ((long)i < count) {
                this.writeCompound(dapvar, dc[i], dst);
                ++i;
            }
        }
        catch (IOException ioe) {
            throw new DataException((Throwable)ioe);
        }
    }

    protected void writeRecord(DapVariable vv, DataRecord dr, SerialWriter dst) throws DataException {
        try {
            DapSequence dapvar = (DapSequence)vv;
            for (DapVariable field : dapvar.getFields()) {
                if (!this.ce.references((DapNode)field)) continue;
                DataVariable dv = dr.readfield(field.getShortName());
                this.writeVariable(field, dv, dst);
            }
        }
        catch (IOException ioe) {
            throw new DataException((Throwable)ioe);
        }
    }

    protected void writeSequence(DapVariable dapvar, DataSequence ds, SerialWriter dst) throws DataException {
        DapSequence seq = (DapSequence)dapvar;
        long nrecs = ds.getRecordCount();
        long actual = 0L;
        ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
        SerialWriter tmp = new SerialWriter(bytestream, this.order);
        tmp.computeChecksums(false);
        try {
            int i = 0;
            while ((long)i < nrecs) {
                DataRecord rec = ds.readRecord((long)i);
                if (this.ce.match(seq, rec)) {
                    this.writeRecord(dapvar, ds.readRecord((long)i), tmp);
                    ++actual;
                }
                ++i;
            }
            bytestream.flush();
            dst.writeCount(actual);
            dst.writeBytes(bytestream.toByteArray());
        }
        catch (IOException ioe) {
            throw new DataException((Throwable)ioe);
        }
    }
}

