/*
 * Decompiled with CFR 0.152.
 */
package dap4.ce;

import dap4.ce.CEConstraint;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnum;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import java.util.ArrayList;
import java.util.List;

public class Universal
extends CEConstraint {
    public Universal() {
    }

    public Universal(DapDataset dmr) throws DapException {
        super(dmr);
        this.build();
    }

    @Override
    public CEConstraint finish() throws DapException {
        this.finished = true;
        return this;
    }

    protected void build() throws DapException {
        List top = this.dmr.getTopVariables();
        for (int i = 0; i < top.size(); ++i) {
            DapVariable var = (DapVariable)top.get(i);
            List slices = DapUtil.dimsetSlices((List)var.getDimensions());
            super.addVariable(var, slices);
        }
        this.enums = new ArrayList<DapEnum>();
        this.enums.addAll(this.dmr.getEnums());
        this.dimrefs = new ArrayList<DapDimension>();
        this.dimrefs.addAll(this.dmr.getDimensions());
        this.groups = new ArrayList<DapGroup>();
        this.groups.addAll(this.dmr.getGroups());
        super.expand();
        super.finish();
    }

    @Override
    public boolean references(DapNode node) {
        switch (node.getSort()) {
            case DIMENSION: 
            case ENUMERATION: 
            case ATOMICVARIABLE: 
            case GRID: 
            case SEQUENCE: 
            case STRUCTURE: 
            case GROUP: 
            case DATASET: {
                return true;
            }
        }
        return false;
    }
}

