/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.dap4shared.XURI;
import dap4.servlet.DapLog;
import java.net.URISyntaxException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;

public class ServletInfo {
    public static final String WEBINFPPATH = "WEB-INF";
    public static final String RESOURCEDIRNAME = "resources";
    protected HttpServlet servlet = null;
    protected ServletConfig servletconfig = null;
    protected ServletContext servletcontext = null;
    protected String servletname = null;
    protected String server = null;
    protected String realpath = null;

    public ServletInfo(HttpServlet sv) throws DapException {
        this.servlet = sv;
        this.servletconfig = sv.getServletConfig();
        if (this.servletconfig == null) {
            throw new DapException("Cannot locate servlet config object");
        }
        this.servletcontext = this.servletconfig.getServletContext();
        this.servletname = this.servletconfig.getServletName();
        this.realpath = DapUtil.canonicalpath((String)this.servletcontext.getRealPath(""));
    }

    public HttpServlet getServlet() {
        return this.servlet;
    }

    public ServletConfig getServletconfig() {
        return this.servletconfig;
    }

    public ServletContext getServletcontext() {
        return this.servletcontext;
    }

    public String getServletname() {
        return this.servletname;
    }

    protected String getRealPath(String virtual) {
        if (virtual.startsWith("/")) {
            virtual = virtual.substring(1);
        }
        return DapUtil.canonicalpath((String)(this.realpath + "/" + virtual));
    }

    public String getContextPath() {
        return this.servletcontext.getContextPath();
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String url) {
        try {
            XURI xurl = new XURI(url);
            String simpleurl = xurl.getLeadProtocol() + "://" + xurl.getHost();
            if (this.server != null && !this.server.equals(simpleurl)) {
                DapLog.warn("ServletInfo.setServer: server mismatch: " + this.server + " :: " + simpleurl);
            }
            this.server = simpleurl;
        }
        catch (URISyntaxException use) {
            DapLog.warn("ServletInfo.setServer: malformed url: " + url);
        }
    }
}

