/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.dap4shared.DSP;
import dap4.servlet.CDMDSP;
import dap4.servlet.SynDSP;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public abstract class DSPFactory {
    protected List<Class> dspRegistry = new ArrayList<Class>();

    public DSPFactory() {
        this.registerDSP(SynDSP.class, true);
        this.registerDSP(CDMDSP.class, true);
    }

    public void registerDSP(String className) throws DapException {
        try {
            Class<?> klass = DSPFactory.class.getClassLoader().loadClass(className);
            this.registerDSP(klass);
        }
        catch (ClassNotFoundException e) {
            throw new DapException((Throwable)e);
        }
    }

    public void registerDSP(Class klass) {
        this.registerDSP(klass, false);
    }

    public synchronized void registerDSP(Class klass, boolean last) {
        int pos = this.dspRegistry.indexOf(klass);
        if (pos < 0) {
            if (last) {
                this.dspRegistry.add(klass);
            } else {
                this.dspRegistry.add(0, klass);
            }
        }
    }

    public synchronized boolean dspRegistered(Class klass) {
        return this.dspRegistry.contains(klass);
    }

    public synchronized void dspUnregister(Class klass) {
        this.dspRegistry.remove(klass);
    }

    public synchronized DSP create(String path) throws DapException {
        for (int i = 0; i < this.dspRegistry.size(); ++i) {
            try {
                Class testclass = this.dspRegistry.get(i);
                Method match = testclass.getMethod("match", String.class, DapContext.class);
                boolean ismatch = (Boolean)match.invoke(null, path, null);
                if (!ismatch) continue;
                DSP dsp = (DSP)testclass.newInstance();
                return dsp.open(path);
            }
            catch (Exception e) {
                throw new DapException((Throwable)e);
            }
        }
        throw new IllegalArgumentException("Cannot open " + path);
    }
}

