/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.ce.CEConstraint;
import dap4.core.data.ChecksumMode;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.Odometer;
import dap4.dap4lib.DMRPrinter;
import dap4.servlet.ChunkWriter;
import dap4.servlet.DapSerializer;
import dap4.servlet.RandomValue;
import dap4.servlet.SerialWriter;
import dap4.servlet.Value;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.nio.ByteOrder;
import java.util.List;

public class Generator
extends DapSerializer {
    static final boolean DEBUG = false;
    static final String LBRACE = "{";
    static final String RBRACE = "}";
    static final int DEFALTCACHELIMIT = 4;
    static final ByteOrder DEFAULTORDER = ByteOrder.LITTLE_ENDIAN;
    static final String DATADIR = "d4tests/src/test/data";
    static final String TESTSRC = "d4tests/src/test/data/resources/testfiles";
    static final String SERIALEXT = ".ser";
    static final String SRCEXT = ".dmr.ser";
    static final String DSTEXT = ".dap.ser";
    static final int MAXROWS = 5;
    static int rowcount = 0;
    protected static boolean asciionly = true;
    protected Value values = null;
    protected ByteArrayOutputStream stream = null;
    protected ChunkWriter cw = null;
    protected boolean withdmr = true;
    protected DapDataset dmr = null;

    public static void setASCII(boolean tf) {
        asciionly = tf;
    }

    public static int getRowCount() {
        return rowcount;
    }

    public static void setRowCount(int count) {
        if (count >= 0) {
            rowcount = count;
        }
    }

    public Generator(DapDataset dmr, Value.ValueSource src) throws DapException {
        this.dmr = dmr;
        if (src == null) {
            src = Value.ValueSource.RANDOM;
        }
        switch (src) {
            default: 
        }
        this.values = new RandomValue();
        this.values.setASCII(asciionly);
        SerialWriter.DEBUG = false;
    }

    public void generate(CEConstraint ce, ChunkWriter cw, boolean withdmr, ChecksumMode mode) throws DapException {
        this.begin(ce, cw, withdmr, mode);
        if (this.withdmr) {
            this.generateDMR(this.dmr);
        }
        this.dataset(this.dmr);
        this.end();
    }

    public void begin(CEConstraint ce, ChunkWriter cw, boolean withdmr, ChecksumMode mode) throws DapException {
        this.cw = cw;
        if (ce == null) {
            ce = CEConstraint.getUniversal((DapDataset)this.dmr);
        }
        this.ce = ce;
        this.order = cw.getWriteOrder();
        this.checksummode = mode;
        this.withdmr = withdmr;
        this.writer = new SerialWriter(this.cw, this.order, this.checksummode);
    }

    public void end() throws DapException {
    }

    public void generateDMR(DapDataset dmr) throws DapException {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            DMRPrinter dp = new DMRPrinter(dmr, this.ce, pw, null);
            dp.print();
            pw.close();
            sw.close();
            String tmp = sw.toString();
            this.cw.cacheDMR(tmp);
            this.cw.flush();
        }
        catch (Exception e) {
            throw new DapException((Throwable)e);
        }
    }

    public void dataset(DapDataset dmr) throws DapException {
        for (DapVariable var : this.dmr.getTopVariables()) {
            if (!this.ce.references((DapNode)var)) continue;
            this.variable(var);
        }
    }

    public void variable(DapVariable dapvar) throws DapException {
        this.writer.startVariable();
        if (dapvar.isAtomic()) {
            this.atomicVariable(dapvar);
        } else if (dapvar.isStructure()) {
            this.structureVariable(dapvar);
        } else if (dapvar.isSequence()) {
            this.sequenceVariable(dapvar);
        } else {
            throw new DapException("generate var: not a variable:" + dapvar.getFQN());
        }
        try {
            this.writer.endVariable();
        }
        catch (IOException ioe) {
            throw new DapException((Throwable)ioe);
        }
    }

    public void atomicVariable(DapVariable dapvar) throws DapException {
        DapType basetype = dapvar.getBaseType();
        Odometer odom = null;
        if (dapvar.getRank() == 0) {
            odom = Odometer.factoryScalar();
        } else {
            List slices = this.ce.getConstrainedSlices(dapvar);
            odom = Odometer.factory((List)slices, (List)dapvar.getDimensions());
        }
        while (odom.hasNext()) {
            Object value = this.values.nextValue(basetype);
            try {
                assert (this.writer != null);
                this.writer.writeAtomicArray(basetype, value);
            }
            catch (IOException ioe) {
                throw new DapException((Throwable)ioe);
            }
            odom.next();
        }
    }

    public void structureVariable(DapVariable var) throws DapException {
        DapStructure struct = (DapStructure)var.getBaseType();
        List fields = struct.getFields();
        Odometer odom = null;
        if (var.getRank() == 0) {
            odom = Odometer.factoryScalar();
        } else {
            List slices = this.ce.getConstrainedSlices(var);
            odom = Odometer.factory((List)slices, (List)var.getDimensions());
        }
        while (odom.hasNext()) {
            for (int i = 0; i < fields.size(); ++i) {
                DapVariable field = (DapVariable)fields.get(i);
                this.variable(field);
            }
            odom.next();
        }
    }

    public void sequenceVariable(DapVariable var) throws DapException {
        DapSequence seq = (DapSequence)var.getBaseType();
        List fields = seq.getFields();
        Odometer odom = null;
        if (var.getRank() == 0) {
            odom = Odometer.factoryScalar();
        } else {
            List slices = this.ce.getConstrainedSlices(var);
            odom = Odometer.factory((List)slices, (List)var.getDimensions());
        }
        try {
            while (odom.hasNext()) {
                int nrows = rowcount == 0 ? this.values.nextCount(5) : rowcount;
                this.writer.writeAtomicArray(DapType.INT64, new long[]{nrows});
                for (int i = 0; i < nrows; ++i) {
                    for (int j = 0; j < fields.size(); ++j) {
                        DapVariable field = (DapVariable)fields.get(j);
                        this.variable(field);
                    }
                }
                odom.next();
            }
        }
        catch (IOException ioe) {
            throw new DapException((Throwable)ioe);
        }
    }

    protected String stringify(Object v) {
        if (v.getClass().isArray()) {
            return this.stringify(Array.get(v, 0));
        }
        if (v instanceof Float || v instanceof Double) {
            return v.toString();
        }
        if (v instanceof Byte) {
            return String.format("%01d 0x%01x", v, v);
        }
        if (v instanceof Short) {
            return String.format("%02d 0x%02x", v, v);
        }
        if (v instanceof Integer) {
            return String.format("%04d 0x%04x", v, v);
        }
        if (v instanceof Long) {
            return String.format("%08d 0x%08x", v, v);
        }
        if (v instanceof Character) {
            return String.format("'%c' 0x%02x", v, (short)((Short)v));
        }
        return v.toString();
    }
}

