/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.ce.CEConstraint;
import dap4.core.data.ChecksumMode;
import dap4.core.data.DSP;
import dap4.core.data.DataCursor;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.Index;
import dap4.core.util.Odometer;
import dap4.servlet.SerialWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.List;

public class DapSerializer {
    protected OutputStream stream = null;
    protected SerialWriter writer = null;
    protected DSP dsp = null;
    protected CEConstraint ce = null;
    protected ByteOrder order = null;
    protected ChecksumMode checksummode = null;

    public DapSerializer() {
    }

    public DapSerializer(DSP dsp, CEConstraint constraint, OutputStream stream, ByteOrder order, ChecksumMode mode) throws IOException {
        this.dsp = dsp;
        this.order = order;
        this.checksummode = mode;
        this.stream = stream;
        this.ce = constraint;
    }

    public void write(DapDataset dmr) throws IOException {
        this.writer = new SerialWriter(this.stream, this.order, this.checksummode);
        this.writer.flush();
        for (DapVariable var : dmr.getTopVariables()) {
            if (!this.ce.references((DapNode)var)) continue;
            DataCursor vardata = this.dsp.getVariableData(var);
            if (vardata == null) {
                throw new DapException("DapSerializer: cannot find  Variable data " + var.getFQN());
            }
            this.writeVariable(vardata, this.writer);
        }
    }

    protected void writeVariable(DataCursor data, SerialWriter dst) throws IOException {
        DapVariable template = (DapVariable)data.getTemplate();
        dst.startVariable();
        switch (data.getScheme()) {
            case ATOMIC: {
                this.writeAtomicVariable(data, dst);
                break;
            }
            case STRUCTARRAY: {
                this.writeStructure(data, dst);
                break;
            }
            case SEQARRAY: {
                this.writeSequence(data, dst);
                break;
            }
            default: {
                assert (false) : "Unexpected variable type: " + data.toString();
                break;
            }
        }
        dst.endVariable();
    }

    protected void writeAtomicVariable(DataCursor data, SerialWriter dst) throws IOException {
        DapVariable template = (DapVariable)data.getTemplate();
        assert (this.ce.references((DapNode)template));
        DapType basetype = template.getBaseType();
        List slices = this.ce.getConstrainedSlices(template);
        if (slices == null) {
            throw new DapException("Unknown variable: " + template.getFQN());
        }
        Object values = data.read(slices);
        dst.writeAtomicArray(basetype, values);
    }

    protected void writeStructure(DataCursor data, SerialWriter dst) throws IOException {
        DapVariable template = (DapVariable)data.getTemplate();
        DapStructure ds = (DapStructure)template.getBaseType();
        assert (this.ce.references((DapNode)template));
        List slices = this.ce.getConstrainedSlices(template);
        Odometer odom = Odometer.factory((List)slices);
        while (odom.hasNext()) {
            Index index = odom.next();
            DataCursor[] instance = (DataCursor[])data.read(index);
            this.writeStructure1(instance[0], dst);
        }
    }

    protected void writeStructure1(DataCursor instance, SerialWriter dst) throws IOException {
        assert (instance.getScheme() == DataCursor.Scheme.STRUCTURE);
        DapVariable template = (DapVariable)instance.getTemplate();
        assert (this.ce.references((DapNode)template));
        DapStructure ds = (DapStructure)template.getBaseType();
        List fields = ds.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            DapVariable field = (DapVariable)fields.get(i);
            if (!this.ce.references((DapNode)field)) continue;
            DataCursor df = instance.readField(i);
            this.writeVariable(df, dst);
        }
    }

    protected void writeSequence(DataCursor data, SerialWriter dst) throws IOException {
        DapVariable template = (DapVariable)data.getTemplate();
        DapSequence ds = (DapSequence)template.getBaseType();
        assert (this.ce.references((DapNode)template));
        List slices = this.ce.getConstrainedSlices(template);
        Odometer odom = Odometer.factory((List)slices);
        DataCursor[] instances = (DataCursor[])data.read(slices);
        for (int i = 0; i < instances.length; ++i) {
            this.writeSequence1(instances[i], dst);
        }
    }

    protected void writeSequence1(DataCursor instance, SerialWriter dst) throws IOException {
        DapVariable template = (DapVariable)instance.getTemplate();
        DapSequence seq = (DapSequence)template.getBaseType();
        assert (this.ce.references((DapNode)template));
        long nrecs = instance.getRecordCount();
        dst.writeCount(nrecs);
        for (long i = 0L; i < nrecs; ++i) {
            DataCursor record = instance.readRecord(i);
            this.writeRecord(record, dst);
        }
    }

    protected void writeRecord(DataCursor record, SerialWriter dst) throws IOException {
        DapVariable template = (DapVariable)record.getTemplate();
        DapSequence seq = (DapSequence)template.getBaseType();
        List fields = seq.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            DapVariable field = (DapVariable)fields.get(i);
            if (!this.ce.references((DapNode)field)) continue;
            DataCursor df = record.readField(i);
            this.writeVariable(df, dst);
        }
    }
}

