/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Stack;

public class IndentWriter
extends PrintWriter {
    static final int MAXDEPTH = 100;
    String blanks = "                                        ";
    int delta = 4;
    int depth = 0;
    Stack<Integer> indentstack = new Stack();

    public IndentWriter(File file) throws FileNotFoundException {
        super(file);
    }

    public IndentWriter(Writer writer) {
        super(writer);
    }

    public IndentWriter(OutputStream stream) {
        super(stream);
    }

    public void indent() {
        this.indent(1);
    }

    public void outdent() {
        this.outdent(1);
    }

    public void outdent(int n) {
        this.indent(-n);
    }

    public void indent(int n) {
        this.depth += n;
        if (this.depth < 0) {
            this.depth = 0;
        } else if (this.depth > 100) {
            this.depth = 100;
        }
    }

    public void setIndent(int n) {
        this.depth = n;
        if (this.depth < 0) {
            this.depth = 0;
        } else if (this.depth > 100) {
            this.depth = 100;
        }
    }

    public void margin() {
        super.write(this.getMargin());
    }

    public String getMargin() {
        int nspaces = this.delta * this.depth;
        while (this.blanks.length() < nspaces) {
            this.blanks = this.blanks + this.blanks;
        }
        return this.blanks.substring(0, nspaces);
    }

    public int getIndent() {
        return this.depth;
    }

    public void push() {
        this.indentstack.push(this.depth);
    }

    public void pop() {
        int n = this.indentstack.empty() ? 0 : this.indentstack.pop();
        this.setIndent(n);
    }

    public void eol() {
        super.println("");
    }

    public void marginPrintln(String text) {
        this.marginPrint(text + "\n");
    }

    public void marginPrintln() {
        this.marginPrintln("");
    }

    public void marginPrint(String text) {
        super.print(this.getMargin() + text);
    }

    public void marginPrintf(String fmt, Object ... args) {
        String s = String.format(fmt, args);
        this.marginPrint(s);
    }
}

