/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr;

import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapDecl;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnum;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class DapGroup
extends DapNode
implements DapDecl {
    protected List<DapNode> decls = new ArrayList<DapNode>();
    protected List<DapGroup> groups = new ArrayList<DapGroup>();
    protected List<DapEnum> enums = new ArrayList<DapEnum>();
    protected List<DapDimension> dimensions = new ArrayList<DapDimension>();
    protected List<DapVariable> variables = new ArrayList<DapVariable>();

    public DapGroup() {
    }

    public DapGroup(String name) {
        super(name);
    }

    public List<DapNode> getDecls() {
        return this.decls;
    }

    public void setDecls(List<? extends DapNode> decls) throws DapException {
        decls.clear();
        this.groups.clear();
        this.enums.clear();
        this.dimensions.clear();
        this.variables.clear();
        for (DapNode dapNode : decls) {
            this.addDecl(dapNode);
        }
    }

    public void addDecl(DapNode newdecl) throws DapException {
        DapSort newsort = newdecl.getSort();
        String newname = newdecl.getShortName();
        if (newsort != DapSort.DIMENSION || newname != null) {
            for (DapNode decl : this.decls) {
                if (newsort != decl.getSort() || !newname.equals(decl.getShortName())) continue;
                throw new DapException("DapGroup: attempt to add duplicate decl: " + newname);
            }
        } else {
            DapDimension anon = (DapDimension)newdecl;
            assert (newsort == DapSort.DIMENSION && newname == null);
            for (DapDimension dim : this.dimensions) {
                if (dim.isShared() || dim.getSize() != anon.getSize()) continue;
                throw new DapException("DapGroup: attempt to add duplicate anonymous dimension: " + dim.getSize());
            }
        }
        this.decls.add(newdecl);
        newdecl.setParent(this);
        switch (newdecl.getSort()) {
            case ATTRIBUTE: 
            case ATTRIBUTESET: 
            case OTHERXML: {
                super.addAttribute((DapAttribute)newdecl);
                break;
            }
            case DIMENSION: {
                this.dimensions.add((DapDimension)newdecl);
                break;
            }
            case ENUMERATION: {
                this.enums.add((DapEnum)newdecl);
                break;
            }
            case ATOMICVARIABLE: 
            case STRUCTURE: 
            case SEQUENCE: {
                this.variables.add((DapVariable)newdecl);
                break;
            }
            case GROUP: 
            case DATASET: {
                if (this == (DapGroup)newdecl) break;
                this.groups.add((DapGroup)newdecl);
                break;
            }
            default: {
                throw new ClassCastException(newdecl.getShortName());
            }
        }
    }

    void updateGroups(List<DapGroup> groups) {
        assert (groups.size() == this.groups.size()) : "Update groups: not same size";
        for (DapGroup g : groups) {
            if (!this.groups.contains(g)) assert (false) : "Update groups: attempt to add new group";
        }
    }

    public List<DapGroup> getGroups() {
        return this.groups;
    }

    public List<DapEnum> getEnums() {
        return this.enums;
    }

    public List<DapDimension> getDimensions() {
        return this.dimensions;
    }

    public List<DapVariable> getVariables() {
        return this.variables;
    }

    public DapNode findByName(String name, DapSort sort) {
        return this.findInGroup(name, sort);
    }

    public List<DapNode> findByName(String name, EnumSet<DapSort> sortset) {
        return this.findInGroup(name, sortset);
    }

    public DapNode findInGroup(String name, DapSort sort) {
        List<DapNode> set = this.findInGroup(name, EnumSet.of(sort));
        assert (set.size() <= 1);
        if (set.size() == 0) {
            return null;
        }
        return set.get(0);
    }

    public List<DapNode> findInGroup(String name, EnumSet<DapSort> sortset) {
        ArrayList<DapNode> matches = new ArrayList<DapNode>();
        block9: for (DapSort sort : sortset) {
            switch (sort) {
                case ATTRIBUTE: 
                case ATTRIBUTESET: 
                case OTHERXML: {
                    DapAttribute attr = super.getAttributes().get(name);
                    matches.add(attr);
                    break;
                }
                case DIMENSION: {
                    for (DapDimension dapDimension : this.dimensions) {
                        if (!dapDimension.getShortName().equals(name)) continue;
                        matches.add(dapDimension);
                    }
                    continue block9;
                }
                case ENUMERATION: {
                    for (DapEnum dapEnum : this.enums) {
                        if (!dapEnum.getShortName().equals(name)) continue;
                        matches.add(dapEnum);
                    }
                    continue block9;
                }
                case ATOMICVARIABLE: {
                    for (DapVariable dapVariable : this.variables) {
                        if (dapVariable.getSort() != sort || !dapVariable.getShortName().equals(name)) continue;
                        matches.add(dapVariable);
                    }
                    continue block9;
                }
                case STRUCTURE: {
                    for (DapVariable dapVariable : this.variables) {
                        if (dapVariable.getSort() != sort || !dapVariable.getShortName().equals(name)) continue;
                        matches.add(dapVariable);
                    }
                    continue block9;
                }
                case SEQUENCE: {
                    for (DapVariable dapVariable : this.variables) {
                        if (dapVariable.getSort() != sort || !dapVariable.getShortName().equals(name)) continue;
                        matches.add(dapVariable);
                    }
                    continue block9;
                }
                case GROUP: {
                    for (DapGroup dapGroup : this.groups) {
                        if (!dapGroup.getShortName().equals(name)) continue;
                        matches.add(dapGroup);
                    }
                    continue block9;
                }
            }
        }
        return matches;
    }

    public DapNode findByFQN(String fqn, DapSort sort) throws DapException {
        List<DapNode> nodes = this.findByFQN(fqn, EnumSet.of(sort));
        if (nodes == null || nodes.size() == 0) {
            throw new DapException("No such sort:" + (Object)((Object)sort));
        }
        return nodes.get(0);
    }

    public List<DapNode> findByFQN(String fqn, EnumSet<DapSort> sortset) throws DapException {
        if ((fqn = fqn.trim()) == null) {
            return null;
        }
        if (fqn.charAt(0) != '/') {
            String prefix = this.getFQN();
            fqn = prefix + '/' + fqn;
        }
        return this.getDataset().lookup(fqn, sortset);
    }

    public DapVariable findVariable(String name) {
        DapNode var = this.findInGroup(name, DapSort.ATOMICVARIABLE);
        if (var == null) {
            var = this.findInGroup(name, DapSort.STRUCTURE);
        }
        return (DapVariable)var;
    }
}

