/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr;

import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import java.util.ArrayList;
import java.util.List;

public class DapStructure
extends DapVariable {
    List<DapVariable> fields = new ArrayList<DapVariable>();

    public DapStructure() {
        this.setBaseType(DapType.STRUCT);
    }

    public DapStructure(String name) {
        super(name);
    }

    public DapVariable findByName(String shortname) {
        for (DapVariable field : this.fields) {
            if (!shortname.equals(field.getShortName())) continue;
            return field;
        }
        return null;
    }

    public int indexByName(String shortname) {
        for (int i = 0; i < this.fields.size(); ++i) {
            DapVariable field = this.fields.get(i);
            if (!shortname.equals(field.getShortName())) continue;
            return i;
        }
        return -1;
    }

    public DapVariable getField(int i) {
        return this.fields.get(i);
    }

    public List<DapVariable> getFields() {
        return this.fields;
    }

    public void setFields(List<? extends DapNode> fields) throws DapException {
        fields.clear();
        for (int i = 0; i < fields.size(); ++i) {
            this.addField(fields.get(i));
        }
    }

    public void addField(DapNode newfield) throws DapException {
        if (!(newfield instanceof DapVariable)) {
            throw new ClassCastException("DapVariable");
        }
        for (DapVariable v : this.fields) {
            if (!v.getShortName().equals(newfield.getShortName())) continue;
            throw new DapException("DapStructure: attempt to add duplicate field: " + newfield.getShortName());
        }
        this.fields.add((DapVariable)newfield);
        newfield.setParent(this);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }
}

