/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr;

import dap4.core.dmr.AtomicType;
import dap4.core.dmr.DapDecl;
import dap4.core.dmr.DapEnum;
import dap4.core.dmr.DapNode;
import dap4.core.util.DapSort;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DapType
extends DapNode
implements DapDecl {
    public static final DapType CHAR;
    public static final DapType INT8;
    public static final DapType UINT8;
    public static final DapType INT16;
    public static final DapType UINT16;
    public static final DapType INT32;
    public static final DapType UINT32;
    public static final DapType INT64;
    public static final DapType UINT64;
    public static final DapType FLOAT32;
    public static final DapType FLOAT64;
    public static final DapType STRING;
    public static final DapType URL;
    public static final DapType OPAQUE;
    public static final DapType ENUM;
    public static final DapType STRUCT;
    public static final DapType SEQ;
    static final Map<AtomicType, DapType> typemap;
    static List<DapEnum> enumlist;
    protected AtomicType typesort = null;

    public static DapType lookup(AtomicType atomic) {
        if (atomic == AtomicType.Enum) {
            return null;
        }
        return typemap.get((Object)atomic);
    }

    public static DapType reify(String typename) {
        for (DapEnum de : enumlist) {
            if (!typename.equals(de.getFQN())) continue;
            return de;
        }
        return typemap.get((Object)AtomicType.getAtomicType(typename));
    }

    public static Map<AtomicType, DapType> getTypeMap() {
        return typemap;
    }

    public static List<DapEnum> getEnumList() {
        return enumlist;
    }

    static void addEnum(DapEnum dapenum) {
        if (!enumlist.contains(dapenum)) {
            enumlist.add(dapenum);
        }
    }

    protected DapType(AtomicType typesort) {
        this(typesort.name());
        this.setAtomicType(typesort);
    }

    public DapType(String name) {
        super(name);
        if (this.sort == DapSort.ENUMERATION) {
            this.setAtomicType(AtomicType.Enum);
            DapType.addEnum((DapEnum)this);
        }
    }

    public AtomicType getPrimitiveType() {
        if (this.typesort == AtomicType.Enum) {
            return ((DapEnum)this).getBaseType().getAtomicType();
        }
        return this.getAtomicType();
    }

    public AtomicType getAtomicType() {
        return this.typesort;
    }

    public String getTypeName() {
        return this.typesort == AtomicType.Enum ? this.getFQN() : this.getShortName();
    }

    protected void setAtomicType(AtomicType typesort) {
        this.typesort = typesort;
    }

    public boolean isUnsigned() {
        if (this.typesort == AtomicType.Enum) {
            return ((DapEnum)this).getBaseType().isUnsigned();
        }
        return this.typesort.isUnsigned();
    }

    public boolean isIntegerType() {
        return this.typesort.isIntegerType();
    }

    public boolean isFloatType() {
        return this.typesort.isFloatType();
    }

    public boolean isNumericType() {
        return this.typesort.isNumericType();
    }

    public boolean isStringType() {
        return this.typesort.isStringType();
    }

    public boolean isEnumType() {
        return this.typesort.isEnumType();
    }

    public boolean isCharType() {
        return this.typesort.isCharType();
    }

    public boolean isOpaqueType() {
        return this.typesort.isOpaqueType();
    }

    public boolean isFixedSize() {
        return this.typesort.isFixedSize();
    }

    public boolean isStructType() {
        return this.typesort.isStructType();
    }

    public boolean isLegalAttrType() {
        return this.typesort.isLegalAttrType();
    }

    public boolean isCompound() {
        return this.typesort.isCompound();
    }

    public int getSize() {
        return AtomicType.getSize(this.getPrimitiveType());
    }

    static {
        enumlist = new ArrayList<DapEnum>();
        typemap = new HashMap<AtomicType, DapType>();
        CHAR = new DapType(AtomicType.Char);
        INT8 = new DapType(AtomicType.Int8);
        UINT8 = new DapType(AtomicType.UInt8);
        INT16 = new DapType(AtomicType.Int16);
        UINT16 = new DapType(AtomicType.UInt16);
        INT32 = new DapType(AtomicType.Int32);
        UINT32 = new DapType(AtomicType.UInt32);
        INT64 = new DapType(AtomicType.Int64);
        UINT64 = new DapType(AtomicType.UInt64);
        FLOAT32 = new DapType(AtomicType.Float32);
        FLOAT64 = new DapType(AtomicType.Float64);
        STRING = new DapType(AtomicType.String);
        URL = new DapType(AtomicType.URL);
        OPAQUE = new DapType(AtomicType.Opaque);
        ENUM = new DapType(AtomicType.Enum);
        STRUCT = new DapType(AtomicType.Structure);
        SEQ = new DapType(AtomicType.Sequence);
        typemap.put(AtomicType.Char, CHAR);
        typemap.put(AtomicType.Int8, INT8);
        typemap.put(AtomicType.UInt8, UINT8);
        typemap.put(AtomicType.Int16, INT16);
        typemap.put(AtomicType.UInt16, UINT16);
        typemap.put(AtomicType.Int32, INT32);
        typemap.put(AtomicType.UInt32, UINT32);
        typemap.put(AtomicType.Int64, INT64);
        typemap.put(AtomicType.UInt64, UINT64);
        typemap.put(AtomicType.Float32, FLOAT32);
        typemap.put(AtomicType.Float64, FLOAT64);
        typemap.put(AtomicType.String, STRING);
        typemap.put(AtomicType.URL, URL);
        typemap.put(AtomicType.Opaque, OPAQUE);
        typemap.put(AtomicType.Enum, ENUM);
        typemap.put(AtomicType.Structure, STRUCT);
        typemap.put(AtomicType.Sequence, SEQ);
    }
}

