/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4shared;

import dap4.core.data.DataException;
import dap4.core.dmr.AtomicType;
import dap4.core.dmr.DapType;
import dap4.core.util.DapUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public abstract class Dap4Util {
    public static int daptypeSize(AtomicType atomtype) {
        switch (atomtype) {
            case Char: 
            case UInt8: 
            case Int8: {
                return 1;
            }
            case Int16: 
            case UInt16: {
                return 2;
            }
            case Int32: 
            case UInt32: 
            case Float32: {
                return 4;
            }
            case Int64: 
            case UInt64: 
            case Float64: {
                return 8;
            }
        }
        return 0;
    }

    public static Object createVector(AtomicType atype, long count) throws DataException {
        int icount = (int)count;
        Object[] vector = null;
        switch (atype) {
            case Char: {
                vector = new char[icount];
                break;
            }
            case UInt8: 
            case Int8: {
                vector = new byte[icount];
                break;
            }
            case Int16: 
            case UInt16: {
                vector = new short[icount];
                break;
            }
            case Int32: 
            case UInt32: {
                vector = new int[icount];
                break;
            }
            case Int64: 
            case UInt64: {
                vector = new long[icount];
                break;
            }
            case Float32: {
                vector = new float[icount];
                break;
            }
            case Float64: {
                vector = new double[icount];
                break;
            }
            case String: 
            case URL: {
                vector = new String[icount];
                break;
            }
            case Opaque: {
                vector = new ByteBuffer[icount];
                break;
            }
            default: {
                throw new DataException("Illegal Conversion");
            }
        }
        return vector;
    }

    public static Object convertVector(DapType dsttype, DapType srctype, Object src) throws DataException {
        AtomicType dstatomtype;
        AtomicType srcatomtype = srctype.getPrimitiveType();
        if (srcatomtype == (dstatomtype = dsttype.getPrimitiveType())) {
            return src;
        }
        if (srcatomtype.isIntegerType() && AtomicType.getSignedVersion(srcatomtype) == AtomicType.getSignedVersion(dstatomtype)) {
            return src;
        }
        Object[] result = null;
        boolean ok = true;
        int len = 0;
        boolean srcunsigned = srcatomtype.isUnsigned();
        boolean dstunsigned = dstatomtype.isUnsigned();
        block0 : switch (srcatomtype) {
            case Char: {
                char[] csrc = (char[])src;
                len = csrc.length;
                switch (dstatomtype) {
                    case Char: 
                    case UInt8: 
                    case Int8: {
                        return src;
                    }
                    case Int16: 
                    case UInt16: {
                        short[] shresult;
                        result = shresult = new short[len];
                        for (int i = 0; i < len; ++i) {
                            shresult[i] = (short)(csrc[i] & 0xFF);
                        }
                        break block0;
                    }
                    case Int32: 
                    case UInt32: {
                        int[] iresult = new int[len];
                        result = iresult;
                        for (int i = 0; i < len; ++i) {
                            iresult[i] = csrc[i] & 0xFF;
                        }
                        break block0;
                    }
                    case Int64: 
                    case UInt64: {
                        long[] lresult = new long[len];
                        result = lresult;
                        for (int i = 0; i < len; ++i) {
                            lresult[i] = csrc[i] & 0xFF;
                        }
                        break block0;
                    }
                    case Float32: {
                        float[] fresult = new float[len];
                        result = fresult;
                        for (int i = 0; i < len; ++i) {
                            fresult[i] = csrc[i] & 0xFF;
                        }
                        break block0;
                    }
                    case Float64: {
                        double[] dresult = new double[len];
                        result = dresult;
                        for (int i = 0; i < len; ++i) {
                            dresult[i] = csrc[i] & 0xFF;
                        }
                        break block0;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
                break;
            }
            case Int8: {
                byte[] bsrc = (byte[])src;
                len = bsrc.length;
                switch (dstatomtype) {
                    case Char: {
                        char[] cresult = new char[len];
                        result = cresult;
                        for (int i = 0; i < len; ++i) {
                            cresult[i] = (char)(bsrc[i] & 0xFF);
                        }
                        break block0;
                    }
                    case Int16: 
                    case UInt16: {
                        int i;
                        short[] shresult = new short[len];
                        result = shresult;
                        for (i = 0; i < len; ++i) {
                            shresult[i] = bsrc[i];
                        }
                        if (!dstunsigned) break block0;
                        i = 0;
                        while (i < len) {
                            int n = i++;
                            shresult[n] = (short)(shresult[n] & 0xFF);
                        }
                        break block0;
                    }
                    case Int32: 
                    case UInt32: {
                        int i;
                        int[] iresult = new int[len];
                        result = iresult;
                        for (i = 0; i < len; ++i) {
                            iresult[i] = bsrc[i];
                        }
                        if (!dstunsigned) break block0;
                        i = 0;
                        while (i < len) {
                            int n = i++;
                            iresult[n] = iresult[n] & 0xFF;
                        }
                        break block0;
                    }
                    case Int64: 
                    case UInt64: {
                        int i;
                        long[] lresult = new long[len];
                        result = lresult;
                        for (i = 0; i < len; ++i) {
                            lresult[i] = bsrc[i];
                        }
                        if (!dstunsigned) break block0;
                        i = 0;
                        while (i < len) {
                            int n = i++;
                            lresult[n] = lresult[n] & 0xFFL;
                        }
                        break block0;
                    }
                    case Float32: {
                        float[] fresult = new float[len];
                        result = fresult;
                        for (int i = 0; i < len; ++i) {
                            fresult[i] = bsrc[i];
                        }
                        break block0;
                    }
                    case Float64: {
                        double[] dresult = new double[len];
                        result = dresult;
                        for (int i = 0; i < len; ++i) {
                            dresult[i] = bsrc[i];
                        }
                        break block0;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
                break;
            }
            case UInt8: {
                byte[] bsrc = (byte[])src;
                len = bsrc.length;
                switch (dstatomtype) {
                    case Char: {
                        char[] cresult = new char[len];
                        result = cresult;
                        for (int i = 0; i < len; ++i) {
                            cresult[i] = (char)(bsrc[i] & 0xFF);
                        }
                        break block0;
                    }
                    case Int16: 
                    case UInt16: {
                        short[] shresult = new short[len];
                        result = shresult;
                        for (int i = 0; i < len; ++i) {
                            shresult[i] = (short)(bsrc[i] & 0xFF);
                        }
                        break block0;
                    }
                    case Int32: 
                    case UInt32: {
                        int[] iresult = new int[len];
                        result = iresult;
                        for (int i = 0; i < len; ++i) {
                            iresult[i] = bsrc[i] & 0xFF;
                        }
                        break block0;
                    }
                    case Int64: 
                    case UInt64: {
                        long[] lresult = new long[len];
                        result = lresult;
                        for (int i = 0; i < len; ++i) {
                            lresult[i] = (long)bsrc[i] & 0xFFL;
                        }
                        break block0;
                    }
                    case Float32: {
                        float[] fresult = new float[len];
                        result = fresult;
                        for (int i = 0; i < len; ++i) {
                            fresult[i] = bsrc[i] & 0xFF;
                        }
                        break block0;
                    }
                    case Float64: {
                        double[] dresult = new double[len];
                        result = dresult;
                        for (int i = 0; i < len; ++i) {
                            dresult[i] = bsrc[i] & 0xFF;
                        }
                        break block0;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
                break;
            }
            case Int16: {
                short[] shsrc = (short[])src;
                len = shsrc.length;
                switch (dstatomtype) {
                    case Char: {
                        char[] cresult = new char[len];
                        result = cresult;
                        for (int i = 0; i < len; ++i) {
                            cresult[i] = (char)(shsrc[i] & 0xFF);
                        }
                        break block0;
                    }
                    case UInt8: 
                    case Int8: {
                        byte[] bresult = new byte[len];
                        result = bresult;
                        for (int i = 0; i < len; ++i) {
                            bresult[i] = (byte)shsrc[i];
                        }
                        break block0;
                    }
                    case Int32: 
                    case UInt32: {
                        int i;
                        int[] iresult = new int[len];
                        result = iresult;
                        for (i = 0; i < len; ++i) {
                            iresult[i] = shsrc[i];
                        }
                        if (!dstunsigned) break block0;
                        i = 0;
                        while (i < len) {
                            int n = i++;
                            iresult[n] = iresult[n] & 0xFFFF;
                        }
                        break block0;
                    }
                    case Int64: 
                    case UInt64: {
                        int i;
                        long[] lresult = new long[len];
                        result = lresult;
                        for (i = 0; i < len; ++i) {
                            lresult[i] = shsrc[i];
                        }
                        if (!dstunsigned) break block0;
                        i = 0;
                        while (i < len) {
                            int n = i++;
                            lresult[n] = lresult[n] & 0xFFFFL;
                        }
                        break block0;
                    }
                    case Float32: {
                        float[] fresult = new float[len];
                        result = fresult;
                        for (int i = 0; i < len; ++i) {
                            fresult[i] = shsrc[i];
                        }
                        break block0;
                    }
                    case Float64: {
                        double[] dresult = new double[len];
                        result = dresult;
                        for (int i = 0; i < len; ++i) {
                            dresult[i] = shsrc[i];
                        }
                        break block0;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
                break;
            }
            case UInt16: {
                short[] shsrc = (short[])src;
                len = shsrc.length;
                switch (dstatomtype) {
                    case Char: {
                        char[] cresult = new char[len];
                        result = cresult;
                        for (int i = 0; i < len; ++i) {
                            cresult[i] = (char)(shsrc[i] & 0xFF);
                        }
                        break block0;
                    }
                    case UInt8: 
                    case Int8: {
                        byte[] bresult = new byte[len];
                        result = bresult;
                        for (int i = 0; i < len; ++i) {
                            bresult[i] = (byte)shsrc[i];
                        }
                        break block0;
                    }
                    case Int32: 
                    case UInt32: {
                        int[] iresult = new int[len];
                        result = iresult;
                        for (int i = 0; i < len; ++i) {
                            iresult[i] = shsrc[i] & 0xFFFF;
                        }
                        break block0;
                    }
                    case Int64: 
                    case UInt64: {
                        long[] lresult = new long[len];
                        result = lresult;
                        for (int i = 0; i < len; ++i) {
                            lresult[i] = (long)shsrc[i] & 0xFFFFL;
                        }
                        break block0;
                    }
                    case Float32: {
                        float[] fresult = new float[len];
                        result = fresult;
                        for (int i = 0; i < len; ++i) {
                            fresult[i] = shsrc[i] & 0xFFFF;
                        }
                        break block0;
                    }
                    case Float64: {
                        double[] dresult = new double[len];
                        result = dresult;
                        for (int i = 0; i < len; ++i) {
                            dresult[i] = shsrc[i] & 0xFFFF;
                        }
                        break block0;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
                break;
            }
            case Int32: {
                int[] isrc = (int[])src;
                len = isrc.length;
                switch (dstatomtype) {
                    case Char: {
                        char[] cresult = new char[len];
                        result = cresult;
                        for (int i = 0; i < len; ++i) {
                            cresult[i] = (char)(isrc[i] & 0xFF);
                        }
                        break block0;
                    }
                    case UInt8: 
                    case Int8: {
                        byte[] bresult = new byte[len];
                        result = bresult;
                        for (int i = 0; i < len; ++i) {
                            bresult[i] = (byte)isrc[i];
                        }
                        break block0;
                    }
                    case Int16: 
                    case UInt16: {
                        short[] shresult = new short[len];
                        result = shresult;
                        for (int i = 0; i < len; ++i) {
                            shresult[i] = (short)isrc[i];
                        }
                        break block0;
                    }
                    case Int64: 
                    case UInt64: {
                        int i;
                        long[] lresult = new long[len];
                        result = lresult;
                        for (i = 0; i < len; ++i) {
                            lresult[i] = isrc[i];
                        }
                        if (!dstunsigned) break block0;
                        i = 0;
                        while (i < len) {
                            int n = i++;
                            lresult[n] = lresult[n] & 0xFFFFL;
                        }
                        break block0;
                    }
                    case Float32: {
                        float[] fresult = new float[len];
                        result = fresult;
                        for (int i = 0; i < len; ++i) {
                            fresult[i] = isrc[i];
                        }
                        break block0;
                    }
                    case Float64: {
                        double[] dresult = new double[len];
                        result = dresult;
                        for (int i = 0; i < len; ++i) {
                            dresult[i] = isrc[i];
                        }
                        break block0;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
                break;
            }
            case UInt32: {
                int[] isrc = (int[])src;
                len = isrc.length;
                switch (dstatomtype) {
                    case Char: {
                        char[] cresult = new char[len];
                        result = cresult;
                        for (int i = 0; i < len; ++i) {
                            cresult[i] = (char)(isrc[i] & 0xFF);
                        }
                        break block0;
                    }
                    case UInt8: 
                    case Int8: {
                        byte[] bresult = new byte[len];
                        result = bresult;
                        for (int i = 0; i < len; ++i) {
                            bresult[i] = (byte)isrc[i];
                        }
                        break block0;
                    }
                    case Int16: 
                    case UInt16: {
                        short[] shresult = new short[len];
                        result = shresult;
                        for (int i = 0; i < len; ++i) {
                            shresult[i] = (short)isrc[i];
                        }
                        break block0;
                    }
                    case Int64: 
                    case UInt64: {
                        int i;
                        long[] lresult = new long[len];
                        result = lresult;
                        for (i = 0; i < len; ++i) {
                            lresult[i] = isrc[i];
                        }
                        if (!dstunsigned) break block0;
                        i = 0;
                        while (i < len) {
                            int n = i++;
                            lresult[n] = lresult[n] & 0xFFFFFFFFL;
                        }
                        break block0;
                    }
                    case Float32: {
                        float[] fresult = new float[len];
                        result = fresult;
                        for (int i = 0; i < len; ++i) {
                            fresult[i] = isrc[i] & 0xFFFF;
                        }
                        break block0;
                    }
                    case Float64: {
                        double[] dresult = new double[len];
                        result = dresult;
                        for (int i = 0; i < len; ++i) {
                            dresult[i] = isrc[i] & 0xFFFF;
                        }
                        break block0;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
                break;
            }
            case Int64: {
                long[] lsrc = (long[])src;
                len = lsrc.length;
                switch (dstatomtype) {
                    case Char: {
                        char[] cresult = new char[len];
                        result = cresult;
                        for (int i = 0; i < len; ++i) {
                            cresult[i] = (char)(lsrc[i] & 0xFFL);
                        }
                        break block0;
                    }
                    case UInt8: 
                    case Int8: {
                        byte[] bresult = new byte[len];
                        result = bresult;
                        for (int i = 0; i < len; ++i) {
                            bresult[i] = (byte)lsrc[i];
                        }
                        break block0;
                    }
                    case Int16: 
                    case UInt16: {
                        short[] shresult = new short[len];
                        result = shresult;
                        for (int i = 0; i < len; ++i) {
                            shresult[i] = (short)lsrc[i];
                        }
                        break block0;
                    }
                    case Int32: 
                    case UInt32: {
                        int[] iresult = new int[len];
                        result = iresult;
                        for (int i = 0; i < len; ++i) {
                            iresult[i] = (int)lsrc[i];
                        }
                        break block0;
                    }
                    case Float32: {
                        float[] fresult = new float[len];
                        result = fresult;
                        for (int i = 0; i < len; ++i) {
                            fresult[i] = lsrc[i];
                        }
                        break block0;
                    }
                    case Float64: {
                        double[] dresult = new double[len];
                        result = dresult;
                        for (int i = 0; i < len; ++i) {
                            dresult[i] = lsrc[i];
                        }
                        break block0;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
                break;
            }
            case UInt64: {
                long[] lsrc = (long[])src;
                len = lsrc.length;
                switch (dstatomtype) {
                    case Char: {
                        char[] cresult = new char[len];
                        result = cresult;
                        for (int i = 0; i < len; ++i) {
                            cresult[i] = (char)(lsrc[i] & 0xFFL);
                        }
                        break block0;
                    }
                    case UInt8: 
                    case Int8: {
                        byte[] bresult = new byte[len];
                        result = bresult;
                        for (int i = 0; i < len; ++i) {
                            bresult[i] = (byte)lsrc[i];
                        }
                        break block0;
                    }
                    case Int16: 
                    case UInt16: {
                        short[] shresult = new short[len];
                        result = shresult;
                        for (int i = 0; i < len; ++i) {
                            shresult[i] = (short)lsrc[i];
                        }
                        break block0;
                    }
                    case Int32: 
                    case UInt32: {
                        int[] iresult = new int[len];
                        result = iresult;
                        for (int i = 0; i < len; ++i) {
                            iresult[i] = (int)lsrc[i];
                        }
                        break block0;
                    }
                    case Float32: {
                        float[] fresult = new float[len];
                        result = fresult;
                        for (int i = 0; i < len; ++i) {
                            BigInteger bi = BigInteger.valueOf(lsrc[i]);
                            bi = bi.and(DapUtil.BIG_UMASK64);
                            fresult[i] = bi.floatValue();
                        }
                        break block0;
                    }
                    case Float64: {
                        double[] dresult = new double[len];
                        result = dresult;
                        for (int i = 0; i < len; ++i) {
                            BigInteger bi = BigInteger.valueOf(lsrc[i]);
                            bi = bi.and(DapUtil.BIG_UMASK64);
                            dresult[i] = bi.doubleValue();
                        }
                        break block0;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
                break;
            }
            case Float32: {
                float[] fsrc = (float[])src;
                len = fsrc.length;
                block85 : switch (dstatomtype) {
                    case Char: {
                        char[] cresult = new char[len];
                        result = cresult;
                        for (int i = 0; i < len; ++i) {
                            cresult[i] = (char)((int)fsrc[i] & 0xFF);
                        }
                        break block0;
                    }
                    case Int8: {
                        byte[] bresult = new byte[len];
                        result = bresult;
                        for (int i = 0; i < len; ++i) {
                            bresult[i] = (byte)fsrc[i];
                        }
                        break block0;
                    }
                    case UInt8: {
                        byte[] bresult = new byte[len];
                        result = bresult;
                        for (int i = 0; i < len; ++i) {
                            if (fsrc[i] < 0.0f) {
                                ok = false;
                                break block85;
                            }
                            bresult[i] = (byte)fsrc[i];
                        }
                        break block0;
                    }
                    case Int16: {
                        short[] shresult = new short[len];
                        result = shresult;
                        for (int i = 0; i < len; ++i) {
                            shresult[i] = (short)fsrc[i];
                        }
                        break block0;
                    }
                    case UInt16: {
                        short[] shresult = new short[len];
                        result = shresult;
                        for (int i = 0; i < len; ++i) {
                            if (fsrc[i] < 0.0f) {
                                ok = false;
                                break block85;
                            }
                            shresult[i] = (short)fsrc[i];
                        }
                        break block0;
                    }
                    case Int32: 
                    case UInt32: {
                        int[] iresult = new int[len];
                        result = iresult;
                        for (int i = 0; i < len; ++i) {
                            if (fsrc[i] < 0.0f) {
                                ok = false;
                                break block85;
                            }
                            iresult[i] = (int)fsrc[i];
                        }
                        break block0;
                    }
                    case Int64: {
                        long[] lresult = new long[len];
                        result = lresult;
                        for (int i = 0; i < len; ++i) {
                            BigDecimal bd = new BigDecimal(fsrc[i]);
                            lresult[i] = bd.toBigInteger().longValue();
                        }
                        break block0;
                    }
                    case UInt64: {
                        long[] lresult = new long[len];
                        result = lresult;
                        for (int i = 0; i < len; ++i) {
                            if (fsrc[i] < 0.0f) {
                                ok = false;
                                break block85;
                            }
                            BigDecimal bd = new BigDecimal(fsrc[i]);
                            lresult[i] = bd.toBigInteger().longValue();
                        }
                        break block0;
                    }
                    case Float64: {
                        double[] dresult = new double[len];
                        result = dresult;
                        for (int i = 0; i < len; ++i) {
                            dresult[i] = fsrc[i];
                        }
                        break block0;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
                break;
            }
            case Float64: {
                double[] dsrc = (double[])src;
                len = dsrc.length;
                block96 : switch (dstatomtype) {
                    case Char: {
                        char[] cresult = new char[len];
                        result = cresult;
                        for (int i = 0; i < len; ++i) {
                            cresult[i] = (char)((int)dsrc[i] & 0xFF);
                        }
                        break block0;
                    }
                    case UInt8: 
                    case Int8: {
                        byte[] bresult = new byte[len];
                        result = bresult;
                        for (int i = 0; i < len; ++i) {
                            bresult[i] = (byte)dsrc[i];
                        }
                        break block0;
                    }
                    case Int16: 
                    case UInt16: {
                        short[] shresult = new short[len];
                        result = shresult;
                        for (int i = 0; i < len; ++i) {
                            shresult[i] = (short)dsrc[i];
                        }
                        break block0;
                    }
                    case Int32: 
                    case UInt32: {
                        int[] iresult = new int[len];
                        result = iresult;
                        for (int i = 0; i < len; ++i) {
                            iresult[i] = (int)dsrc[i];
                        }
                        break block0;
                    }
                    case Int64: {
                        long[] lresult = new long[len];
                        result = lresult;
                        for (int i = 0; i < len; ++i) {
                            BigDecimal bd = new BigDecimal(dsrc[i]);
                            lresult[i] = bd.toBigInteger().longValue();
                        }
                        break block0;
                    }
                    case UInt64: {
                        long[] lresult = new long[len];
                        result = lresult;
                        for (int i = 0; i < len; ++i) {
                            if (dsrc[i] < 0.0) {
                                ok = false;
                                break block96;
                            }
                            BigDecimal bd = new BigDecimal(dsrc[i]);
                            lresult[i] = bd.toBigInteger().longValue();
                        }
                        break block0;
                    }
                    case Float32: {
                        float[] fresult = new float[len];
                        result = fresult;
                        for (int i = 0; i < len; ++i) {
                            fresult[i] = (float)dsrc[i];
                        }
                        break block0;
                    }
                    default: {
                        ok = false;
                        break;
                    }
                }
                break;
            }
            default: {
                throw new DataException(String.format("Illegal Conversion: %s->%s", srctype, dsttype));
            }
        }
        if (!ok) {
            throw new DataException(String.format("Illegal Conversion: %s->%s", srctype, dsttype));
        }
        return result;
    }
}

