/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.ce;

import dap4.core.dmr.DapVariable;
import dap4.core.util.Slice;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public class CEAST {
    public Sort sort = null;
    public NodeList clauses = null;
    public Map<String, Slice> dimdefs = null;
    public CEAST tree = null;
    public String name = null;
    public boolean isleaf = true;
    public List<Slice> slices = null;
    public NodeList subnodes = null;
    public CEAST projection = null;
    public CEAST filter = null;
    public DapVariable field = null;
    public Operator op = null;
    public CEAST lhs = null;
    public CEAST rhs = null;
    public Constant kind = null;
    public Object value = null;
    public Slice slice = null;

    public CEAST(Sort sort) {
        this.sort = sort;
    }

    public void addSegment(CEAST segment) {
        assert (this.sort == Sort.SEGMENT);
        if (this.subnodes == null) {
            this.subnodes = new NodeList();
        }
        this.subnodes.add(segment);
    }

    public static void toString(CEAST node, StringBuilder buf) {
        if (node == null) {
            return;
        }
        switch (node.sort) {
            case CONSTRAINT: {
                boolean first = true;
                for (CEAST elem : node.clauses) {
                    if (!first) {
                        buf.append(";");
                    }
                    CEAST.toString(elem, buf);
                    first = false;
                }
                break;
            }
            case PROJECTION: {
                CEAST.toString(node.tree, buf);
                break;
            }
            case SELECTION: {
                CEAST.toString(node.projection, buf);
                buf.append("|");
                CEAST.toString(node.filter, buf);
                break;
            }
            case SEGMENT: {
                buf.append(node.name);
                if (node.slice != null) {
                    buf.append(node.slice.toString());
                }
                if (node.subnodes == null) break;
                buf.append(".{");
                boolean first = true;
                for (CEAST subnode : node.subnodes) {
                    if (!first) {
                        buf.append(",");
                    } else {
                        first = false;
                    }
                    buf.append(subnode.toString());
                }
                buf.append("}");
                break;
            }
            case EXPR: {
                if (!node.op.isbinary()) break;
                buf.append(node.lhs.toString());
                buf.append(node.op.printstring());
                buf.append(node.rhs.toString());
                break;
            }
            case CONSTANT: {
                buf.append(node.value.toString());
                break;
            }
            case DEFINE: {
                buf.append(node.name);
                if (node.slice == null) break;
                buf.append("=");
                buf.append(node.slice.toString());
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        CEAST.toString(this, buf);
        return buf.toString();
    }

    public static enum Sort {
        CONSTRAINT,
        PROJECTION,
        SEGMENT,
        SELECTION,
        EXPR,
        CONSTANT,
        DEFINE;

    }

    public static class NodeList
    extends ArrayList<CEAST> {
    }

    public static enum Operator {
        LT("<", true, Constant.BOOLEAN, Constant.COMPARABLE),
        LE("<=", true, Constant.BOOLEAN, Constant.COMPARABLE),
        GT(">", true, Constant.BOOLEAN, Constant.COMPARABLE),
        GE(">=", true, Constant.BOOLEAN, Constant.COMPARABLE),
        EQ("==", true, Constant.BOOLEAN, Constant.COMPARABLE),
        NEQ("!=", true, Constant.BOOLEAN, Constant.COMPARABLE),
        REQ("~=", true, Constant.BOOLEAN, EnumSet.of(Constant.STRING)),
        AND(",", true, Constant.BOOLEAN, EnumSet.of(Constant.BOOLEAN)),
        NOT("!", true, Constant.BOOLEAN, EnumSet.of(Constant.BOOLEAN));

        private final String printstring;
        private final boolean binary;
        private final Constant type;
        private final EnumSet<Constant> legalvalues;

        private Operator(String printstring, boolean binary, Constant type, EnumSet<Constant> legal) {
            this.printstring = printstring;
            this.binary = binary;
            this.type = type;
            this.legalvalues = legal;
        }

        public String printstring() {
            return this.printstring;
        }

        public boolean isbinary() {
            return this.binary;
        }

        public EnumSet<Constant> legalvalues() {
            return this.legalvalues;
        }

        public Constant returntype() {
            return this.type;
        }
    }

    public static enum Constant {
        STRING,
        LONG,
        DOUBLE,
        BOOLEAN;

        public static EnumSet<Constant> COMPARABLE;
        public static EnumSet<Constant> NUMERIC;

        static {
            COMPARABLE = EnumSet.of(LONG, DOUBLE, STRING);
            NUMERIC = EnumSet.of(LONG, DOUBLE);
        }
    }

    public static class SliceList
    extends ArrayList<Slice> {
    }

    public static class StringList
    extends ArrayList<String> {
    }

    public static class Path
    extends NodeList {
    }
}

