/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib.cdm.nc2;

import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapNode;
import dap4.core.util.DapException;
import dap4.dap4lib.D4DSP;
import dap4.dap4lib.cdm.NodeMap;
import dap4.dap4lib.cdm.nc2.DMRToCDM;
import dap4.dap4lib.cdm.nc2.DapNetcdfFile;
import dap4.dap4lib.cdm.nc2.DataToCDM;
import java.util.Map;
import ucar.ma2.Array;
import ucar.nc2.CDMNode;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class CDMCompiler {
    public static boolean DEBUG = false;
    protected DapNetcdfFile ncfile = null;
    protected D4DSP dsp = null;
    protected DapDataset dmr = null;
    protected NodeMap<CDMNode, DapNode> nodemap = null;
    protected Map<Variable, Array> arraymap = null;

    public CDMCompiler(DapNetcdfFile ncfile, D4DSP dsp) throws DapException {
        this.ncfile = ncfile;
        this.dsp = dsp;
        this.dmr = this.dsp.getDMR();
    }

    public NodeMap<CDMNode, DapNode> getNodeMap() {
        return this.nodemap;
    }

    public Map<Variable, Array> getArrayMap() {
        return this.arraymap;
    }

    public NetcdfFile getNetcdfFile() {
        return this.ncfile;
    }

    public void compileDMR() throws DapException {
        this.nodemap = new DMRToCDM(this.ncfile, this.dsp).create();
    }

    public void compileData() throws DapException {
        this.arraymap = DataToCDM.createDataMap(this.dsp, this.nodemap);
    }
}

