/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr;

import dap4.core.ce.CEConstraint;
import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnumConst;
import dap4.core.dmr.DapEnumeration;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapMap;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.Escape;
import dap4.core.util.IndentWriter;
import dap4.core.util.ResponseFormat;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteOrder;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

public class DMRPrinter {
    protected static final int NILFLAGS = 0;
    protected static final int PERLINE = 1;
    protected static final int NONAME = 2;
    protected static final int NONNIL = 4;
    protected static final int XMLESCAPED = 8;
    protected static final String[] GROUPSPECIAL = new String[]{"_NCProperties", "_DAP4_Little_Endian"};
    protected static final String[] VARSPECIAL = new String[0];
    protected static final String[] RESERVEDTAGS = new String[]{"_edu.ucar"};
    public static final boolean ALLOWFIELDMAPS = false;
    public static final String XMLDOCUMENTHEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>";
    protected PrintWriter writer = null;
    protected IndentWriter printer = null;
    protected DapDataset dmr = null;
    protected CEConstraint ce = null;
    protected ResponseFormat format = null;
    protected DapContext cxt = null;
    protected ByteOrder order = null;
    protected Map<DapVariable, Long> localchecksummap = null;
    protected EnumSet<Controls> controls = EnumSet.noneOf(Controls.class);

    public static void print(DapDataset dmr, PrintStream stream) {
        try {
            PrintWriter pw = new PrintWriter(stream);
            new DMRPrinter(dmr, pw).print();
            pw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String printAsString(DapDataset dmr) {
        String s = null;
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            new DMRPrinter(dmr, pw).print();
            pw.close();
            s = sw.toString();
            sw.close();
        }
        catch (IOException ioe) {
            s = null;
        }
        return s;
    }

    protected DMRPrinter() {
    }

    public DMRPrinter(DapDataset dmr, PrintWriter writer) {
        this(dmr, null, writer, null);
    }

    public DMRPrinter(DapDataset dmr, CEConstraint ce, PrintWriter writer, ResponseFormat format) {
        this(dmr, ce, writer, format, null);
    }

    public DMRPrinter(DapDataset dmr, CEConstraint ce, PrintWriter writer, ResponseFormat format, DapContext cxt) {
        this();
        this.dmr = dmr;
        this.ce = ce == null ? CEConstraint.getUniversal(dmr) : ce;
        this.writer = writer;
        this.printer = new IndentWriter(writer);
        this.format = format == null ? ResponseFormat.XML : format;
        this.cxt = cxt == null ? new DapContext() : cxt;
        this.order = (ByteOrder)this.cxt.get("ucar.littleendian");
        this.localchecksummap = (Map)this.cxt.get("checksummap");
    }

    public void flush() {
        this.printer.flush();
    }

    public void close() {
        this.flush();
    }

    public void setControl(Controls ctl) {
        this.controls.add(ctl);
    }

    public void print() throws IOException {
        this.printer.setIndent(0);
        this.printer.marginPrintln(XMLDOCUMENTHEADER);
        if (this.printNode(this.dmr)) {
            this.printer.eol();
        }
    }

    public boolean printNode(DapNode node) throws IOException {
        if (node == null) {
            return false;
        }
        DapSort sort = node.getSort();
        switch (sort) {
            case DATASET: 
            case GROUP: 
            case DIMENSION: 
            case ENUMERATION: 
            case VARIABLE: {
                if (this.ce.references(node)) break;
                return false;
            }
        }
        String dmrname = sort.getName();
        switch (sort) {
            case DATASET: 
            case GROUP: {
                DapGroup group = (DapGroup)node;
                this.printer.marginPrint("<" + dmrname);
                int flags = sort == DapSort.DATASET ? 1 : 0;
                this.printXMLAttributes(node, this.ce, flags);
                this.printer.println(">");
                this.printer.indent();
                if (group.getDimensions().size() > 0) {
                    for (DapNode dapNode : group.getDimensions()) {
                        if (!this.ce.references(dapNode) || !this.printNode(dapNode)) continue;
                        this.printer.eol();
                    }
                }
                if (group.getEnums().size() > 0) {
                    for (DapNode dapNode : group.getEnums()) {
                        if (!this.ce.references(dapNode) || !this.printNode(dapNode)) continue;
                        this.printer.eol();
                    }
                }
                if (group.getVariables().size() > 0) {
                    for (DapNode dapNode : group.getVariables()) {
                        if (!this.ce.references(dapNode) || !this.printNode(dapNode)) continue;
                        this.printer.eol();
                    }
                }
                this.printMetadata(node);
                if (group.getGroups().size() > 0) {
                    for (DapNode dapNode : group.getGroups()) {
                        if (!this.ce.references(dapNode) || !this.printNode(dapNode)) continue;
                        this.printer.eol();
                    }
                }
                this.printer.outdent();
                this.printer.marginPrint("</" + dmrname + ">");
                break;
            }
            case DIMENSION: {
                DapDimension dim = (DapDimension)node;
                if (!dim.isShared()) {
                    return false;
                }
                this.printer.marginPrint("<" + dmrname);
                this.printXMLAttributes(node, this.ce, 0);
                if (dim.isUnlimited()) {
                    this.printXMLAttribute("_edu.ucar.isunlimited", "1", 0);
                }
                if (this.hasMetadata(node)) {
                    this.printer.println(">");
                    this.printMetadata(node);
                    this.printer.marginPrint("</" + dmrname + ">");
                    break;
                }
                this.printer.print("/>");
                break;
            }
            case ENUMERATION: {
                DapEnumeration dapEnumeration = (DapEnumeration)node;
                this.printer.marginPrint("<" + dmrname);
                this.printXMLAttributes(dapEnumeration, this.ce, 0);
                this.printer.println(">");
                this.printer.indent();
                List<String> econstnames = dapEnumeration.getNames();
                for (String econst : econstnames) {
                    DapEnumConst value = dapEnumeration.lookup(econst);
                    assert (value != null);
                    this.printer.marginPrintln(String.format("<EnumConst name=\"%s\" value=\"%d\"/>", Escape.entityEscape(econst, null), value.getValue()));
                }
                this.printMetadata(node);
                this.printer.outdent();
                this.printer.marginPrint("</" + dmrname + ">");
                break;
            }
            case VARIABLE: {
                DapVariable var = (DapVariable)node;
                if (var.getCount() == 0L) {
                    return false;
                }
                DapType type = var.getBaseType();
                this.printer.marginPrint("<" + type.getTypeSort().name());
                this.printXMLAttributes(node, this.ce, 0);
                if (type.isAtomic()) {
                    if (this.hasMetadata(node) || this.hasDimensions(var) || this.hasMaps(var) || this.hasRequestData(var)) {
                        this.printer.println(">");
                        this.printer.indent();
                        if (this.hasDimensions(var)) {
                            this.printDimrefs(var);
                        }
                        if (this.hasMetadata(var)) {
                            this.printMetadata(var);
                        }
                        if (this.hasMaps(var)) {
                            this.printMaps(var);
                        }
                        if (this.hasRequestData(var)) {
                            this.printRequestData(var);
                        }
                        this.printer.outdent();
                        this.printer.marginPrint("</" + type.getTypeSort().name() + ">");
                        break;
                    }
                    this.printer.print("/>");
                    break;
                }
                if (type.getTypeSort().isCompound()) {
                    DapStructure struct = (DapStructure)type;
                    this.printer.println(">");
                    this.printer.indent();
                    for (DapVariable field : struct.getFields()) {
                        if (!this.ce.references(field) || !this.printNode(field)) continue;
                        this.printer.eol();
                    }
                    this.printDimrefs(var);
                    this.printMetadata(var);
                    this.printMaps(var);
                    if (this.hasRequestData(var)) {
                        this.printRequestData(var);
                    }
                    this.printer.outdent();
                    this.printer.marginPrint("</" + type.getTypeSort().name() + ">");
                    break;
                }
                throw new IllegalStateException("Illegal variable base type");
            }
            default: {
                throw new IllegalStateException("Unexpected sort: " + sort.name());
            }
        }
        return true;
    }

    void printXMLAttributes(DapNode node, CEConstraint ce, int flags) throws IOException {
        String name;
        if ((flags & 1) != 0) {
            this.printer.indent(2);
        }
        if ((name = node.getShortName()) != null && (flags & 2) == 0) {
            name = node.getShortName();
            this.printXMLAttribute("name", name, flags);
        }
        switch (node.getSort()) {
            case DATASET: {
                DapDataset dataset = (DapDataset)node;
                this.printXMLAttribute("dapVersion", dataset.getDapVersion(), flags);
                this.printXMLAttribute("dmrVersion", dataset.getDMRVersion(), flags);
                this.printXMLAttribute("xmlns", "http://xml.opendap.org/ns/DAP/4.0#", flags);
                this.printXMLAttribute("xmlns:dap", "http://xml.opendap.org/ns/DAP/4.0#", flags);
                break;
            }
            case DIMENSION: {
                DapDimension orig = (DapDimension)node;
                if (!orig.isShared()) break;
                DapDimension actual = this.ce.getRedefDim(orig);
                if (actual == null) {
                    actual = orig;
                }
                long size = actual.getSize();
                this.printXMLAttribute("size", Long.toString(size), flags);
                break;
            }
            case ENUMERATION: {
                this.printXMLAttribute("basetype", ((DapEnumeration)node).getBaseType().getTypeName(), flags);
                break;
            }
            case VARIABLE: {
                DapVariable var = (DapVariable)node;
                DapType basetype = var.getBaseType();
                if (!basetype.isEnumType()) break;
                this.printXMLAttribute("enum", basetype.getTypeName(), flags);
                break;
            }
            case ATTRIBUTE: {
                DapAttribute attr = (DapAttribute)node;
                DapType basetype = attr.getBaseType();
                this.printXMLAttribute("type", basetype.getTypeName(), flags);
                if (!attr.getBaseType().isEnumType()) break;
                this.printXMLAttribute("enum", basetype.getTypeName(), flags);
                break;
            }
        }
        if (this.controls.contains((Object)Controls.RESERVED)) {
            this.printReserved(node);
        }
        if ((flags & 1) != 0) {
            this.printer.outdent(2);
        }
    }

    protected void printXMLAttribute(String name, String value, int flags) throws DapException {
        if (name == null) {
            return;
        }
        if ((flags & 4) == 0 && (value == null || value.length() == 0)) {
            return;
        }
        if ((flags & 1) != 0) {
            this.printer.eol();
            this.printer.margin();
        }
        this.printer.print(" " + name + "=");
        this.printer.print("\"");
        if (value != null) {
            if ((flags & 8) == 0) {
                value = Escape.entityEscape(value, "\"");
            }
            this.printer.print(value);
        }
        this.printer.print("\"");
    }

    protected void printReserved(DapNode node) throws DapException {
        Map<String, String> xattrs = node.getXMLAttributes();
        if (xattrs == null) {
            return;
        }
        for (Map.Entry<String, String> entry : xattrs.entrySet()) {
            if (!DMRPrinter.isReserved(entry.getKey())) continue;
            this.printXMLAttribute(entry.getKey(), entry.getValue(), 0);
        }
    }

    protected void printMetadata(DapNode node) throws IOException {
        boolean isdataset = node.getSort() == DapSort.DATASET;
        Map<String, DapAttribute> attributes = node.getAttributes();
        if (!isdataset && attributes.size() == 0) {
            return;
        }
        for (Map.Entry<String, DapAttribute> entry : attributes.entrySet()) {
            DapAttribute attr = entry.getValue();
            assert (attr != null);
            switch (attr.getSort()) {
                case ATTRIBUTE: {
                    this.printAttribute(attr);
                    break;
                }
                case ATTRIBUTESET: {
                    this.printContainerAttribute(attr);
                    break;
                }
                case OTHERXML: {
                    this.printOtherXML(attr);
                }
            }
        }
        if (isdataset) {
            this.printRequestMetaData(node);
        }
    }

    protected void printContainerAttribute(DapAttribute attr) {
    }

    protected void printOtherXML(DapAttribute attr) {
    }

    static boolean isSuppressed(String name) {
        return DMRPrinter.isReserved(name);
    }

    static boolean isReserved(String key) {
        for (String s : RESERVEDTAGS) {
            if (!key.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    static boolean isSpecial(DapAttribute attr) {
        block3: {
            block2: {
                if (attr.getParent().getSort() != DapSort.DATASET) break block2;
                for (String s : GROUPSPECIAL) {
                    if (!s.equals(attr.getShortName())) continue;
                    return true;
                }
                break block3;
            }
            if (attr.getParent().getSort() != DapSort.VARIABLE) break block3;
            for (String s : VARSPECIAL) {
                if (!s.equals(attr.getShortName())) continue;
                return true;
            }
        }
        return false;
    }

    void printAttribute(DapAttribute attr) throws IOException {
        this.printer.marginPrint("<Attribute");
        this.printXMLAttribute("name", attr.getShortName(), 0);
        DapType type = attr.getBaseType();
        this.printXMLAttribute("type", type.getTypeName(), 0);
        this.printer.println(">");
        String[] values = attr.getValues();
        if (values == null) {
            throw new DapException("Attribute with no values:" + attr.getFQN());
        }
        this.printer.indent();
        String[] svec = values;
        if (type == DapType.CHAR) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < svec.length; ++i) {
                buf.append(svec[i]);
            }
            String cs = String.format("<Value value=\"%s\"/>", buf.toString());
            this.printer.marginPrintln(cs);
        } else if (type.isEnumType()) {
            String[] names = ((DapEnumeration)type).convert(svec);
            for (int i = 0; i < svec.length; ++i) {
                String s = Escape.entityEscape(names[i], null);
                String cs = String.format("<Value value=\"%s\"/>", s);
                this.printer.marginPrintln(cs);
            }
        } else {
            for (int i = 0; i < svec.length; ++i) {
                String s = Escape.entityEscape(svec[i], null);
                String cs = String.format("<Value value=\"%s\"/>", s);
                this.printer.marginPrintln(cs);
            }
        }
        this.printer.outdent();
        this.printer.marginPrintln("</Attribute>");
    }

    void printDimrefs(DapVariable var) throws DapException {
        if (var.getRank() == 0) {
            return;
        }
        List<DapDimension> dimset = this.ce.getConstrainedDimensions(var);
        if (dimset == null) {
            throw new DapException("Unknown variable: " + var);
        }
        assert (var.getRank() == dimset.size());
        for (int i = 0; i < var.getRank(); ++i) {
            DapDimension dim = dimset.get(i);
            this.printer.marginPrint("<Dim");
            if (dim.isShared()) {
                String fqn = dim.getFQN();
                assert (fqn != null) : "Illegal Dimension reference";
                fqn = DMRPrinter.fqnXMLEscape(fqn);
                this.printXMLAttribute("name", fqn, 8);
            } else {
                long size = dim.getSize();
                this.printXMLAttribute("size", Long.toString(size), 0);
            }
            this.printer.println("/>");
        }
    }

    void printMaps(DapVariable parent) throws IOException {
        List<DapMap> maps = parent.getMaps();
        if (maps.size() == 0) {
            return;
        }
        for (DapMap map : maps) {
            DapVariable mapvar = map.getVariable();
            if (mapvar != null && mapvar.getParent() != null && !mapvar.getParent().getSort().isGroup()) continue;
            String name = map.getTargetName();
            assert (name != null) : "Illegal <Map> reference";
            this.printer.marginPrint("<Map");
            name = DMRPrinter.fqnXMLEscape(name);
            this.printXMLAttribute("name", name, 8);
            this.printXMLAttributes(map, this.ce, 2);
            if (this.hasMetadata(map)) {
                this.printer.println(">");
                this.printer.indent();
                this.printMetadata(map);
                this.printer.outdent();
                this.printer.marginPrintln("</Map>");
                continue;
            }
            this.printer.println("/>");
        }
    }

    void printRequestMetaData(DapNode dataset) throws DapException {
        try {
            if (!this.ce.isUniversal()) {
                String sce = this.ce.toConstraintString();
                DapAttribute a = new DapAttribute("_dap4.ce", DapType.STRING);
                a.setValues(new String[]{sce});
                this.printAttribute(a);
            }
            DapAttribute a = new DapAttribute("_DAP4_Little_Endian", DapType.UINT8);
            String[] value = new String[]{this.order == ByteOrder.LITTLE_ENDIAN ? "1" : "0"};
            a.setValues(value);
            this.printAttribute(a);
        }
        catch (IOException ioe) {
            throw new DapException(ioe);
        }
    }

    protected void printRequestData(DapVariable var) throws DapException {
        try {
            Long csum = this.localchecksummap.get(var);
            if (csum == null) {
                return;
            }
            DapAttribute a = var.getChecksumAttribute();
            if (a == null) {
                a = new DapAttribute("_DAP4_Checksum_CRC32", DapType.INT32);
                a.setValues(new String[]{csum.toString()});
            }
            this.printAttribute(a);
        }
        catch (IOException ioe) {
            throw new DapException(ioe);
        }
    }

    public static String fqnXMLEscape(String fqn) {
        int i;
        StringBuilder xml = new StringBuilder();
        String segment = null;
        List<String> segments = Escape.backslashsplit(fqn, '/');
        for (i = 1; i < segments.size() - 1; ++i) {
            segment = segments.get(i);
            segment = Escape.backslashUnescape(segment);
            segment = Escape.entityEscape(segment, "\"");
            segment = Escape.backslashEscape(segment, "/.");
            xml.append("/");
            xml.append(segment);
        }
        segment = segments.get(segments.size() - 1);
        segments = Escape.backslashsplit(segment, '.');
        xml.append("/");
        for (i = 0; i < segments.size(); ++i) {
            segment = segments.get(i);
            segment = Escape.backslashUnescape(segment);
            segment = Escape.entityEscape(segment, "\"");
            segment = Escape.backslashEscape(segment, "/.");
            if (i > 0) {
                xml.append(".");
            }
            xml.append(segment);
        }
        return xml.toString();
    }

    protected static String getPrintValue(Object value) {
        if (value instanceof String) {
            String sclean = Escape.cleanString((String)value);
            return Escape.entityEscape((String)value, null);
        }
        if (value instanceof Character) {
            return Escape.entityEscape(((Character)value).toString(), null);
        }
        return value.toString();
    }

    protected boolean hasMetadata(DapNode node) {
        return node.getAttributes().size() > 0;
    }

    protected boolean hasMaps(DapVariable var) {
        return var.getMaps().size() > 0;
    }

    protected boolean hasDimensions(DapVariable var) {
        return var.getDimensions().size() > 0;
    }

    protected boolean hasRequestData(DapVariable var) {
        return this.localchecksummap != null && this.localchecksummap.containsKey(var);
    }

    public static enum Controls {
        RESERVED;

    }
}

