/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.Slice;
import dap4.core.util.XURI;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class DapUtil {
    public static final BigInteger BIG_UMASK64 = new BigInteger("FFFFFFFFFFFFFFFF", 16);
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final ByteOrder NETWORK_ORDER = ByteOrder.BIG_ENDIAN;
    public static final ByteOrder NATIVE_ORDER = ByteOrder.nativeOrder();
    public static final String LF = "\n";
    public static final String CRLF = "\r\n";
    public static final int CRLFSIZE = 2;
    public static Pattern DAP4EXT_RE = Pattern.compile("^.*(.dmr|.dap|.dsr|.xml|.html)$");

    public static String fqnSuffix(String fqn) {
        int structindex = fqn.lastIndexOf(46);
        int groupindex = fqn.lastIndexOf(47);
        if (structindex >= 0) {
            return fqn.substring(structindex + 1, fqn.length());
        }
        return fqn.substring(groupindex + 1, fqn.length());
    }

    public static String fqnPrefix(String fqn) {
        int structindex = fqn.lastIndexOf(46);
        int groupindex = fqn.lastIndexOf(47);
        if (structindex >= 0) {
            return fqn.substring(0, structindex);
        }
        return fqn.substring(0, groupindex);
    }

    public static List<String> backslashSplit(String s, char sep) {
        ArrayList<String> path = new ArrayList<String>();
        int len = s.length();
        StringBuilder piece = new StringBuilder();
        for (int i = 0; i <= len - 1; ++i) {
            char c = s.charAt(i);
            if (c == '\\' && i < len - 1) {
                piece.append(c);
                piece.append(s.charAt(++i));
                continue;
            }
            if (c == sep) {
                path.add(piece.toString());
                piece.setLength(0);
                continue;
            }
            piece.append(c);
        }
        path.add(piece.toString());
        return path;
    }

    public static Integer stringToInteger(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static boolean hasSequence(DapNode node) {
        switch (node.getSort()) {
            case SEQUENCE: {
                return true;
            }
            case STRUCTURE: {
                DapStructure container = (DapStructure)node;
                for (int i = 0; i < container.getFields().size(); ++i) {
                    if (!DapUtil.hasSequence(container.getFields().get(i))) continue;
                    return true;
                }
                break;
            }
            case GROUP: {
                DapGroup group = (DapGroup)node;
                for (int i = 0; i < group.getDecls().size(); ++i) {
                    if (!DapUtil.hasSequence(group.getDecls().get(i))) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public static String locateFile(String filename, String abspath, boolean wantdir) {
        String currentpath;
        ArrayDeque<String> q = new ArrayDeque<String>();
        filename = filename.trim().replace('\\', '/');
        abspath = abspath.trim().replace('\\', '/');
        if (filename.charAt(0) == '/') {
            filename = filename.substring(1);
        }
        if (filename.endsWith("/")) {
            filename = filename.substring(0, filename.length() - 1);
        }
        if (abspath.endsWith("/")) {
            abspath = abspath.substring(0, abspath.length() - 1);
        }
        q.addFirst(abspath);
        while ((currentpath = (String)q.poll()) != null) {
            File current = new File(currentpath);
            File[] contents = current.listFiles();
            if (contents == null) continue;
            for (File subfile : contents) {
                if (!subfile.getName().equals(filename) || (!wantdir || !subfile.isDirectory()) && (wantdir || !subfile.isFile())) continue;
                return DapUtil.canonicalpath(subfile.getAbsolutePath());
            }
            for (File subfile : contents) {
                if (!subfile.isDirectory()) continue;
                q.addFirst(currentpath + "/" + subfile.getName());
            }
        }
        return null;
    }

    public static String locateRelative(String relpath, String abspath, boolean wantdir) {
        if ((relpath = relpath.trim().replace('\\', '/')).charAt(0) == '/') {
            relpath = relpath.substring(1);
        }
        if (relpath.endsWith("/")) {
            relpath = relpath.substring(0, relpath.length() - 1);
        }
        String[] pieces = relpath.split("[/]");
        String partial = abspath;
        for (int i = 0; i < pieces.length - 1; ++i) {
            String nextdir = DapUtil.locateFile(pieces[i], abspath, true);
            if (nextdir == null) {
                return null;
            }
            partial = nextdir;
        }
        String finalpath = DapUtil.locateFile(pieces[pieces.length - 1], partial, wantdir);
        return finalpath;
    }

    public static String canonicalpath(String path) {
        boolean abs;
        if (path == null) {
            return null;
        }
        path = path.trim();
        if ((path = path.replace('\\', '/')).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        boolean bl = abs = path.length() > 0 && path.charAt(0) == '/';
        if (abs) {
            path = path.substring(1);
        }
        if (DapUtil.hasDriveLetter(path)) {
            path = path.substring(0, 1).toLowerCase() + path.substring(1);
        } else if (abs) {
            path = "/" + path;
        }
        return path;
    }

    public static String relativize(String path) {
        if (path == null) {
            return path;
        }
        if ((path = path.replace('\\', '/')).length() > 0) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (DapUtil.hasDriveLetter(path)) {
                path = path.substring(2);
            }
        }
        return path;
    }

    public static String absolutize(String path) {
        if (path != null && !path.startsWith("/") && !DapUtil.hasDriveLetter(path)) {
            path = "/" + path;
        }
        return path;
    }

    public static boolean checkFixedSize(DapVariable var) {
        DapType dt = var.getBaseType();
        switch (dt.getTypeSort()) {
            case Structure: 
            case Sequence: {
                for (DapVariable field : ((DapStructure)dt).getFields()) {
                    if (DapUtil.checkFixedSize(field)) continue;
                    return false;
                }
                break;
            }
            default: {
                return dt.isFixedSize();
            }
        }
        return true;
    }

    public static byte[] extract(ByteBuffer buf) {
        int len = buf.limit();
        byte[] bytes = new byte[len];
        buf.rewind();
        buf.get(bytes);
        return bytes;
    }

    public static byte[] readbinaryfile(InputStream stream) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] tmp = new byte[65536];
        try {
            int cnt;
            while ((cnt = stream.read(tmp)) > 0) {
                bytes.write(tmp, 0, cnt);
            }
        }
        catch (IOException ioe) {
            throw new DapException(ioe);
        }
        return bytes.toByteArray();
    }

    public static int readbinaryfilepartial(InputStream stream, byte[] buffer, int count) throws IOException {
        try {
            int red;
            int offset = 0;
            int remainder = count;
            while (remainder > 0 && (red = stream.read(buffer, offset, remainder)) > 0) {
                remainder -= red;
                offset += red;
            }
            return offset;
        }
        catch (IOException ioe) {
            throw new DapException(ioe);
        }
    }

    public static String readtextfile(InputStream stream) throws IOException {
        int c;
        StringBuilder buf = new StringBuilder();
        InputStreamReader rdr = new InputStreamReader(stream, UTF8);
        while ((c = rdr.read()) >= 0) {
            buf.append((char)c);
        }
        return buf.toString();
    }

    public static List<DapVariable> getStructurePath(DapVariable var) {
        List<DapNode> path = var.getPath();
        ArrayList<DapVariable> structpath = new ArrayList<DapVariable>();
        block4: for (int i = 0; i < path.size(); ++i) {
            DapNode node = path.get(i);
            switch (node.getSort()) {
                case GROUP: 
                case DATASET: {
                    continue block4;
                }
                case VARIABLE: {
                    structpath.add((DapVariable)node);
                    continue block4;
                }
                default: {
                    throw new IllegalStateException("Internal error, sort = " + (Object)((Object)node.getSort()));
                }
            }
        }
        return structpath;
    }

    public static String denullify(String path) {
        return path == null ? "" : path;
    }

    public static Object stringable(Object obj) {
        return obj == null ? "" : obj;
    }

    public static String nullify(String path) {
        return path != null && path.length() == 0 ? null : path;
    }

    public static long[] getDimSizes(List<DapDimension> dims) {
        long[] sizes = new long[dims.size()];
        for (int i = 0; i < dims.size(); ++i) {
            sizes[i] = dims.get(i).getSize();
        }
        return sizes;
    }

    public static long dimProduct(List<DapDimension> dimset) {
        long count = 1L;
        for (DapDimension dim : dimset) {
            count *= dim.getSize();
        }
        return count;
    }

    public static boolean isWhole(List<Slice> slices, List<DapDimension> dimset) {
        if (slices.size() != dimset.size()) {
            return false;
        }
        for (int i = 0; i < slices.size(); ++i) {
            Slice slice = slices.get(i);
            DapDimension dim = dimset.get(i);
            if (slice.getStride() == 1 && slice.getFirst() == 0 && (long)slice.getCount() == dim.getSize()) continue;
            return false;
        }
        return true;
    }

    public static long sliceProduct(List<Slice> slices) {
        long count = 1L;
        if (slices != null) {
            for (Slice slice : slices) {
                count *= (long)slice.getCount();
            }
        }
        return count;
    }

    public static boolean hasStrideOne(List<Slice> slices) {
        for (Slice slice : slices) {
            if (slice.getStride() == 1) continue;
            return false;
        }
        return true;
    }

    public static String join(String[] array, String sep, int from, int upto) {
        if (sep == null) {
            sep = "";
        }
        if (from < 0 || upto > array.length) {
            throw new IndexOutOfBoundsException();
        }
        if (upto <= from) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (int i = from; i < upto; ++i) {
            if (!first) {
                result.append(sep);
            }
            result.append(array[i]);
            first = false;
        }
        return result.toString();
    }

    public static String xrelpath(String path) {
        return DapUtil.canonicalpath(path);
    }

    public static boolean hasDriveLetter(String path) {
        return XURI.hasDriveLetter(path);
    }

    public static String repairPath(String path) {
        return XURI.hideDriveLetter(path);
    }

    public static List<String> getProtocols(String url, int[] breakpoint) {
        int index;
        ArrayList<String> allprotocols = new ArrayList<String>();
        StringBuilder buf = new StringBuilder(url);
        int protosize = 0;
        while ((index = buf.indexOf(":")) >= 0) {
            String protocol = buf.substring(0, index);
            if (index == 1 && "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(buf.charAt(0)) >= 0) break;
            allprotocols.add(protocol);
            buf.delete(0, index + 1);
            protosize += index + 1;
            if (buf.indexOf("/") != 0) continue;
            break;
        }
        breakpoint[0] = protosize;
        return allprotocols;
    }

    public static String merge(String[] pieces, String sep) {
        if (pieces == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < pieces.length; ++i) {
            if (i > 0) {
                buf.append(sep);
            }
            buf.append(pieces[i]);
        }
        return buf.toString();
    }

    static String multiSliceString(List<List<Slice>> slices) {
        if (slices == null || slices.size() == 0) {
            return "[]";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < slices.size(); ++i) {
            List<Slice> set = slices.get(i);
            buf.append("[");
            for (int j = 0; j < set.size(); ++j) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(set.get(j));
            }
            buf.append("]");
        }
        buf.append("]");
        return buf.toString();
    }

    public static void checkruntime(Exception e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
    }

    public static String canonjoin(String prefix, String suffix) {
        int pos;
        StringBuilder result = new StringBuilder();
        if (prefix == null) {
            prefix = "";
        }
        if (suffix == null) {
            suffix = "";
        }
        prefix = DapUtil.canonicalpath(prefix);
        suffix = DapUtil.canonicalpath(suffix);
        result.append(prefix);
        result.append("/");
        result.append(suffix);
        while ((pos = result.indexOf("//")) >= 0) {
            result.deleteCharAt(pos);
        }
        return result.toString();
    }

    public static boolean hasWindowsDrive(String path) {
        if (path != null && path.length() >= 2 && path.charAt(1) == ':') {
            char c = path.charAt(0);
            return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
        }
        return false;
    }

    public static boolean isAbsolutePath(String path) {
        return path != null && (DapUtil.hasWindowsDrive(path) || path.charAt(0) == '/' || path.charAt(0) == '\\');
    }

    public static String canonFileURL(String url) {
        if (url == null || url.startsWith("file:")) {
            return url;
        }
        return "file:" + DapUtil.absolutize(url);
    }

    public static String stripDap4Extensions(String path) {
        Matcher m;
        while ((m = DAP4EXT_RE.matcher(path)).matches()) {
            String match = m.group(1);
            int pathlen = path.length();
            path = path.substring(0, pathlen - match.length());
        }
        return path;
    }

    public static boolean isContiguous(List<Slice> slices) {
        for (Slice sl : slices) {
            if (sl.getStride() == 1) continue;
            return false;
        }
        return true;
    }

    public static boolean isSinglePoint(List<Slice> slices) {
        for (Slice sl : slices) {
            if (sl.getCount() == 1) continue;
            return false;
        }
        return true;
    }

    public static List<Slice> dimsetToSlices(List<DapDimension> dimset) throws DapException {
        if (dimset == null || dimset.size() == 0) {
            return Slice.SCALARSLICES;
        }
        ArrayList<Slice> slices = new ArrayList<Slice>(dimset.size());
        for (int i = 0; i < dimset.size(); ++i) {
            DapDimension dim = dimset.get(i);
            Slice s = new Slice(dim);
            slices.add(s);
        }
        return slices;
    }

    public static boolean isScalarSlices(List<Slice> slices) {
        if (slices == null || slices.size() != 1) {
            return false;
        }
        Slice s = slices.get(0);
        return s.getFirst() == 0 && s.getStop() == 1;
    }

    public static long[] longvector(int[] iv) {
        long[] lv = new long[iv.length];
        for (int i = 0; i < iv.length; ++i) {
            lv[i] = iv[i];
        }
        return lv;
    }

    public static int[] intvector(long[] lv) {
        int[] iv = new int[lv.length];
        for (int i = 0; i < lv.length; ++i) {
            iv[i] = (int)lv[i];
        }
        return iv;
    }
}

