/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import dap4.core.dmr.DapDimension;
import dap4.core.util.DapException;
import dap4.core.util.SliceIterator;
import java.util.ArrayList;
import java.util.List;

public class Slice {
    public static final int UNDEFINED = -1;
    public static final int MAXLENGTH = 0x3FFFFFFF;
    public static List<Slice> SCALARSLICES;
    public static Slice SCALARSLICE;
    protected Sort sort = Sort.Single;
    int first = -1;
    int stop = -1;
    int stride = -1;
    int maxsize = 0x3FFFFFFF;
    Boolean whole = null;
    protected boolean constrained = true;

    public Slice() {
    }

    public Slice(int first, int stop, int stride) throws DapException {
        this(first, stop, stride, -1);
    }

    public Slice(int first, int stop, int stride, int maxsize) throws DapException {
        this();
        this.setIndices(first, stop, stride, maxsize);
    }

    public Slice(Slice s) throws DapException {
        this();
        this.setIndices(s.getFirst(), s.getStop(), s.getStride(), s.getMax());
        this.setConstrained(s.isConstrained());
        this.setWhole(s.isWhole());
    }

    public Slice(DapDimension dim) throws DapException {
        this();
        this.setIndices(0, (int)dim.getSize(), 1, (int)dim.getSize());
        this.setWhole(true);
        this.setConstrained(false);
    }

    public Slice finish() throws DapException {
        if (this.first == -1) {
            this.first = 0;
        }
        if (this.stride == -1) {
            this.stride = 1;
        }
        if (this.stop == -1 && this.maxsize != -1) {
            this.stop = this.maxsize;
        }
        if (this.stop == -1 && this.maxsize == -1) {
            this.stop = this.first + 1;
        }
        if (this.maxsize == -1 && this.stop != -1) {
            this.maxsize = this.stop;
        }
        assert (this.first != -1);
        assert (this.stride != -1);
        assert (this.stop != -1);
        if (this.first > this.maxsize) {
            throw new DapException("Slice: first index > max size");
        }
        if (this.stop > this.maxsize + 1) {
            throw new DapException("Slice: stop > max size");
        }
        if (this.first < 0) {
            throw new DapException("Slice: first index < 0");
        }
        if (this.stop < 0) {
            throw new DapException("Slice: stop index < 0");
        }
        if (this.stride <= 0) {
            throw new DapException("Slice: stride index <= 0");
        }
        if (this.first > this.stop) {
            throw new DapException("Slice: first index > last");
        }
        return this;
    }

    public SliceIterator iterator() {
        return new SliceIterator(this);
    }

    public Sort getSort() {
        return this.sort;
    }

    public int getFirst() {
        return this.first;
    }

    public int getStop() {
        return this.stop;
    }

    public int getLast() {
        return this.stop - this.first == 0 ? 0 : this.stop - 1;
    }

    public int getStride() {
        return this.stride;
    }

    public int getSize() {
        return this.stop - this.first;
    }

    public int getMax() {
        return this.maxsize;
    }

    public boolean isScalar() {
        return this.getSize() <= 1;
    }

    public Slice setMaxSize(int size) throws DapException {
        return this.setIndices(this.first, this.stop, this.stride, size);
    }

    public Slice setIndices(int first, int stop, int stride) throws DapException {
        return this.setIndices(first, stop, stride, -1);
    }

    public Slice setIndices(int first, int stop, int stride, int maxsize) throws DapException {
        this.first = first;
        this.stop = stop;
        this.stride = stride;
        this.maxsize = maxsize;
        return this.finish();
    }

    public Boolean isWhole() {
        return this.whole;
    }

    public Slice setWhole(Boolean tf) {
        this.whole = tf;
        return this;
    }

    public Boolean isConstrained() {
        return this.constrained;
    }

    public Slice setConstrained(Boolean tf) {
        this.constrained = tf;
        return this;
    }

    public int getCount() {
        assert (this.first != -1 && this.stride != -1 && this.stop != -1);
        int count = this.stop - this.first;
        count = count + this.stride - 1;
        return count /= this.stride;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Slice)) {
            return false;
        }
        Slice other = (Slice)o;
        if (other == this) {
            return true;
        }
        return other.getFirst() == this.getFirst() && other.getStop() == this.getStop() && other.getStride() == this.getStride();
    }

    public int hashCode() {
        return this.getFirst() << 20 | this.getStop() << 10 | this.getStride();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean withbrackets) {
        StringBuilder buf = new StringBuilder();
        if (withbrackets) {
            buf.append("[");
        }
        if (this.stop - this.first == 0) {
            buf.append("0");
        } else if (this.stride == 1) {
            buf.append(String.format("%d:%d", this.first, this.stop - 1));
        } else {
            buf.append(String.format("%d:%d:%d", this.first, this.stride, this.stop - 1));
        }
        buf.append(String.format("|%d", this.stop - this.first));
        if (withbrackets) {
            buf.append("]");
        }
        return buf.toString();
    }

    public String toConstraintString() throws DapException {
        assert (this.first != -1 && this.stride != -1 && this.stop != -1);
        if (this.stop - this.first == 0) {
            return String.format("[0]", new Object[0]);
        }
        if (this.stride == 1) {
            if (this.stop - this.first == 1) {
                return String.format("[%d]", this.first);
            }
            return String.format("[%d:%d]", this.first, this.stop - 1);
        }
        return String.format("[%d:%d:%d]", this.first, this.stride, this.stop - 1);
    }

    public static Slice compose(Slice target, Slice src) throws DapException {
        int sr_stride = target.getStride() * src.getStride();
        int sr_first = Slice.MAP(target, src.getFirst());
        int lastx = Slice.MAP(target, src.getLast());
        int sr_last = target.getLast() < lastx ? target.getLast() : lastx;
        return new Slice(sr_first, sr_last + 1, sr_stride, sr_last + 1).finish();
    }

    static int MAP(Slice target, int i) throws DapException {
        if (i < 0) {
            throw new DapException("Slice.compose: i must be >= 0");
        }
        if (i > target.getStop()) {
            throw new DapException("i must be < stop");
        }
        return target.getFirst() + i * target.getStride();
    }

    public List<Slice> getSubSlices() {
        ArrayList<Slice> list = new ArrayList<Slice>();
        list.add(this);
        return list;
    }

    public Slice getSubSlice(int i) {
        if (i != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    static {
        try {
            SCALARSLICE = new Slice(0, 1, 1, 1).finish();
            SCALARSLICES = new ArrayList<Slice>();
            SCALARSLICES.add(SCALARSLICE);
        }
        catch (DapException de) {
            SCALARSLICES = null;
        }
    }

    public static enum Sort {
        Single,
        Multi;

    }
}

