/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib.cdm;

import com.google.common.collect.ImmutableList;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapType;
import dap4.core.dmr.TypeSort;
import dap4.core.util.DapException;
import dap4.core.util.Slice;
import dap4.dap4lib.cdm.CDMTypeFcns;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.ForbiddenConversionException;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.CDMNode;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;

public abstract class CDMUtil {
    static final String hexchars = "0123456789abcdef";
    public static final Index SCALAR = new Index(new int[0], new int[0]);

    public static List<Slice> createSlices(List<Range> rangelist) throws DapException {
        ArrayList<Slice> slices = new ArrayList<Slice>(rangelist.size());
        for (int i = 0; i < rangelist.size(); ++i) {
            Range r = rangelist.get(i);
            int stride = r.stride();
            int first = r.first();
            int n = r.length();
            int stop = first + n * stride;
            Slice cer = new Slice(first, stop - 1, stride);
            slices.add(cer);
        }
        return slices;
    }

    public static boolean isWhole(List<Range> rangelist, List<DapDimension> dimset, int start, int stop) throws DapException {
        int rsize;
        int n = rsize = rangelist == null ? 0 : rangelist.size();
        if (rsize != dimset.size()) {
            throw new DapException("range/dimset rank mismatch");
        }
        if (rsize == 0) {
            return true;
        }
        if (start < 0 || stop < start || stop > rsize) {
            throw new DapException("Invalid start/stop indices");
        }
        for (int i = start; i < stop; ++i) {
            Range r = rangelist.get(i);
            DapDimension d = dimset.get(i);
            if (r.stride() == 1 && r.first() == 0 && (long)r.length() == d.getSize()) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhole(List<Range> rangelist, List<Slice> slices) throws DapException {
        if (rangelist.size() != slices.size()) {
            return false;
        }
        for (int i = 0; i < rangelist.size(); ++i) {
            Range r = rangelist.get(i);
            Slice slice = slices.get(i);
            if (r.stride() == 1 && r.first() == 0 && r.length() == slice.getCount()) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhole(List<Range> rangelist, Variable var) throws DapException {
        ImmutableList dimset = var.getDimensions();
        if (rangelist.size() != dimset.size()) {
            return false;
        }
        for (int i = 0; i < rangelist.size(); ++i) {
            Range r = rangelist.get(i);
            Dimension dim = (Dimension)dimset.get(i);
            if (r.stride() == 1 && r.first() == 0 && r.length() == dim.getLength()) continue;
            return false;
        }
        return true;
    }

    public static List<Range> createCDMRanges(List<Slice> slices) throws DapException {
        ArrayList<Range> cdmranges = new ArrayList<Range>();
        for (int i = 0; i < slices.size(); ++i) {
            Slice r = slices.get(i);
            try {
                Range cmdr = new Range(r.getFirst(), r.getLast(), r.getStride());
                cdmranges.add(cmdr);
                continue;
            }
            catch (InvalidRangeException ire) {
                throw new DapException(ire);
            }
        }
        return cdmranges;
    }

    public static Variable unwrap(Variable var) {
        return (Variable)CDMNode.unwrap((CDMNode)var);
    }

    public static NetcdfFile unwrapfile(NetcdfFile file) {
        NetcdfDataset ds;
        while (file instanceof NetcdfDataset && (file = (ds = (NetcdfDataset)file).getReferencedFile()) != null) {
        }
        return file;
    }

    public static boolean hasVLEN(List<Range> ranges) {
        if (ranges == null || ranges.isEmpty()) {
            return false;
        }
        return ranges.get(ranges.size() - 1) == Range.VLEN;
    }

    public static boolean hasVLEN(Variable v) {
        return CDMUtil.containsVLEN((List<Dimension>)v.getDimensions());
    }

    public static boolean containsVLEN(List<Dimension> dimset) {
        if (dimset == null) {
            return false;
        }
        for (Dimension dim : dimset) {
            if (!dim.isVariableLength()) continue;
            return true;
        }
        return false;
    }

    public static int[] computeEffectiveShape(List<DapDimension> dimset) {
        if (dimset == null || dimset.isEmpty()) {
            return new int[0];
        }
        int effectiverank = dimset.size();
        int[] shape = new int[effectiverank];
        for (int i = 0; i < effectiverank; ++i) {
            shape[i] = (int)dimset.get(i).getSize();
        }
        return shape;
    }

    public static Object convertVector(DapType dsttype, DapType srctype, Object src) {
        TypeSort dstatomtype;
        TypeSort srcatomtype = srctype.getAtomicType();
        if (srcatomtype == (dstatomtype = dsttype.getAtomicType())) {
            return src;
        }
        if (srcatomtype.isIntegerType() && TypeSort.getSignedVersion(srcatomtype) == TypeSort.getSignedVersion(dstatomtype)) {
            return src;
        }
        Object result = CDMTypeFcns.convert(dstatomtype, srcatomtype, src);
        if (result == null) {
            throw new ForbiddenConversionException();
        }
        return result;
    }

    public static String getChecksumString(byte[] checksum) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < checksum.length; ++i) {
            byte b = checksum[i];
            buf.append(hexchars.charAt(b >> 4));
            buf.append(hexchars.charAt(b & 0xF));
        }
        return buf.toString();
    }

    public static List<Range> dimsetToRanges(List<DapDimension> dimset) throws DapException {
        if (dimset == null) {
            return null;
        }
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (int i = 0; i < dimset.size(); ++i) {
            DapDimension dim = dimset.get(i);
            try {
                Range r = new Range(dim.getShortName(), 0, (int)dim.getSize() - 1, 1);
                ranges.add(r);
                continue;
            }
            catch (InvalidRangeException ire) {
                throw new DapException(ire);
            }
        }
        return ranges;
    }

    public static List<Slice> shapeToSlices(int[] shape) throws DapException {
        if (shape == null) {
            return null;
        }
        ArrayList<Slice> slices = new ArrayList<Slice>(shape.length);
        for (int i = 0; i < shape.length; ++i) {
            Slice sl = new Slice(0, shape[i] - 1, 1);
            slices.add(sl);
        }
        return slices;
    }

    public static Index cdmIndexToIndex(Index cdmidx) {
        Index dapidx = new Index(cdmidx.getCurrentCounter(), cdmidx.getShape());
        return dapidx;
    }

    public static Index indexToCcMIndex(Index d4) {
        return d4;
    }

    public static List<Slice> indexToSlices(Index indices) throws DapException {
        int rank = indices.getRank();
        if (rank == 0) {
            return Slice.SCALARSLICES;
        }
        ArrayList<Slice> slices = new ArrayList<Slice>(rank);
        for (int i = 0; i < rank; ++i) {
            int isize = indices.getCurrentCounter()[i];
            slices.add(new Slice(isize, isize + 1, 1, indices.getShape(i)));
        }
        return slices;
    }

    public static Index slicesToIndex(List<Slice> slices) throws DapException {
        int[] positions = new int[slices.size()];
        int[] dimsizes = new int[slices.size()];
        for (int i = 0; i < positions.length; ++i) {
            Slice s = slices.get(i);
            if (s.getCount() != 1) {
                throw new DapException("Attempt to convert non-singleton sliceset to index");
            }
            positions[i] = s.getFirst();
            dimsizes[i] = s.getMax();
        }
        return new Index(positions, dimsizes);
    }
}

