/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib;

import dap4.core.util.DapException;
import dap4.core.util.Slice;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.Index;

public class D4Index
extends Index {
    public static final D4Index SCALAR = new D4Index(0);

    public static Index offsetToIndex(int offset, int[] shape) {
        int[] indices = new int[shape.length];
        for (int i = shape.length - 1; i >= 0; --i) {
            indices[i] = offset % shape[i];
            offset = (offset - indices[i]) / shape[i];
        }
        return new Index(indices, shape);
    }

    public static List<Slice> indexToSlices(Index indices) throws DapException {
        int rank = indices.getRank();
        if (rank == 0) {
            return Slice.SCALARSLICES;
        }
        ArrayList<Slice> slices = new ArrayList<Slice>(rank);
        int[] counter = indices.getCurrentCounter();
        for (int i = 0; i < rank; ++i) {
            int isize = counter[i];
            slices.add(new Slice(isize, isize + 1, 1, indices.getShape(i)));
        }
        return slices;
    }

    public static D4Index slicesToIndex(List<Slice> slices) throws DapException {
        int[] positions = new int[slices.size()];
        int[] dimsizes = new int[slices.size()];
        for (int i = 0; i < positions.length; ++i) {
            Slice s = slices.get(i);
            if (s.getCount() != 1) {
                throw new DapException("Attempt to convert non-singleton sliceset to index");
            }
            positions[i] = s.getFirst();
            dimsizes[i] = s.getMax();
        }
        D4Index result = new D4Index(dimsizes);
        result.set(positions);
        return result;
    }

    public D4Index(int rank) {
        super(rank);
    }

    public D4Index(int[] _shape) {
        super(_shape);
    }

    public D4Index(D4Index index) {
        this(index.getRank());
        if (this.rank > 0) {
            System.arraycopy(index.getCurrentCounter(), 0, this.current, 0, this.rank);
            System.arraycopy(index.getShape(), 0, this.getShape(), 0, this.rank);
        }
    }

    public D4Index(int[] indices, int[] dimsizes) {
        super(dimsizes);
        if (this.rank > 0) {
            System.arraycopy(indices, 0, this.current, 0, this.rank);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        for (int i = 0; i < this.rank; ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(this.current[i]);
            buf.append('/');
            buf.append(this.shape[i]);
        }
        buf.append("](");
        buf.append(this.index());
        buf.append(")");
        return buf.toString();
    }

    public int index() {
        int offset = this.offset;
        int[] cur = this.getCurrentCounter();
        int[] sh = this.getShape();
        for (int i = 0; i < cur.length; ++i) {
            offset *= sh[i];
            offset += cur[i];
        }
        return offset;
    }

    public int getCurrentCounter(int i) {
        if (i < 0 || i >= this.rank) {
            throw new IllegalArgumentException();
        }
        return this.getCurrentCounter()[i];
    }

    public boolean isScalar() {
        return this.rank == 0 && this.getCurrentCounter().length == 1 && this.index() == 1;
    }
}

