/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import dap4.core.util.DapException;
import dap4.core.util.Slice;
import java.util.ArrayList;
import java.util.List;

public class MultiSlice
extends Slice {
    protected List<Slice> subslices;
    protected int count = -1;

    public MultiSlice(List<Slice> subslices) throws DapException {
        this.sort = Slice.Sort.Multi;
        this.subslices = subslices;
        this.finish();
        this.first = -1;
        this.stop = -1;
        this.stride = -1;
        this.maxsize = -1;
        for (int i = 0; i < this.subslices.size(); ++i) {
            Slice s = this.subslices.get(i);
            this.first = this.first < 0 ? s.getFirst() : Math.min(this.first, s.getFirst());
            this.stop = Math.max(this.stop, s.getStop());
            this.stride = Math.max(this.stride, s.getStride());
            this.maxsize = Math.max(this.maxsize, s.getMax());
        }
        this.whole = false;
        this.constrained = true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof Slice) {
            try {
                ArrayList<Slice> tmp = new ArrayList<Slice>();
                tmp.add((Slice)o);
                o = new MultiSlice(tmp);
            }
            catch (DapException de) {
                throw new IllegalArgumentException();
            }
        }
        if (!(o instanceof MultiSlice)) {
            return false;
        }
        Slice other = (Slice)o;
        return other.getFirst() == this.getFirst() && other.getLast() == this.getLast() && other.getStride() == this.getStride();
    }

    @Override
    public int hashCode() {
        int accum = 0;
        for (int i = 0; i < this.subslices.size(); ++i) {
            Slice s = this.subslices.get(i);
            accum += s.hashCode() * i;
        }
        return accum;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (int i = 0; i < this.subslices.size(); ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(this.subslices.get(i).toString(false));
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public String toConstraintString() throws DapException {
        assert (this.first != -1 && this.stride != -1 && this.stop != -1);
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        boolean first = true;
        for (Slice sub : this.subslices) {
            if (!first) {
                buf.append(",");
            }
            first = false;
            if (sub.stop - sub.first == 0) {
                buf.append("0");
                continue;
            }
            if (sub.stride == 1) {
                if (sub.stop - sub.first == 1) {
                    buf.append(sub.first);
                    continue;
                }
                buf.append(String.format("%d:%d", sub.first, sub.stop - 1));
                continue;
            }
            buf.append(String.format("%d:%d:%d", sub.first, sub.stride, sub.stop - 1));
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public Slice finish() throws DapException {
        int i;
        this.maxsize = -1;
        for (i = 0; i < this.subslices.size(); ++i) {
            Slice sl = this.subslices.get(i);
            assert (sl.getSort() == Slice.Sort.Single);
            sl.finish();
            if (this.maxsize >= sl.getMax()) continue;
            this.maxsize = sl.getMax();
        }
        if (this.maxsize < 0) {
            throw new DapException("Cannot compute multislice size");
        }
        for (i = 0; i < this.subslices.size(); ++i) {
            this.subslices.get(i).setMaxSize(this.maxsize);
        }
        this.count = 0;
        for (i = 0; i < this.subslices.size(); ++i) {
            this.count += this.subslices.get(i).getCount();
        }
        return this;
    }

    @Override
    public List<Slice> getSubSlices() {
        return this.subslices;
    }

    @Override
    public Slice getSubSlice(int i) {
        return this.subslices.get(i);
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public Slice setMaxSize(int size) throws DapException {
        for (int i = 0; i < this.subslices.size(); ++i) {
            this.subslices.get(i).setMaxSize(size);
        }
        return this;
    }
}

