/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr;

import dap4.core.dmr.DapDecl;
import dap4.core.dmr.DapNode;

public class DapDimension
extends DapNode
implements DapDecl,
Cloneable {
    public static final long UNDEFINED = -2L;
    protected long size = -2L;
    protected boolean isshared = false;
    protected boolean isunlimited = false;

    public DapDimension() {
    }

    public DapDimension(String name) {
        this();
        this.setShortName(name);
        this.isshared = name != null;
    }

    public DapDimension(String name, long size) {
        this(name);
        this.setSize(size);
    }

    public DapDimension(long size) {
        this.setSize(size);
        this.isshared = false;
    }

    public long getSize() {
        if (this.size == -2L) {
            throw new IllegalStateException("Undefined dimension size");
        }
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public boolean isShared() {
        return this.isshared;
    }

    public void setShared(boolean tf) {
        this.isshared = tf;
    }

    public boolean isUnlimited() {
        return this.isunlimited;
    }

    public void setUnlimited(boolean tf) {
        this.isunlimited = tf;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public String toString() {
        String sortname = this.sort == null ? "" : this.sort.name();
        String name = null;
        if (name == null) {
            name = this.getShortName();
        }
        if (name == null) {
            name = "";
        }
        return sortname + "::" + name + "[" + this.getSize() + "]";
    }
}

