/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib.serial;

import dap4.core.data.DataCursor;
import dap4.core.dmr.DapEnumeration;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.dmr.TypeSort;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.Index;
import dap4.core.util.Odometer;
import dap4.core.util.Slice;
import dap4.dap4lib.AbstractCursor;
import dap4.dap4lib.LibTypeFcns;
import dap4.dap4lib.serial.D4DSP;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class D4Cursor
extends AbstractCursor {
    static final long NULLOFFSET = -1L;
    static final int D4LENSIZE = 8;
    protected long offset = -1L;
    protected long[] bytestrings = null;
    protected D4Cursor[] elements = null;
    protected D4Cursor[] fieldcursors = null;
    protected List<D4Cursor> records = null;

    public D4Cursor(DataCursor.Scheme scheme, D4DSP dsp, DapNode template, D4Cursor container) {
        super(scheme, dsp, template, container);
    }

    public D4Cursor(D4Cursor c) {
        super(c);
        D4Cursor dc;
        int i;
        assert (false);
        this.offset = c.offset;
        this.bytestrings = c.bytestrings;
        this.fieldcursors = new D4Cursor[c.fieldcursors.length];
        for (i = 0; i < c.fieldcursors.length; ++i) {
            dc = c.fieldcursors[i];
            this.fieldcursors[i] = new D4Cursor(dc);
            this.fieldcursors[i].setContainer(this);
        }
        this.elements = new D4Cursor[c.elements.length];
        for (i = 0; i < c.elements.length; ++i) {
            dc = c.elements[i];
            this.elements[i] = new D4Cursor(dc);
            this.elements[i].setContainer(this);
        }
        this.records = new ArrayList<D4Cursor>();
        for (i = 0; i < c.records.size(); ++i) {
            dc = c.records.get(i);
            this.records.add(new D4Cursor(dc));
            this.records.get(i).setContainer(this);
        }
    }

    @Override
    public Object read(Index index) throws DapException {
        return this.read(DapUtil.indexToSlices(index));
    }

    @Override
    public Object read(List<Slice> slices) throws DapException {
        switch (this.scheme) {
            case ATOMIC: {
                return this.readAtomic(slices);
            }
            case STRUCTURE: 
            case SEQUENCE: {
                if (((DapVariable)this.getTemplate()).getRank() == 0 || DapUtil.isScalarSlices(slices)) {
                    throw new DapException("Cannot slice a scalar variable");
                }
                return new D4Cursor(this);
            }
            case STRUCTARRAY: {
                Odometer odom = Odometer.factory(slices);
                D4Cursor[] instances = new D4Cursor[(int)odom.totalSize()];
                int i = 0;
                while (odom.hasNext()) {
                    instances[i] = this.readStructure(odom.next());
                    ++i;
                }
                return instances;
            }
            case SEQARRAY: {
                Odometer odom = Odometer.factory(slices);
                D4Cursor[] instances = new D4Cursor[(int)odom.totalSize()];
                int i = 0;
                while (odom.hasNext()) {
                    instances[i] = this.readSequence(odom.next());
                    ++i;
                }
                return instances;
            }
        }
        throw new DapException("Attempt to slice a scalar object");
    }

    @Override
    public D4Cursor readField(int findex) throws DapException {
        if (!$assertionsDisabled) {
            if (this.scheme != DataCursor.Scheme.RECORD) {
                if (this.scheme != DataCursor.Scheme.STRUCTURE) {
                    throw new AssertionError();
                }
            }
        }
        DapStructure basetype = (DapStructure)((DapVariable)this.getTemplate()).getBaseType();
        if (findex < 0 || findex >= basetype.getFields().size()) {
            throw new DapException("Field index out of range: " + findex);
        }
        D4Cursor field = this.fieldcursors[findex];
        return field;
    }

    @Override
    public D4Cursor readRecord(long i) {
        assert (this.scheme == DataCursor.Scheme.SEQUENCE);
        if (this.records == null || i < 0L || i > (long)this.records.size()) {
            throw new IndexOutOfBoundsException("No such record: " + i);
        }
        return this.records.get((int)i);
    }

    @Override
    public long getRecordCount() {
        assert (this.scheme == DataCursor.Scheme.SEQUENCE);
        return this.records == null ? 0L : (long)this.records.size();
    }

    protected Object readAtomic(List<Slice> slices) throws DapException {
        if (slices == null) {
            throw new DapException("DataCursor.read: null set of slices");
        }
        assert (this.scheme == DataCursor.Scheme.ATOMIC);
        DapVariable atomvar = (DapVariable)this.getTemplate();
        int rank = atomvar.getRank();
        assert (slices != null && (rank == 0 && slices.size() == 1 || slices.size() == rank));
        DapType basetype = atomvar.getBaseType();
        return this.readAs(atomvar, basetype, slices);
    }

    protected Object readAs(DapVariable atomvar, DapType basetype, List<Slice> slices) throws DapException {
        if (basetype.getTypeSort() == TypeSort.Enum) {
            basetype = ((DapEnumeration)basetype).getBaseType();
            return this.readAs(atomvar, basetype, slices);
        }
        long count = DapUtil.sliceProduct(slices);
        Object result = LibTypeFcns.newVector(basetype, count);
        Odometer odom = Odometer.factory(slices);
        if (DapUtil.isContiguous(slices) && basetype.isFixedSize()) {
            this.readContig(slices, basetype, count, odom, result);
        } else {
            this.readOdom(slices, basetype, odom, result);
        }
        return result;
    }

    protected void readContig(List<Slice> slices, DapType basetype, long count, Odometer odom, Object result) throws DapException {
        ByteBuffer alldata = ((D4DSP)this.dsp).getBuffer();
        long off = this.offset;
        long ix = odom.indices().index();
        int elemsize = basetype.getSize();
        alldata.position((int)(off + ix * (long)elemsize));
        int icount = (int)count;
        long totalsize = count * (long)basetype.getSize();
        switch (basetype.getTypeSort()) {
            case Int8: 
            case UInt8: {
                alldata.get((byte[])result);
                break;
            }
            case Char: {
                byte[] ascii = new byte[icount];
                alldata.get(ascii);
                for (int i = 0; i < icount; ++i) {
                    ((char[])result)[i] = (char)(ascii[i] & 0x7F);
                }
                break;
            }
            case Int16: 
            case UInt16: {
                alldata.asShortBuffer().get((short[])result);
                D4Cursor.skip(totalsize, alldata);
                break;
            }
            case Int32: 
            case UInt32: {
                alldata.asIntBuffer().get((int[])result);
                D4Cursor.skip(totalsize, alldata);
                break;
            }
            case Int64: 
            case UInt64: {
                alldata.asLongBuffer().get((long[])result);
                D4Cursor.skip(totalsize, alldata);
                break;
            }
            case Float32: {
                alldata.asFloatBuffer().get((float[])result);
                D4Cursor.skip(totalsize, alldata);
                break;
            }
            case Float64: {
                alldata.asDoubleBuffer().get((double[])result);
                D4Cursor.skip(totalsize, alldata);
                break;
            }
            default: {
                throw new DapException("Contiguous read not supported for type: " + (Object)((Object)basetype.getTypeSort()));
            }
        }
    }

    protected Object readOdom(List<Slice> slices, DapType basetype, Odometer odom, Object result) throws DapException {
        ByteBuffer alldata = ((D4DSP)this.dsp).getBuffer();
        alldata.position((int)this.offset);
        ByteBuffer slice = alldata.slice();
        slice.order(alldata.order());
        int i = 0;
        while (odom.hasNext()) {
            Index index = odom.next();
            int ipos = (int)index.index();
            switch (basetype.getTypeSort()) {
                case Int8: 
                case UInt8: {
                    ((byte[])result)[i] = slice.get(ipos);
                    break;
                }
                case Char: {
                    byte ascii = slice.get(ipos);
                    ((char[])result)[i] = (char)ascii;
                    break;
                }
                case Int16: 
                case UInt16: {
                    ((short[])result)[i] = slice.getShort(ipos);
                    break;
                }
                case Int32: 
                case UInt32: {
                    ((int[])result)[i] = slice.getInt(ipos);
                    break;
                }
                case Int64: 
                case UInt64: {
                    ((long[])result)[i] = slice.getLong(ipos);
                    break;
                }
                case Float32: {
                    ((float[])result)[i] = slice.getFloat(ipos);
                    break;
                }
                case Float64: {
                    ((double[])result)[i] = slice.getDouble(ipos);
                    break;
                }
                case String: 
                case URL: {
                    int savepos = alldata.position();
                    long pos = this.bytestrings[i];
                    alldata.position((int)pos);
                    long n = D4Cursor.getLength(alldata);
                    byte[] data = new byte[(int)n];
                    alldata.get(data);
                    ((String[])result)[i] = new String(data, DapUtil.UTF8);
                    alldata.position(savepos);
                    break;
                }
                case Opaque: {
                    ByteBuffer buf;
                    int savepos = alldata.position();
                    long pos = this.bytestrings[i];
                    alldata.position((int)pos);
                    long n = D4Cursor.getLength(alldata);
                    byte[] data = new byte[(int)n];
                    alldata.get(data);
                    ((ByteBuffer[])result)[i] = buf = ByteBuffer.wrap(data);
                    alldata.position(savepos);
                    break;
                }
                default: {
                    throw new DapException("Attempt to read non-atomic value of type: " + (Object)((Object)basetype.getTypeSort()));
                }
            }
            ++i;
        }
        return result;
    }

    protected D4Cursor readStructure(Index index) throws DapException {
        assert (this.scheme == DataCursor.Scheme.STRUCTARRAY);
        long pos = index.index();
        long avail = this.elements == null ? 0 : this.elements.length;
        if (pos < 0L || pos > avail) {
            throw new IndexOutOfBoundsException("read: " + index);
        }
        return this.elements[(int)pos];
    }

    public D4Cursor readSequence(Index index) throws DapException {
        assert (this.scheme == DataCursor.Scheme.SEQARRAY);
        long pos = index.index();
        long avail = this.elements == null ? 0 : this.elements.length;
        if (pos < 0L || pos > avail) {
            throw new IndexOutOfBoundsException("read: " + index);
        }
        return this.elements[(int)pos];
    }

    public D4Cursor setElements(D4Cursor[] instances) {
        if (this.getScheme() != DataCursor.Scheme.SEQARRAY && this.getScheme() != DataCursor.Scheme.STRUCTARRAY) {
            throw new IllegalStateException("Adding element to !(structure|sequence array) object");
        }
        DapVariable var = (DapVariable)this.getTemplate();
        this.elements = instances;
        return this;
    }

    public D4Cursor setOffset(long pos) {
        this.offset = pos;
        return this;
    }

    public D4Cursor setByteStringOffsets(long total, long[] positions) {
        this.bytestrings = positions;
        return this;
    }

    public D4Cursor addField(int m3, D4Cursor field) {
        if (this.getScheme() != DataCursor.Scheme.RECORD && this.getScheme() != DataCursor.Scheme.STRUCTURE) {
            throw new IllegalStateException("Adding field to non-(structure|record) object");
        }
        if (this.fieldcursors == null) {
            DapStructure ds = (DapStructure)((DapVariable)this.getTemplate()).getBaseType();
            List<DapVariable> fields = ds.getFields();
            this.fieldcursors = new D4Cursor[fields.size()];
        }
        if (this.fieldcursors[m3] != null) {
            throw new IndexOutOfBoundsException("Adding duplicate fields at position:" + m3);
        }
        this.fieldcursors[m3] = field;
        return this;
    }

    public D4Cursor addRecord(D4Cursor rec) {
        if (this.getScheme() != DataCursor.Scheme.SEQUENCE) {
            throw new IllegalStateException("Adding record to non-sequence object");
        }
        if (this.records == null) {
            this.records = new ArrayList<D4Cursor>();
        }
        this.records.add(rec);
        return this;
    }

    public long getElementSize(DapVariable v) {
        return v.getBaseType().isFixedSize() ? (long)v.getBaseType().getSize() : 0L;
    }

    static ByteBuffer skip(long n, ByteBuffer b) {
        if (b.position() + (int)n > b.limit()) {
            throw new IllegalArgumentException();
        }
        b.position(b.position() + (int)n);
        return b;
    }

    public static long getLength(ByteBuffer b) {
        if (b.position() + 8 > b.limit()) {
            throw new IllegalArgumentException();
        }
        long n = b.getLong();
        return n;
    }
}

