/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.CancelTaskImpl;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.write.Nc4Chunking;

public class FileWriter2 {
    private static final Logger log = LoggerFactory.getLogger(FileWriter2.class);
    private static final long maxSize = 50000000L;
    private static boolean debug = false;
    private static boolean debugWrite = false;
    private static boolean debugChunk = false;
    private final NetcdfFile fileIn;
    private final NetcdfFileWriter writer;
    private final NetcdfFileWriter.Version version;
    private final Map<Variable, Variable> varMap = new HashMap<Variable, Variable>(100);
    private final List<Variable> varList = new ArrayList<Variable>(100);
    private final Map<String, Dimension> gdimHash = new HashMap<String, Dimension>(33);
    private N3StructureStrategy n3StructureStrategy;

    public static void setDebugFlags(DebugFlags debugFlags) {
        debug = debugFlags.isSet("ncfileWriter2/debug");
        debugWrite = debugFlags.isSet("ncfileWriter2/debugWrite");
        debugChunk = debugFlags.isSet("ncfileWriter2/debugChunk");
    }

    public FileWriter2(NetcdfFile fileIn, String fileOutName, NetcdfFileWriter.Version version, Nc4Chunking chunker) throws IOException {
        this.fileIn = fileIn;
        this.writer = NetcdfFileWriter.createNew(version, fileOutName, chunker);
        this.version = version;
    }

    public void setN3StructureStrategy(N3StructureStrategy n3StructureStrategy) {
        this.n3StructureStrategy = n3StructureStrategy;
    }

    public NetcdfFileWriter getNetcdfFileWriter() {
        return this.writer;
    }

    public FileWriter2(NetcdfFileWriter fileWriter) throws IOException {
        this.fileIn = null;
        this.writer = fileWriter;
        this.version = fileWriter.getVersion();
    }

    public Variable addVariable(Variable oldVar) {
        List<Dimension> newDims = this.getNewDimensions(oldVar);
        Variable newVar = oldVar.getDataType().equals((Object)DataType.STRING) && !this.version.isExtendedModel() ? this.writer.addStringVariable(null, oldVar, newDims) : this.writer.addVariable(null, oldVar.getShortName(), oldVar.getDataType(), newDims);
        this.varMap.put(oldVar, newVar);
        this.varList.add(oldVar);
        for (Attribute orgAtt : oldVar.getAttributes()) {
            this.writer.addVariableAttribute(newVar, this.convertAttribute(orgAtt));
        }
        return newVar;
    }

    private List<Dimension> getNewDimensions(Variable oldVar) {
        ArrayList<Dimension> result = new ArrayList<Dimension>(oldVar.getRank());
        for (Dimension oldD : oldVar.getDimensions()) {
            Dimension newD = this.gdimHash.get(oldD.getShortName());
            if (newD == null) {
                newD = this.writer.addDimension(null, oldD.getShortName(), oldD.isUnlimited() ? 0 : oldD.getLength(), oldD.isUnlimited(), oldD.isVariableLength());
                this.gdimHash.put(oldD.getShortName(), newD);
                if (debug) {
                    System.out.println("add dim= " + newD);
                }
            }
            result.add(newD);
        }
        return result;
    }

    public NetcdfFile write() throws IOException {
        return this.write(null);
    }

    public NetcdfFile write(CancelTask cancel) throws IOException {
        try {
            if (this.version.isExtendedModel()) {
                this.addGroupExtended(null, this.fileIn.getRootGroup());
            } else {
                this.addGroupClassic();
            }
            if (cancel != null && cancel.isCancel()) {
                return null;
            }
            this.writer.create();
            if (cancel != null && cancel.isCancel()) {
                return null;
            }
            double total = this.copyVarData(this.varList, null, cancel);
            if (cancel != null && cancel.isCancel()) {
                return null;
            }
            this.writer.flush();
            if (debug) {
                System.out.println("FileWriter done total bytes = " + total);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            this.writer.abort();
            throw ioe;
        }
        return this.writer.getNetcdfFile();
    }

    /*
     * WARNING - void declaration
     */
    private void addGroupClassic() throws IOException {
        if (this.fileIn.getRootGroup().getGroups().size() != 0) {
            throw new IllegalStateException("Input file has nested groups: cannot write to netcdf-3 format");
        }
        for (Attribute attribute : this.fileIn.getGlobalAttributes()) {
            this.writer.addGroupAttribute(null, this.convertAttribute(attribute));
        }
        HashMap<String, Dimension> dimHash = new HashMap<String, Dimension>();
        for (Dimension oldD : this.fileIn.getDimensions()) {
            Dimension newD = this.writer.addDimension(null, oldD.getShortName(), oldD.isUnlimited() ? 0 : oldD.getLength(), oldD.isUnlimited(), oldD.isVariableLength());
            dimHash.put(oldD.getShortName(), newD);
            if (!debug) continue;
            System.out.println("add dim= " + newD);
        }
        boolean bl = false;
        for (Variable oldVar : this.fileIn.getVariables()) {
            if (oldVar instanceof Structure) continue;
            ArrayList<Dimension> dims = new ArrayList<Dimension>();
            for (Dimension oldD : oldVar.getDimensions()) {
                if (!oldD.isShared()) {
                    void var2_5;
                    String anonName = "anon" + (int)var2_5;
                    ++var2_5;
                    Dimension newD = this.writer.addDimension(null, anonName, oldD.getLength());
                    dims.add(newD);
                    continue;
                }
                Dimension dim = (Dimension)dimHash.get(oldD.getShortName());
                if (dim != null) {
                    dims.add(dim);
                    continue;
                }
                throw new IllegalStateException("Unknown dimension= " + oldD.getShortName());
            }
            DataType newType = oldVar.getDataType();
            if (oldVar.getDataType() == DataType.STRING) {
                Array data = oldVar.read();
                IndexIterator ii = data.getIndexIterator();
                int max_len = 0;
                while (ii.hasNext()) {
                    String s2 = (String)ii.getObjectNext();
                    max_len = Math.max(max_len, s2.length());
                }
                String useName = oldVar.getShortName() + "_strlen";
                Dimension newD = this.writer.addDimension(null, useName, max_len);
                dims.add(newD);
                newType = DataType.CHAR;
            }
            Variable v = this.writer.addVariable(null, oldVar.getShortName(), newType, dims);
            if (debug) {
                System.out.println("add var= " + v.getNameAndDimensions());
            }
            this.varMap.put(oldVar, v);
            this.varList.add(oldVar);
            for (Attribute orgAtt : oldVar.getAttributes()) {
                this.writer.addVariableAttribute(v, this.convertAttribute(orgAtt));
            }
        }
    }

    private void addGroupExtended(Group newParent, Group oldGroup) throws IOException {
        Group newGroup = this.writer.addGroup(newParent, oldGroup.getShortName());
        for (Attribute att : oldGroup.getAttributes()) {
            this.writer.addGroupAttribute(newGroup, att);
            if (!debug) continue;
            System.out.println("add gatt= " + att);
        }
        for (EnumTypedef td : oldGroup.getEnumTypedefs()) {
            this.writer.addTypedef(newGroup, td);
            if (!debug) continue;
            System.out.println("add td= " + td);
        }
        HashMap<String, Dimension> dimHash = new HashMap<String, Dimension>();
        for (Dimension oldD : oldGroup.getDimensions()) {
            Dimension newD = this.writer.addDimension(newGroup, oldD.getShortName(), oldD.isUnlimited() ? 0 : oldD.getLength(), oldD.isUnlimited(), oldD.isVariableLength());
            dimHash.put(oldD.getShortName(), newD);
            if (!debug) continue;
            System.out.println("add dim= " + newD);
        }
        for (Variable oldVar : oldGroup.getVariables()) {
            Variable v;
            ArrayList<Dimension> dims = new ArrayList<Dimension>();
            for (Dimension oldD : oldVar.getDimensions()) {
                Dimension newD;
                Dimension dimension = newD = oldD.isShared() ? (Dimension)dimHash.get(oldD.getShortName()) : oldD;
                if (newD == null) {
                    newD = newParent.findDimension(oldD.getShortName());
                }
                if (newD == null) {
                    throw new IllegalStateException("Cant find dimension " + oldD.getShortName());
                }
                dims.add(newD);
            }
            DataType newType = oldVar.getDataType();
            if (newType == DataType.STRUCTURE) {
                v = this.writer.addCopyOfStructure(newGroup, (Structure)oldVar, oldVar.getShortName(), dims);
            } else if (newType.isEnum()) {
                EnumTypedef en = oldVar.getEnumTypedef();
                v = this.writer.addVariable(newGroup, oldVar.getShortName(), newType, dims);
                v.setEnumTypedef(en);
            } else {
                v = this.writer.addVariable(newGroup, oldVar.getShortName(), newType, dims);
            }
            this.varMap.put(oldVar, v);
            this.varList.add(oldVar);
            if (debug) {
                System.out.println("add var= " + v);
            }
            for (Attribute att : oldVar.getAttributes()) {
                this.writer.addVariableAttribute(v, att);
            }
        }
        for (Group nested : oldGroup.getGroups()) {
            this.addGroupExtended(newGroup, nested);
        }
    }

    private Attribute convertAttribute(Attribute org) {
        if (this.version.isExtendedModel()) {
            return org;
        }
        if (!org.getDataType().isUnsigned()) {
            return org;
        }
        Array orgValues = org.getValues();
        Array nc3Values = Array.makeFromJavaArray(orgValues.getStorage(), false);
        return new Attribute(org.getShortName(), nc3Values);
    }

    public double copyVarData(List<Variable> oldVars, Structure recordVar, CancelTask cancel) throws IOException {
        boolean useRecordDimension = recordVar != null;
        double total = 0.0;
        int countVars = 0;
        for (Variable oldVar : oldVars) {
            if (useRecordDimension && oldVar.isUnlimited() || oldVar == recordVar) continue;
            if (debug) {
                System.out.println("write var= " + oldVar.getShortName() + " size = " + oldVar.getSize() + " type=" + (Object)((Object)oldVar.getDataType()));
            }
            if (cancel != null) {
                cancel.setProgress("writing " + oldVar.getShortName(), countVars++);
            }
            long size = oldVar.getSize() * (long)oldVar.getElementSize();
            total += (double)size;
            if (size <= 50000000L) {
                this.copyAll(oldVar, this.varMap.get(oldVar));
            } else {
                this.copySome(oldVar, this.varMap.get(oldVar), 50000000L, cancel);
            }
            if (cancel == null || !cancel.isCancel()) continue;
            return total;
        }
        if (useRecordDimension) {
            int[] origin = new int[]{0};
            int[] size = new int[]{1};
            int nrecs = (int)recordVar.getSize();
            int sdataSize = recordVar.getElementSize();
            Variable recordVarNew = this.varMap.get(recordVar);
            double totalRecordBytes = 0.0;
            for (int count = 0; count < nrecs; ++count) {
                block10: {
                    origin[0] = count;
                    try {
                        Array recordData = recordVar.read(origin, size);
                        this.writer.write(recordVarNew, origin, recordData);
                        if (!debug || count != 0) break block10;
                        System.out.println("write record size = " + sdataSize);
                    }
                    catch (InvalidRangeException e) {
                        e.printStackTrace();
                        break;
                    }
                }
                totalRecordBytes += (double)sdataSize;
                if (cancel == null || !cancel.isCancel()) continue;
                return total;
            }
            total += totalRecordBytes;
            totalRecordBytes /= 1000000.0;
            if (debug) {
                System.out.println("write record var; total = " + totalRecordBytes + " Mbytes # recs=" + nrecs);
            }
        }
        return total;
    }

    void copyAll(Variable oldVar, Variable newVar) throws IOException {
        Array data = oldVar.read();
        try {
            if (!this.version.isNetdf4format() && oldVar.getDataType() == DataType.STRING) {
                data = this.convertToChar(newVar, data);
            }
            if (data.getSize() > 0L) {
                this.writer.write(newVar, data);
            }
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage() + " for Variable " + oldVar.getFullName());
        }
    }

    private void copySome(Variable oldVar, Variable newVar, long maxChunkSize, CancelTask cancel) throws IOException {
        long maxChunkElems = maxChunkSize / (long)oldVar.getElementSize();
        long byteWriteTotal = 0L;
        ChunkingIndex index = new ChunkingIndex(oldVar.getShape());
        while ((long)index.currentElement() < index.getSize()) {
            try {
                int[] chunkOrigin = index.getCurrentCounter();
                int[] chunkShape = index.computeChunkShape(maxChunkElems);
                if (cancel != null) {
                    cancel.setProgress("Reading chunk " + new Section(chunkOrigin, chunkShape) + " from variable: " + oldVar.getShortName(), -1);
                }
                Array data = oldVar.read(chunkOrigin, chunkShape);
                if (!this.version.isNetdf4format() && oldVar.getDataType() == DataType.STRING) {
                    data = this.convertToChar(newVar, data);
                }
                if (data.getSize() > 0L) {
                    if (cancel != null) {
                        cancel.setProgress("Writing chunk " + new Section(chunkOrigin, chunkShape) + " from variable: " + oldVar.getShortName(), -1);
                    }
                    this.writer.write(newVar, chunkOrigin, data);
                    if (debugWrite) {
                        System.out.println(" write " + data.getSize() + " bytes at " + new Section(chunkOrigin, chunkShape));
                    }
                    byteWriteTotal += data.getSize();
                }
                index.setCurrentCounter(index.currentElement() + (int)Index.computeSize(chunkShape));
                if (cancel == null || !cancel.isCancel()) continue;
                return;
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }
    }

    private Array convertToChar(Variable newVar, Array oldData) {
        ArrayChar newData = (ArrayChar)Array.factory(DataType.CHAR, newVar.getShape());
        Index ima = newData.getIndex();
        IndexIterator ii = oldData.getIndexIterator();
        while (ii.hasNext()) {
            String s2 = (String)ii.getObjectNext();
            int[] c = ii.getCurrentCounter();
            for (int i = 0; i < c.length; ++i) {
                ima.setDim(i, c[i]);
            }
            newData.setString(ima, s2);
        }
        return newData;
    }

    private static void usage() {
        System.out.println("usage: ucar.nc2.FileWriter2 -in <fileIn> -out <fileOut> [-netcdf4]");
    }

    public static void main(String[] arg) throws IOException {
        if (arg.length < 4) {
            FileWriter2.usage();
            System.exit(0);
        }
        String datasetIn = null;
        String datasetOut = null;
        NetcdfFileWriter.Version version = NetcdfFileWriter.Version.netcdf3;
        for (int i = 0; i < arg.length; ++i) {
            String s2 = arg[i];
            if (s2.equalsIgnoreCase("-in")) {
                datasetIn = arg[i + 1];
            }
            if (s2.equalsIgnoreCase("-out")) {
                datasetOut = arg[i + 1];
            }
            if (!s2.equalsIgnoreCase("-netcdf4")) continue;
            version = NetcdfFileWriter.Version.netcdf4;
        }
        if (datasetIn == null || datasetOut == null) {
            FileWriter2.usage();
            System.exit(0);
        }
        System.out.printf("FileWriter2 copy %s to %s ", datasetIn, datasetOut);
        CancelTaskImpl cancel = new CancelTaskImpl();
        NetcdfFile ncfileIn = NetcdfFile.open(datasetIn, cancel);
        if (cancel.isCancel()) {
            return;
        }
        FileWriter2 writer2 = new FileWriter2(ncfileIn, datasetOut, version, null);
        NetcdfFile ncfileOut = writer2.write(cancel);
        if (ncfileOut != null) {
            ncfileOut.close();
        }
        ncfileIn.close();
        System.out.printf("%s%n", cancel);
    }

    public static class ChunkingIndex
    extends Index {
        public ChunkingIndex(int[] shape) {
            super(shape);
        }

        public int[] computeChunkShape(long maxChunkElems) {
            int[] chunkShape = new int[this.rank];
            for (int iDim = 0; iDim < this.rank; ++iDim) {
                int size = (int)(maxChunkElems / (long)this.stride[iDim]);
                size = size == 0 ? 1 : size;
                chunkShape[iDim] = size = Math.min(size, this.shape[iDim] - this.current[iDim]);
            }
            return chunkShape;
        }
    }

    public static enum N3StructureStrategy {
        flatten,
        exclude;

    }
}

