/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import dap4.core.dmr.DapEnumConst;
import dap4.core.dmr.DapEnumeration;
import dap4.core.dmr.DapType;
import dap4.core.dmr.TypeSort;
import dap4.core.util.ConversionException;
import dap4.core.util.DapUtil;
import java.nio.ByteBuffer;

public abstract class CoreTypeFcns {
    public static Object attributeConvert(DapType type, Object value) {
        if (value == null) {
            return value;
        }
        if (type.isEnumType()) {
            if (value instanceof String) {
                try {
                    int ival = Integer.parseInt(value.toString());
                    return ival;
                }
                catch (NumberFormatException nfe) {
                    DapEnumConst dec = ((DapEnumeration)type).lookup(value.toString());
                    if (dec == null) {
                        return value;
                    }
                    return dec.getValue();
                }
            }
            if (value instanceof Long) {
                return (Long)value;
            }
        } else {
            if (value instanceof Long) {
                return (Long)value;
            }
            if (value instanceof Float) {
                return (Float)value;
            }
            if (value instanceof Double) {
                return (Double)value;
            }
            if (value instanceof Character) {
                return (Character)value;
            }
        }
        return value;
    }

    public static int getJavaSize(TypeSort atomtype) {
        switch (atomtype) {
            case Char: 
            case Int8: 
            case UInt8: {
                return 1;
            }
            case Int16: 
            case UInt16: {
                return 2;
            }
            case Int32: 
            case UInt32: {
                return 4;
            }
            case Int64: 
            case UInt64: {
                return 8;
            }
            case Float32: {
                return 4;
            }
            case Float64: {
                return 8;
            }
        }
        return 0;
    }

    public static long forceRange(TypeSort basetype, long value) {
        assert (basetype.isIntegerType()) : "Internal error";
        switch (basetype) {
            case Char: {
                value = CoreTypeFcns.minmax(value, 0L, 255L);
                break;
            }
            case Int8: {
                value = CoreTypeFcns.minmax(value, -128L, 127L);
                break;
            }
            case UInt8: {
                value &= 0xFFL;
                break;
            }
            case Int16: {
                value = CoreTypeFcns.minmax(value, -32768L, 32767L);
                break;
            }
            case UInt16: {
                value &= 0xFFFFL;
                break;
            }
            case Int32: {
                value = CoreTypeFcns.minmax(value, Integer.MIN_VALUE, Integer.MAX_VALUE);
                break;
            }
            case UInt32: {
                value &= 0xFFFFFFFFL;
                break;
            }
            case Int64: 
            case UInt64: {
                break;
            }
        }
        return value;
    }

    protected static long minmax(long value, long min2, long max) {
        if (value < min2) {
            return min2;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static Object get(DapType type, Object v, int n) {
        switch (type.getAtomicType()) {
            case Char: {
                return Character.valueOf(((char[])v)[n]);
            }
            case Int8: 
            case UInt8: {
                return ((byte[])v)[n];
            }
            case Int16: 
            case UInt16: {
                return ((short[])v)[n];
            }
            case Int32: 
            case UInt32: {
                return ((int[])v)[n];
            }
            case Int64: 
            case UInt64: {
                return ((long[])v)[n];
            }
            case Float32: {
                return Float.valueOf(((float[])v)[n]);
            }
            case Float64: {
                return ((double[])v)[n];
            }
            case String: 
            case URL: {
                return ((String[])v)[n];
            }
            case Opaque: {
                return ((ByteBuffer[])v)[n];
            }
            case Enum: {
                return CoreTypeFcns.get(((DapEnumeration)type).getBaseType(), v, n);
            }
        }
        throw new IllegalArgumentException();
    }

    public static void put(TypeSort sort, Object v, int n, Object value) {
        switch (sort) {
            case Char: {
                ((char[])v)[n] = ((char[])value)[0];
                break;
            }
            case Int8: 
            case UInt8: {
                ((byte[])v)[n] = ((byte[])value)[0];
                break;
            }
            case Int16: 
            case UInt16: {
                ((short[])v)[n] = ((short[])value)[0];
                break;
            }
            case Int32: 
            case UInt32: {
                ((int[])v)[n] = ((int[])value)[0];
                break;
            }
            case Int64: 
            case UInt64: {
                ((long[])v)[n] = ((long[])value)[0];
                break;
            }
            case Float32: {
                ((float[])v)[n] = ((float[])value)[0];
                break;
            }
            case Float64: {
                ((double[])v)[n] = ((double[])value)[0];
                break;
            }
            case String: 
            case URL: {
                ((String[])v)[n] = ((String[])value)[0];
                break;
            }
            case Opaque: {
                ((ByteBuffer[])v)[n] = ((ByteBuffer[])value)[0];
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public static int putVector(TypeSort sort, Object v, int offset, Object vec) {
        int len = 0;
        switch (sort) {
            case Char: {
                len = ((char[])vec).length;
                System.arraycopy((char[])v, offset, (char[])vec, 0, len);
                break;
            }
            case Int8: 
            case UInt8: {
                len = ((int[])vec).length;
                System.arraycopy((byte[])v, offset, (byte[])vec, 0, len);
                break;
            }
            case Int16: 
            case UInt16: {
                len = ((short[])vec).length;
                System.arraycopy((short[])v, offset, (short[])vec, 0, len);
                break;
            }
            case Int32: 
            case UInt32: {
                len = ((int[])vec).length;
                System.arraycopy((int[])v, offset, (int[])vec, 0, len);
                break;
            }
            case Int64: 
            case UInt64: {
                len = ((long[])vec).length;
                System.arraycopy((long[])v, offset, (long[])vec, 0, len);
                break;
            }
            case Float32: {
                len = ((float[])vec).length;
                System.arraycopy((float[])v, offset, (float[])vec, 0, len);
                break;
            }
            case Float64: {
                len = ((double[])vec).length;
                System.arraycopy((double[])v, offset, (double[])vec, 0, len);
                break;
            }
            case String: 
            case URL: {
                len = ((String[])vec).length;
                System.arraycopy((String[])v, offset, (String[])vec, 0, len);
                break;
            }
            case Opaque: {
                len = ((ByteBuffer[])vec).length;
                System.arraycopy((ByteBuffer[])v, offset, (ByteBuffer[])vec, 0, len);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return len;
    }

    public static Object get(TypeSort sort, ByteBuffer b, int n) {
        switch (sort) {
            case Char: {
                return Character.valueOf((char)((long)b.get(n) & 0xFFL));
            }
            case Int8: 
            case UInt8: {
                return b.get(n);
            }
            case Int16: 
            case UInt16: {
                return b.getShort(n);
            }
            case Int32: 
            case UInt32: {
                return b.getInt(n);
            }
            case Int64: 
            case UInt64: {
                return b.getLong(n);
            }
            case Float32: {
                return Float.valueOf(b.getFloat(n));
            }
            case Float64: {
                return b.getDouble(n);
            }
            case String: 
            case URL: {
                byte[] bytes = new byte[(int)b.getLong()];
                b.get(bytes);
                return new String(bytes, DapUtil.UTF8);
            }
            case Opaque: {
                byte[] bytes = new byte[(int)b.getLong()];
                b.get(bytes);
                return ByteBuffer.wrap(bytes);
            }
        }
        throw new IllegalArgumentException();
    }

    public static Object createVector(TypeSort type, long count) {
        int icount = (int)count;
        Object[] vector = null;
        switch (type) {
            case Char: {
                vector = new char[icount];
                break;
            }
            case Int8: 
            case UInt8: {
                vector = new byte[icount];
                break;
            }
            case Int16: 
            case UInt16: {
                vector = new short[icount];
                break;
            }
            case Int32: 
            case UInt32: {
                vector = new int[icount];
                break;
            }
            case Int64: 
            case UInt64: {
                vector = new long[icount];
                break;
            }
            case Float32: {
                vector = new float[icount];
                break;
            }
            case Float64: {
                vector = new double[icount];
                break;
            }
            case String: {
                vector = new String[icount];
                break;
            }
            case Opaque: {
                vector = new ByteBuffer[icount];
                break;
            }
            default: {
                throw new ConversionException();
            }
        }
        return vector;
    }
}

