/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.simpgeometry;

import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.conv.CF1Convention;
import ucar.nc2.ft2.simpgeometry.CFLine;
import ucar.nc2.ft2.simpgeometry.CFPoint;
import ucar.nc2.ft2.simpgeometry.CFPolygon;
import ucar.nc2.ft2.simpgeometry.GeometryType;
import ucar.nc2.ft2.simpgeometry.Line;
import ucar.nc2.ft2.simpgeometry.Point;
import ucar.nc2.ft2.simpgeometry.Polygon;

public class SimpleGeometryReader {
    private NetcdfDataset ds;

    public Polygon readPolygon(String name, int index) {
        Variable polyvar = this.ds.findVariable(name);
        if (polyvar == null) {
            return null;
        }
        Polygon poly = null;
        if (this.ds.findGlobalAttribute("Conventions") != null && CF1Convention.getVersion(this.ds.findGlobalAttribute("Conventions").getStringValue()) >= 8) {
            poly = new CFPolygon();
        }
        if (poly == null) {
            return null;
        }
        return poly.setupPolygon(this.ds, polyvar, index);
    }

    public Line readLine(String name, int index) {
        Variable linevar = this.ds.findVariable(name);
        if (linevar == null) {
            return null;
        }
        Line line = null;
        if (this.ds.findGlobalAttribute("Conventions") != null && CF1Convention.getVersion(this.ds.findGlobalAttribute("Conventions").getStringValue()) >= 8) {
            line = new CFLine();
        }
        if (line == null) {
            return null;
        }
        return line.setupLine(this.ds, linevar, index);
    }

    public Point readPoint(String name, int index) {
        Variable pointvar = this.ds.findVariable(name);
        if (pointvar == null) {
            return null;
        }
        Point pt = null;
        if (this.ds.findGlobalAttribute("Conventions") != null && CF1Convention.getVersion(this.ds.findGlobalAttribute("Conventions").getStringValue()) >= 8) {
            pt = new CFPoint();
        }
        if (pt == null) {
            return pt;
        }
        return pt.setupPoint(this.ds, pointvar, index);
    }

    public GeometryType getGeometryType(String name) {
        Variable geometryVar = this.ds.findVariable(name);
        if (geometryVar == null) {
            return null;
        }
        if (this.ds.findGlobalAttribute("Conventions") != null && CF1Convention.getVersion(this.ds.findGlobalAttribute("Conventions").getStringValue()) >= 8) {
            Attribute geometryTypeAttr = null;
            String geometry_type = null;
            geometryTypeAttr = geometryVar.findAttribute("geometry_type");
            if (geometryTypeAttr == null) {
                return null;
            }
            switch (geometry_type = geometryTypeAttr.getStringValue()) {
                case "polygon": {
                    return GeometryType.POLYGON;
                }
                case "line": {
                    return GeometryType.LINE;
                }
                case "point": {
                    return GeometryType.POINT;
                }
            }
            return null;
        }
        return null;
    }

    public SimpleGeometryReader(NetcdfDataset ds) {
        this.ds = ds;
    }
}

