/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;

public class RotatedPole
extends ProjectionImpl {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final double RAD_PER_DEG = Math.PI / 180;
    private static final double DEG_PER_RAD = 57.29577951308232;
    private final ProjectionPointImpl northPole;
    private final double[][] rotY = new double[3][3];
    private final double[][] rotZ = new double[3][3];

    public RotatedPole() {
        this(0.0, 0.0);
    }

    public RotatedPole(double northPoleLat, double northPoleLon) {
        super("RotatedPole", false);
        this.northPole = new ProjectionPointImpl(northPoleLon, northPoleLat);
        this.buildRotationMatrices();
        this.addParameter("grid_mapping_name", "rotated_latitude_longitude");
        this.addParameter("grid_north_pole_latitude", northPoleLat);
        this.addParameter("grid_north_pole_longitude", northPoleLon);
    }

    private void buildRotationMatrices() {
        double betaRad = 0.0;
        double gammaRad = 0.0;
        if (this.northPole.getY() == 90.0) {
            betaRad = 0.0;
            gammaRad = this.northPole.getX() * (Math.PI / 180);
        } else {
            betaRad = -(90.0 - this.northPole.getY()) * (Math.PI / 180);
            gammaRad = (this.northPole.getX() + 180.0) * (Math.PI / 180);
        }
        double cosBeta = Math.cos(betaRad);
        double sinBeta = Math.sin(betaRad);
        double cosGamma = Math.cos(gammaRad);
        double sinGamma = Math.sin(gammaRad);
        this.rotY[0][0] = cosBeta;
        this.rotY[0][1] = 0.0;
        this.rotY[0][2] = -sinBeta;
        this.rotY[1][0] = 0.0;
        this.rotY[1][1] = 1.0;
        this.rotY[1][2] = 0.0;
        this.rotY[2][0] = sinBeta;
        this.rotY[2][1] = 0.0;
        this.rotY[2][2] = cosBeta;
        this.rotZ[0][0] = cosGamma;
        this.rotZ[0][1] = sinGamma;
        this.rotZ[0][2] = 0.0;
        this.rotZ[1][0] = -sinGamma;
        this.rotZ[1][1] = cosGamma;
        this.rotZ[1][2] = 0.0;
        this.rotZ[2][0] = 0.0;
        this.rotZ[2][1] = 0.0;
        this.rotZ[2][2] = 1.0;
    }

    public ProjectionPointImpl getNorthPole() {
        return new ProjectionPointImpl(this.northPole);
    }

    @Override
    public ProjectionImpl constructCopy() {
        RotatedPole result = new RotatedPole(this.northPole.getY(), this.northPole.getX());
        result.setDefaultMapArea(this.defaultMapArea);
        result.setName(this.name);
        return result;
    }

    @Override
    public String paramsToString() {
        return " northPole= " + this.northPole;
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latlon, ProjectionPointImpl destPoint) {
        double lon = latlon.getLongitude();
        double lat = latlon.getLatitude();
        double lonRad = Math.toRadians(lon);
        double latRad = Math.toRadians(lat);
        double[] p0 = new double[]{Math.cos(latRad) * Math.cos(lonRad), Math.cos(latRad) * Math.sin(lonRad), Math.sin(latRad)};
        double[] p1 = new double[]{this.rotZ[0][0] * p0[0] + this.rotZ[0][1] * p0[1], this.rotZ[1][0] * p0[0] + this.rotZ[1][1] * p0[1], p0[2]};
        double[] p2 = new double[]{this.rotY[0][0] * p1[0] + this.rotY[0][2] * p1[2], p1[1], this.rotY[2][0] * p1[0] + this.rotY[2][2] * p1[2]};
        double lonR = LatLonPointImpl.range180(Math.atan2(p2[1], p2[0]) * 57.29577951308232);
        double latR = Math.asin(p2[2]) * 57.29577951308232;
        if (destPoint == null) {
            destPoint = new ProjectionPointImpl(lonR, latR);
        } else {
            destPoint.setLocation(lonR, latR);
        }
        log.debug("LatLon= " + latlon + ", proj= " + destPoint);
        return destPoint;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint ppt, LatLonPointImpl destPoint) {
        double lonR = LatLonPointImpl.range180(ppt.getX());
        double latR = ppt.getY();
        if (Math.abs(latR) > 90.0) {
            throw new IllegalArgumentException("ProjectionPoint y must be in range [-90,90].");
        }
        double lonRRad = Math.toRadians(lonR);
        double latRRad = Math.toRadians(latR);
        double[] p0 = new double[]{Math.cos(latRRad) * Math.cos(lonRRad), Math.cos(latRRad) * Math.sin(lonRRad), Math.sin(latRRad)};
        double[] p1 = new double[]{this.rotY[0][0] * p0[0] + this.rotY[2][0] * p0[2], p0[1], this.rotY[0][2] * p0[0] + this.rotY[2][2] * p0[2]};
        double[] p2 = new double[]{this.rotZ[0][0] * p1[0] + this.rotZ[1][0] * p1[1], this.rotZ[0][1] * p1[0] + this.rotZ[1][1] * p1[1], p1[2]};
        double lon = Math.atan2(p2[1], p2[0]) * 57.29577951308232;
        double lat = Math.asin(p2[2]) * 57.29577951308232;
        if (destPoint == null) {
            destPoint = new LatLonPointImpl(lat, lon);
        } else {
            destPoint.set(lat, lon);
        }
        log.debug("Proj= " + ppt + ", latlon= " + destPoint);
        return destPoint;
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        return Math.abs(pt1.getX() - pt2.getX()) > 270.0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RotatedPole that = (RotatedPole)o;
        return this.northPole.equals(that.northPole);
    }

    public int hashCode() {
        return this.northPole.hashCode();
    }
}

