/*
 * Decompiled with CFR 0.152.
 */
package ucar.atd.dorade;

import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import ucar.atd.dorade.DoradeDescriptor;
import ucar.atd.dorade.DoradePARM;

class DoradeRDAT
extends DoradeDescriptor {
    private String paramName;
    private byte[] paramData;

    public DoradeRDAT(RandomAccessFile file, boolean littleEndianData) throws DoradeDescriptor.DescriptorException {
        byte[] data = this.readDescriptor(file, littleEndianData, "RDAT");
        this.paramName = new String(data, 8, 8, StandardCharsets.UTF_8).trim();
        this.paramData = new byte[data.length - 16];
        System.arraycopy(data, 16, this.paramData, 0, data.length - 16);
    }

    public String toString() {
        String s2 = "RDAT\n";
        s2 = s2 + "  param name: " + this.paramName + "\n";
        s2 = s2 + "  data length: " + this.paramData.length;
        return s2;
    }

    public String getParamName() {
        return this.paramName;
    }

    public byte[] getRawData() {
        return this.paramData;
    }

    public static DoradeRDAT getNextOf(DoradePARM parm, RandomAccessFile file, boolean littleEndianData) throws DoradeDescriptor.DescriptorException {
        while (true) {
            long pos = DoradeRDAT.findNextWithName("RDAT", file, littleEndianData);
            if (DoradeRDAT.peekParamName(file).equals(parm.getName())) {
                return new DoradeRDAT(file, littleEndianData);
            }
            DoradeRDAT.skipDescriptor(file, littleEndianData);
        }
    }

    private static String peekParamName(RandomAccessFile file) throws DoradeDescriptor.DescriptorException {
        try {
            long filepos = file.getFilePointer();
            file.skipBytes(8);
            byte[] nameBytes = new byte[8];
            if (file.read(nameBytes) == -1) {
                throw new DoradeDescriptor.DescriptorException("unexpected EOF");
            }
            file.seek(filepos);
            return new String(nameBytes, StandardCharsets.UTF_8).trim();
        }
        catch (Exception ex) {
            throw new DoradeDescriptor.DescriptorException(ex);
        }
    }
}

