/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid.gis;

import java.util.ArrayList;
import java.util.List;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.ProjectionImpl;

public final class GridBoundariesExtractor {
    private GridDataset gridDataset;
    private double minLon;
    private double maxLon;
    private double maxDiff;
    private boolean crossesDateLine;

    private GridBoundariesExtractor() {
    }

    private GridBoundariesExtractor(GridDataset gridDataset) {
        this.gridDataset = gridDataset;
    }

    public String getDatasetBoundariesWKT() {
        StringBuilder polygonWKT = new StringBuilder("POLYGON((");
        ArrayList<Double> polLons = new ArrayList<Double>();
        ArrayList<Double> polLats = new ArrayList<Double>();
        this.getLatLonsForPolygon(polLons, polLats);
        if (this.maxLon > 0.0 && this.minLon < 0.0 && this.maxDiff > 270.0) {
            this.crossesDateLine = true;
        }
        int nPoints = polLats.size();
        for (int i = 0; i < nPoints; ++i) {
            double lon = (Double)polLons.get(i);
            if (this.crossesDateLine && lon < 0.0) {
                lon += 360.0;
            }
            if (i < nPoints - 1) {
                polygonWKT.append(lon).append(" ").append(polLats.get(i)).append(",");
                continue;
            }
            polygonWKT.append(lon).append(" ").append(polLats.get(i));
        }
        polygonWKT.append("))");
        return polygonWKT.toString();
    }

    public String getDatasetBoundariesGeoJSON() {
        StringBuilder polygonJSON = new StringBuilder("{\"type\":\"Polygon\", \"coordinates\":[ [ ");
        ArrayList<Double> polLons = new ArrayList<Double>();
        ArrayList<Double> polLats = new ArrayList<Double>();
        this.getLatLonsForPolygon(polLons, polLats);
        if (this.maxLon > 0.0 && this.minLon < 0.0 && this.maxDiff > 270.0) {
            this.crossesDateLine = true;
        }
        int nPoints = polLats.size();
        for (int i = 0; i < nPoints; ++i) {
            double lon = (Double)polLons.get(i);
            if (this.crossesDateLine && lon < 0.0) {
                lon += 360.0;
            }
            if (i < nPoints - 1) {
                polygonJSON.append("[").append(lon).append(", ").append(polLats.get(i)).append("],");
                continue;
            }
            polygonJSON.append("[").append(lon).append(", ").append(polLats.get(i)).append("]");
        }
        polygonJSON.append(" ] ]}");
        return polygonJSON.toString();
    }

    private void getLatLonsForPolygon(List<Double> polLons, List<Double> polLats) {
        block35: {
            LatLonPoint point;
            double y;
            double x;
            int i;
            ProjectionImpl fromProj;
            GridCoordSystem coordSystem;
            block34: {
                GridDataset.Gridset gridset = this.gridDataset.getGridsets().get(0);
                coordSystem = gridset.getGeoCoordSystem();
                fromProj = coordSystem.getProjection();
                coordSystem.getLatLonBoundingBox();
                if (!(coordSystem.getYHorizAxis() instanceof CoordinateAxis1D) || !(coordSystem.getXHorizAxis() instanceof CoordinateAxis1D)) break block34;
                CoordinateAxis1D xAxis = (CoordinateAxis1D)coordSystem.getXHorizAxis();
                CoordinateAxis1D yAxis = (CoordinateAxis1D)coordSystem.getYHorizAxis();
                if (coordSystem.isGlobalLon()) {
                    double maxy = yAxis.getMaxValue();
                    double miny = yAxis.getMinValue();
                    polLons.add(0.0);
                    polLats.add(miny);
                    polLons.add(360.0);
                    polLats.add(miny);
                    polLons.add(360.0);
                    polLats.add(maxy);
                    polLons.add(0.0);
                    polLats.add(maxy);
                    polLons.add(0.0);
                    polLats.add(miny);
                } else {
                    int i2;
                    LatLonPoint point2;
                    double[] xCoords = xAxis.getCoordValues();
                    double[] yCoords = yAxis.getCoordValues();
                    LatLonPoint prev = fromProj.projToLatLon(xCoords[0], yCoords[0]);
                    for (double x2 : xCoords) {
                        point2 = fromProj.projToLatLon(x2, yCoords[0]);
                        if (point2.getLongitude() < this.minLon) {
                            this.minLon = point2.getLongitude();
                        }
                        if (point2.getLongitude() > this.maxLon) {
                            this.maxLon = point2.getLongitude();
                        }
                        if (Math.abs(prev.getLongitude() - point2.getLongitude()) > this.maxDiff) {
                            this.maxDiff = Math.abs(prev.getLongitude() - point2.getLongitude());
                        }
                        polLons.add(point2.getLongitude());
                        polLats.add(point2.getLatitude());
                        prev = point2;
                    }
                    for (double y2 : yCoords) {
                        point2 = fromProj.projToLatLon(xCoords[xCoords.length - 1], y2);
                        if (point2.getLongitude() < this.minLon) {
                            this.minLon = point2.getLongitude();
                        }
                        if (point2.getLongitude() > this.maxLon) {
                            this.maxLon = point2.getLongitude();
                        }
                        if (Math.abs(prev.getLongitude() - point2.getLongitude()) > this.maxDiff) {
                            this.maxDiff = Math.abs(prev.getLongitude() - point2.getLongitude());
                        }
                        polLons.add(point2.getLongitude());
                        polLats.add(point2.getLatitude());
                        prev = point2;
                    }
                    for (i2 = xCoords.length - 1; i2 >= 0; --i2) {
                        LatLonPoint point3 = fromProj.projToLatLon(xCoords[i2], yCoords[yCoords.length - 1]);
                        if (point3.getLongitude() < this.minLon) {
                            this.minLon = point3.getLongitude();
                        }
                        if (point3.getLongitude() > this.maxLon) {
                            this.maxLon = point3.getLongitude();
                        }
                        if (Math.abs(prev.getLongitude() - point3.getLongitude()) > this.maxDiff) {
                            this.maxDiff = Math.abs(prev.getLongitude() - point3.getLongitude());
                        }
                        polLons.add(point3.getLongitude());
                        polLats.add(point3.getLatitude());
                        prev = point3;
                    }
                    for (i2 = yCoords.length - 1; i2 >= 0; --i2) {
                        LatLonPoint point4 = fromProj.projToLatLon(xCoords[0], yCoords[i2]);
                        if (point4.getLongitude() < this.minLon) {
                            this.minLon = point4.getLongitude();
                        }
                        if (point4.getLongitude() > this.maxLon) {
                            this.maxLon = point4.getLongitude();
                        }
                        if (Math.abs(prev.getLongitude() - point4.getLongitude()) > this.maxDiff) {
                            this.maxDiff = Math.abs(prev.getLongitude() - point4.getLongitude());
                        }
                        polLons.add(point4.getLongitude());
                        polLats.add(point4.getLatitude());
                        prev = point4;
                    }
                }
                break block35;
            }
            if (!(coordSystem.getYHorizAxis() instanceof CoordinateAxis2D) || !(coordSystem.getXHorizAxis() instanceof CoordinateAxis2D)) break block35;
            CoordinateAxis2D xAxis = (CoordinateAxis2D)coordSystem.getXHorizAxis();
            CoordinateAxis2D yAxis = (CoordinateAxis2D)coordSystem.getYHorizAxis();
            int[] xShape = xAxis.getShape();
            int[] yShape = yAxis.getShape();
            LatLonPoint prev = fromProj.projToLatLon(xAxis.getCoordValue(0, 0), yAxis.getCoordValue(0, 0));
            for (i = 0; i < xShape[0]; ++i) {
                x = xAxis.getCoordValue(i, 0);
                point = fromProj.projToLatLon(x, y = yAxis.getCoordValue(i, 0));
                if (point.getLongitude() < this.minLon) {
                    this.minLon = point.getLongitude();
                }
                if (point.getLongitude() > this.maxLon) {
                    this.maxLon = point.getLongitude();
                }
                if (Math.abs(prev.getLongitude() - point.getLongitude()) > this.maxDiff) {
                    this.maxDiff = Math.abs(prev.getLongitude() - point.getLongitude());
                }
                polLons.add(point.getLongitude());
                polLats.add(point.getLatitude());
                prev = point;
            }
            for (i = 0; i < xShape[1]; ++i) {
                x = xAxis.getCoordValue(xShape[0] - 1, i);
                point = fromProj.projToLatLon(x, y = yAxis.getCoordValue(xShape[0] - 1, i));
                if (point.getLongitude() < this.minLon) {
                    this.minLon = point.getLongitude();
                }
                if (point.getLongitude() > this.maxLon) {
                    this.maxLon = point.getLongitude();
                }
                if (Math.abs(prev.getLongitude() - point.getLongitude()) > this.maxDiff) {
                    this.maxDiff = Math.abs(prev.getLongitude() - point.getLongitude());
                }
                polLons.add(point.getLongitude());
                polLats.add(point.getLatitude());
                prev = point;
            }
            for (i = xShape[0] - 1; i >= 0; --i) {
                x = xAxis.getCoordValue(i, xShape[1] - 1);
                point = fromProj.projToLatLon(x, y = yAxis.getCoordValue(i, xShape[1] - 1));
                if (point.getLongitude() < this.minLon) {
                    this.minLon = point.getLongitude();
                }
                if (point.getLongitude() > this.maxLon) {
                    this.maxLon = point.getLongitude();
                }
                if (Math.abs(prev.getLongitude() - point.getLongitude()) > this.maxDiff) {
                    this.maxDiff = Math.abs(prev.getLongitude() - point.getLongitude());
                }
                polLons.add(point.getLongitude());
                polLats.add(point.getLatitude());
                prev = point;
            }
            for (i = xShape[1] - 1; i >= 0; --i) {
                x = xAxis.getCoordValue(0, i);
                point = fromProj.projToLatLon(x, y = yAxis.getCoordValue(0, i));
                if (point.getLongitude() < this.minLon) {
                    this.minLon = point.getLongitude();
                }
                if (point.getLongitude() > this.maxLon) {
                    this.maxLon = point.getLongitude();
                }
                if (Math.abs(prev.getLongitude() - point.getLongitude()) > this.maxDiff) {
                    this.maxDiff = Math.abs(prev.getLongitude() - point.getLongitude());
                }
                polLons.add(point.getLongitude());
                polLats.add(point.getLatitude());
                prev = point;
            }
        }
    }

    public static GridBoundariesExtractor valueOf(GridDataset gds) {
        return new GridBoundariesExtractor(gds);
    }
}

