/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.fmrc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ProxyReader;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordSysBuilderIF;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.DatasetConstructor;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.fmrc.FmrInv;
import ucar.nc2.ft.fmrc.FmrcInv;
import ucar.nc2.ft.fmrc.FmrcInvLite;
import ucar.nc2.ft.fmrc.GridDatasetInv;
import ucar.nc2.ft.fmrc.TimeInventory;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.CancelTask;

@ThreadSafe
class FmrcDataset {
    private static final Logger logger = LoggerFactory.getLogger(FmrcDataset.class);
    private static final boolean debugEnhance = false;
    private static final boolean debugRead = false;
    private final FeatureCollectionConfig config;
    private State state;
    private final Object lock = new Object();

    FmrcDataset(FeatureCollectionConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<CalendarDate> getRunDates() {
        State localState;
        Object object = this.lock;
        synchronized (object) {
            localState = this.state;
        }
        return localState.lite.getRunDates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<CalendarDate> getForecastDates() {
        State localState;
        Object object = this.lock;
        synchronized (object) {
            localState = this.state;
        }
        return localState.lite.getForecastDates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double[] getForecastOffsets() {
        State localState;
        Object object = this.lock;
        synchronized (object) {
            localState = this.state;
        }
        return localState.lite.getForecastOffsets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CalendarDateRange getDateRangeForRun(CalendarDate run) {
        State localState;
        Object object = this.lock;
        synchronized (object) {
            localState = this.state;
        }
        int runidx = localState.lite.findRunIndex(run);
        if (runidx < 0) {
            return null;
        }
        double min2 = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (FmrcInvLite.Gridset gs : localState.lite.gridSets) {
            for (int i = 0; i < gs.noffsets; ++i) {
                double time = gs.getTimeCoord(runidx, i);
                if (Double.isNaN(time)) continue;
                min2 = Math.min(min2, time);
                max = Math.max(max, time);
            }
        }
        return CalendarDateRange.of(FmrcInv.makeOffsetDate(localState.lite.base, min2), FmrcInv.makeOffsetDate(localState.lite.base, max));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CalendarDateRange getDateRangeForOffset(double offset) {
        State localState;
        Object object = this.lock;
        synchronized (object) {
            localState = this.state;
        }
        List<CalendarDate> runs = localState.lite.getRunDates();
        int n = runs.size();
        return CalendarDateRange.of(FmrcInv.makeOffsetDate(runs.get(0), offset), FmrcInv.makeOffsetDate(runs.get(n - 1), offset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GridDataset getNetcdfDataset2D(NetcdfDataset result) throws IOException {
        State localState;
        Object object = this.lock;
        synchronized (object) {
            localState = this.state;
        }
        return this.buildDataset2D(result, localState.proto, localState.lite);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GridDataset getBest() throws IOException {
        State localState;
        Object object = this.lock;
        synchronized (object) {
            localState = this.state;
        }
        return this.buildDataset1D(localState.proto, localState.lite, localState.lite.makeBestDatasetInventory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GridDataset getBest(FeatureCollectionConfig.BestDataset bd) throws IOException {
        State localState;
        Object object = this.lock;
        synchronized (object) {
            localState = this.state;
        }
        return this.buildDataset1D(localState.proto, localState.lite, localState.lite.makeBestDatasetInventory(bd));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GridDataset getRunTimeDataset(CalendarDate run) throws IOException {
        State localState;
        Object object = this.lock;
        synchronized (object) {
            localState = this.state;
        }
        return this.buildDataset1D(localState.proto, localState.lite, localState.lite.makeRunTimeDatasetInventory(run));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GridDataset getConstantForecastDataset(CalendarDate run) throws IOException {
        State localState;
        Object object = this.lock;
        synchronized (object) {
            localState = this.state;
        }
        return this.buildDataset1D(localState.proto, localState.lite, localState.lite.getConstantForecastDataset(run));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GridDataset getConstantOffsetDataset(double offset) throws IOException {
        State localState;
        Object object = this.lock;
        synchronized (object) {
            localState = this.state;
        }
        return this.buildDataset1D(localState.proto, localState.lite, localState.lite.getConstantOffsetDataset(offset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInventory(FmrcInv fmrcInv, boolean forceProto) throws IOException {
        NetcdfDataset protoLocal = null;
        if (this.state == null || forceProto) {
            protoLocal = this.buildProto(fmrcInv, this.config.protoConfig);
        }
        FmrcInvLite liteLocal = new FmrcInvLite(fmrcInv);
        Object object = this.lock;
        synchronized (object) {
            if (protoLocal == null && this.state != null) {
                protoLocal = this.state.proto;
            }
            this.state = new State(protoLocal, liteLocal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetcdfDataset buildProto(FmrcInv fmrcInv, FeatureCollectionConfig.ProtoConfig protoConfig) throws IOException {
        NetcdfDataset result = new NetcdfDataset();
        List<FmrInv> list = fmrcInv.getFmrInv();
        if (list.isEmpty()) {
            logger.error("Fmrc collection is empty =" + fmrcInv.getName());
            throw new IllegalStateException("Fmrc collection is empty =" + fmrcInv.getName());
        }
        int protoIdx = 0;
        switch (protoConfig.choice) {
            case First: {
                protoIdx = 0;
                break;
            }
            case Random: {
                Random r = new Random(System.currentTimeMillis());
                protoIdx = r.nextInt(list.size() - 1);
                break;
            }
            case Penultimate: {
                protoIdx = Math.max(list.size() - 2, 0);
                break;
            }
            case Latest: {
                protoIdx = Math.max(list.size() - 1, 0);
                break;
            }
            case Run: {
                int runOffset = 0;
                if (protoConfig.param != null) {
                    runOffset = Integer.parseInt(protoConfig.param);
                }
                for (int i = 0; i < list.size(); ++i) {
                    FmrInv fmr = list.get(i);
                    CalendarDate cd2 = fmr.getRunDate();
                    int hour = cd2.getHourOfDay();
                    if (hour != runOffset) continue;
                    protoIdx = i;
                }
                break;
            }
        }
        FmrInv proto = list.get(protoIdx);
        HashMap<String, NetcdfDataset> openFilesProto = new HashMap<String, NetcdfDataset>();
        try {
            Set<GridDatasetInv> files = proto.getFiles();
            if (logger.isDebugEnabled()) {
                logger.debug("FmrcDataset: proto= " + proto.getName() + " " + proto.getRunDate() + " collection= " + fmrcInv.getName());
            }
            for (GridDatasetInv file : files) {
                NetcdfDataset ncfile = this.open(file.getLocation(), openFilesProto);
                if (ncfile != null) {
                    this.transferGroup(ncfile.getRootGroup(), result.getRootGroup(), result);
                } else {
                    logger.warn("Failed to open " + file.getLocation());
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("FmrcDataset: proto dataset= " + file.getLocation());
            }
            Group root = result.getRootGroup();
            Attribute orgConv = root.findAttributeIgnoreCase("Conventions");
            String convAtt = CoordSysBuilder.buildConventionAttribute("CF-1.4", orgConv == null ? null : orgConv.getStringValue());
            root.addAttribute(new Attribute("Conventions", convAtt));
            root.addAttribute(new Attribute("cdm_data_type", FeatureType.GRID.toString()));
            root.addAttribute(new Attribute("featureType", FeatureType.GRID.toString()));
            root.addAttribute(new Attribute("location", "Proto " + fmrcInv.getName()));
            root.remove(root.findAttribute("_CoordinateModelRunDate"));
            ArrayList<Variable> copyList = new ArrayList<Variable>(root.getVariables());
            for (Variable v : copyList) {
                FmrcInv.UberGrid grid = fmrcInv.findUberGrid(v.getFullName());
                if (grid == null) {
                    Variable orgV = (Variable)v.getSPobject();
                    if (orgV.getSize() > 10000000L) {
                        logger.info("FMRCDataset build Proto cache >10M var= " + orgV.getNameAndDimensions());
                    }
                    v.setCachedData(orgV.read());
                }
                v.setSPobject(null);
            }
            result.finish();
            CoordSysBuilderIF builder = result.enhance();
            Formatter parseInfo = new Formatter();
            GridDataset gds = new GridDataset(result, parseInfo);
            for (GridDatatype grid : gds.getGrids()) {
                Variable newV = result.findVariable(grid.getFullName());
                if (newV == null) {
                    logger.warn("FmrcDataset cant find " + grid.getFullName() + " in proto gds ");
                    continue;
                }
                StringBuilder sbuff = new StringBuilder();
                GridCoordSystem gcs = grid.getCoordinateSystem();
                for (CoordinateAxis axis : gcs.getCoordinateAxes()) {
                    if (axis.getAxisType() == AxisType.Time || axis.getAxisType() == AxisType.RunTime) continue;
                    sbuff.append(axis.getFullName()).append(" ");
                }
                newV.addAttribute(new Attribute("coordinates", sbuff.toString()));
                for (CoordinateTransform ct : gcs.getCoordinateTransforms()) {
                    Variable ctv = result.findVariable(ct.getName());
                    if (ctv == null || ct.getTransformType() != TransformType.Projection) continue;
                    newV.addAttribute(new Attribute("grid_mapping", ctv.getFullName()));
                }
                for (CoordinateAxis axis : gcs.getCoordinateAxes()) {
                    Attribute att;
                    Variable coordV = result.findVariable(axis.getFullNameEscaped());
                    if ((axis.getAxisType() == AxisType.Height || axis.getAxisType() == AxisType.Pressure || axis.getAxisType() == AxisType.GeoZ) && null != axis.getPositive()) {
                        coordV.addAttribute(new Attribute("positive", axis.getPositive()));
                    }
                    if (axis.getAxisType() == AxisType.Lat) {
                        coordV.addAttribute(new Attribute("units", "degrees_north"));
                        coordV.addAttribute(new Attribute("standard_name", "latitude"));
                    }
                    if (axis.getAxisType() == AxisType.Lon) {
                        coordV.addAttribute(new Attribute("units", "degrees_east"));
                        coordV.addAttribute(new Attribute("standard_name", "longitude"));
                    }
                    if (axis.getAxisType() == AxisType.GeoX) {
                        coordV.addAttribute(new Attribute("standard_name", "projection_x_coordinate"));
                    }
                    if (axis.getAxisType() == AxisType.GeoY) {
                        coordV.addAttribute(new Attribute("standard_name", "projection_y_coordinate"));
                    }
                    if (axis.getAxisType() != AxisType.Time || (att = axis.findAttribute("bounds")) == null || !att.isString()) continue;
                    result.removeVariable(null, att.getStringValue());
                }
            }
            for (Variable v : result.getVariables()) {
                Attribute att = v.findAttribute("_CoordinateAxes");
                if (null != att) {
                    v.remove(att);
                }
                if (null != (att = v.findAttribute("_CoordinateSystems"))) {
                    v.remove(att);
                }
                if (null != (att = v.findAttribute("_CoordinateSystemFor"))) {
                    v.remove(att);
                }
                if (null == (att = v.findAttribute("_CoordinateTransforms"))) continue;
                v.remove(att);
            }
            if (protoConfig.outerNcml != null) {
                NcMLReader.mergeNcMLdirect(result, protoConfig.outerNcml);
            }
            NetcdfDataset netcdfDataset = result;
            return netcdfDataset;
        }
        finally {
            this.closeAll(openFilesProto);
        }
    }

    private void transferGroup(Group srcGroup, Group targetGroup, NetcdfDataset target) throws IOException {
        DatasetConstructor.transferGroupAttributes(srcGroup, targetGroup);
        for (Dimension d : srcGroup.getDimensions()) {
            if (null != targetGroup.findDimensionLocal(d.getShortName())) continue;
            Dimension newd = new Dimension(d.getShortName(), d.getLength(), d.isShared(), d.isUnlimited(), d.isVariableLength());
            targetGroup.addDimension(newd);
        }
        for (Variable v : srcGroup.getVariables()) {
            Variable targetV = targetGroup.findVariable(v.getShortName());
            if (null != targetV) continue;
            targetV = v instanceof Structure ? new StructureDS(target, targetGroup, null, v.getShortName(), v.getDimensionsString(), v.getUnitsString(), v.getDescription()) : new VariableDS(target, targetGroup, null, v.getShortName(), v.getDataType(), v.getDimensionsString(), v.getUnitsString(), v.getDescription());
            DatasetConstructor.transferVariableAttributes(v, targetV);
            VariableDS vds = (VariableDS)v;
            targetV.setSPobject(vds);
            if (vds.hasCachedDataRecurse()) {
                if (vds.getSize() > 1000000L) {
                    boolean bl = vds.hasCachedDataRecurse();
                }
                targetV.setCachedData(vds.read());
            }
            targetGroup.addVariable(targetV);
        }
        for (Group srcNested : srcGroup.getGroups()) {
            Group nested = targetGroup.findGroup(srcNested.getShortName());
            if (null == nested) {
                nested = new Group(target, targetGroup, srcNested.getShortName());
                targetGroup.addGroup(nested);
                for (EnumTypedef et : srcNested.getEnumTypedefs()) {
                    targetGroup.addEnumeration(et);
                }
            }
            this.transferGroup(srcNested, nested, target);
        }
    }

    private String getRunDimensionName() {
        return "run";
    }

    private String makeCoordinateList(VariableDS aggVar, String timeCoordName, boolean is2D) {
        String coords = "";
        Attribute att = aggVar.findAttribute("coordinates");
        if (att == null) {
            att = aggVar.findAttribute("_CoordinateAxes");
        }
        if (att != null) {
            coords = att.getStringValue();
        }
        if (is2D) {
            return this.getRunDimensionName() + " " + timeCoordName + " " + coords;
        }
        return timeCoordName + "_" + this.getRunDimensionName() + " " + timeCoordName + " " + coords;
    }

    private void addAttributeInfo(NetcdfDataset result, String attName, String info) {
        Attribute att = result.findGlobalAttribute(attName);
        if (att == null) {
            result.addAttribute(null, new Attribute(attName, info));
        } else {
            String oldValue = att.getStringValue();
            result.addAttribute(null, new Attribute(attName, oldValue + " ;\n" + info));
        }
    }

    private GridDataset buildDataset2D(NetcdfDataset result, NetcdfDataset proto, FmrcInvLite lite) throws IOException {
        if (lite == null) {
            return null;
        }
        if (result == null) {
            result = new NetcdfDataset();
        }
        result.setLocation(lite.collectionName);
        this.transferGroup(proto.getRootGroup(), result.getRootGroup(), result);
        result.finish();
        this.addAttributeInfo(result, "history", "FMRC 2D Dataset");
        double[] runOffset = lite.runOffset;
        String runtimeDimName = this.getRunDimensionName();
        int nruns = runOffset.length;
        Dimension runDim = new Dimension(runtimeDimName, nruns);
        result.removeDimension(null, runtimeDimName);
        result.addDimension(null, runDim);
        ProxyReader2D proxyReader2D = new ProxyReader2D();
        DataType coordType = DataType.DOUBLE;
        VariableDS runtimeCoordVar = new VariableDS(result, null, null, runtimeDimName, coordType, runtimeDimName, null, null);
        runtimeCoordVar.addAttribute(new Attribute("long_name", "Run time for ForecastModelRunCollection"));
        runtimeCoordVar.addAttribute(new Attribute("standard_name", "forecast_reference_time"));
        runtimeCoordVar.addAttribute(new Attribute("units", "hours since " + lite.base));
        runtimeCoordVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.RunTime.toString()));
        result.removeVariable(null, runtimeCoordVar.getShortName());
        result.addVariable(null, runtimeCoordVar);
        if (logger.isDebugEnabled()) {
            logger.debug("FmrcDataset: added runtimeCoordVar " + runtimeCoordVar.getFullName());
        }
        Array runCoordVals = ArrayDouble.factory(DataType.DOUBLE, new int[]{nruns}, (Object)runOffset);
        runtimeCoordVar.setCachedData(runCoordVals);
        List<Variable> nonAggVars = result.getVariables();
        for (FmrcInvLite.Gridset gridset : lite.gridSets) {
            Group newGroup = result.getRootGroup();
            Dimension timeDim = new Dimension(gridset.gridsetName, gridset.noffsets);
            result.removeDimension(null, gridset.gridsetName);
            result.addDimension(null, timeDim);
            DataType dtype = DataType.DOUBLE;
            String dims = this.getRunDimensionName() + " " + gridset.gridsetName;
            VariableDS timeVar = new VariableDS(result, newGroup, null, gridset.gridsetName, dtype, dims, null, null);
            timeVar.addAttribute(new Attribute("long_name", "Forecast time for ForecastModelRunCollection"));
            timeVar.addAttribute(new Attribute("standard_name", "time"));
            timeVar.addAttribute(new Attribute("units", "hours since " + lite.base));
            timeVar.addAttribute(new Attribute("missing_value", Double.NaN));
            timeVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
            newGroup.removeVariable(gridset.gridsetName);
            newGroup.addVariable(timeVar);
            Array timeCoordVals = Array.factory(DataType.DOUBLE, timeVar.getShape(), (Object)gridset.timeOffset);
            timeVar.setCachedData(timeCoordVals);
            if (gridset.timeBounds != null) {
                String bname = timeVar.getShortName() + "_bounds";
                timeVar.addAttribute(new Attribute("bounds", bname));
                Dimension bd = DatasetConstructor.getBoundsDimension(result);
                VariableDS boundsVar = new VariableDS(result, newGroup, null, bname, dtype, dims + " " + bd.getShortName(), null, null);
                boundsVar.addAttribute(new Attribute("long_name", "bounds for " + timeVar.getShortName()));
                boundsVar.setCachedData(Array.factory(DataType.DOUBLE, new int[]{nruns, gridset.noffsets, 2}, (Object)gridset.timeBounds));
                newGroup.addVariable(boundsVar);
            }
            for (FmrcInvLite.Gridset.Grid ugrid : gridset.grids) {
                VariableDS aggVar = (VariableDS)result.findVariable(ugrid.name);
                if (aggVar == null) {
                    logger.error("buildDataset2D: cant find ugrid variable " + ugrid.name + " in collection " + lite.collectionName + this.debugMissingVar(proto, result));
                    continue;
                }
                List<Dimension> dimList = aggVar.getDimensions();
                dimList = dimList.subList(1, dimList.size());
                dimList.add(0, timeDim);
                dimList.add(0, runDim);
                aggVar.setDimensions(dimList);
                aggVar.setProxyReader(proxyReader2D);
                aggVar.setSPobject(ugrid);
                nonAggVars.remove(aggVar);
                String coords = this.makeCoordinateList(aggVar, gridset.gridsetName, true);
                aggVar.removeAttribute("_CoordinateAxes");
                aggVar.addAttribute(new Attribute("coordinates", coords));
            }
        }
        result.finish();
        Formatter parseInfo = new Formatter();
        GridDataset gds = new GridDataset(result, parseInfo);
        return gds;
    }

    private CoordinateSystem findReplacementCs(CoordinateSystem protoCs, String timeDim, NetcdfDataset result) {
        CoordinateSystem replace = result.findCoordinateSystem(protoCs.getName());
        if (replace != null) {
            return replace;
        }
        ArrayList<CoordinateAxis> axes = new ArrayList<CoordinateAxis>();
        for (CoordinateAxis axis : protoCs.getCoordinateAxes()) {
            CoordinateAxis ra = result.findCoordinateAxis(axis.getFullNameEscaped());
            axes.add(ra);
        }
        CoordinateSystem cs = new CoordinateSystem(result, axes, protoCs.getCoordinateTransforms());
        result.addCoordinateSystem(cs);
        return cs;
    }

    private GridDataset buildDataset1D(NetcdfDataset proto, FmrcInvLite lite, TimeInventory timeInv) throws IOException {
        if (timeInv == null) {
            return null;
        }
        NetcdfDataset result = new NetcdfDataset();
        result.setLocation(lite.collectionName);
        this.transferGroup(proto.getRootGroup(), result.getRootGroup(), result);
        result.finish();
        this.addAttributeInfo(result, "history", "FMRC " + timeInv.getName() + " Dataset");
        ProxyReader1D proxyReader1D = new ProxyReader1D();
        List<Variable> nonAggVars = result.getVariables();
        for (FmrcInvLite.Gridset gridset : lite.gridSets) {
            Group group = result.getRootGroup();
            String timeDimName = gridset.gridsetName;
            int ntimes = timeInv.getTimeLength(gridset);
            if (ntimes == 0) {
                for (FmrcInvLite.Gridset.Grid ugrid : gridset.grids) {
                    result.removeVariable(group, ugrid.name);
                    logger.warn("buildDataset1D " + timeInv.getName() + " remove " + ugrid.name);
                }
                continue;
            }
            Dimension timeDim = new Dimension(timeDimName, ntimes);
            result.removeDimension(group, timeDimName);
            result.addDimension(group, timeDim);
            group.removeVariable(timeDimName);
            FmrcInvLite.ValueB timeCoordValues = timeInv.getTimeCoords(gridset);
            if (timeCoordValues != null) {
                this.makeTimeCoordinate(result, group, timeDimName, lite.base, timeCoordValues);
            }
            group.removeVariable(timeDimName + "_run");
            double[] runtimeCoordValues = timeInv.getRunTimeCoords(gridset);
            if (runtimeCoordValues != null) {
                this.makeRunTimeCoordinate(result, group, timeDimName, lite.base, runtimeCoordValues);
            }
            group.removeVariable(timeDimName + "_offset");
            double[] offsetCoordValues = timeInv.getOffsetCoords(gridset);
            if (offsetCoordValues != null) {
                this.makeOffsetCoordinate(result, group, timeDimName, lite.base, offsetCoordValues);
            }
            for (FmrcInvLite.Gridset.Grid ugrid : gridset.grids) {
                VariableDS aggVar = (VariableDS)result.findVariable(ugrid.name);
                if (aggVar == null) {
                    logger.error("buildDataset1D " + lite.collectionName + ": cant find ugrid variable " + ugrid.name + " in collection " + lite.collectionName + this.debugMissingVar(proto, result));
                    continue;
                }
                List<Dimension> dimList = aggVar.getDimensions();
                dimList = dimList.subList(1, dimList.size());
                dimList.add(0, timeDim);
                aggVar.setDimensions(dimList);
                aggVar.setProxyReader(proxyReader1D);
                aggVar.setSPobject(new Vstate1D(ugrid, timeInv));
                nonAggVars.remove(aggVar);
                String coords = this.makeCoordinateList(aggVar, timeDimName, false);
                aggVar.removeAttribute("_CoordinateAxes");
                aggVar.addAttribute(new Attribute("coordinates", coords));
            }
        }
        result.finish();
        for (Variable v : nonAggVars) {
            VariableDS protoV = (VariableDS)proto.findVariable(v.getFullNameEscaped());
            if (protoV.hasCachedDataRecurse()) {
                v.setCachedData(protoV.read());
                continue;
            }
            v.setProxyReader(protoV.getProxyReader());
        }
        return new GridDataset(result);
    }

    private String debugMissingVar(NetcdfFile proto, NetcdfFile result) {
        Formatter f = new Formatter();
        f.format("%nresult dataset %s%n", result.getLocation());
        for (Variable v : result.getVariables()) {
            f.format(" %s%n", v.getNameAndDimensions());
        }
        f.format("%n", new Object[0]);
        f.format("proto dataset %s%n", proto.getLocation());
        for (Variable v : proto.getVariables()) {
            f.format(" %s%n", v.getNameAndDimensions());
        }
        return f.toString();
    }

    private VariableDS makeTimeCoordinate(NetcdfDataset result, Group group, String dimName, CalendarDate base, FmrcInvLite.ValueB valueb) {
        DataType dtype = DataType.DOUBLE;
        VariableDS timeVar = new VariableDS(result, group, null, dimName, dtype, dimName, null, null);
        timeVar.addAttribute(new Attribute("long_name", "Forecast time for ForecastModelRunCollection"));
        timeVar.addAttribute(new Attribute("standard_name", "time"));
        timeVar.addAttribute(new Attribute("calendar", base.getCalendar().name()));
        timeVar.addAttribute(new Attribute("units", "hours since " + base.getTimeUnits()));
        timeVar.addAttribute(new Attribute("missing_value", Double.NaN));
        timeVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        int ntimes = valueb.offset.length;
        timeVar.setCachedData(Array.factory(DataType.DOUBLE, new int[]{ntimes}, (Object)valueb.offset));
        group.addVariable(timeVar);
        if (valueb.bounds != null) {
            String bname = timeVar.getShortName() + "_bounds";
            timeVar.addAttribute(new Attribute("bounds", bname));
            Dimension bd = DatasetConstructor.getBoundsDimension(result);
            VariableDS boundsVar = new VariableDS(result, group, null, bname, dtype, dimName + " " + bd.getShortName(), null, null);
            boundsVar.addAttribute(new Attribute("long_name", "bounds for " + timeVar.getShortName()));
            boundsVar.setCachedData(Array.factory(DataType.DOUBLE, new int[]{ntimes, 2}, (Object)valueb.bounds));
            group.addVariable(boundsVar);
        }
        return timeVar;
    }

    private VariableDS makeRunTimeCoordinate(NetcdfDataset result, Group group, String dimName, CalendarDate base, double[] values) {
        DataType dtype = DataType.DOUBLE;
        VariableDS timeVar = new VariableDS(result, group, null, dimName + "_run", dtype, dimName, null, null);
        timeVar.addAttribute(new Attribute("long_name", "run times for coordinate = " + dimName));
        timeVar.addAttribute(new Attribute("standard_name", "forecast_reference_time"));
        timeVar.addAttribute(new Attribute("calendar", base.getCalendar().name()));
        timeVar.addAttribute(new Attribute("units", "hours since " + base.getTimeUnits()));
        timeVar.addAttribute(new Attribute("missing_value", Double.NaN));
        timeVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.RunTime.toString()));
        int ntimes = values.length;
        ArrayDouble.D1 timeCoordVals = (ArrayDouble.D1)Array.factory(DataType.DOUBLE, new int[]{ntimes}, (Object)values);
        timeVar.setCachedData(timeCoordVals);
        group.addVariable(timeVar);
        return timeVar;
    }

    private VariableDS makeOffsetCoordinate(NetcdfDataset result, Group group, String dimName, CalendarDate base, double[] values) {
        DataType dtype = DataType.DOUBLE;
        VariableDS timeVar = new VariableDS(result, group, null, dimName + "_offset", dtype, dimName, null, null);
        timeVar.addAttribute(new Attribute("long_name", "offset hour from start of run for coordinate = " + dimName));
        timeVar.addAttribute(new Attribute("standard_name", "forecast_period"));
        timeVar.addAttribute(new Attribute("calendar", base.getCalendar().name()));
        timeVar.addAttribute(new Attribute("units", "hours since " + base));
        timeVar.addAttribute(new Attribute("missing_value", Double.NaN));
        int ntimes = values.length;
        ArrayDouble.D1 timeCoordVals = (ArrayDouble.D1)Array.factory(DataType.DOUBLE, new int[]{ntimes}, (Object)values);
        timeVar.setCachedData(timeCoordVals);
        group.addVariable(timeVar);
        return timeVar;
    }

    private Array read(TimeInventory.Instance timeInstance, String fullNameEsc, List<Range> innerSection, HashMap<String, NetcdfDataset> openFilesRead) throws IOException, InvalidRangeException {
        NetcdfDataset ncfile = this.open(timeInstance.getDatasetLocation(), openFilesRead);
        if (ncfile == null) {
            return null;
        }
        Variable v = ncfile.findVariable(fullNameEsc);
        if (v == null) {
            return null;
        }
        Range timeRange = new Range(timeInstance.getDatasetIndex(), timeInstance.getDatasetIndex());
        Section s2 = new Section(innerSection);
        s2.insertRange(0, timeRange);
        return v.read(s2);
    }

    private NetcdfDataset open(String location, Map<String, NetcdfDataset> openFiles) throws IOException {
        NetcdfDataset ncd;
        if (openFiles != null && (ncd = openFiles.get(location)) != null) {
            return ncd;
        }
        if (this.config.innerNcml == null) {
            ncd = NetcdfDataset.acquireDataset(new DatasetUrl(null, location), true, null);
        } else {
            NetcdfFile nc = NetcdfDataset.acquireFile(new DatasetUrl(null, location), null);
            ncd = NcMLReader.mergeNcML(nc, this.config.innerNcml);
            ncd.enhance();
        }
        if (openFiles != null && ncd != null) {
            openFiles.put(location, ncd);
        }
        return ncd;
    }

    private void closeAll(Map<String, NetcdfDataset> openFiles) throws IOException {
        for (NetcdfDataset ncfile : openFiles.values()) {
            ncfile.close();
        }
        openFiles.clear();
    }

    protected Variable findVariable(NetcdfFile ncfile, Variable client) {
        Variable v = ncfile.findVariable(client.getFullNameEscaped());
        if (v == null) {
            VariableEnhanced ve = (VariableEnhanced)((Object)client);
            v = ncfile.findVariable(ve.getOriginalName());
        }
        return v;
    }

    public void showDetails(Formatter out) {
        out.format("==========================%nproto=%n%s%n", this.state.proto);
    }

    protected class DatasetProxyReader
    implements ProxyReader {
        String location;

        DatasetProxyReader(String location) {
            this.location = location;
        }

        @Override
        public Array reallyRead(Variable client, CancelTask cancelTask) throws IOException {
            try (NetcdfDataset ncfile = FmrcDataset.this.open(this.location, null);){
                if (cancelTask != null && cancelTask.isCancel()) {
                    Array array = null;
                    return array;
                }
                Variable proxyV = FmrcDataset.this.findVariable(ncfile, client);
                Array array = proxyV.read();
                return array;
            }
        }

        @Override
        public Array reallyRead(Variable client, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
            try (NetcdfDataset ncfile = FmrcDataset.this.open(this.location, null);){
                Variable proxyV = FmrcDataset.this.findVariable(ncfile, client);
                if (cancelTask != null && cancelTask.isCancel()) {
                    Array array = null;
                    return array;
                }
                Array array = proxyV.read(section);
                return array;
            }
        }
    }

    private class ProxyReader1D
    implements ProxyReader {
        private ProxyReader1D() {
        }

        @Override
        public Array reallyRead(Variable mainv, CancelTask cancelTask) throws IOException {
            try {
                return this.reallyRead(mainv, mainv.getShapeAsSection(), cancelTask);
            }
            catch (InvalidRangeException e) {
                throw new IOException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Array reallyRead(Variable mainv, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
            Vstate1D vstate = (Vstate1D)mainv.getSPobject();
            DataType dtype = mainv instanceof VariableDS ? ((VariableDS)mainv).getOriginalDataType() : mainv.getDataType();
            Array allData = Array.factory(dtype, section.getShape());
            int destPos = 0;
            List<Range> ranges = section.getRanges();
            Range timeRange = ranges.get(0);
            List<Range> innerSection = ranges.subList(1, ranges.size());
            HashMap openFilesRead = new HashMap();
            try {
                Object object = timeRange.iterator();
                while (object.hasNext()) {
                    int timeIdx = object.next();
                    Array result = null;
                    TimeInventory.Instance timeInv = vstate.timeInv.getInstance(vstate.gridLite, timeIdx);
                    if (timeInv == null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Missing Inventory timeInx=" + timeIdx + " for " + mainv.getFullName() + " in " + ((FmrcDataset)FmrcDataset.this).state.lite.collectionName);
                        }
                    } else if (timeInv.getDatasetLocation() != null) {
                        result = FmrcDataset.this.read(timeInv, mainv.getFullNameEscaped(), innerSection, openFilesRead);
                        result = MAMath.convert(result, dtype);
                    }
                    if (result == null) {
                        int[] shape = new Section(innerSection).getShape();
                        result = ((VariableDS)mainv).getMissingDataArray(shape);
                    }
                    Array.arraycopy(result, 0, allData, destPos, (int)result.getSize());
                    destPos = (int)((long)destPos + result.getSize());
                }
                object = allData;
                return object;
            }
            finally {
                FmrcDataset.this.closeAll(openFilesRead);
            }
        }
    }

    private static class Vstate1D {
        FmrcInvLite.Gridset.Grid gridLite;
        TimeInventory timeInv;

        private Vstate1D(FmrcInvLite.Gridset.Grid gridLite, TimeInventory timeInv) {
            this.gridLite = gridLite;
            this.timeInv = timeInv;
        }
    }

    private class ProxyReader2D
    implements ProxyReader {
        private ProxyReader2D() {
        }

        @Override
        public Array reallyRead(Variable mainv, CancelTask cancelTask) throws IOException {
            try {
                return this.reallyRead(mainv, mainv.getShapeAsSection(), cancelTask);
            }
            catch (InvalidRangeException e) {
                throw new IOException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Array reallyRead(Variable mainv, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
            FmrcInvLite.Gridset.Grid gridLite = (FmrcInvLite.Gridset.Grid)mainv.getSPobject();
            DataType dtype = mainv instanceof VariableDS ? ((VariableDS)mainv).getOriginalDataType() : mainv.getDataType();
            Array allData = Array.factory(dtype, section.getShape());
            int destPos = 0;
            List<Range> ranges = section.getRanges();
            Range runRange = ranges.get(0);
            Range timeRange = ranges.get(1);
            List<Range> innerSection = ranges.subList(2, ranges.size());
            HashMap openFilesRead = new HashMap();
            try {
                Object object = runRange.iterator();
                while (object.hasNext()) {
                    int runIdx = object.next();
                    for (int timeIdx : timeRange) {
                        Array result = null;
                        TimeInventory.Instance timeInv = gridLite.getInstance(runIdx, timeIdx);
                        if (timeInv != null) {
                            result = FmrcDataset.this.read(timeInv, gridLite.name, innerSection, openFilesRead);
                            result = MAMath.convert(result, dtype);
                        }
                        if (result == null) {
                            int[] shape = new Section(innerSection).getShape();
                            result = ((VariableDS)mainv).getMissingDataArray(shape);
                        }
                        Array.arraycopy(result, 0, allData, destPos, (int)result.getSize());
                        destPos = (int)((long)destPos + result.getSize());
                    }
                }
                object = allData;
                return object;
            }
            finally {
                FmrcDataset.this.closeAll(openFilesRead);
            }
        }
    }

    private static class State {
        NetcdfDataset proto;
        FmrcInvLite lite;

        private State(NetcdfDataset proto, FmrcInvLite lite) {
            this.proto = proto;
            this.lite = lite;
        }
    }
}

