/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage.writer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import ucar.nc2.AttributeContainerHelper;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.CoverageTransform;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.util.Optional;

public class CoverageSubsetter2 {
    public static Optional<CoverageCollection> makeCoverageDatasetSubset(CoverageCollection org, List<String> gridsWanted, SubsetParams params) {
        ArrayList<Coverage> orgCoverages = new ArrayList<Coverage>();
        HashMap<String, CoverageCoordSys> orgCoordSys = new HashMap<String, CoverageCoordSys>();
        HashSet<String> coordTransformSet = new HashSet<String>();
        for (String gridName : gridsWanted) {
            Coverage orgGrid = org.findCoverage(gridName);
            if (orgGrid == null) continue;
            orgCoverages.add(orgGrid);
            CoverageCoordSys cs = orgGrid.getCoordSys();
            orgCoordSys.put(cs.getName(), cs);
            coordTransformSet.addAll(cs.getTransformNames());
        }
        HashMap<String, CoverageCoordAxis> subsetCoordAxes = new HashMap<String, CoverageCoordAxis>();
        HashMap<String, CoverageCoordSys> subsetCFCoordSys = new HashMap<String, CoverageCoordSys>();
        for (CoverageCoordSys orgCs : orgCoordSys.values()) {
            Optional<CoverageCoordSys> opt = orgCs.subset(params, true, false);
            if (!opt.isPresent()) {
                return Optional.empty(opt.getErrorMessage());
            }
            CoverageCoordSys subsetCoordSys = opt.get();
            subsetCFCoordSys.put(orgCs.getName(), subsetCoordSys);
            for (CoverageCoordAxis axis : subsetCoordSys.getAxes()) {
                subsetCoordAxes.put(axis.getName(), axis);
            }
        }
        ArrayList<CoverageCoordSys> coordSys = new ArrayList<CoverageCoordSys>();
        ArrayList<CoverageCoordAxis> coordAxes = new ArrayList<CoverageCoordAxis>();
        ArrayList<Coverage> coverages = new ArrayList<Coverage>();
        ArrayList<CoverageTransform> coordTransforms = new ArrayList<CoverageTransform>();
        coordSys.addAll(subsetCFCoordSys.values());
        coordAxes.addAll(subsetCoordAxes.values());
        for (Coverage orgCov : orgCoverages) {
            CoverageCoordSys subsetCs = (CoverageCoordSys)subsetCFCoordSys.get(orgCov.getCoordSysName());
            coverages.add(new Coverage(orgCov, subsetCs));
        }
        for (String tname : coordTransformSet) {
            CoverageTransform t = org.findCoordTransform(tname);
            if (t == null) continue;
            coordTransforms.add(t);
        }
        return Optional.of(new CoverageCollection(org.getName(), org.getCoverageType(), new AttributeContainerHelper(org.getName(), org.getGlobalAttributes()), null, null, null, coordSys, coordTransforms, coordAxes, coverages, org.getReader()));
    }

    CoverageCoordAxis1D findIndependentAxis(String want, List<CoverageCoordAxis> axes) {
        String name = want == null ? null : want.trim();
        for (CoverageCoordAxis axis : axes) {
            if (!(axis instanceof CoverageCoordAxis1D) || !axis.getName().equalsIgnoreCase(name)) continue;
            return (CoverageCoordAxis1D)axis;
        }
        return null;
    }
}

