/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib;

import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.dap4lib.ErrorException;
import dap4.dap4lib.RequestMode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ChunkInputStream
extends InputStream {
    static final int DFALTCHUNKSIZE = 0xFFFFFF;
    static final byte CR8 = DapUtil.extract(DapUtil.UTF8.encode("\r"))[0];
    static final byte LF8 = DapUtil.extract(DapUtil.UTF8.encode("\n"))[0];
    protected InputStream input = null;
    protected State state = State.INITIAL;
    protected RequestMode requestmode = null;
    protected ByteOrder localorder = null;
    protected ByteOrder remoteorder = null;
    protected boolean nochecksum = false;
    protected int flags = 0;
    protected int chunksize = 0;
    protected int avail = 0;

    public ChunkInputStream(InputStream input, RequestMode requestmode) {
        this(input, requestmode, ByteOrder.nativeOrder());
    }

    public ChunkInputStream(InputStream input, RequestMode requestmode, ByteOrder order) {
        this.input = input;
        this.requestmode = requestmode;
        this.localorder = order;
    }

    public ByteOrder getHostByteOrder() {
        return this.localorder;
    }

    public ByteOrder getRemoteByteOrder() {
        return this.remoteorder;
    }

    public boolean getNoChecksum() {
        return this.nochecksum;
    }

    public String readDMR() throws DapException {
        try {
            if (this.state != State.INITIAL) {
                throw new DapException("Attempt to read DMR twice");
            }
            byte[] dmr8 = null;
            if (this.requestmode == RequestMode.DMR) {
                int c;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((c = this.input.read()) >= 0) {
                    baos.write(c);
                }
                baos.close();
                dmr8 = baos.toByteArray();
            } else if (this.requestmode == RequestMode.DAP) {
                if (!this.readHeader(this.input)) {
                    throw new DapException("Malformed chunk count");
                }
                dmr8 = new byte[this.chunksize];
                int red = this.read(dmr8, 0, this.chunksize);
                if (red < this.chunksize) {
                    throw new DapException("Short chunk");
                }
            } else assert (false) : "Internal error";
            String dmr = new String(dmr8, DapUtil.UTF8);
            dmr = dmr.trim();
            if (!dmr.endsWith("\r\n")) {
                dmr = dmr.endsWith("\n") ? dmr.substring(0, dmr.length() - 2) + "\r\n" : dmr + "\r\n";
            }
            this.remoteorder = (this.flags & 4) == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
            boolean bl = this.nochecksum = (this.flags & 8) != 0;
            this.state = (this.flags & 2) != 0 ? State.ERROR : ((this.flags & 1) != 0 ? State.END : State.DATA);
            return dmr;
        }
        catch (IOException ioe) {
            throw new DapException(ioe.getMessage());
        }
    }

    public void throwError(String document) throws ErrorException {
        throw new ErrorException("Error chunk encountered").setDocument(document);
    }

    public String readError() throws IOException {
        this.state = State.ERROR;
        byte[] bytes = new byte[this.chunksize];
        try {
            if (this.read(bytes, 0, this.chunksize) < this.chunksize) {
                throw new ErrorException("Short chunk");
            }
        }
        catch (IOException ioe) {
            throw new ErrorException(ioe);
        }
        String document = new String(bytes, DapUtil.UTF8);
        return document;
    }

    @Override
    public int read() throws IOException {
        if (this.requestmode == RequestMode.DMR) {
            throw new UnsupportedOperationException("Attempt to read databuffer when DMR only");
        }
        if (this.avail <= 0) {
            if ((this.flags & 1) != 0) {
                return -1;
            }
            if (!this.readHeader(this.input)) {
                return -1;
            }
            if ((this.flags & 2) != 0) {
                String document = this.readError();
                this.throwError(document);
            }
        }
        --this.avail;
        return this.input.read();
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (off < 0 || len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (off >= buf.length || buf.length < off + len) {
            throw new IndexOutOfBoundsException();
        }
        if (this.requestmode == RequestMode.DMR) {
            throw new UnsupportedOperationException("Attempt to read databuffer when DMR only");
        }
        int count = len;
        int pos = off;
        while (count > 0) {
            if (this.avail <= 0) {
                if ((this.flags & 1) != 0 || !this.readHeader(this.input)) {
                    return len - count;
                }
                if ((this.flags & 2) == 0) continue;
                String document = this.readError();
                this.throwError(document);
                continue;
            }
            int actual = this.avail < count ? this.avail : count;
            int red = this.input.read(buf, pos, actual);
            if (red < 0) {
                throw new IOException("Unexpected EOF");
            }
            pos += red;
            count -= red;
            this.avail -= red;
        }
        return len;
    }

    @Override
    public int available() {
        if (this.avail > 0) {
            return this.avail;
        }
        if ((this.flags & 1) != 0) {
            return 0;
        }
        return 1;
    }

    @Override
    public void close() throws IOException {
        this.state = State.END;
    }

    boolean readHeader(InputStream input) throws IOException {
        byte[] bytehdr = new byte[4];
        int red = input.read(bytehdr);
        if (red == -1) {
            return false;
        }
        if (red < 4) {
            throw new IOException("Short binary chunk count");
        }
        this.flags = bytehdr[0] & 0xFF;
        bytehdr[0] = 0;
        ByteBuffer buf = ByteBuffer.wrap(bytehdr).order(ByteOrder.BIG_ENDIAN);
        this.avail = this.chunksize = buf.getInt();
        return true;
    }

    static enum State {
        ERROR,
        END,
        DATA,
        INDATA,
        INITIAL;

    }
}

