/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr;

import dap4.core.util.DapException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DapXML {
    protected String name = null;
    protected DapXML parent = null;
    protected NodeType nodetype = null;
    protected String prefix = null;
    protected List<DapXML> elements = new ArrayList<DapXML>();
    protected Map<String, DapXML> xmlattributes = new HashMap<String, DapXML>();
    protected String value = null;
    protected String text = null;

    public DapXML() {
    }

    public DapXML(NodeType nodetype, String fullname) {
        this.setNodeType(nodetype);
        int i = fullname.indexOf(58);
        if (i >= 0) {
            this.prefix = fullname.substring(i);
            fullname = fullname.substring(i + 1, fullname.length());
            if (this.prefix.length() == 0) {
                this.prefix = null;
            }
        }
        this.setName(fullname);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NodeType getNodeType() {
        return this.nodetype;
    }

    public void setNodeType(NodeType nodetype) {
        this.nodetype = nodetype;
        this.prefix = null;
        String fullname = null;
        switch (nodetype) {
            case COMMENT: {
                fullname = "#comment";
                break;
            }
            case TEXT: {
                fullname = "#text";
                break;
            }
            case DOCUMENT: {
                fullname = "#document";
                break;
            }
            case CDATA: {
                fullname = "#cdata-section";
                break;
            }
        }
        this.setName(fullname);
    }

    public String getLocalName() {
        return this.getName();
    }

    public void setLocalName(String localname) {
        this.setName(localname);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public DapXML getParent() {
        return this.parent;
    }

    public void setParent(DapXML parent) {
        this.parent = parent;
    }

    public List<DapXML> getElements() {
        return this.elements;
    }

    public void addElement(DapXML child) {
        if (this.elements == null) {
            this.elements = new ArrayList<DapXML>();
        }
        this.elements.add(child);
        child.setParent(this);
    }

    public Map<String, DapXML> getXMLAttributes() {
        return this.xmlattributes;
    }

    public void addXMLAttribute(DapXML attr) throws DapException {
        if (this.xmlattributes == null) {
            this.xmlattributes = new HashMap<String, DapXML>();
        }
        if (this.xmlattributes.containsKey(attr.getName())) {
            throw new DapException("DapXML: attempt to add duplicate xml attribute: " + attr.getName());
        }
        this.xmlattributes.put(attr.getName(), attr);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.stringify(0, buf);
        return buf.toString();
    }

    protected void stringify(int depth, StringBuilder buf) {
        switch (this.nodetype) {
            case ELEMENT: {
                this.indent(depth, buf);
                buf.append(this.name);
                for (Map.Entry<String, DapXML> entry : this.xmlattributes.entrySet()) {
                    buf.append(' ');
                    entry.getValue().stringify(depth + 1, buf);
                }
                buf.append(">\n");
                for (DapXML sub : this.elements) {
                    sub.stringify(depth + 1, buf);
                }
                buf.append("</");
                buf.append(this.name);
                buf.append(">\n");
                break;
            }
            case ATTRIBUTE: {
                buf.append(this.name);
                buf.append('=');
                buf.append('\"');
                buf.append(this.value);
                buf.append('\"');
                break;
            }
            case TEXT: {
                this.indent(depth, buf);
                buf.append(this.text);
                buf.append("\n");
                break;
            }
            case CDATA: {
                this.indent(depth, buf);
                buf.append("<![CDATA[");
                buf.append(this.text);
                buf.append("]]>\n");
                break;
            }
            case COMMENT: {
                this.indent(depth, buf);
                buf.append("<!--");
                buf.append(this.text);
                buf.append("-->\n");
                break;
            }
        }
    }

    protected void indent(int n, StringBuilder buf) {
        for (int i = 0; i < n; ++i) {
            buf.append(' ');
        }
    }

    public static enum NodeType {
        ELEMENT(1),
        ATTRIBUTE(2),
        TEXT(3),
        CDATA(4),
        COMMENT(8),
        DOCUMENT(9),
        DOCTYPE(10);

        private short w3c_nodetype;

        private NodeType(short nodetype) {
            this.w3c_nodetype = nodetype;
        }

        public short getW3CNodeType() {
            return this.w3c_nodetype;
        }
    }

    public static class XMLList
    extends ArrayList<DapXML> {
    }
}

