/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.CDMNode;
import ucar.nc2.Dimension;
import ucar.nc2.Dimensions;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.ProxyReader;
import ucar.nc2.ReduceReader;
import ucar.nc2.SectionReader;
import ucar.nc2.SliceReader;
import ucar.nc2.Structure;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.Indent;
import ucar.nc2.util.rc.RC;

public class Variable
extends CDMNode
implements VariableSimpleIF,
ProxyReader,
AttributeContainer {
    public static boolean permitCaching = true;
    public static int defaultSizeToCache = 4000;
    public static int defaultCoordsSizeToCache = 40000;
    protected static boolean debugCaching;
    private static Logger log;
    private static boolean showSize;
    protected int hashCode;
    protected NetcdfFile ncfile;
    protected DataType dataType;
    private EnumTypedef enumTypedef;
    protected List<Dimension> dimensions = new ArrayList<Dimension>(5);
    protected AttributeContainerMutable attributes;
    protected ProxyReader proxyReader = this;
    protected Object spiObject;
    private Section shapeAsSection;
    protected int[] shape = new int[0];
    protected boolean isVariableLength;
    protected int elementSize;
    protected Cache cache = new Cache();
    protected int sizeToCache = -1;

    @Deprecated
    public static String getDAPName(String name, Variable context) {
        Group xg;
        if (RC.getUseGroups() && !(xg = context.getParentGroup()).isRoot()) {
            List<Group> path = Group.collectPath(xg);
            Formatter dapname = new Formatter();
            for (int i = 1; i < path.size(); ++i) {
                Group g2 = path.get(i);
                dapname.format("/%s", g2.getShortName());
            }
            dapname.format("/%s", name);
            name = dapname.toString();
        }
        return name;
    }

    @Deprecated
    public static String getDAPName(Variable v) {
        return Variable.getDAPName(v.getShortName(), v);
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public int[] getShape() {
        int[] result = new int[this.shape.length];
        System.arraycopy(this.shape, 0, result, 0, this.shape.length);
        return result;
    }

    public int getShape(int index) {
        return this.shape[index];
    }

    public long getSize() {
        long size = 1L;
        for (int aShape : this.shape) {
            if (aShape < 0) continue;
            size *= (long)aShape;
        }
        return size;
    }

    public int getElementSize() {
        return this.elementSize;
    }

    @Override
    public int getRank() {
        return this.shape.length;
    }

    @Override
    public Group getParentGroup() {
        Group g2 = super.getParentGroup();
        if (g2 == null) {
            g2 = this.ncfile.getRootGroup();
            super.setParentGroup(g2);
        }
        assert (g2 != null);
        return g2;
    }

    public boolean isMetadata() {
        return this.cache != null && this.cache.isMetadata;
    }

    public boolean isScalar() {
        return this.getRank() == 0;
    }

    public boolean isVariableLength() {
        return this.isVariableLength;
    }

    public boolean isUnlimited() {
        for (Dimension d : this.dimensions) {
            if (!d.isUnlimited()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public Dimension getDimension(int i) {
        if (i < 0 || i >= this.getRank()) {
            return null;
        }
        return this.dimensions.get(i);
    }

    public String getDimensionsString() {
        return Dimensions.makeDimensionsString(this.dimensions);
    }

    public int findDimensionIndex(String name) {
        for (int i = 0; i < this.dimensions.size(); ++i) {
            Dimension d = this.dimensions.get(i);
            if (!name.equals(d.getShortName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getDescription() {
        String desc = null;
        Attribute att = this.findAttributeIgnoreCase("long_name");
        if (att != null && att.isString()) {
            desc = att.getStringValue();
        }
        if (desc == null && (att = this.findAttributeIgnoreCase("description")) != null && att.isString()) {
            desc = att.getStringValue();
        }
        if (desc == null && (att = this.findAttributeIgnoreCase("title")) != null && att.isString()) {
            desc = att.getStringValue();
        }
        if (desc == null && (att = this.findAttributeIgnoreCase("standard_name")) != null && att.isString()) {
            desc = att.getStringValue();
        }
        return desc;
    }

    @Override
    public String getUnitsString() {
        String units = null;
        Attribute att = this.attributes().findAttributeIgnoreCase("units");
        if (att != null && att.isString() && (units = att.getStringValue()) != null) {
            units = units.trim();
        }
        return units;
    }

    public List<Range> getRanges() {
        return this.getShapeAsSection().getRanges();
    }

    public Section getShapeAsSection() {
        if (this.shapeAsSection == null) {
            this.shapeAsSection = Dimensions.makeSectionFromDimensions(this.dimensions);
        }
        return this.shapeAsSection;
    }

    @Deprecated
    public ProxyReader getProxyReader() {
        return this.proxyReader;
    }

    @Deprecated
    public void setProxyReader(ProxyReader proxyReader) {
        this.proxyReader = proxyReader;
    }

    public Variable section(List<Range> ranges) throws InvalidRangeException {
        return this.section(new Section(ranges, this.shape).makeImmutable());
    }

    public Variable section(Section subsection) throws InvalidRangeException {
        subsection = Section.fill(subsection, this.shape);
        Variable sectionV = this.copy();
        sectionV.setProxyReader(new SectionReader(this, subsection));
        sectionV.shape = subsection.getShape();
        sectionV.createNewCache();
        sectionV.setCaching(false);
        int[] shape = subsection.getShape();
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        for (int i = 0; i < this.getRank(); ++i) {
            Dimension oldD = this.getDimension(i);
            Dimension newD = oldD.getLength() == shape[i] ? oldD : Dimension.builder(oldD.getShortName(), shape[i]).setIsShared(false).setIsUnlimited(oldD.isUnlimited()).build();
            dimensions.add(newD);
        }
        sectionV.dimensions = dimensions;
        return sectionV;
    }

    public Variable slice(int dim, int value) throws InvalidRangeException {
        if (dim < 0 || dim >= this.shape.length) {
            throw new InvalidRangeException("Slice dim invalid= " + dim);
        }
        boolean recordSliceOk = false;
        if (dim == 0 && value == 0) {
            Dimension d = this.getDimension(0);
            recordSliceOk = d.isUnlimited();
        }
        if (!(recordSliceOk || value >= 0 && value < this.shape[dim])) {
            throw new InvalidRangeException("Slice value invalid= " + value + " for dimension " + dim);
        }
        Builder<?> sliceV = this.toBuilder();
        Section slice = new Section(this.getShapeAsSection());
        slice.replaceRange(dim, new Range(value, value)).makeImmutable();
        sliceV.setProxyReader(new SliceReader(this, dim, slice));
        sliceV.resetCache();
        sliceV.setCaching(false);
        ((Builder)sliceV).dimensions.remove(dim);
        return sliceV.build();
    }

    public Variable reduce(List<Dimension> dims) {
        ArrayList<Integer> dimIdx = new ArrayList<Integer>(dims.size());
        for (Dimension d : dims) {
            assert (this.dimensions.contains(d));
            assert (d.getLength() == 1);
            dimIdx.add(this.dimensions.indexOf(d));
        }
        Builder<?> sliceV = this.toBuilder();
        sliceV.setProxyReader(new ReduceReader(this, dimIdx));
        sliceV.resetCache();
        sliceV.setCaching(false);
        for (Dimension d : dims) {
            ((Builder)sliceV).dimensions.remove(d);
        }
        return sliceV.build();
    }

    @Deprecated
    protected Variable copy() {
        return new Variable(this);
    }

    @Nullable
    public NetcdfFile getNetcdfFile() {
        return this.ncfile;
    }

    @Nullable
    public String getFileTypeId() {
        return this.ncfile == null ? null : this.ncfile.getFileTypeId();
    }

    public String lookupEnumString(int val) {
        if (!this.dataType.isEnum()) {
            throw new UnsupportedOperationException("Can only call Variable.lookupEnumVal() on enum types");
        }
        return this.enumTypedef.lookupEnumString(val);
    }

    @Deprecated
    public void setEnumTypedef(EnumTypedef enumTypedef) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (!this.dataType.isEnum()) {
            throw new UnsupportedOperationException("Can only call Variable.setEnumTypedef() on enum types");
        }
        this.enumTypedef = enumTypedef;
    }

    public EnumTypedef getEnumTypedef() {
        return this.enumTypedef;
    }

    public Array read(int[] origin, int[] shape) throws IOException, InvalidRangeException {
        if (origin == null && shape == null) {
            return this.read();
        }
        if (origin == null) {
            return this.read(new Section(shape));
        }
        if (shape == null) {
            return this.read(new Section(origin, this.shape));
        }
        return this.read(new Section(origin, shape));
    }

    public Array read(String sectionSpec) throws IOException, InvalidRangeException {
        return this.read(new Section(sectionSpec));
    }

    public Array read(List<Range> ranges) throws IOException, InvalidRangeException {
        if (null == ranges) {
            return this._read();
        }
        return this.read(new Section(ranges));
    }

    public Array read(Section section) throws IOException, InvalidRangeException {
        return section == null ? this._read() : this._read(Section.fill(section, this.shape));
    }

    public Array read() throws IOException {
        return this._read();
    }

    public byte readScalarByte() throws IOException {
        Array data = this.getScalarData();
        return data.getByte(Index.scalarIndexImmutable);
    }

    public short readScalarShort() throws IOException {
        Array data = this.getScalarData();
        return data.getShort(Index.scalarIndexImmutable);
    }

    public int readScalarInt() throws IOException {
        Array data = this.getScalarData();
        return data.getInt(Index.scalarIndexImmutable);
    }

    public long readScalarLong() throws IOException {
        Array data = this.getScalarData();
        return data.getLong(Index.scalarIndexImmutable);
    }

    public float readScalarFloat() throws IOException {
        Array data = this.getScalarData();
        return data.getFloat(Index.scalarIndexImmutable);
    }

    public double readScalarDouble() throws IOException {
        Array data = this.getScalarData();
        return data.getDouble(Index.scalarIndexImmutable);
    }

    public String readScalarString() throws IOException {
        Array data = this.getScalarData();
        if (this.dataType == DataType.STRING) {
            return (String)data.getObject(Index.scalarIndexImmutable);
        }
        if (this.dataType == DataType.CHAR) {
            ArrayChar dataC = (ArrayChar)data;
            return dataC.getString();
        }
        throw new IllegalArgumentException("readScalarString not STRING or CHAR " + this.getFullName());
    }

    protected Array getScalarData() throws IOException {
        Array scalarData = this.cache.data != null ? this.cache.data : this.read();
        if ((scalarData = scalarData.reduce()).getRank() == 0 || scalarData.getRank() == 1 && this.dataType == DataType.CHAR) {
            return scalarData;
        }
        throw new UnsupportedOperationException("not a scalar variable =" + this);
    }

    protected Array _read() throws IOException {
        if (this.cache.data != null) {
            if (debugCaching) {
                System.out.println("got data from cache " + this.getFullName());
            }
            return this.cache.data.copy();
        }
        Array data = this.proxyReader.reallyRead(this, null);
        if (this.isCaching()) {
            this.setCachedData(data);
            if (debugCaching) {
                System.out.println("cache " + this.getFullName());
            }
            return this.cache.data.copy();
        }
        return data;
    }

    @Override
    public Array reallyRead(Variable client, CancelTask cancelTask) throws IOException {
        if (this.isMemberOfStructure()) {
            ArrayList<String> memList = new ArrayList<String>();
            memList.add(this.getShortName());
            Structure s2 = this.getParentStructure().select(memList);
            ArrayStructure as = (ArrayStructure)s2.read();
            return as.extractMemberArray(as.findMember(this.getShortName()));
        }
        try {
            return this.ncfile.readData(this, this.getShapeAsSection());
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    protected Array _read(Section section) throws IOException, InvalidRangeException {
        if (null == section || section.computeSize() == this.getSize()) {
            return this._read();
        }
        if (this.isCaching()) {
            if (this.cache.data == null) {
                this.setCachedData(this._read());
                if (debugCaching) {
                    System.out.println("cache " + this.getFullName());
                }
            }
            if (debugCaching) {
                System.out.println("got data from cache " + this.getFullName());
            }
            return this.cache.data.sectionNoReduce(section.getRanges()).copy();
        }
        return this.proxyReader.reallyRead(this, section, null);
    }

    @Override
    public Array reallyRead(Variable client, Section section, CancelTask cancelTask) throws IOException, InvalidRangeException {
        if (this.isMemberOfStructure()) {
            throw new UnsupportedOperationException("Cannot directly read section of Member Variable=" + this.getFullName());
        }
        return this.ncfile.readData(this, section);
    }

    @Deprecated
    public long readToByteChannel(Section section, WritableByteChannel wbc) throws IOException, InvalidRangeException {
        if (this.ncfile == null || this.hasCachedData()) {
            return IospHelper.copyToByteChannel(this.read(section), wbc);
        }
        return this.ncfile.readToByteChannel(this, section, wbc);
    }

    public long readToStream(Section section, OutputStream out) throws IOException, InvalidRangeException {
        if (this.ncfile == null || this.hasCachedData()) {
            return IospHelper.copyToOutputStream(this.read(section), out);
        }
        return this.ncfile.readToOutputStream(this, section, out);
    }

    public String getNameAndDimensions() {
        Formatter buf = new Formatter();
        this.getNameAndDimensions(buf, true, false);
        return buf.toString();
    }

    public String getNameAndDimensions(boolean strict) {
        Formatter buf = new Formatter();
        this.getNameAndDimensions(buf, false, strict);
        return buf.toString();
    }

    @Deprecated
    public void getNameAndDimensions(StringBuilder buf) {
        this.getNameAndDimensions(buf, true, false);
    }

    public void getNameAndDimensions(StringBuffer buf) {
        Formatter proxy = new Formatter();
        this.getNameAndDimensions(proxy, true, false);
        buf.append(proxy);
    }

    @Deprecated
    public void getNameAndDimensions(StringBuilder buf, boolean useFullName, boolean strict) {
        Formatter proxy = new Formatter();
        this.getNameAndDimensions(proxy, useFullName, strict);
        buf.append(proxy);
    }

    public void getNameAndDimensions(Formatter buf, boolean useFullName, boolean strict) {
        String name;
        useFullName = useFullName && !strict;
        String string = name = useFullName ? this.getFullName() : this.getShortName();
        if (strict) {
            name = NetcdfFile.makeValidCDLName(this.getShortName());
        }
        buf.format("%s", name);
        if (this.shape != null) {
            if (this.getRank() > 0) {
                buf.format("(", new Object[0]);
            }
            for (int i = 0; i < this.dimensions.size(); ++i) {
                Dimension myd = this.dimensions.get(i);
                String dimName = myd.getShortName();
                if (dimName != null && strict) {
                    dimName = NetcdfFile.makeValidCDLName(dimName);
                }
                if (i != 0) {
                    buf.format(", ", new Object[0]);
                }
                if (myd.isVariableLength()) {
                    buf.format("*", new Object[0]);
                    continue;
                }
                if (myd.isShared()) {
                    if (!strict) {
                        buf.format("%s=%d", dimName, myd.getLength());
                        continue;
                    }
                    buf.format("%s", dimName);
                    continue;
                }
                if (dimName != null) {
                    buf.format("%s=", dimName);
                }
                buf.format("%d", myd.getLength());
            }
            if (this.getRank() > 0) {
                buf.format(")", new Object[0]);
            }
        }
    }

    public String toString() {
        return this.writeCDL(false, false);
    }

    @Deprecated
    public String writeCDL(boolean useFullName, boolean strict) {
        Formatter buf = new Formatter();
        this.writeCDL(buf, new Indent(2), useFullName, strict);
        return buf.toString();
    }

    @Deprecated
    protected void writeCDL(Formatter buf, Indent indent, boolean useFullName, boolean strict) {
        buf.format("%s", indent);
        if (this.dataType == null) {
            buf.format("Unknown", new Object[0]);
        } else if (this.dataType.isEnum()) {
            if (this.enumTypedef == null) {
                buf.format("enum UNKNOWN", new Object[0]);
            } else {
                buf.format("enum %s", NetcdfFile.makeValidCDLName(this.enumTypedef.getShortName()));
            }
        } else {
            buf.format("%s", this.dataType.toString());
        }
        buf.format(" ", new Object[0]);
        this.getNameAndDimensions(buf, useFullName, strict);
        buf.format(";", new Object[0]);
        if (!strict) {
            buf.format(this.extraInfo(), new Object[0]);
        }
        buf.format("%n", new Object[0]);
        indent.incr();
        for (Attribute att : this.attributes()) {
            if (Attribute.isspecial(att)) continue;
            buf.format("%s", indent);
            att.writeCDL(buf, strict, this.getShortName());
            buf.format(";", new Object[0]);
            if (!strict && att.getDataType() != DataType.STRING) {
                buf.format(" // %s", new Object[]{att.getDataType()});
            }
            buf.format("%n", new Object[0]);
        }
        indent.decr();
    }

    public String toStringDebug() {
        Formatter f = new Formatter();
        f.format("Variable %s", this.getFullName());
        if (this.ncfile != null) {
            f.format(" in file %s", this.getDatasetLocation());
            String extra = this.ncfile.toStringDebug(this);
            if (extra != null) {
                f.format(" %s", extra);
            }
        }
        return f.toString();
    }

    protected String extraInfo() {
        return showSize ? " // " + this.getElementSize() + " " + this.getSize() : "";
    }

    public String getDatasetLocation() {
        if (this.ncfile != null) {
            return this.ncfile.getLocation();
        }
        return "N/A";
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof Variable)) {
            return false;
        }
        Variable o = (Variable)oo;
        if (!this.getShortName().equals(o.getShortName())) {
            return false;
        }
        if (this.isScalar() != o.isScalar()) {
            return false;
        }
        if (this.getDataType() != o.getDataType()) {
            return false;
        }
        if (!this.getParentGroup().equals(o.getParentGroup())) {
            return false;
        }
        if (this.getParentStructure() != null && !this.getParentStructure().equals(o.getParentStructure())) {
            return false;
        }
        if (this.isVariableLength() != o.isVariableLength()) {
            return false;
        }
        if (this.dimensions.size() != o.getDimensions().size()) {
            return false;
        }
        for (int i = 0; i < this.dimensions.size(); ++i) {
            if (this.getDimension(i).equals(o.getDimension(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getShortName().hashCode();
            if (this.isScalar()) {
                ++result;
            }
            result = 37 * result + this.getDataType().hashCode();
            result = 37 * result + this.getParentGroup().hashCode();
            if (this.getParentStructure() != null) {
                result = 37 * result + this.getParentStructure().hashCode();
            }
            if (this.isVariableLength) {
                ++result;
            }
            this.hashCode = result = 37 * result + this.dimensions.hashCode();
        }
        return this.hashCode;
    }

    @Override
    public int compareTo(VariableSimpleIF o) {
        return this.getShortName().compareTo(o.getShortName());
    }

    @Deprecated
    protected Variable() {
    }

    @Deprecated
    public Variable(NetcdfFile ncfile, Group group, Structure parent, String shortName) {
        super(shortName);
        this.ncfile = ncfile;
        if (parent == null) {
            this.setParentGroup(group == null ? ncfile.getRootGroup() : group);
        } else {
            this.setParentStructure(parent);
        }
        this.attributes = new AttributeContainerMutable(shortName);
    }

    @Deprecated
    public Variable(NetcdfFile ncfile, Group group, Structure parent, String shortName, DataType dtype, String dims) {
        this(ncfile, group, parent, shortName, dtype, (List<Dimension>)null);
        if (group == null) {
            group = ncfile.getRootGroup();
        }
        this.setDimensions(Dimensions.makeDimensionsList(group::findDimension, dims));
    }

    @Deprecated
    public Variable(NetcdfFile ncfile, Group group, Structure parent, String shortName, DataType dtype, List<Dimension> dims) {
        this(ncfile, group, parent, shortName);
        this.setDataType(dtype);
        this.setDimensions(dims);
    }

    @Deprecated
    public Variable(Variable from) {
        super(from.getShortName());
        this.attributes = new AttributeContainerMutable(from.getShortName(), from.attributes());
        this.cache = from.cache;
        this.setDataType(from.getDataType());
        this.dimensions = new ArrayList<Dimension>(from.dimensions);
        this.elementSize = from.getElementSize();
        this.enumTypedef = from.enumTypedef;
        this.setParentGroup(from.group);
        this.setParentStructure(from.getParentStructure());
        this.isVariableLength = from.isVariableLength;
        this.ncfile = from.ncfile;
        this.shape = from.getShape();
        this.sizeToCache = from.sizeToCache;
        this.spiObject = from.spiObject;
    }

    @Deprecated
    public void setDataType(DataType dataType) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.dataType = dataType;
        this.elementSize = this.getDataType().getSize();
    }

    @Deprecated
    public String setName(String shortName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.setShortName(shortName);
        return this.getShortName();
    }

    @Override
    @Deprecated
    public void setParentGroup(Group group) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        super.setParentGroup(group);
    }

    @Deprecated
    public void setElementSize(int elementSize) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.elementSize = elementSize;
    }

    @Override
    public AttributeContainer attributes() {
        return this.attributes;
    }

    @Override
    @Nullable
    public Attribute findAttribute(String name) {
        return this.attributes.findAttribute(name);
    }

    @Override
    public String findAttValueIgnoreCase(String attName, String defaultValue) {
        return this.attributes.findAttValueIgnoreCase(attName, defaultValue);
    }

    @Override
    @Deprecated
    public List<Attribute> getAttributes() {
        return this.attributes.getAttributes();
    }

    @Override
    @Deprecated
    public Attribute findAttributeIgnoreCase(String name) {
        return this.attributes.findAttributeIgnoreCase(name);
    }

    @Override
    @Deprecated
    public double findAttributeDouble(String attName, double defaultValue) {
        return this.attributes.findAttributeDouble(attName, defaultValue);
    }

    @Override
    @Deprecated
    public int findAttributeInteger(String attName, int defaultValue) {
        return this.attributes.findAttributeInteger(attName, defaultValue);
    }

    @Override
    @Deprecated
    public Attribute addAttribute(Attribute att) {
        return this.attributes.addAttribute(att);
    }

    @Override
    @Deprecated
    public void addAll(Iterable<Attribute> atts) {
        this.attributes.addAll(atts);
    }

    @Override
    @Deprecated
    public boolean remove(Attribute a) {
        return this.attributes.remove(a);
    }

    @Override
    @Deprecated
    public boolean removeAttribute(String attName) {
        return this.attributes.removeAttribute(attName);
    }

    @Override
    @Deprecated
    public boolean removeAttributeIgnoreCase(String attName) {
        return this.attributes.removeAttributeIgnoreCase(attName);
    }

    @Deprecated
    public void setDimensions(List<Dimension> dims) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.dimensions = dims == null ? new ArrayList<Dimension>() : new ArrayList<Dimension>(dims);
        this.resetShape();
    }

    @Deprecated
    public void resetShape() {
        this.shape = new int[this.dimensions.size()];
        for (int i = 0; i < this.dimensions.size(); ++i) {
            Dimension dim = this.dimensions.get(i);
            this.shape[i] = dim.getLength();
            if (!dim.isVariableLength()) continue;
            this.isVariableLength = true;
        }
        this.shapeAsSection = null;
    }

    @Deprecated
    public void setDimensions(String dimString) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        try {
            this.setDimensions(Dimensions.makeDimensionsList(this.getParentGroup()::findDimension, dimString));
            this.resetShape();
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("Variable " + this.getFullName() + " setDimensions = '" + dimString + "' FAILED: " + e.getMessage() + " file = " + this.getDatasetLocation());
        }
    }

    @Deprecated
    public void resetDimensions() {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        ArrayList<Dimension> newDimensions = new ArrayList<Dimension>();
        for (Dimension dim : this.dimensions) {
            if (dim.isShared()) {
                Dimension newD = this.getParentGroup().findDimension(dim.getShortName());
                if (newD == null) {
                    throw new IllegalArgumentException("Variable " + this.getFullName() + " resetDimensions  FAILED, dim doesnt exist in parent group=" + dim);
                }
                newDimensions.add(newD);
                continue;
            }
            newDimensions.add(dim);
        }
        this.dimensions = newDimensions;
        this.resetShape();
    }

    @Deprecated
    public void setDimensionsAnonymous(int[] shape) throws InvalidRangeException {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.dimensions = new ArrayList<Dimension>();
        for (int i = 0; i < shape.length; ++i) {
            Dimension anon;
            if (shape[i] < 1 && shape[i] != -1) {
                throw new InvalidRangeException("shape[" + i + "]=" + shape[i] + " must be > 0");
            }
            if (shape[i] == -1) {
                anon = Dimension.VLEN;
                this.isVariableLength = true;
            } else {
                anon = new Dimension(null, shape[i], false, false, false);
            }
            this.dimensions.add(anon);
        }
        this.resetShape();
    }

    @Deprecated
    public void setIsScalar() {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.dimensions = new ArrayList<Dimension>();
        this.resetShape();
    }

    @Deprecated
    public void setDimension(int idx, Dimension dim) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.dimensions.set(idx, dim);
        this.resetShape();
    }

    @Override
    @Deprecated
    public Variable setImmutable() {
        super.setImmutable();
        this.dimensions = Collections.unmodifiableList(this.dimensions);
        this.attributes.setImmutable();
        return this;
    }

    @Deprecated
    public boolean isImmutable() {
        return this.immutable;
    }

    @Deprecated
    public Object getSPobject() {
        return this.spiObject;
    }

    @Deprecated
    public void setSPobject(Object spiObject) {
        this.spiObject = spiObject;
    }

    public int getSizeToCache() {
        if (this.sizeToCache >= 0) {
            return this.sizeToCache;
        }
        return this.isCoordinateVariable() ? defaultCoordsSizeToCache : defaultSizeToCache;
    }

    @Deprecated
    public void setSizeToCache(int sizeToCache) {
        this.sizeToCache = sizeToCache;
    }

    @Deprecated
    public void setCaching(boolean caching) {
        this.cache.isCaching = caching;
        this.cache.cachingSet = true;
    }

    public boolean isCaching() {
        if (!permitCaching) {
            return false;
        }
        if (!this.cache.cachingSet) {
            boolean bl = this.cache.isCaching = !this.isVariableLength && this.getSize() * (long)this.getElementSize() < (long)this.getSizeToCache();
            if (debugCaching) {
                System.out.printf("  cache %s %s %d < %d%n", this.getFullName(), this.cache.isCaching, this.getSize() * (long)this.getElementSize(), this.getSizeToCache());
            }
            this.cache.cachingSet = true;
        }
        return this.cache.isCaching;
    }

    @Deprecated
    public void invalidateCache() {
        this.cache.data = null;
    }

    @Deprecated
    public void setCachedData(Array cacheData) {
        this.setCachedData(cacheData, false);
    }

    @Deprecated
    public void setCachedData(Array cacheData, boolean isMetadata) {
        if (cacheData != null && cacheData.getElementType() != this.getDataType().getPrimitiveClassType()) {
            throw new IllegalArgumentException("setCachedData type=" + cacheData.getElementType() + " incompatible with variable type=" + (Object)((Object)this.getDataType()));
        }
        this.cache.data = cacheData;
        this.cache.isMetadata = isMetadata;
        this.cache.cachingSet = true;
        this.cache.isCaching = true;
    }

    public void createNewCache() {
        this.cache = new Cache();
    }

    public boolean hasCachedData() {
        return null != this.cache.data;
    }

    @Deprecated
    public void setValues(int npts, double start, double incr) {
        if ((long)npts != this.getSize()) {
            throw new IllegalArgumentException("bad npts = " + npts + " should be " + this.getSize());
        }
        Array data = Array.makeArray(this.getDataType(), npts, start, incr);
        if (this.getRank() != 1) {
            data = data.reshape(this.getShape());
        }
        this.setCachedData(data, true);
    }

    @Deprecated
    public void setValues(List<String> values) throws IllegalArgumentException {
        Array data = Array.makeArray(this.getDataType(), values);
        if (data.getSize() != this.getSize()) {
            throw new IllegalArgumentException("Incorrect number of values specified for the Variable " + this.getFullName() + " needed= " + this.getSize() + " given=" + data.getSize());
        }
        if (this.getRank() != 1) {
            data = data.reshape(this.getShape());
        }
        this.setCachedData(data, true);
    }

    @Deprecated
    public List<Dimension> getDimensionsAll() {
        ArrayList<Dimension> dimsAll = new ArrayList<Dimension>();
        this.addDimensionsAll(dimsAll, this);
        return dimsAll;
    }

    private void addDimensionsAll(List<Dimension> result, Variable v) {
        if (v.isMemberOfStructure()) {
            this.addDimensionsAll(result, v.getParentStructure());
        }
        for (int i = 0; i < v.getRank(); ++i) {
            result.add(v.getDimension(i));
        }
    }

    @Deprecated
    public int[] getShapeAll() {
        if (this.getParentStructure() == null) {
            return this.getShape();
        }
        List<Dimension> dimAll = this.getDimensionsAll();
        int[] shapeAll = new int[dimAll.size()];
        for (int i = 0; i < dimAll.size(); ++i) {
            shapeAll[i] = dimAll.get(i).getLength();
        }
        return shapeAll;
    }

    public boolean isCoordinateVariable() {
        Dimension firstd;
        if (this.dataType == DataType.STRUCTURE || this.isMemberOfStructure()) {
            return false;
        }
        int n = this.getRank();
        if (n == 1 && this.dimensions.size() == 1) {
            firstd = this.dimensions.get(0);
            if (this.getShortName().equals(firstd.getShortName())) {
                return true;
            }
        }
        if (n == 2 && this.dimensions.size() == 2) {
            firstd = this.dimensions.get(0);
            return this.shortName.equals(firstd.getShortName()) && this.getDataType() == DataType.CHAR;
        }
        return false;
    }

    protected Variable(Builder<?> builder) {
        super(builder.shortName);
        if (builder.parent == null) {
            throw new IllegalStateException(String.format("Parent Group must be set for Variable %s", builder.shortName));
        }
        if (builder.dataType == null) {
            throw new IllegalStateException(String.format("DataType must be set for Variable %s", builder.shortName));
        }
        if (builder.shortName == null || builder.shortName.isEmpty()) {
            throw new IllegalStateException(String.format("Name must be set for Variable", new Object[0]));
        }
        this.group = builder.parent;
        this.ncfile = builder.ncfile;
        this.parentstruct = builder.parentStruct;
        this.dataType = builder.dataType;
        this.attributes = ((Builder)builder).attributes;
        this.proxyReader = builder.proxyReader == null ? this : builder.proxyReader;
        this.spiObject = builder.spiObject;
        this.cache = builder.cache;
        if (this.dataType.isEnum()) {
            this.enumTypedef = this.group.findEnumeration(((Builder)builder).enumTypeName);
            if (this.enumTypedef == null) {
                throw new IllegalStateException(String.format("EnumTypedef '%s' does not exist in a parent Group", ((Builder)builder).enumTypeName));
            }
        }
        if (((Builder)builder).dimString != null && !((Builder)builder).dimString.isEmpty()) {
            this.dimensions = this.group.makeDimensionsList(((Builder)builder).dimString);
        } else {
            ArrayList<Dimension> dims = new ArrayList<Dimension>();
            for (Dimension dim : ((Builder)builder).dimensions) {
                if (dim.isShared()) {
                    Dimension sharedDim = this.group.findDimension(dim.getShortName());
                    if (sharedDim == null) {
                        throw new IllegalStateException(String.format("Shared Dimension %s does not exist in a parent proup", dim));
                    }
                    dims.add(sharedDim);
                    continue;
                }
                dims.add(dim);
            }
            this.dimensions = dims;
        }
        if (((Builder)builder).autoGen != null) {
            this.cache.data = ((Builder)builder).autoGen.makeDataArray(this.dataType, this.dimensions);
        }
        this.elementSize = ((Builder)builder).elementSize > 0 ? ((Builder)builder).elementSize : this.getDataType().getSize();
        this.isVariableLength = this.dimensions.stream().anyMatch(Dimension::isVariableLength);
        try {
            ArrayList<Range> list = new ArrayList<Range>();
            for (Dimension d : this.dimensions) {
                int len = d.getLength();
                if (len > 0) {
                    list.add(new Range(d.getShortName(), 0, len - 1));
                    continue;
                }
                if (len == 0) {
                    list.add(Range.EMPTY);
                    continue;
                }
                assert (d.isVariableLength());
                list.add(Range.VLEN);
            }
            this.shapeAsSection = new Section(list).makeImmutable();
            this.shape = this.shapeAsSection.getShape();
        }
        catch (InvalidRangeException e) {
            log.error("Bad shape in variable " + this.getFullName(), e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Builder<?> toBuilder() {
        return this.addLocalFieldsToBuilder(Variable.builder());
    }

    protected Builder<?> addLocalFieldsToBuilder(Builder<? extends Builder<?>> builder) {
        ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)builder.setName(this.shortName).setGroup(this.group)).setNcfile(this.ncfile)).setParentStructure(this.getParentStructure())).setDataType(this.dataType)).setEnumTypeName(this.enumTypedef != null ? this.enumTypedef.getShortName() : null)).addDimensions(this.dimensions)).addAttributes(this.attributes)).setProxyReader(this.proxyReader)).setSPobject(this.spiObject);
        if (this.cache.isMetadata) {
            builder.setCachedData(this.cache.data, true);
        }
        return builder;
    }

    public static Builder<?> builder() {
        return new Builder2();
    }

    public boolean isUnknownLength() {
        return this.isVariableLength;
    }

    static {
        log = LoggerFactory.getLogger(Variable.class);
        showSize = false;
    }

    @Immutable
    private static class AutoGen {
        final double start;
        final double incr;

        private AutoGen(double start, double incr) {
            this.start = start;
            this.incr = incr;
        }

        private Array makeDataArray(DataType dtype, List<Dimension> dimensions) {
            Section section = Dimensions.makeSectionFromDimensions(dimensions);
            return Array.makeArray(dtype, (int)section.getSize(), this.start, this.incr).reshape(section.getShape());
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        public String shortName;
        public DataType dataType;
        private int elementSize;
        public NetcdfFile ncfile;
        public Group parent;
        public Structure parentStruct;
        private String dimString;
        private List<Dimension> dimensions = new ArrayList<Dimension>();
        public Object spiObject;
        public ProxyReader proxyReader;
        public Cache cache = new Cache();
        private String enumTypeName;
        private AutoGen autoGen;
        private AttributeContainerMutable attributes = new AttributeContainerMutable("");
        private boolean built;

        protected abstract T self();

        public T addAttribute(Attribute att) {
            this.attributes.addAttribute(att);
            return this.self();
        }

        public T addAttributes(Iterable<Attribute> atts) {
            this.attributes.addAll(atts);
            return this.self();
        }

        public AttributeContainerMutable getAttributeContainer() {
            return this.attributes;
        }

        public T addDimension(Dimension dim) {
            this.dimensions.add(dim);
            return this.self();
        }

        public T addDimensions(Collection<Dimension> dims) {
            this.dimensions.addAll(dims);
            return this.self();
        }

        public T setDimensions(List<Dimension> dims) {
            this.dimensions = dims;
            return this.self();
        }

        public boolean replaceDimension(Dimension dim) {
            int idx = -1;
            for (int i = 0; i < this.dimensions.size(); ++i) {
                if (!this.dimensions.get(i).getShortName().equals(dim.getShortName())) continue;
                idx = i;
            }
            if (idx >= 0) {
                this.dimensions.set(idx, dim);
            }
            return idx >= 0;
        }

        public T setDimensionsByName(String dimString) {
            this.dimString = dimString;
            return this.self();
        }

        @Nullable
        public String getFirstDimensionName() {
            return this.getDimensionName(0);
        }

        @Nullable
        public String getDimensionName(int index) {
            if (this.dimString != null) {
                Iterable<String> iter = Splitter.on(CharMatcher.whitespace()).omitEmptyStrings().split(this.dimString);
                return Iterators.get(iter.iterator(), index, null);
            }
            if (this.dimensions.size() > index) {
                return this.dimensions.get(index).getShortName();
            }
            return null;
        }

        public Iterable<String> getDimensionNames() {
            if (this.dimString != null) {
                return Splitter.on(CharMatcher.whitespace()).omitEmptyStrings().split(this.dimString);
            }
            if (this.dimensions.size() > 0) {
                return this.dimensions.stream().map(d -> d.getShortName()).collect(Collectors.toList());
            }
            return ImmutableList.of();
        }

        public String makeDimensionsString() {
            if (this.dimString != null) {
                return this.dimString;
            }
            return Dimensions.makeDimensionsString(this.dimensions);
        }

        @Deprecated
        public List<Dimension> copyDimensions() {
            return this.dimensions.stream().map(d -> d.toBuilder().build()).collect(Collectors.toList());
        }

        public T setDimensionsAnonymous(int[] shape) {
            this.dimensions = Dimensions.makeDimensionsAnon(shape);
            return this.self();
        }

        String getDimensionString() {
            return this.dimString;
        }

        public ImmutableList<Dimension> getDimensions(@Nullable Group.Builder gb) {
            if (this.dimString != null && !this.dimString.isEmpty() && gb != null) {
                return gb.makeDimensionsList(this.dimString);
            }
            return ImmutableList.copyOf(this.dimensions);
        }

        public ImmutableSet<String> getDimensionsAll() {
            ImmutableSet.Builder<String> dimsAll = new ImmutableSet.Builder<String>();
            this.addDimensionsAll(dimsAll, this);
            return dimsAll.build();
        }

        private void addDimensionsAll(ImmutableSet.Builder<String> result, Builder<?> v) {
            if (v.parentStruct != null) {
                this.parentStruct.getDimensions().forEach(dim -> result.add((Object)dim.getShortName()));
            }
            this.getDimensionNames().forEach(result::add);
        }

        public T setIsScalar() {
            this.dimensions = new ArrayList<Dimension>();
            return this.self();
        }

        public int getRank() {
            if (this.dimString != null) {
                Iterable<String> iter = Splitter.on(CharMatcher.whitespace()).omitEmptyStrings().split(this.dimString);
                return Iterators.size(iter.iterator());
            }
            return this.dimensions.size();
        }

        public T setDataType(DataType dataType) {
            this.dataType = dataType;
            return this.self();
        }

        public String getEnumTypeName() {
            return this.enumTypeName;
        }

        public T setElementSize(int elementSize) {
            this.elementSize = elementSize;
            return this.self();
        }

        public T setEnumTypeName(String enumTypeName) {
            this.enumTypeName = enumTypeName;
            return this.self();
        }

        public T setNcfile(NetcdfFile ncfile) {
            this.ncfile = ncfile;
            return this.self();
        }

        public T setSPobject(Object spiObject) {
            this.spiObject = spiObject;
            return this.self();
        }

        public T setName(String shortName) {
            this.shortName = NetcdfFiles.makeValidCdmObjectName(shortName);
            this.attributes.setName(shortName);
            return this.self();
        }

        public T setGroup(Group parent) {
            this.parent = parent;
            return this.self();
        }

        public T setParentStructure(Structure parent) {
            this.parentStruct = parent;
            return this.self();
        }

        public T setProxyReader(ProxyReader proxy) {
            this.proxyReader = proxy;
            return this.self();
        }

        public T setCachedData(Array cacheData, boolean isMetadata) {
            this.cache.data = cacheData;
            this.cache.isMetadata = isMetadata;
            this.cache.cachingSet = true;
            this.cache.isCaching = true;
            return this.self();
        }

        public T setAutoGen(double start, double incr) {
            this.autoGen = new AutoGen(start, incr);
            return this.self();
        }

        public T resetCache() {
            this.cache.data = null;
            return this.self();
        }

        public T setCaching(boolean caching) {
            this.cache.isCaching = caching;
            this.cache.cachingSet = true;
            return this.self();
        }

        public T copyFrom(Variable orgVar) {
            this.setName(orgVar.getShortName());
            this.setDataType(orgVar.getDataType());
            if (orgVar.getEnumTypedef() != null) {
                this.setEnumTypeName(orgVar.getEnumTypedef().getShortName());
            }
            this.setGroup(orgVar.getParentGroup());
            this.setSPobject(orgVar.getSPobject());
            this.addDimensions(orgVar.getDimensions());
            this.addAttributes(orgVar);
            return this.self();
        }

        public T copyFrom(Builder<?> builder) {
            this.addAttributes(builder.attributes);
            this.autoGen = builder.autoGen;
            this.cache = builder.cache;
            this.setDataType(builder.dataType);
            this.addDimensions(builder.dimensions);
            this.setDimensionsByName(builder.dimString);
            this.elementSize = builder.elementSize;
            this.setEnumTypeName(builder.getEnumTypeName());
            this.setNcfile(builder.ncfile);
            this.setGroup(builder.parent);
            this.setParentStructure(this.parentStruct);
            this.setProxyReader(builder.proxyReader);
            this.setName(builder.shortName);
            this.setSPobject(builder.spiObject);
            return this.self();
        }

        public Variable build() {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new Variable(this);
        }
    }

    private static class Builder2
    extends Builder<Builder2> {
        private Builder2() {
        }

        @Override
        protected Builder2 self() {
            return this;
        }
    }

    protected static class Cache {
        private Array data;
        protected boolean isCaching;
        protected boolean cachingSet;
        private boolean isMetadata;

        private Cache() {
        }

        public void reset() {
            this.data = null;
            this.isCaching = false;
            this.cachingSet = false;
            this.isMetadata = false;
        }
    }
}

