/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.conv;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.spi.CoordSystemBuilderFactory;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.internal.ncml.NcMLReaderNew;
import ucar.nc2.util.CancelTask;

public class ZebraConvention
extends CoordSystemBuilder {
    private static final String CONVENTION_NAME = "Zebra";

    ZebraConvention(NetcdfDataset.Builder datasetBuilder) {
        super(datasetBuilder);
        this.conventionName = CONVENTION_NAME;
    }

    @Override
    protected void augmentDataset(CancelTask cancelTask) throws IOException {
        Array data;
        NcMLReaderNew.wrapNcMLresource(this.datasetBuilder, "resources/nj22/coords/Zebra.ncml", cancelTask);
        Dimension timeDim = this.rootGroup.findDimension("time").orElse(null);
        VariableDS.Builder base_time = this.rootGroup.findVariable("base_time").orElse(null);
        VariableDS.Builder time_offset = this.rootGroup.findVariable("time_offset").orElse(null);
        Variable.Builder time = this.rootGroup.findVariable("time").orElse(null);
        if (timeDim == null || base_time == null || time_offset == null || time == null) {
            return;
        }
        String units = base_time.getAttributeContainer().findAttValueIgnoreCase("units", "seconds since 1970-01-01 00:00 UTC");
        time.addAttribute(new Attribute("units", units));
        try {
            double baseValue = base_time.orgVar.readScalarDouble();
            data = time_offset.orgVar.read();
            IndexIterator iter = data.getIndexIterator();
            while (iter.hasNext()) {
                iter.setDoubleCurrent(iter.getDoubleNext() + baseValue);
            }
        }
        catch (IOException ioe) {
            this.parseInfo.format("ZebraConvention failed to create time Coord Axis for file %s err= %s%n", this.datasetBuilder.location, ioe);
            return;
        }
        time.setCachedData(data, true);
    }

    public static class Factory
    implements CoordSystemBuilderFactory {
        @Override
        public String getConventionName() {
            return ZebraConvention.CONVENTION_NAME;
        }

        @Override
        public boolean isMine(NetcdfFile ncfile) {
            String s2 = ncfile.getRootGroup().findAttValueIgnoreCase("Convention", "none");
            return s2.startsWith(ZebraConvention.CONVENTION_NAME);
        }

        @Override
        public CoordSystemBuilder open(NetcdfDataset.Builder datasetBuilder) {
            return new ZebraConvention(datasetBuilder);
        }
    }
}

