/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib;

import dap4.core.dmr.DapDataset;
import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.dap4lib.ChunkInputStream;
import dap4.dap4lib.RequestMode;
import dap4.dap4lib.XURI;
import dap4.dap4lib.serial.D4DSP;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPUtil;

public class HttpDSP
extends D4DSP {
    protected static final boolean DEBUG = false;
    protected static final String DAPVERSION = "4.0";
    protected static final String DMRVERSION = "1.0";
    protected static final String DAP4PROTO = "dap4";
    protected static final String FILEPROTO = "file";
    protected static final String DMRSUFFIX = "dmr";
    protected static final String DATASUFFIX = "dap";
    protected static final String DSRSUFFIX = "dsr";
    protected static final String QUERYSTART = "?";
    protected static final String CONSTRAINTTAG = "dap4.ce";
    protected static final String PROTOTAG = "protocol";
    protected static final int DFALTPRELOADSIZE = 50000;
    protected static final String[] DAPEXTENSIONS = new String[]{"dmr", "dap", "dds", "das", "ddx", "dods"};
    protected static final String[] DAP4EXTENSIONS = new String[]{"dmr", "dap"};
    protected static final String[][] DAP4QUERYMARKERS = new String[][]{{"proto", "dap4"}, {"dap4.ce", null}};
    protected static final String[][] DAP4FRAGMARKERS = new String[][]{{"protocol", "dap4"}, {"dap4", null}};
    protected static final String[] DAP4SCHEMES = new String[]{"dap4", "http", "https"};
    protected boolean allowCompression = true;
    protected String basece = null;
    protected int status = 200;
    protected XURI xuri = null;
    protected Object context = null;

    @Override
    public boolean dspMatch(String url, DapContext context) {
        try {
            String tag;
            XURI xuri = new XURI(url);
            boolean found = false;
            for (String scheme : DAP4SCHEMES) {
                if (!scheme.equalsIgnoreCase(xuri.getBaseProtocol()) && !scheme.equalsIgnoreCase(xuri.getFormatProtocol())) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            String formatproto = xuri.getFormatProtocol();
            if (DAP4PROTO.equalsIgnoreCase(formatproto)) {
                return true;
            }
            for (String[] pair : DAP4QUERYMARKERS) {
                tag = xuri.getQueryFields().get(pair[0]);
                if (tag == null || pair[1] != null && !pair[1].equalsIgnoreCase(tag)) continue;
                return true;
            }
            for (String[] pair : DAP4FRAGMARKERS) {
                tag = xuri.getFragFields().get(pair[0]);
                if (tag == null || pair[1] != null && !pair[1].equalsIgnoreCase(tag)) continue;
                return true;
            }
        }
        catch (URISyntaxException use) {
            return false;
        }
        return false;
    }

    @Override
    public HttpDSP open(String url) throws DapException {
        this.setLocation(url);
        this.parseURL(url);
        this.basece = this.xuri.getQueryFields().get(CONSTRAINTTAG);
        this.build();
        return this;
    }

    @Override
    public void close() {
    }

    protected void build() throws DapException {
        String methodurl = HttpDSP.buildURL(this.xuri.assemble(XURI.URLONLY), DATASUFFIX, this.dmr, this.basece);
        InputStream stream = this.callServer(methodurl);
        try {
            ChunkInputStream reader = new ChunkInputStream(stream, RequestMode.DAP, this.getOrder());
            String document = reader.readDMR();
            byte[] bytes = DapUtil.readbinaryfile(reader);
            super.build(document, bytes, this.getOrder());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new DapException(t);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException reader) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InputStream callServer(String methodurl) throws DapException {
        try {
            URI uri = HTTPUtil.parseToURI(methodurl);
        }
        catch (URISyntaxException mue) {
            throw new DapException("Malformed url: " + methodurl);
        }
        long start = System.currentTimeMillis();
        long stop = 0L;
        this.status = 0;
        try (HTTPMethod method = HTTPFactory.Get(methodurl);){
            if (this.allowCompression) {
                method.setCompression("deflate,gzip");
            }
            this.status = method.execute();
            if (this.status != 200) {
                String msg = method.getResponseAsString();
                throw new DapException("Request failure: " + this.status + ": " + methodurl).setCode(this.status);
            }
            byte[] body = method.getResponseAsBytes();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
            return byteArrayInputStream;
        }
        catch (HTTPException e) {
            throw new DapException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCapabilities(String url) throws IOException {
        String saveurl = this.xuri.getOriginal();
        this.parseURL(url);
        String fdsurl = HttpDSP.buildURL(this.xuri.assemble(XURI.URLALL), DSRSUFFIX, null, null);
        try {
            String document;
            InputStream stream = this.callServer(fdsurl);
            byte[] bytes = DapUtil.readbinaryfile(stream);
            String string = document = new String(bytes, DapUtil.UTF8);
            return string;
        }
        finally {
            this.parseURL(saveurl);
        }
    }

    protected static String buildURL(String baseurl, String suffix, DapDataset template, String ce) {
        StringBuilder methodurl = new StringBuilder();
        methodurl.append(baseurl);
        if (suffix != null) {
            methodurl.append('.');
            methodurl.append(suffix);
        }
        if (ce != null && ce.length() > 0) {
            methodurl.append(QUERYSTART);
            methodurl.append(CONSTRAINTTAG);
            methodurl.append('=');
            methodurl.append(ce);
        }
        return methodurl.toString();
    }

    protected void parseURL(String url) throws DapException {
        try {
            this.xuri = new XURI(url);
        }
        catch (URISyntaxException use) {
            throw new DapException(use);
        }
    }
}

