/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

public class PowerSet {
    protected static boolean DEBUG = false;
    protected long[][] powerset;
    protected long[] sizes;
    protected int rank;
    protected long totalsize;
    static final long[] l0 = new long[]{2L, 2L};
    static final long[] l1 = new long[]{2L, 2L, 3L};

    public PowerSet(long[] sizes) {
        this(sizes, sizes.length);
    }

    public PowerSet(long[] sizes, int count) {
        this.sizes = sizes;
        this.rank = count;
        this.totalsize = 1L;
        for (int i = 0; i < this.rank; ++i) {
            this.totalsize *= sizes[i];
        }
        this.powerset = new long[(int)this.totalsize][this.rank];
        this.generate();
        if (DEBUG) {
            System.err.println(this.toString());
        }
    }

    public long getTotalSize() {
        return this.totalsize;
    }

    public long[][] getPowerSet() {
        return this.powerset;
    }

    protected void generate() {
        int index = 1;
        while ((long)index < this.totalsize) {
            long[] ith = this.powerset[index];
            System.arraycopy(this.powerset[index - 1], 0, ith, 0, this.rank);
            for (int pos = this.rank - 1; pos >= 0; --pos) {
                int n = pos;
                ith[n] = ith[n] + 1L;
                if (ith[pos] < this.sizes[pos]) break;
                ith[pos] = 0L;
            }
            ++index;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Powerset:\n");
        int i = 0;
        while ((long)i < this.totalsize) {
            buf.append(String.format("[%2d]", i));
            for (int j = 0; j < this.rank; ++j) {
                buf.append(String.format(" %2d", this.powerset[i][j]));
            }
            buf.append("\n");
            ++i;
        }
        return buf.toString();
    }

    public static void main(String[] argv) {
        new PowerSet(l1);
    }
}

